/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.nntp;

import gnu.mail.providers.nntp.NNTPFolder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;

public final class NNTPMessage
extends MimeMessage {
    String messageId;

    NNTPMessage(NNTPFolder folder, int msgnum, String messageId) {
        super((Folder)folder, msgnum);
        this.messageId = messageId;
        this.headers = null;
        this.flags = folder.getPermanentFlags();
        if (folder.isSeen(msgnum)) {
            this.flags.add(Flags.Flag.SEEN);
        } else {
            this.flags.remove(Flags.Flag.SEEN);
        }
    }

    public String getMessageId() {
        return this.messageId;
    }

    void requestHeaders() throws MessagingException {
        FetchProfile fp = new FetchProfile();
        fp.add(FetchProfile.Item.ENVELOPE);
        NNTPMessage[] messages = new NNTPMessage[]{this};
        this.folder.fetch((Message[])messages, fp);
    }

    void updateHeaders(InputStream in) throws MessagingException, IOException {
        this.headers = new InternetHeaders(in);
    }

    void requestContent() throws MessagingException {
        FetchProfile fp = new FetchProfile();
        fp.add(FetchProfile.Item.CONTENT_INFO);
        NNTPMessage[] messages = new NNTPMessage[]{this};
        this.folder.fetch((Message[])messages, fp);
    }

    void updateContent(byte[] content) {
        this.content = content;
    }

    public String[] getHeader(String name) throws MessagingException {
        if (this.headers == null) {
            this.requestHeaders();
        }
        return super.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        if (this.headers == null) {
            this.requestHeaders();
        }
        return super.getHeader(name, delimiter);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        if (this.headers == null) {
            this.requestHeaders();
        }
        return super.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.requestHeaders();
        }
        return super.getMatchingHeaders(names);
    }

    public Enumeration getNonMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.requestHeaders();
        }
        return super.getNonMatchingHeaders(names);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        if (this.headers == null) {
            this.requestHeaders();
        }
        return super.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.requestHeaders();
        }
        return super.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.requestHeaders();
        }
        return super.getNonMatchingHeaderLines(names);
    }

    public int getSize() throws MessagingException {
        if (this.content == null) {
            this.requestContent();
        }
        return super.getSize();
    }

    public int getLineCount() throws MessagingException {
        String value = this.getHeader("Lines", ",");
        if (value != null) {
            try {
                return Integer.parseInt(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public InputStream getContentStream() throws MessagingException {
        if (this.content == null) {
            this.requestContent();
        }
        return super.getContentStream();
    }

    public void saveChanges() throws MessagingException {
        if (this.headers == null) {
            this.requestHeaders();
        }
        if (this.content == null) {
            this.requestContent();
        }
    }

    public void setFlags(Flags flag, boolean set) throws MessagingException {
        if (flag.contains(Flags.Flag.SEEN)) {
            ((NNTPFolder)this.folder).setSeen(this.msgnum, set);
        }
        super.setFlags(flag, set);
    }
}

