/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RemoveNodesCommand
extends Command {
    private final Way way;
    private final Set<Node> rmNodes;

    public RemoveNodesCommand(Way way, List<Node> rmNodes) {
        super(way.getDataSet());
        this.way = way;
        this.rmNodes = new HashSet<Node>(rmNodes);
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.way.removeNodes(this.rmNodes);
        this.way.setModified(true);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.way);
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Removed nodes from {0}", this.way.getDisplayName(DefaultNameFormatter.getInstance()));
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get(OsmPrimitiveType.WAY);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.way, this.rmNodes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RemoveNodesCommand that = (RemoveNodesCommand)obj;
        return Objects.equals(this.way, that.way) && Objects.equals(this.rmNodes, that.rmNodes);
    }
}

