/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class AtkComponent {
    AccessibleContext ac;
    AccessibleComponent acc_component;
    private int x;
    private int y;
    private int width;
    private int height;
    private Rectangle extents;

    public AtkComponent(AccessibleContext accessibleContext) {
        this.ac = accessibleContext;
        this.acc_component = accessibleContext.getAccessibleComponent();
    }

    public boolean contains(int n, int n2, int n3) {
        if (n3 == 0) {
            Point point = this.acc_component.getLocationOnScreen();
            this.x -= point.x;
            this.y -= point.y;
        }
        return this.acc_component.contains(new Point(n, n2));
    }

    public AccessibleContext get_accessible_at_point(int n, int n2, int n3) {
        Object object;
        if (n3 == 0) {
            object = this.acc_component.getLocationOnScreen();
            this.x -= ((Point)object).x;
            this.y -= ((Point)object).y;
        }
        if ((object = this.acc_component.getAccessibleAt(new Point(n, n2))) == null) {
            return null;
        }
        return object.getAccessibleContext();
    }

    public boolean grab_focus() {
        if (!this.acc_component.isFocusTraversable()) {
            return false;
        }
        this.acc_component.requestFocus();
        return true;
    }

    public Point get_position(int n) {
        if (n == 0) {
            return this.acc_component.getLocationOnScreen();
        }
        return this.acc_component.getLocation();
    }

    public Rectangle set_extents(int n, int n2, int n3, int n4, int n5) {
        this.width = (int)this.acc_component.getSize().getWidth();
        this.height = (int)this.acc_component.getSize().getHeight();
        if (n5 == 0) {
            Point point = this.acc_component.getLocationOnScreen();
        } else {
            Point point = this.acc_component.getLocation();
            this.x -= point.x;
            this.y -= point.y;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public Rectangle get_extents() {
        return this.acc_component.getBounds();
    }

    public int get_layer() {
        AccessibleRole accessibleRole = this.ac.getAccessibleRole();
        if (accessibleRole == AccessibleRole.MENU || accessibleRole == AccessibleRole.MENU_ITEM || accessibleRole == AccessibleRole.POPUP_MENU) {
            return 5;
        }
        if (accessibleRole == AccessibleRole.INTERNAL_FRAME) {
            return 4;
        }
        if (accessibleRole == AccessibleRole.GLASS_PANE) {
            return 6;
        }
        if (accessibleRole == AccessibleRole.CANVAS || accessibleRole == AccessibleRole.ROOT_PANE || accessibleRole == AccessibleRole.LAYERED_PANE) {
            return 2;
        }
        if (accessibleRole == AccessibleRole.WINDOW) {
            return 7;
        }
        return 3;
    }
}

