/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.tree;

import java.util.List;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.TypePath;
import org.jruby.org.objectweb.asm.tree.LabelNode;
import org.jruby.org.objectweb.asm.tree.TypeAnnotationNode;
import org.jruby.org.objectweb.asm.tree.Util;

public class LocalVariableAnnotationNode
extends TypeAnnotationNode {
    public List<LabelNode> start;
    public List<LabelNode> end;
    public List<Integer> index;

    public LocalVariableAnnotationNode(int typeRef, TypePath typePath, LabelNode[] start2, LabelNode[] end2, int[] index2, String descriptor) {
        this(393216, typeRef, typePath, start2, end2, index2, descriptor);
    }

    public LocalVariableAnnotationNode(int api, int typeRef, TypePath typePath, LabelNode[] start2, LabelNode[] end2, int[] index2, String descriptor) {
        super(api, typeRef, typePath, descriptor);
        this.start = Util.asArrayList(start2);
        this.end = Util.asArrayList(end2);
        this.index = Util.asArrayList(index2);
    }

    public void accept(MethodVisitor methodVisitor, boolean visible) {
        Label[] startLabels = new Label[this.start.size()];
        Label[] endLabels = new Label[this.end.size()];
        int[] indices = new int[this.index.size()];
        int n = startLabels.length;
        for (int i2 = 0; i2 < n; ++i2) {
            startLabels[i2] = this.start.get(i2).getLabel();
            endLabels[i2] = this.end.get(i2).getLabel();
            indices[i2] = this.index.get(i2);
        }
        this.accept(methodVisitor.visitLocalVariableAnnotation(this.typeRef, this.typePath, startLabels, endLabels, indices, this.desc, visible));
    }
}

