/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, drupalSettings) {
  function hide($placeholder) {
    return $placeholder.closest('.comment-new-comments').prev().addClass('last').end().hide();
  }

  function remove($placeholder) {
    hide($placeholder).remove();
  }

  function show($placeholder) {
    return $placeholder.closest('.comment-new-comments').prev().removeClass('last').end().show();
  }

  function processNodeNewCommentLinks($placeholders) {
    var $placeholdersToUpdate = {};
    var fieldName = 'comment';
    var $placeholder = void 0;
    $placeholders.each(function (index, placeholder) {
      $placeholder = $(placeholder);
      var timestamp = parseInt($placeholder.attr('data-history-node-last-comment-timestamp'), 10);
      fieldName = $placeholder.attr('data-history-node-field-name');
      var nodeID = $placeholder.closest('[data-history-node-id]').attr('data-history-node-id');
      var lastViewTimestamp = Drupal.history.getLastRead(nodeID);

      if (timestamp > lastViewTimestamp) {
        $placeholdersToUpdate[nodeID] = $placeholder;
      } else {
          remove($placeholder);
        }
    });

    var nodeIDs = Object.keys($placeholdersToUpdate);
    if (nodeIDs.length === 0) {
      return;
    }

    function render(results) {
      Object.keys(results || {}).forEach(function (nodeID) {
        if ($placeholdersToUpdate.hasOwnProperty(nodeID)) {
          $placeholdersToUpdate[nodeID].attr('href', results[nodeID].first_new_comment_link).text(Drupal.formatPlural(results[nodeID].new_comment_count, '1 new comment', '@count new comments')).removeClass('hidden');
          show($placeholdersToUpdate[nodeID]);
        }
      });
    }

    if (drupalSettings.comment && drupalSettings.comment.newCommentsLinks) {
      render(drupalSettings.comment.newCommentsLinks.node[fieldName]);
    } else {
      $.ajax({
        url: Drupal.url('comments/render_new_comments_node_links'),
        type: 'POST',
        data: { 'node_ids[]': nodeIDs, field_name: fieldName },
        dataType: 'json',
        success: render
      });
    }
  }

  Drupal.behaviors.nodeNewCommentsLink = {
    attach: function attach(context) {
      var nodeIDs = [];
      var $placeholders = $(context).find('[data-history-node-last-comment-timestamp]').once('history').filter(function () {
        var $placeholder = $(this);
        var lastCommentTimestamp = parseInt($placeholder.attr('data-history-node-last-comment-timestamp'), 10);
        var nodeID = $placeholder.closest('[data-history-node-id]').attr('data-history-node-id');
        if (Drupal.history.needsServerCheck(nodeID, lastCommentTimestamp)) {
          nodeIDs.push(nodeID);

          hide($placeholder);
          return true;
        }

        remove($placeholder);
        return false;
      });

      if ($placeholders.length === 0) {
        return;
      }

      Drupal.history.fetchTimestamps(nodeIDs, function () {
        processNodeNewCommentLinks($placeholders);
      });
    }
  };
})(jQuery, Drupal, drupalSettings);