/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.elasticsearch.indices.recovery.RecoveryResponse;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoverySourceHandler;
import org.elasticsearch.indices.recovery.RemoteRecoveryTargetHandler;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportService;

public class PeerRecoverySourceService
extends AbstractComponent
implements IndexEventListener {
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final RecoverySettings recoverySettings;
    final OngoingRecoveries ongoingRecoveries = new OngoingRecoveries();

    @Inject
    public PeerRecoverySourceService(Settings settings, TransportService transportService, IndicesService indicesService, RecoverySettings recoverySettings) {
        super(settings);
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.recoverySettings = recoverySettings;
        transportService.registerRequestHandler("internal:index/shard/recovery/start_recovery", StartRecoveryRequest::new, "generic", new StartRecoveryTransportRequestHandler());
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        if (indexShard != null) {
            this.ongoingRecoveries.cancel(indexShard, "shard is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecoveryResponse recover(StartRecoveryRequest request) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard shard = indexService.getShard(request.shardId().id());
        ShardRouting routingEntry = shard.routingEntry();
        if (!routingEntry.primary() || !routingEntry.active()) {
            throw new DelayRecoveryException("source shard [" + routingEntry + "] is not an active primary");
        }
        if (!(!request.isPrimaryRelocation() || routingEntry.relocating() && routingEntry.relocatingNodeId().equals(request.targetNode().getId()))) {
            this.logger.debug("delaying recovery of {} as source shard is not marked yet as relocating to {}", (Object)request.shardId(), (Object)request.targetNode());
            throw new DelayRecoveryException("source shard is not marked yet as relocating to [" + request.targetNode() + "]");
        }
        RecoverySourceHandler handler = this.ongoingRecoveries.addNewRecovery(request, shard);
        this.logger.trace("[{}][{}] starting recovery to {}", (Object)request.shardId().getIndex().getName(), (Object)request.shardId().id(), (Object)request.targetNode());
        try {
            RecoveryResponse recoveryResponse = handler.recoverToTarget();
            return recoveryResponse;
        }
        finally {
            this.ongoingRecoveries.remove(shard, handler);
        }
    }

    final class OngoingRecoveries {
        private final Map<IndexShard, ShardRecoveryContext> ongoingRecoveries = new HashMap<IndexShard, ShardRecoveryContext>();

        OngoingRecoveries() {
        }

        synchronized RecoverySourceHandler addNewRecovery(StartRecoveryRequest request, IndexShard shard) {
            ShardRecoveryContext shardContext = this.ongoingRecoveries.computeIfAbsent(shard, s -> new ShardRecoveryContext());
            RecoverySourceHandler handler = shardContext.addNewRecovery(request, shard);
            shard.recoveryStats().incCurrentAsSource();
            return handler;
        }

        synchronized void remove(IndexShard shard, RecoverySourceHandler handler) {
            ShardRecoveryContext shardRecoveryContext = this.ongoingRecoveries.get(shard);
            assert (shardRecoveryContext != null) : "Shard was not registered [" + shard + "]";
            boolean remove = shardRecoveryContext.recoveryHandlers.remove(handler);
            assert (remove) : "Handler was not registered [" + handler + "]";
            if (remove) {
                shard.recoveryStats().decCurrentAsSource();
            }
            if (shardRecoveryContext.recoveryHandlers.isEmpty()) {
                this.ongoingRecoveries.remove(shard);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void cancel(IndexShard shard, String reason) {
            ShardRecoveryContext shardRecoveryContext = this.ongoingRecoveries.get(shard);
            if (shardRecoveryContext != null) {
                ArrayList<Exception> failures = new ArrayList<Exception>();
                for (RecoverySourceHandler handlers : shardRecoveryContext.recoveryHandlers) {
                    try {
                        handlers.cancel(reason);
                    }
                    catch (Exception ex) {
                        failures.add(ex);
                    }
                    finally {
                        shard.recoveryStats().decCurrentAsSource();
                    }
                }
                ExceptionsHelper.maybeThrowRuntimeAndSuppress(failures);
            }
        }

        private final class ShardRecoveryContext {
            final Set<RecoverySourceHandler> recoveryHandlers = new HashSet<RecoverySourceHandler>();

            private ShardRecoveryContext() {
            }

            synchronized RecoverySourceHandler addNewRecovery(StartRecoveryRequest request, IndexShard shard) {
                for (RecoverySourceHandler existingHandler : this.recoveryHandlers) {
                    if (!existingHandler.getRequest().targetAllocationId().equals(request.targetAllocationId())) continue;
                    throw new DelayRecoveryException("recovery with same target already registered, waiting for previous recovery attempt to be cancelled or completed");
                }
                RecoverySourceHandler handler = this.createRecoverySourceHandler(request, shard);
                this.recoveryHandlers.add(handler);
                return handler;
            }

            private RecoverySourceHandler createRecoverySourceHandler(StartRecoveryRequest request, IndexShard shard) {
                RemoteRecoveryTargetHandler recoveryTarget = new RemoteRecoveryTargetHandler(request.recoveryId(), request.shardId(), PeerRecoverySourceService.this.transportService, request.targetNode(), PeerRecoverySourceService.this.recoverySettings, throttleTime -> shard.recoveryStats().addThrottleTime((long)throttleTime));
                RecoverySourceHandler handler = new RecoverySourceHandler(shard, recoveryTarget, request, PeerRecoverySourceService.this.recoverySettings.getChunkSize().bytesAsInt());
                return handler;
            }
        }
    }

    class StartRecoveryTransportRequestHandler
    implements TransportRequestHandler<StartRecoveryRequest> {
        StartRecoveryTransportRequestHandler() {
        }

        @Override
        public void messageReceived(StartRecoveryRequest request, TransportChannel channel) throws Exception {
            RecoveryResponse response = PeerRecoverySourceService.this.recover(request);
            channel.sendResponse(response);
        }
    }

    public static class Actions {
        public static final String START_RECOVERY = "internal:index/shard/recovery/start_recovery";
    }
}

