/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.bucket.composite.HistogramValuesSource;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public class HistogramValuesSourceBuilder
extends CompositeValuesSourceBuilder<HistogramValuesSourceBuilder> {
    static final String TYPE = "histogram";
    private static final ObjectParser<HistogramValuesSourceBuilder, Void> PARSER = new ObjectParser("histogram");
    private double interval = 0.0;

    static HistogramValuesSourceBuilder parse(String name, XContentParser parser) throws IOException {
        return (HistogramValuesSourceBuilder)PARSER.parse(parser, (Object)new HistogramValuesSourceBuilder(name), null);
    }

    public HistogramValuesSourceBuilder(String name) {
        super(name, ValueType.DOUBLE);
    }

    protected HistogramValuesSourceBuilder(StreamInput in) throws IOException {
        super(in);
        this.interval = in.readDouble();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.interval);
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Histogram.INTERVAL_FIELD.getPreferredName(), this.interval);
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.interval);
    }

    @Override
    protected boolean innerEquals(HistogramValuesSourceBuilder other) {
        return Objects.equals(this.interval, other.interval);
    }

    @Override
    public String type() {
        return TYPE;
    }

    public double interval() {
        return this.interval;
    }

    public HistogramValuesSourceBuilder interval(double interval) {
        if (interval <= 0.0) {
            throw new IllegalArgumentException("[interval] must be greater than 0 for [histogram] source");
        }
        this.interval = interval;
        return this;
    }

    @Override
    protected CompositeValuesSourceConfig innerBuild(SearchContext context, ValuesSourceConfig<?> config) throws IOException {
        Object orig = config.toValuesSource(context.getQueryShardContext());
        if (orig == null) {
            orig = ValuesSource.Numeric.EMPTY;
        }
        if (orig instanceof ValuesSource.Numeric) {
            ValuesSource.Numeric numeric = (ValuesSource.Numeric)orig;
            HistogramValuesSource vs = new HistogramValuesSource(numeric, this.interval);
            MappedFieldType fieldType = config.fieldContext() != null ? config.fieldContext().fieldType() : null;
            return new CompositeValuesSourceConfig(this.name, fieldType, vs, config.format(), this.order(), this.missingBucket(), this.missing());
        }
        throw new IllegalArgumentException("invalid source, expected numeric, got " + orig.getClass().getSimpleName());
    }

    static {
        PARSER.declareDouble(HistogramValuesSourceBuilder::interval, Histogram.INTERVAL_FIELD);
        CompositeValuesSourceParserHelper.declareValuesSourceFields(PARSER, ValueType.NUMERIC);
    }
}

