/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Set;
import org.gephi.filters.AbstractQueryImpl;
import org.gephi.filters.AttributeColumnPropertyEditor;
import org.gephi.filters.FilterModelImpl;
import org.gephi.filters.FilterProcessor;
import org.gephi.filters.FilterQueryImpl;
import org.gephi.filters.FilterThread;
import org.gephi.filters.GenericPropertyEditor;
import org.gephi.filters.OperatorQueryImpl;
import org.gephi.filters.RangePropertyEditor;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.FilterModel;
import org.gephi.filters.api.PropertyExecutor;
import org.gephi.filters.api.Query;
import org.gephi.filters.api.Range;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.ElementFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.Subgraph;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceInformation;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.gephi.utils.progress.ProgressTicketProvider;
import org.gephi.visualization.api.VisualizationController;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FilterControllerImpl
implements FilterController,
PropertyExecutor {
    private FilterModelImpl model;

    public FilterControllerImpl() {
        PropertyEditorManager.registerEditor(Range.class, RangePropertyEditor.class);
        PropertyEditorManager.registerEditor(Column.class, AttributeColumnPropertyEditor.class);
        PropertyEditorManager.registerEditor(Set.class, GenericPropertyEditor.class);
        PropertyEditorManager.registerEditor(Number.class, GenericPropertyEditor.class);
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
                workspace.add((Object)new FilterModelImpl(workspace));
            }

            public void select(Workspace workspace) {
                FilterControllerImpl.this.model = (FilterModelImpl)workspace.getLookup().lookup(FilterModel.class);
                if (FilterControllerImpl.this.model == null) {
                    FilterControllerImpl.this.model = new FilterModelImpl(workspace);
                    workspace.add((Object)FilterControllerImpl.this.model);
                }
            }

            public void unselect(Workspace workspace) {
            }

            public void close(Workspace workspace) {
                FilterModelImpl m = (FilterModelImpl)workspace.getLookup().lookup(FilterModel.class);
                if (m != null) {
                    m.destroy();
                }
            }

            public void disable() {
                if (FilterControllerImpl.this.model != null && FilterControllerImpl.this.model.getCurrentResult() != null) {
                    GraphModel graphModel = FilterControllerImpl.this.model.getGraphModel();
                    if (graphModel != null) {
                        graphModel.destroyView(FilterControllerImpl.this.model.getCurrentResult());
                    }
                    FilterControllerImpl.this.model.setCurrentResult(null);
                }
                FilterControllerImpl.this.model = null;
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            Workspace workspace = pc.getCurrentWorkspace();
            this.model = (FilterModelImpl)workspace.getLookup().lookup(FilterModel.class);
            if (this.model == null) {
                this.model = new FilterModelImpl(workspace);
                workspace.add((Object)this.model);
            }
        }
    }

    public Query createQuery(FilterBuilder builder) {
        Filter filter = builder.getFilter(this.model.getWorkspace());
        if (filter instanceof Operator) {
            return new OperatorQueryImpl((Operator)filter);
        }
        return new FilterQueryImpl(builder, filter);
    }

    public Query createQuery(Filter filter) {
        if (filter instanceof Operator) {
            return new OperatorQueryImpl((Operator)filter);
        }
        return new FilterQueryImpl(null, filter);
    }

    public void add(Query query) {
        AbstractQueryImpl absQuery = (AbstractQueryImpl)query;
        if (!this.model.hasQuery(absQuery = absQuery.getRoot())) {
            Graph graph;
            this.model.addFirst(absQuery);
            if (this.model != null && this.model.getGraphModel() != null) {
                graph = this.model.getGraphModel().getGraph();
            } else {
                GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(this.model.getWorkspace());
                graph = graphModel.getGraph();
            }
            for (Query q : query.getDescendantsAndSelf()) {
                Filter filter = q.getFilter();
                if (!(filter instanceof NodeFilter) && !(filter instanceof EdgeFilter) && !(filter instanceof ElementFilter)) continue;
                FilterProcessor filterProcessor = new FilterProcessor();
                filterProcessor.init(filter, graph);
            }
        }
    }

    public void remove(Query query) {
        if (this.model.getCurrentQuery() == query) {
            if (this.model.isSelecting()) {
                this.selectVisible(null);
            } else {
                this.filterVisible(null);
            }
        }
        query = ((AbstractQueryImpl)query).getRoot();
        this.model.remove(query);
    }

    public void rename(Query query, String name) {
        this.model.rename(query, name);
    }

    public void setSubQuery(Query query, Query subQuery) {
        if (subQuery.getParent() == null && subQuery != this.model.getCurrentQuery()) {
            Graph graph;
            if (this.model != null && this.model.getGraphModel() != null) {
                graph = this.model.getGraphModel().getGraph();
            } else {
                GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(this.model.getWorkspace());
                graph = graphModel.getGraph();
            }
            Filter filter = subQuery.getFilter();
            if (filter instanceof NodeFilter || filter instanceof EdgeFilter || filter instanceof ElementFilter) {
                FilterProcessor filterProcessor = new FilterProcessor();
                filterProcessor.init(filter, graph);
            }
        }
        this.model.setSubQuery(query, subQuery);
    }

    public void removeSubQuery(Query query, Query parent) {
        this.model.removeSubQuery(query, parent);
    }

    public void filterVisible(Query query) {
        if (query != null && this.model.getCurrentQuery() == query && this.model.isFiltering()) {
            return;
        }
        this.model.setFiltering(query != null);
        this.model.setCurrentQuery(query);
        if (this.model.getFilterThread() != null) {
            this.model.getFilterThread().setRunning(false);
            this.model.setFilterThread(null);
        }
        if (query != null) {
            FilterThread filterThread = new FilterThread(this.model);
            this.model.setFilterThread(filterThread);
            filterThread.setRootQuery((AbstractQueryImpl)query);
            filterThread.start();
        } else {
            this.model.getGraphModel().setVisibleView(null);
            if (this.model.getCurrentResult() != null) {
                this.model.getGraphModel().destroyView(this.model.getCurrentResult());
                this.model.setCurrentResult(null);
            }
        }
    }

    public GraphView filter(Query query) {
        FilterProcessor processor = new FilterProcessor();
        GraphModel graphModel = this.model.getGraphModel();
        Graph result = processor.process((AbstractQueryImpl)query, graphModel);
        return result.getView();
    }

    public void selectVisible(Query query) {
        if (query != null && this.model.getCurrentQuery() == query && this.model.isSelecting()) {
            return;
        }
        this.model.setSelecting(query != null);
        this.model.setCurrentQuery(query);
        if (this.model.getFilterThread() != null) {
            this.model.getFilterThread().setRunning(false);
            this.model.setFilterThread(null);
        }
        this.model.getGraphModel().setVisibleView(null);
        if (this.model.getCurrentResult() != null) {
            this.model.getGraphModel().destroyView(this.model.getCurrentResult());
            this.model.setCurrentResult(null);
        }
        if (query != null) {
            FilterThread filterThread = new FilterThread(this.model);
            this.model.setFilterThread(filterThread);
            filterThread.setRootQuery((AbstractQueryImpl)query);
            filterThread.start();
        } else {
            VisualizationController visController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
            if (visController != null) {
                visController.resetSelection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToColumn(String title, Query query) {
        Column edgeCol;
        Subgraph result;
        if (this.model.getCurrentQuery() == query) {
            GraphView view = this.model.getCurrentResult();
            if (view == null) {
                return;
            }
            result = this.model.getGraphModel().getGraph(view);
        } else {
            FilterProcessor processor = new FilterProcessor();
            GraphModel graphModel = this.model.getGraphModel();
            result = processor.process((AbstractQueryImpl)query, graphModel);
        }
        Column nodeCol = result.getModel().getNodeTable().getColumn("filter_" + title);
        if (nodeCol == null) {
            nodeCol = result.getModel().getNodeTable().addColumn("filter_" + title, title, Boolean.class, Origin.DATA, (Object)Boolean.FALSE, true);
        }
        if ((edgeCol = result.getModel().getEdgeTable().getColumn("filter_" + title)) == null) {
            edgeCol = result.getModel().getEdgeTable().addColumn("filter_" + title, title, Boolean.class, Origin.DATA, (Object)Boolean.FALSE, true);
        }
        result.writeLock();
        try {
            for (Node n : result.getNodes()) {
                n.setAttribute(nodeCol, (Object)Boolean.TRUE);
            }
            for (Edge e : result.getEdges()) {
                e.setAttribute(edgeCol, (Object)Boolean.TRUE);
            }
        }
        finally {
            result.writeUnlock();
            result.readUnlockAll();
        }
    }

    public void exportToNewWorkspace(Query query) {
        Subgraph result;
        if (this.model.getCurrentQuery() == query) {
            GraphView view = this.model.getCurrentResult();
            if (view == null) {
                return;
            }
            result = this.model.getGraphModel().getGraph(view);
        } else {
            FilterProcessor processor = new FilterProcessor();
            GraphModel graphModel = this.model.getGraphModel();
            result = processor.process((AbstractQueryImpl)query, graphModel);
        }
        Subgraph graphView = result;
        new Thread(new Runnable((Graph)graphView){
            final /* synthetic */ Graph val$graphView;
            {
                this.val$graphView = graph;
            }

            @Override
            public void run() {
                ProgressTicketProvider progressProvider = (ProgressTicketProvider)Lookup.getDefault().lookup(ProgressTicketProvider.class);
                ProgressTicket ticket = null;
                if (progressProvider != null) {
                    String msg = NbBundle.getMessage(FilterControllerImpl.class, (String)"FilterController.exportToNewWorkspace.task");
                    ticket = progressProvider.createTicket(msg, null);
                }
                Progress.start(ticket);
                ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
                Workspace newWorkspace = pc.newWorkspace(pc.getCurrentProject());
                GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(newWorkspace);
                graphModel.bridge().copyNodes(this.val$graphView.getNodes().toArray());
                Graph graph = graphModel.getGraph();
                ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
                for (Edge edge : graph.getEdges()) {
                    if (this.val$graphView.hasEdge(edge.getId())) continue;
                    edgesToRemove.add(edge);
                }
                if (!edgesToRemove.isEmpty()) {
                    graph.removeAllEdges(edgesToRemove);
                }
                Progress.finish((ProgressTicket)ticket);
                String workspaceName = ((WorkspaceInformation)newWorkspace.getLookup().lookup(WorkspaceInformation.class)).getName();
            }
        }, "Export filter to workspace").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToLabelVisible(Query query) {
        Subgraph result;
        if (this.model.getCurrentQuery() == query) {
            GraphView view = this.model.getCurrentResult();
            if (view == null) {
                return;
            }
            result = this.model.getGraphModel().getGraph(view);
        } else {
            FilterProcessor processor = new FilterProcessor();
            result = processor.process((AbstractQueryImpl)query, this.model.getGraphModel());
        }
        Graph fullGraph = this.model.getGraphModel().getGraph();
        fullGraph.writeLock();
        try {
            boolean inView;
            for (Node n : fullGraph.getNodes()) {
                inView = result.contains(n);
                n.getTextProperties().setVisible(inView);
            }
            for (Edge e : fullGraph.getEdges()) {
                inView = result.contains(e);
                e.getTextProperties().setVisible(inView);
            }
        }
        finally {
            fullGraph.writeUnlock();
            fullGraph.readUnlockAll();
        }
    }

    public void setAutoRefresh(boolean autoRefresh) {
        if (this.model != null) {
            this.model.setAutoRefresh(autoRefresh);
        }
    }

    public void setCurrentQuery(Query query) {
        if (this.model != null) {
            this.model.setCurrentQuery(query);
        }
    }

    public FilterModel getModel() {
        return this.model;
    }

    public synchronized FilterModel getModel(Workspace workspace) {
        FilterModel filterModel = (FilterModel)workspace.getLookup().lookup(FilterModel.class);
        if (filterModel == null) {
            filterModel = new FilterModelImpl(workspace);
            workspace.add((Object)filterModel);
        }
        return filterModel;
    }

    public void setValue(FilterProperty property, Object value, PropertyExecutor.Callback callback) {
        if (this.model != null) {
            Query query = this.model.getQuery(property.getFilter());
            if (query == null) {
                callback.setValue(value);
                return;
            }
            AbstractQueryImpl rootQuery = ((AbstractQueryImpl)query).getRoot();
            FilterThread filterThread = this.model.getFilterThread();
            if (filterThread != null && this.model.getCurrentQuery() == rootQuery) {
                if (Thread.currentThread().equals(filterThread)) {
                    callback.setValue(value);
                    this.model.updateParameters(query);
                } else {
                    filterThread.addModifier(new FilterThread.PropertyModifier(query, property, value, callback));
                    filterThread.setRootQuery(rootQuery);
                }
            } else {
                callback.setValue(value);
                this.model.updateParameters(query);
            }
        } else {
            callback.setValue(value);
        }
    }
}

