/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;

public class ToolTip
extends Window {
    private static final int MARGIN_HORZ = 4;
    private static final int MARGIN_VERT = 2;
    private String[] arrStrings = null;

    public ToolTip(String strText) {
        super(new Frame());
        this.arrStrings = new String[1];
        this.arrStrings[0] = new String(strText);
        Font font = new Font("Helvetica", 0, 10);
        this.setFont(font);
        this.resizePopup();
    }

    public ToolTip(String[] arrStrings) {
        super(new Frame());
        arrStrings = new String[arrStrings.length];
        int i = 0;
        while (i < arrStrings.length) {
            arrStrings[i] = new String(arrStrings[i]);
            ++i;
        }
        Font font = new Font("Helvetica", 0, 10);
        this.setFont(font);
        this.resizePopup();
    }

    public void setText(String strText) {
        this.arrStrings = new String[1];
        this.arrStrings[0] = new String(strText);
        this.resizePopup();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Rectangle rect = this.getBounds();
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.setColor(new Color(255, 255, 192));
        graphics.fillRect(0, 0, rect.width, rect.height);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, rect.width - 1, rect.height - 1);
        int nX = 4;
        int nY = 2 + fontMetrics.getAscent();
        int nHeight = fontMetrics.getHeight();
        int i = 0;
        while (i < this.arrStrings.length) {
            graphics.drawString(this.arrStrings[i], nX, nY);
            nY += nHeight;
            ++i;
        }
    }

    private void resizePopup() {
        int nWidth = 0;
        int nHeight = 0;
        Rectangle rect = this.getBounds();
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int i = 0;
        while (i < this.arrStrings.length) {
            int nWidthText = fontMetrics.stringWidth(this.arrStrings[i]);
            nWidth = Math.max(nWidth, nWidthText);
            ++i;
        }
        nHeight = fontMetrics.getHeight() * this.arrStrings.length;
        rect.width = nWidth + 8;
        rect.height = nHeight + 4;
        Dimension dim = this.getSize();
        if (dim.height != rect.height || rect.width > dim.width || rect.width < dim.width / 2) {
            ((Component)this).setBounds(rect);
        }
    }
}

