/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesStereo;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.viewer.JC;

public class SmilesAtom
extends P3
implements Node {
    static final String UNBRACKETED_SET = "B, C, N, O, P, S, F, Cl, Br, I, *,";
    int patternIndex = -1;
    String pattern;
    int primitiveType;
    boolean isAND;
    SmilesAtom[] subAtoms;
    int nSubAtoms;
    int index;
    String referance;
    String residueName;
    String residueChar;
    char insCode;
    boolean isBioAtom;
    boolean isBioResidue;
    boolean isBioAtomWild;
    char bioType = '\u0000';
    boolean isLeadAtom;
    int notBondedIndex = -1;
    boolean notCrossLinked;
    boolean aromaticAmbiguous = true;
    private int covalentHydrogenCount = -1;
    boolean not;
    boolean selected;
    boolean hasSymbol;
    boolean elementDefined;
    String atomType;
    String bioAtomName;
    boolean isFirst = true;
    int jmolIndex = -1;
    int elementNumber = -2;
    int atomNumber = Integer.MIN_VALUE;
    int residueNumber = Integer.MIN_VALUE;
    int explicitHydrogenCount = Integer.MIN_VALUE;
    int implicitHydrogenCount = Integer.MIN_VALUE;
    SmilesAtom parent;
    SmilesBond[] bonds = new SmilesBond[4];
    int bondCount;
    int iNested = 0;
    boolean isAromatic;
    private int atomicMass = Integer.MIN_VALUE;
    private int charge = Integer.MIN_VALUE;
    private int matchingIndex = -1;
    public SmilesStereo stereo;
    int component = Integer.MIN_VALUE;
    int matchingComponent;
    int atomSite;
    int degree = -1;
    int nonhydrogenDegree = -1;
    int valence = 0;
    int connectivity = -1;
    int ringMembership = Integer.MIN_VALUE;
    int ringSize = Integer.MIN_VALUE;
    int ringConnectivity = -1;
    private Node matchingNode;
    boolean hasSubpattern;
    int mapIndex = -1;
    float atomClass = Float.NaN;
    String symbol;
    private boolean isTopoAtom;
    private int missingHydrogenCount;
    private int cipChirality;

    static boolean allowSmilesUnbracketed(String string) {
        return UNBRACKETED_SET.indexOf(String.valueOf(string) + ",") >= 0;
    }

    SmilesAtom() {
    }

    @Override
    public String getAtomType() {
        return this.atomType == null ? this.bioAtomName : this.atomType;
    }

    public int getChiralClass() {
        return this.stereo == null ? Integer.MIN_VALUE : this.stereo.getChiralClass(this);
    }

    public boolean isDefined() {
        return this.hasSubpattern || this.iNested != 0 || this.isBioAtom || this.component != Integer.MIN_VALUE || this.elementNumber != -2 || this.nSubAtoms > 0;
    }

    void setBioAtom(char c) {
        this.isBioAtom = c != '\u0000';
        this.bioType = c;
        if (this.parent != null) {
            this.parent.bioType = c;
            this.parent.isBioAtom = this.isBioAtom;
            this.parent.isBioAtomWild = this.isBioAtomWild;
        }
    }

    void setAtomName(String string) {
        if (string == null) {
            return;
        }
        if (string.length() > 0) {
            this.bioAtomName = string;
        }
        if (string.equals("\u0000")) {
            this.isLeadAtom = true;
        }
        if (this.parent != null) {
            this.parent.bioAtomName = string;
        }
    }

    public void setBonds(SmilesBond[] smilesBondArray) {
        this.bonds = smilesBondArray;
    }

    SmilesAtom addSubAtom(SmilesAtom smilesAtom, boolean bl) {
        this.isAND = bl;
        if (this.subAtoms == null) {
            this.subAtoms = new SmilesAtom[2];
        }
        if (this.nSubAtoms >= this.subAtoms.length) {
            this.subAtoms = (SmilesAtom[])AU.doubleLength(this.subAtoms);
        }
        smilesAtom.setIndex(this.index);
        smilesAtom.parent = this;
        this.subAtoms[this.nSubAtoms++] = smilesAtom;
        this.setSymbol("*");
        this.hasSymbol = false;
        return smilesAtom;
    }

    public SmilesAtom setIndex(int n) {
        this.index = n;
        return this;
    }

    public SmilesAtom setTopoAtom(int n, int n2, String string, int n3, int n4) {
        this.component = n;
        this.index = n2;
        this.patternIndex = n4;
        this.setSymbol(string);
        this.charge = n3;
        this.isTopoAtom = true;
        return this;
    }

    public boolean setHydrogenCount() {
        this.missingHydrogenCount = this.explicitHydrogenCount;
        if (this.explicitHydrogenCount != Integer.MIN_VALUE) {
            return true;
        }
        int n = SmilesAtom.getDefaultCount(this.elementNumber, this.isAromatic);
        if (n < 0) {
            this.missingHydrogenCount = 0;
            return n == -1;
        }
        if (this.elementNumber == 7 && this.isAromatic && this.bondCount == 2 && this.bonds[0].order == 1 && this.bonds[1].order == 1) {
            ++n;
        }
        int n2 = 0;
        while (n2 < this.bondCount) {
            SmilesBond smilesBond = this.bonds[n2];
            switch (smilesBond.order) {
                case 81: {
                    if (this.elementNumber == 7) {
                        Logger.info("Ambiguous bonding to aromatic N found -- MF may be in error");
                    }
                    --n;
                    break;
                }
                case 1025: 
                case 1041: 
                case 65537: 
                case 65538: {
                    --n;
                    break;
                }
                case 2: {
                    n -= this.isAromatic && this.elementNumber == 6 ? 1 : 2;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n -= smilesBond.order;
                }
            }
            ++n2;
        }
        if (n >= 0) {
            this.missingHydrogenCount = this.explicitHydrogenCount = n;
        }
        return true;
    }

    static int getDefaultCount(int n, boolean bl) {
        switch (n) {
            case -2: 
            case -1: 
            case 0: {
                return -1;
            }
            case 6: {
                return bl ? 3 : 4;
            }
            case 8: 
            case 16: {
                return 2;
            }
            case 7: {
                return bl ? 2 : 3;
            }
            case 5: 
            case 15: {
                return 3;
            }
            case 9: 
            case 17: 
            case 35: 
            case 53: {
                return 1;
            }
        }
        return -2;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public boolean setSymbol(String string) {
        this.symbol = string;
        this.isAromatic = string.equals(string.toLowerCase());
        this.hasSymbol = true;
        this.elementDefined = true;
        if (string.equals("*")) {
            this.isAromatic = false;
            this.elementNumber = -2;
            return true;
        }
        if (string.equals("Xx")) {
            this.elementNumber = 0;
            return true;
        }
        this.aromaticAmbiguous = false;
        if (string.equals("a") || string.equals("A")) {
            if (this.elementNumber < 0) {
                this.elementNumber = -1;
            }
            return true;
        }
        if (this.isAromatic) {
            string = String.valueOf(string.substring(0, 1).toUpperCase()) + (string.length() == 1 ? "" : string.substring(1));
        }
        this.elementNumber = Elements.elementNumberFromSymbol(string, true);
        return this.elementNumber != 0;
    }

    @Override
    public int getElementNumber() {
        return this.elementNumber;
    }

    public int getAtomicMass() {
        return this.atomicMass;
    }

    @Override
    public int getAtomNumber() {
        return this.atomNumber;
    }

    public void setAtomicMass(int n) {
        this.atomicMass = n;
    }

    public int getCharge() {
        return this.charge;
    }

    public void setCharge(int n) {
        this.charge = n;
    }

    public int getMatchingAtomIndex() {
        return this.matchingIndex;
    }

    public Node getMatchingAtom() {
        return this.matchingNode == null ? this : this.matchingNode;
    }

    public void setMatchingAtom(Node node, int n) {
        this.matchingNode = node;
        this.matchingIndex = n;
    }

    public void setExplicitHydrogenCount(int n) {
        this.explicitHydrogenCount = n;
    }

    public void setImplicitHydrogenCount(int n) {
        this.implicitHydrogenCount = n;
    }

    public void setDegree(int n) {
        this.degree = n;
    }

    public void setNonhydrogenDegree(int n) {
        this.nonhydrogenDegree = n;
    }

    public void setValence(int n) {
        this.valence = n;
    }

    public void setConnectivity(int n) {
        this.connectivity = n;
    }

    public void setRingMembership(int n) {
        this.ringMembership = n;
    }

    public void setRingSize(int n) {
        this.ringSize = n;
        if (this.ringSize == 500 || this.ringSize == 600) {
            this.isAromatic = true;
        }
    }

    public void setRingConnectivity(int n) {
        this.ringConnectivity = n;
    }

    @Override
    public int getModelIndex() {
        return this.component;
    }

    @Override
    public int getMoleculeNumber(boolean bl) {
        return this.component;
    }

    @Override
    public int getAtomSite() {
        return this.atomSite;
    }

    @Override
    public int getFormalCharge() {
        return this.charge;
    }

    @Override
    public int getIsotopeNumber() {
        return this.atomicMass;
    }

    @Override
    public int getAtomicAndIsotopeNumber() {
        return Elements.getAtomicAndIsotopeNumber(this.elementNumber, this.atomicMass);
    }

    @Override
    public String getAtomName() {
        return this.bioAtomName == null ? "" : this.bioAtomName;
    }

    @Override
    public String getGroup3(boolean bl) {
        return this.residueName == null ? "" : this.residueName;
    }

    @Override
    public String getGroup1(char c) {
        return this.residueChar == null ? "" : this.residueChar;
    }

    void addBond(SmilesBond smilesBond) {
        if (this.bondCount >= this.bonds.length) {
            this.bonds = (SmilesBond[])AU.doubleLength(this.bonds);
        }
        this.bonds[this.bondCount] = smilesBond;
        ++this.bondCount;
    }

    public void setBondArray() {
        if (this.bonds.length > this.bondCount) {
            this.bonds = (SmilesBond[])AU.arrayCopyObject(this.bonds, this.bondCount);
        }
        if (this.subAtoms != null && this.subAtoms.length > this.nSubAtoms) {
            this.subAtoms = (SmilesAtom[])AU.arrayCopyObject(this.subAtoms, this.subAtoms.length);
        }
        int n = 0;
        while (n < this.bonds.length) {
            SmilesBond smilesBond = this.bonds[n];
            if (this.isBioAtom && smilesBond.order == 17) {
                smilesBond.order = 112;
            }
            if (smilesBond.atom1.index > smilesBond.atom2.index) {
                smilesBond.switchAtoms();
            }
            ++n;
        }
    }

    @Override
    public Edge[] getEdges() {
        return this.parent != null ? this.parent.getEdges() : this.bonds;
    }

    public SmilesBond getBond(int n) {
        return this.parent != null ? this.parent.getBond(n) : (n >= 0 && n < this.bondCount ? this.bonds[n] : null);
    }

    @Override
    public int getCovalentBondCount() {
        return this.getBondCount();
    }

    @Override
    public int getBondCount() {
        return this.parent != null ? this.parent.getBondCount() : this.bondCount;
    }

    @Override
    public int getCovalentBondCountPlusMissingH() {
        return this.getBondCount() + (this.isTopoAtom ? 0 : this.missingHydrogenCount);
    }

    @Override
    public int getTotalHydrogenCount() {
        return this.getCovalentHydrogenCount() + (this.isTopoAtom ? 0 : this.missingHydrogenCount);
    }

    @Override
    public int getImplicitHydrogenCount() {
        return this.implicitHydrogenCount;
    }

    public int getExplicitHydrogenCount() {
        return this.explicitHydrogenCount;
    }

    public int getMatchingBondedAtom(int n) {
        if (this.parent != null) {
            return this.parent.getMatchingBondedAtom(n);
        }
        if (n >= this.bondCount) {
            return -1;
        }
        SmilesBond smilesBond = this.bonds[n];
        return (smilesBond.atom1 == this ? smilesBond.atom2 : smilesBond.atom1).matchingIndex;
    }

    @Override
    public int getBondedAtomIndex(int n) {
        return this.parent != null ? this.parent.getBondedAtomIndex(n) : this.bonds[n].getOtherAtom((SmilesAtom)this).index;
    }

    @Override
    public int getCovalentHydrogenCount() {
        if (this.covalentHydrogenCount >= 0) {
            return this.covalentHydrogenCount;
        }
        if (this.parent != null) {
            this.covalentHydrogenCount = this.parent.getCovalentHydrogenCount();
            return this.covalentHydrogenCount;
        }
        this.covalentHydrogenCount = 0;
        int n = 0;
        while (n < this.bonds.length) {
            if (this.bonds[n].getOtherAtom((SmilesAtom)this).elementNumber == 1) {
                ++this.covalentHydrogenCount;
            }
            ++n;
        }
        return this.covalentHydrogenCount;
    }

    @Override
    public int getValence() {
        if (this.parent != null) {
            return this.parent.getValence();
        }
        int n = this.valence;
        if (n <= 0 && this.bonds != null) {
            int n2 = this.bonds.length;
            while (--n2 >= 0) {
                n += this.bonds[n2].getValence();
            }
        }
        this.valence = n;
        return n;
    }

    @Override
    public int getTotalValence() {
        return this.getValence() + (this.isTopoAtom ? 0 : this.missingHydrogenCount);
    }

    SmilesBond getBondTo(SmilesAtom smilesAtom) {
        if (this.parent != null) {
            return this.parent.getBondTo(smilesAtom);
        }
        int n = 0;
        while (n < this.bonds.length) {
            SmilesBond smilesBond = this.bonds[n];
            if (smilesBond != null && (smilesAtom == null ? smilesBond.atom2 == this : smilesBond.getOtherAtom(this) == smilesAtom)) {
                return smilesBond;
            }
            ++n;
        }
        return null;
    }

    SmilesBond getBondNotTo(SmilesAtom smilesAtom, boolean bl) {
        int n = 0;
        while (n < this.bonds.length) {
            SmilesAtom smilesAtom2;
            SmilesBond smilesBond = this.bonds[n];
            if (smilesBond != null && smilesAtom != (smilesAtom2 = smilesBond.getOtherAtom(this)) && (bl || smilesAtom2.elementNumber != 1)) {
                return smilesBond;
            }
            ++n;
        }
        return null;
    }

    @Override
    public boolean isLeadAtom() {
        return this.isLeadAtom;
    }

    @Override
    public int getOffsetResidueAtom(String string, int n) {
        if (this.isBioAtom) {
            if (n == 0) {
                return this.index;
            }
            int n2 = 0;
            while (n2 < this.bonds.length) {
                if (this.bonds[n2].getAtomIndex1() == this.index && this.bonds[n2].order == 96) {
                    return this.bonds[n2].getOtherAtom((SmilesAtom)this).index;
                }
                ++n2;
            }
        }
        return -1;
    }

    @Override
    public void getGroupBits(BS bS) {
        bS.set(this.index);
    }

    @Override
    public boolean isCrossLinked(Node node) {
        SmilesBond smilesBond = this.getBondTo((SmilesAtom)node);
        return smilesBond.isHydrogen();
    }

    @Override
    public boolean getCrossLinkVector(Lst<Integer> lst, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n = 0;
        while (n < this.bonds.length) {
            if (this.bonds[n].order == 112) {
                if (lst == null) {
                    return true;
                }
                lst.addLast(this.index);
                lst.addLast(this.bonds[n].getOtherAtom((SmilesAtom)this).index);
                lst.addLast(this.bonds[n].getOtherAtom((SmilesAtom)this).index);
                bl3 = true;
            }
            ++n;
        }
        return bl3;
    }

    @Override
    public String getBioStructureTypeName() {
        return null;
    }

    @Override
    public char getInsertionCode() {
        return this.insCode;
    }

    @Override
    public int getResno() {
        return this.residueNumber;
    }

    @Override
    public int getChainID() {
        return 0;
    }

    @Override
    public String getChainIDStr() {
        return "";
    }

    static String getAtomLabel(int n, int n2, int n3, int n4, float f, int n5, boolean bl, String string) {
        int n6;
        String string2 = Elements.elementSymbolFromNumber(n);
        if (bl) {
            string2 = string2.toLowerCase();
            if (n != 6) {
                n3 = Integer.MAX_VALUE;
            }
        }
        int n7 = n6 = n3 == Integer.MAX_VALUE || n2 != 0 || n4 != 0 || !Float.isNaN(f) || string != null && string.length() > 0 ? -1 : SmilesAtom.getDefaultCount(n, false);
        return n6 == n3 ? string2 : "[" + (n2 <= 0 ? "" : "" + n2) + string2 + (string == null ? "" : string) + (n5 > 1 ? "H" + n5 : (n5 == 1 ? "H" : "")) + (n4 < 0 && n4 != Integer.MIN_VALUE ? "" + n4 : (n4 > 0 ? "+" + n4 : "")) + (Float.isNaN(f) ? "" : ":" + (int)f) + "]";
    }

    @Override
    public char getBioSmilesType() {
        return this.bioType;
    }

    public boolean isNucleic() {
        return this.bioType == 'n' || this.bioType == 'r' || this.bioType == 'd';
    }

    @Override
    public boolean isPurine() {
        return this.residueChar != null && this.isNucleic() && "AG".indexOf(this.residueChar) >= 0;
    }

    @Override
    public boolean isPyrimidine() {
        return this.residueChar != null && this.isNucleic() && "CTUI".indexOf(this.residueChar) >= 0;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public BS findAtomsLike(String string) {
        return null;
    }

    @Override
    public String toString() {
        String string;
        String string2 = this.residueChar != null || this.residueName != null ? String.valueOf(this.residueChar == null ? this.residueName : this.residueChar) + "." + this.bioAtomName : (this.bioAtomName != null && this.atomNumber != Integer.MIN_VALUE ? null : (this.elementNumber == -1 ? "A" : (string = this.elementNumber == -2 ? "*" : Elements.elementSymbolFromNumber(this.elementNumber))));
        if (string == null) {
            return String.valueOf(this.bioAtomName) + " #" + this.atomNumber;
        }
        if (this.isAromatic) {
            string = string.toLowerCase();
        }
        String string3 = "";
        int n = 0;
        while (n < this.bondCount) {
            string3 = String.valueOf(string3) + this.bonds[n].getOtherAtom((SmilesAtom)this).index + ", ";
            ++n;
        }
        return "[" + string + '.' + this.index + (this.matchingIndex >= 0 ? "(" + this.matchingNode + ")" : "") + "]" + string3 + "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    @Override
    public float getFloatProperty(String string) {
        if (string == "property_atomclass") {
            return this.atomClass;
        }
        return Float.NaN;
    }

    @Override
    public float getMass() {
        return this.atomicMass;
    }

    @Override
    public String getCIPChirality(boolean bl) {
        return JC.getCIPChiralityName(this.cipChirality & 0xFFFFFF1F);
    }

    @Override
    public void setCIPChirality(int n) {
        this.cipChirality = n;
    }

    @Override
    public int getCIPChiralityCode() {
        return this.cipChirality;
    }

    @Override
    public P3 getXYZ() {
        return this;
    }

    public SmilesStereo getStereo() {
        return this.stereo;
    }

    public int getPatternIndex() {
        return this.patternIndex;
    }
}

