/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyStandardError;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.LocalJumpError;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"LocalJumpError"}, parent="StandardError")
public class RubyLocalJumpError
extends RubyStandardError {
    private static ObjectAllocator LOCALJUMPERROR_ALLOCATOR = (runtime2, klass) -> new RubyLocalJumpError(runtime2, klass);
    private Reason reason;

    public static RubyClass define(Ruby runtime2, RubyClass standardErrorClass) {
        RubyClass nameErrorClass = runtime2.defineClass("LocalJumpError", standardErrorClass, LOCALJUMPERROR_ALLOCATOR);
        nameErrorClass.defineAnnotatedMethods(RubyLocalJumpError.class);
        return nameErrorClass;
    }

    private RubyLocalJumpError(Ruby runtime2, RubyClass exceptionClass) {
        super(runtime2, exceptionClass);
    }

    public RubyLocalJumpError(Ruby runtime2, RubyClass exceptionClass, String message2, Reason reason2, IRubyObject exitValue) {
        super(runtime2, exceptionClass, message2);
        this.reason = reason2;
        this.setInternalVariable("reason", runtime2.newSymbol(reason2.toString()));
        this.setInternalVariable("exit_value", exitValue);
    }

    @Override
    protected RaiseException constructThrowable(String message2) {
        return new LocalJumpError(message2, this);
    }

    @JRubyMethod
    public IRubyObject reason() {
        return (IRubyObject)this.getInternalVariable("reason");
    }

    public Reason getReason() {
        return this.reason;
    }

    @JRubyMethod
    public IRubyObject exit_value() {
        return (IRubyObject)this.getInternalVariable("exit_value");
    }

    public static enum Reason {
        REDO,
        BREAK,
        NEXT,
        RETURN,
        RETRY,
        NOREASON;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

