/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.AbstractRenderableDependency;

public abstract class AbstractRenderableDependencyResult
extends AbstractRenderableDependency {
    public ComponentIdentifier getId() {
        return this.getActual();
    }

    @Override
    public String getName() {
        ModuleComponentIdentifier selectedModuleComponentedIdentifier;
        ModuleComponentSelector requestedModuleComponentSelector;
        ComponentIdentifier selected;
        ComponentSelector requested = this.getRequested();
        if (requested.matchesStrictly(selected = this.getActual())) {
            return this.getSimpleName();
        }
        if (requested instanceof ModuleComponentSelector && selected instanceof ModuleComponentIdentifier && this.isSameGroupAndModuleButDifferentVersion(requestedModuleComponentSelector = (ModuleComponentSelector)requested, selectedModuleComponentedIdentifier = (ModuleComponentIdentifier)selected)) {
            return this.getSimpleName() + " -> " + selectedModuleComponentedIdentifier.getVersion();
        }
        return this.getSimpleName() + " -> " + selected.getDisplayName();
    }

    private boolean isSameGroupAndModuleButDifferentVersion(ModuleComponentSelector requested, ModuleComponentIdentifier selected) {
        return requested.getModuleIdentifier().equals(selected.getModuleIdentifier()) && !requested.getVersion().equals(selected.getVersion());
    }

    private String getSimpleName() {
        return this.getRequested().getDisplayName();
    }

    protected abstract ComponentSelector getRequested();

    protected abstract ComponentIdentifier getActual();
}

