/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.peer.RobotPeer;
import java.lang.reflect.InvocationTargetException;
import sun.awt.ComponentFactory;
import sun.awt.SunToolkit;
import sun.awt.image.SunWritableRaster;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.security.util.SecurityConstants;

public class Robot {
    private static final int MAX_DELAY = 60000;
    private RobotPeer peer;
    private boolean isAutoWaitForIdle = false;
    private int autoDelay = 0;
    private static int LEGAL_BUTTON_MASK = 0;
    private DirectColorModel screenCapCM = null;
    private transient Object anchor = new Object();
    private transient RobotDisposer disposer;

    public Robot() throws AWTException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new AWTException("headless environment");
        }
        this.init(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    public Robot(GraphicsDevice graphicsDevice) throws AWTException {
        this.checkIsScreenDevice(graphicsDevice);
        this.init(graphicsDevice);
    }

    private void init(GraphicsDevice graphicsDevice) throws AWTException {
        this.checkRobotAllowed();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof ComponentFactory) {
            this.peer = ((ComponentFactory)((Object)toolkit)).createRobot(this, graphicsDevice);
            this.disposer = new RobotDisposer(this.peer);
            Disposer.addRecord(this.anchor, this.disposer);
        }
        Robot.initLegalButtonMask();
    }

    private static synchronized void initLegalButtonMask() {
        if (LEGAL_BUTTON_MASK != 0) {
            return;
        }
        int n = 0;
        if (Toolkit.getDefaultToolkit().areExtraMouseButtonsEnabled() && Toolkit.getDefaultToolkit() instanceof SunToolkit) {
            int n2 = ((SunToolkit)Toolkit.getDefaultToolkit()).getNumberOfButtons();
            for (int i = 0; i < n2; ++i) {
                n |= InputEvent.getMaskForButton(i + 1);
            }
        }
        LEGAL_BUTTON_MASK = n |= 0x1C1C;
    }

    private void checkRobotAllowed() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.AWT.CREATE_ROBOT_PERMISSION);
        }
    }

    private void checkIsScreenDevice(GraphicsDevice graphicsDevice) {
        if (graphicsDevice == null || graphicsDevice.getType() != 0) {
            throw new IllegalArgumentException("not a valid screen device");
        }
    }

    public synchronized void mouseMove(int n, int n2) {
        this.peer.mouseMove(n, n2);
        this.afterEvent();
    }

    public synchronized void mousePress(int n) {
        this.checkButtonsArgument(n);
        this.peer.mousePress(n);
        this.afterEvent();
    }

    public synchronized void mouseRelease(int n) {
        this.checkButtonsArgument(n);
        this.peer.mouseRelease(n);
        this.afterEvent();
    }

    private void checkButtonsArgument(int n) {
        if ((n | LEGAL_BUTTON_MASK) != LEGAL_BUTTON_MASK) {
            throw new IllegalArgumentException("Invalid combination of button flags");
        }
    }

    public synchronized void mouseWheel(int n) {
        this.peer.mouseWheel(n);
        this.afterEvent();
    }

    public synchronized void keyPress(int n) {
        this.checkKeycodeArgument(n);
        this.peer.keyPress(n);
        this.afterEvent();
    }

    public synchronized void keyRelease(int n) {
        this.checkKeycodeArgument(n);
        this.peer.keyRelease(n);
        this.afterEvent();
    }

    private void checkKeycodeArgument(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Invalid key code");
        }
    }

    public synchronized Color getPixelColor(int n, int n2) {
        Color color = new Color(this.peer.getRGBPixel(n, n2));
        return color;
    }

    public synchronized BufferedImage createScreenCapture(Rectangle rectangle) {
        Robot.checkScreenCaptureAllowed();
        Robot.checkValidRect(rectangle);
        if (this.screenCapCM == null) {
            this.screenCapCM = new DirectColorModel(24, 0xFF0000, 65280, 255);
        }
        Toolkit.getDefaultToolkit().sync();
        int[] nArray = new int[3];
        int[] nArray2 = this.peer.getRGBPixels(rectangle);
        DataBufferInt dataBufferInt = new DataBufferInt(nArray2, nArray2.length);
        nArray[0] = this.screenCapCM.getRedMask();
        nArray[1] = this.screenCapCM.getGreenMask();
        nArray[2] = this.screenCapCM.getBlueMask();
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, rectangle.width, rectangle.height, rectangle.width, nArray, null);
        SunWritableRaster.makeTrackable(dataBufferInt);
        BufferedImage bufferedImage = new BufferedImage(this.screenCapCM, writableRaster, false, null);
        return bufferedImage;
    }

    private static void checkValidRect(Rectangle rectangle) {
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            throw new IllegalArgumentException("Rectangle width and height must be > 0");
        }
    }

    private static void checkScreenCaptureAllowed() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.AWT.READ_DISPLAY_PIXELS_PERMISSION);
        }
    }

    private void afterEvent() {
        this.autoWaitForIdle();
        this.autoDelay();
    }

    public synchronized boolean isAutoWaitForIdle() {
        return this.isAutoWaitForIdle;
    }

    public synchronized void setAutoWaitForIdle(boolean bl) {
        this.isAutoWaitForIdle = bl;
    }

    private void autoWaitForIdle() {
        if (this.isAutoWaitForIdle) {
            this.waitForIdle();
        }
    }

    public synchronized int getAutoDelay() {
        return this.autoDelay;
    }

    public synchronized void setAutoDelay(int n) {
        this.checkDelayArgument(n);
        this.autoDelay = n;
    }

    private void autoDelay() {
        this.delay(this.autoDelay);
    }

    public synchronized void delay(int n) {
        this.checkDelayArgument(n);
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void checkDelayArgument(int n) {
        if (n < 0 || n > 60000) {
            throw new IllegalArgumentException("Delay must be to 0 to 60,000ms");
        }
    }

    public synchronized void waitForIdle() {
        this.checkNotDispatchThread();
        try {
            SunToolkit.flushPendingEvents();
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Robot.waitForIdle, non-fatal exception caught:");
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("Robot.waitForIdle, non-fatal exception caught:");
            invocationTargetException.printStackTrace();
        }
    }

    private void checkNotDispatchThread() {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalThreadStateException("Cannot call method from the event dispatcher thread");
        }
    }

    public synchronized String toString() {
        String string = "autoDelay = " + this.getAutoDelay() + ", autoWaitForIdle = " + this.isAutoWaitForIdle();
        return this.getClass().getName() + "[ " + string + " ]";
    }

    static class RobotDisposer
    implements DisposerRecord {
        private final RobotPeer peer;

        public RobotDisposer(RobotPeer robotPeer) {
            this.peer = robotPeer;
        }

        @Override
        public void dispose() {
            if (this.peer != null) {
                this.peer.dispose();
            }
        }
    }
}

