/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.Serializable;
import java.util.BitSet;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.Option;

class OptionListModel<E>
extends DefaultListModel<E>
implements ListSelectionModel,
Serializable {
    private static final int MIN = -1;
    private static final int MAX = Integer.MAX_VALUE;
    private int selectionMode = 0;
    private int minIndex = Integer.MAX_VALUE;
    private int maxIndex = -1;
    private int anchorIndex = -1;
    private int leadIndex = -1;
    private int firstChangedIndex = Integer.MAX_VALUE;
    private int lastChangedIndex = -1;
    private boolean isAdjusting = false;
    private BitSet value = new BitSet(32);
    private BitSet initialValue = new BitSet(32);
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean leadAnchorNotificationEnabled = true;

    OptionListModel() {
    }

    @Override
    public int getMinSelectionIndex() {
        return this.isSelectionEmpty() ? -1 : this.minIndex;
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.maxIndex;
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.selectionMode = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid selectionMode");
            }
        }
    }

    @Override
    public boolean isSelectedIndex(int n) {
        return n < this.minIndex || n > this.maxIndex ? false : this.value.get(n);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.minIndex > this.maxIndex;
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(ListSelectionListener.class, listSelectionListener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(ListSelectionListener.class, listSelectionListener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return (ListSelectionListener[])this.listenerList.getListeners(ListSelectionListener.class);
    }

    protected void fireValueChanged(boolean bl) {
        this.fireValueChanged(this.getMinSelectionIndex(), this.getMaxSelectionIndex(), bl);
    }

    protected void fireValueChanged(int n, int n2) {
        this.fireValueChanged(n, n2, this.getValueIsAdjusting());
    }

    protected void fireValueChanged(int n, int n2, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListSelectionEvent listSelectionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListSelectionListener.class) continue;
            if (listSelectionEvent == null) {
                listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
            }
            ((ListSelectionListener)objectArray[i + 1]).valueChanged(listSelectionEvent);
        }
    }

    private void fireValueChanged() {
        if (this.lastChangedIndex == -1) {
            return;
        }
        int n = this.firstChangedIndex;
        int n2 = this.lastChangedIndex;
        this.firstChangedIndex = Integer.MAX_VALUE;
        this.lastChangedIndex = -1;
        this.fireValueChanged(n, n2);
    }

    private void markAsDirty(int n) {
        this.firstChangedIndex = Math.min(this.firstChangedIndex, n);
        this.lastChangedIndex = Math.max(this.lastChangedIndex, n);
    }

    private void set(int n) {
        if (this.value.get(n)) {
            return;
        }
        this.value.set(n);
        Option option = (Option)this.get(n);
        option.setSelection(true);
        this.markAsDirty(n);
        this.minIndex = Math.min(this.minIndex, n);
        this.maxIndex = Math.max(this.maxIndex, n);
    }

    private void clear(int n) {
        if (!this.value.get(n)) {
            return;
        }
        this.value.clear(n);
        Option option = (Option)this.get(n);
        option.setSelection(false);
        this.markAsDirty(n);
        if (n == this.minIndex) {
            ++this.minIndex;
            while (this.minIndex <= this.maxIndex && !this.value.get(this.minIndex)) {
                ++this.minIndex;
            }
        }
        if (n == this.maxIndex) {
            --this.maxIndex;
            while (this.minIndex <= this.maxIndex && !this.value.get(this.maxIndex)) {
                --this.maxIndex;
            }
        }
        if (this.isSelectionEmpty()) {
            this.minIndex = Integer.MAX_VALUE;
            this.maxIndex = -1;
        }
    }

    public void setLeadAnchorNotificationEnabled(boolean bl) {
        this.leadAnchorNotificationEnabled = bl;
    }

    public boolean isLeadAnchorNotificationEnabled() {
        return this.leadAnchorNotificationEnabled;
    }

    private void updateLeadAnchorIndices(int n, int n2) {
        if (this.leadAnchorNotificationEnabled) {
            if (this.anchorIndex != n) {
                if (this.anchorIndex != -1) {
                    this.markAsDirty(this.anchorIndex);
                }
                this.markAsDirty(n);
            }
            if (this.leadIndex != n2) {
                if (this.leadIndex != -1) {
                    this.markAsDirty(this.leadIndex);
                }
                this.markAsDirty(n2);
            }
        }
        this.anchorIndex = n;
        this.leadIndex = n2;
    }

    private boolean contains(int n, int n2, int n3) {
        return n3 >= n && n3 <= n2;
    }

    private void changeSelection(int n, int n2, int n3, int n4, boolean bl) {
        for (int i = Math.min(n3, n); i <= Math.max(n4, n2); ++i) {
            boolean bl2 = this.contains(n, n2, i);
            boolean bl3 = this.contains(n3, n4, i);
            if (bl3 && bl2) {
                if (bl) {
                    bl2 = false;
                } else {
                    bl3 = false;
                }
            }
            if (bl3) {
                this.set(i);
            }
            if (!bl2) continue;
            this.clear(i);
        }
        this.fireValueChanged();
    }

    private void changeSelection(int n, int n2, int n3, int n4) {
        this.changeSelection(n, n2, n3, n4, true);
    }

    @Override
    public void clearSelection() {
        this.removeSelectionInterval(this.minIndex, this.maxIndex);
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return;
        }
        if (this.getSelectionMode() == 0) {
            n = n2;
        }
        this.updateLeadAnchorIndices(n, n2);
        int n3 = this.minIndex;
        int n4 = this.maxIndex;
        int n5 = Math.min(n, n2);
        int n6 = Math.max(n, n2);
        this.changeSelection(n3, n4, n5, n6);
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return;
        }
        if (this.getSelectionMode() != 2) {
            this.setSelectionInterval(n, n2);
            return;
        }
        this.updateLeadAnchorIndices(n, n2);
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        int n5 = Math.min(n, n2);
        int n6 = Math.max(n, n2);
        this.changeSelection(n3, n4, n5, n6);
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return;
        }
        this.updateLeadAnchorIndices(n, n2);
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = Integer.MAX_VALUE;
        int n6 = -1;
        this.changeSelection(n3, n4, n5, n6);
    }

    private void setState(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    @Override
    public void insertIndexInterval(int n, int n2, boolean bl) {
        int n3;
        int n4 = bl ? n : n + 1;
        int n5 = n4 + n2 - 1;
        for (n3 = this.maxIndex; n3 >= n4; --n3) {
            this.setState(n3 + n2, this.value.get(n3));
        }
        n3 = this.value.get(n) ? 1 : 0;
        for (int i = n4; i <= n5; ++i) {
            this.setState(i, n3 != 0);
        }
    }

    @Override
    public void removeIndexInterval(int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = n4 - n3 + 1;
        for (int i = n3; i <= this.maxIndex; ++i) {
            this.setState(i, this.value.get(i + n5));
        }
    }

    @Override
    public void setValueIsAdjusting(boolean bl) {
        if (bl != this.isAdjusting) {
            this.isAdjusting = bl;
            this.fireValueChanged(bl);
        }
    }

    @Override
    public String toString() {
        String string = (this.getValueIsAdjusting() ? "~" : "=") + this.value.toString();
        return this.getClass().getName() + " " + Integer.toString(this.hashCode()) + " " + string;
    }

    public Object clone() throws CloneNotSupportedException {
        OptionListModel optionListModel = (OptionListModel)super.clone();
        optionListModel.value = (BitSet)this.value.clone();
        optionListModel.listenerList = new EventListenerList();
        return optionListModel;
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.anchorIndex;
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.leadIndex;
    }

    @Override
    public void setAnchorSelectionIndex(int n) {
        this.anchorIndex = n;
    }

    @Override
    public void setLeadSelectionIndex(int n) {
        int n2 = this.anchorIndex;
        if (this.getSelectionMode() == 0) {
            n2 = n;
        }
        int n3 = Math.min(this.anchorIndex, this.leadIndex);
        int n4 = Math.max(this.anchorIndex, this.leadIndex);
        int n5 = Math.min(n2, n);
        int n6 = Math.max(n2, n);
        if (this.value.get(this.anchorIndex)) {
            this.changeSelection(n3, n4, n5, n6);
        } else {
            this.changeSelection(n5, n6, n3, n4, false);
        }
        this.anchorIndex = n2;
        this.leadIndex = n;
    }

    public void setInitialSelection(int n) {
        if (this.initialValue.get(n)) {
            return;
        }
        if (this.selectionMode == 0) {
            this.initialValue.and(new BitSet());
        }
        this.initialValue.set(n);
    }

    public BitSet getInitialSelection() {
        return this.initialValue;
    }
}

