/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.Invoker;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.ArrayMemoryIO;
import org.jruby.ext.ffi.Buffer;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.Enums;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.jffi.BufferNativeInvoker;
import org.jruby.ext.ffi.jffi.DataConverters;
import org.jruby.ext.ffi.jffi.DefaultMethod;
import org.jruby.ext.ffi.jffi.FunctionInvoker;
import org.jruby.ext.ffi.jffi.Invocation;
import org.jruby.ext.ffi.jffi.JITRuntime;
import org.jruby.ext.ffi.jffi.MethodFactory;
import org.jruby.ext.ffi.jffi.NativeDataConverter;
import org.jruby.ext.ffi.jffi.ParameterMarshaller;
import org.jruby.ext.ffi.jffi.PointerParameterStrategy;
import org.jruby.ext.ffi.jffi.Signature;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class DefaultMethodFactory
extends MethodFactory {
    public static DefaultMethodFactory getFactory() {
        return SingletonHolder.INSTANCE;
    }

    private DefaultMethodFactory() {
    }

    @Override
    boolean isSupported(Type returnType, Type[] parameterTypes, CallingConvention convention) {
        return true;
    }

    @Override
    DynamicMethod createMethod(RubyModule module, Function function, Type returnType, Type[] parameterTypes, CallingConvention convention, IRubyObject enums, boolean ignoreError) {
        FunctionInvoker functionInvoker = DefaultMethodFactory.getFunctionInvoker(returnType);
        ParameterMarshaller[] marshallers = new ParameterMarshaller[parameterTypes.length];
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            marshallers[i2] = DefaultMethodFactory.getMarshaller(parameterTypes[i2], convention, enums);
            if (marshallers[i2] != null) continue;
            throw module.getRuntime().newTypeError("Could not create marshaller for " + parameterTypes[i2]);
        }
        Signature signature = new Signature(returnType, parameterTypes, convention, ignoreError, enums instanceof RubyHash ? (RubyHash)enums : null);
        BufferNativeInvoker fallbackInvoker = new BufferNativeInvoker(module, function, signature, functionInvoker, marshallers);
        return parameterTypes.length <= 6 ? new DefaultMethod(module, function, signature, fallbackInvoker) : fallbackInvoker;
    }

    static FunctionInvoker getFunctionInvoker(Type returnType) {
        if (returnType instanceof Type.Builtin) {
            return DefaultMethodFactory.getFunctionInvoker(returnType.getNativeType());
        }
        if (returnType instanceof CallbackInfo) {
            return new ConvertingInvoker(DefaultMethodFactory.getFunctionInvoker(NativeType.POINTER), DataConverters.getResultConverter(returnType));
        }
        if (returnType instanceof StructByValue) {
            return new StructByValueInvoker((StructByValue)returnType);
        }
        if (returnType instanceof MappedType) {
            MappedType ctype = (MappedType)returnType;
            return new ConvertingInvoker(DefaultMethodFactory.getFunctionInvoker(ctype.getRealType()), DataConverters.getResultConverter(ctype));
        }
        throw returnType.getRuntime().newArgumentError("Cannot get FunctionInvoker for " + returnType);
    }

    static FunctionInvoker getFunctionInvoker(NativeType returnType) {
        switch (returnType) {
            case VOID: {
                return VoidInvoker.INSTANCE;
            }
            case BOOL: {
                return BooleanInvoker.INSTANCE;
            }
            case POINTER: {
                return Platform.getPlatform().addressSize() == 32 ? Pointer32Invoker.INSTANCE : Pointer64Invoker.INSTANCE;
            }
            case CHAR: {
                return Signed8Invoker.INSTANCE;
            }
            case SHORT: {
                return Signed16Invoker.INSTANCE;
            }
            case INT: {
                return Signed32Invoker.INSTANCE;
            }
            case UCHAR: {
                return Unsigned8Invoker.INSTANCE;
            }
            case USHORT: {
                return Unsigned16Invoker.INSTANCE;
            }
            case UINT: {
                return Unsigned32Invoker.INSTANCE;
            }
            case LONG_LONG: {
                return Signed64Invoker.INSTANCE;
            }
            case ULONG_LONG: {
                return Unsigned64Invoker.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Invoker.INSTANCE : Signed64Invoker.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? Unsigned32Invoker.INSTANCE : Unsigned64Invoker.INSTANCE;
            }
            case FLOAT: {
                return Float32Invoker.INSTANCE;
            }
            case DOUBLE: {
                return Float64Invoker.INSTANCE;
            }
            case STRING: 
            case TRANSIENT_STRING: {
                return StringInvoker.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Invalid return type: " + (Object)((Object)returnType));
    }

    static ParameterMarshaller getMarshaller(Type type2, CallingConvention convention, IRubyObject enums) {
        if (!(enums == null || enums.isNil() || enums instanceof RubyHash || enums instanceof Enums)) {
            throw type2.getRuntime().newArgumentError("wrong argument type " + enums.getMetaClass().getName() + " (expected Hash or Enums)");
        }
        if (type2 instanceof Type.Builtin) {
            return enums != null && !enums.isNil() ? DefaultMethodFactory.getEnumMarshaller(type2, convention, enums) : DefaultMethodFactory.getMarshaller(type2.getNativeType());
        }
        if (type2 instanceof CallbackInfo) {
            return new ConvertingMarshaller(DefaultMethodFactory.getMarshaller(type2.getNativeType()), DataConverters.getParameterConverter(type2, (Enums)null));
        }
        if (type2 instanceof StructByValue) {
            return new StructByValueMarshaller((StructByValue)type2);
        }
        if (type2 instanceof MappedType) {
            MappedType ctype = (MappedType)type2;
            if (enums == null || enums instanceof Enums) {
                return new ConvertingMarshaller(DefaultMethodFactory.getMarshaller(ctype.getRealType(), convention, (Enums)enums), DataConverters.getParameterConverter(type2, (Enums)enums));
            }
            return DefaultMethodFactory.newConvertingMarshallerWithHash(type2, convention, enums, ctype);
        }
        return null;
    }

    private static ParameterMarshaller newConvertingMarshallerWithHash(Type type2, CallingConvention convention, IRubyObject enums, MappedType ctype) {
        return new ConvertingMarshaller(DefaultMethodFactory.getMarshaller(ctype.getRealType(), convention, enums.isNil() ? null : (RubyHash)enums), DataConverters.getParameterConverter(type2, enums.isNil() ? null : (RubyHash)enums));
    }

    static ParameterMarshaller getEnumMarshaller(Type type2, CallingConvention convention, IRubyObject enums) {
        if (!(enums == null || enums.isNil() || enums instanceof RubyHash || enums instanceof Enums)) {
            throw type2.getRuntime().newArgumentError("wrong argument type " + enums.getMetaClass().getName() + " (expected Hash or Enums)");
        }
        NativeDataConverter converter = DataConverters.getParameterConverter(type2, (Enums)enums);
        ParameterMarshaller marshaller = DefaultMethodFactory.getMarshaller(type2.getNativeType());
        return converter != null ? new ConvertingMarshaller(marshaller, converter) : marshaller;
    }

    static ParameterMarshaller getMarshaller(NativeType type2) {
        switch (type2) {
            case BOOL: {
                return BooleanMarshaller.INSTANCE;
            }
            case CHAR: {
                return Signed8Marshaller.INSTANCE;
            }
            case UCHAR: {
                return Unsigned8Marshaller.INSTANCE;
            }
            case SHORT: {
                return Signed16Marshaller.INSTANCE;
            }
            case USHORT: {
                return Unsigned16Marshaller.INSTANCE;
            }
            case INT: {
                return Signed32Marshaller.INSTANCE;
            }
            case UINT: {
                return Unsigned32Marshaller.INSTANCE;
            }
            case LONG_LONG: {
                return Signed64Marshaller.INSTANCE;
            }
            case ULONG_LONG: {
                return Unsigned64Marshaller.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Marshaller.INSTANCE : Signed64Marshaller.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Marshaller.INSTANCE : Unsigned64Marshaller.INSTANCE;
            }
            case FLOAT: {
                return Float32Marshaller.INSTANCE;
            }
            case DOUBLE: {
                return Float64Marshaller.INSTANCE;
            }
            case STRING: 
            case TRANSIENT_STRING: {
                return StringMarshaller.INSTANCE;
            }
            case POINTER: {
                return BufferMarshaller.INOUT;
            }
            case BUFFER_IN: {
                return BufferMarshaller.IN;
            }
            case BUFFER_OUT: {
                return BufferMarshaller.OUT;
            }
            case BUFFER_INOUT: {
                return BufferMarshaller.INOUT;
            }
        }
        throw new IllegalArgumentException("Invalid parameter type: " + (Object)((Object)type2));
    }

    static final class ConvertingMarshaller
    implements ParameterMarshaller {
        private final ParameterMarshaller nativeMarshaller;
        private final NativeDataConverter converter;

        public ConvertingMarshaller(ParameterMarshaller nativeMarshaller, NativeDataConverter converter) {
            this.nativeMarshaller = nativeMarshaller;
            this.converter = converter;
        }

        @Override
        public void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            ThreadContext context = invocation.getThreadContext();
            IRubyObject nativeValue = this.converter.toNative(context, parameter);
            if (this.converter.isReferenceRequired()) {
                invocation.addReference(nativeValue);
            }
            this.nativeMarshaller.marshal(context, buffer, nativeValue);
        }

        @Override
        public void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            this.nativeMarshaller.marshal(context, buffer, this.converter.toNative(context, parameter));
        }

        @Override
        public boolean requiresPostInvoke() {
            return this.converter.isPostInvokeRequired();
        }

        @Override
        public boolean requiresReference() {
            return this.converter.isReferenceRequired();
        }
    }

    static final class StructByValueMarshaller
    extends NonSessionMarshaller {
        private final StructLayout layout;

        public StructByValueMarshaller(StructByValue sbv) {
            this.layout = sbv.getStructLayout();
        }

        @Override
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            if (!(parameter instanceof Struct)) {
                throw context.runtime.newTypeError("wrong argument type " + parameter.getMetaClass().getName() + " (expected instance of FFI::Struct)");
            }
            AbstractMemory memory = ((Struct)parameter).getMemory();
            if (memory.getSize() < (long)this.layout.getSize()) {
                throw context.runtime.newArgumentError("struct memory too small for parameter");
            }
            MemoryIO io2 = memory.getMemoryIO();
            if (io2.isDirect()) {
                if (io2.isNull()) {
                    throw context.runtime.newRuntimeError("Cannot use a NULL pointer as a struct by value argument");
                }
                buffer.putStruct(io2.address());
            } else if (io2 instanceof ArrayMemoryIO) {
                ArrayMemoryIO aio = (ArrayMemoryIO)io2;
                buffer.putStruct(aio.array(), aio.arrayOffset());
            } else {
                throw context.runtime.newRuntimeError("invalid struct memory");
            }
        }
    }

    static final class StringMarshaller
    extends PointerParameterMarshaller {
        public static final ParameterMarshaller INSTANCE = new StringMarshaller(5);

        StringMarshaller(int flags2) {
            super(flags2);
        }

        @Override
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            this.marshal(context, buffer, parameter, JITRuntime.stringParameterStrategy(parameter));
        }
    }

    static final class BufferMarshaller
    extends PointerParameterMarshaller {
        static final ParameterMarshaller IN = new BufferMarshaller(1);
        static final ParameterMarshaller OUT = new BufferMarshaller(2);
        static final ParameterMarshaller INOUT = new BufferMarshaller(3);

        public BufferMarshaller(int flags2) {
            super(flags2);
        }

        @Override
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            this.marshal(context, buffer, parameter, JITRuntime.pointerParameterStrategy(parameter));
        }
    }

    static abstract class PointerParameterMarshaller
    extends NonSessionMarshaller {
        private final int flags;

        public PointerParameterMarshaller(int flags2) {
            this.flags = flags2;
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter, PointerParameterStrategy strategy) {
            if (strategy.isDirect()) {
                buffer.putAddress(strategy.address(parameter));
            } else {
                buffer.putArray((byte[])byte[].class.cast(strategy.object(parameter)), strategy.offset(parameter), strategy.length(parameter), this.flags);
            }
        }
    }

    static final class Float64Marshaller
    extends NonSessionMarshaller {
        public static final ParameterMarshaller INSTANCE = new Float64Marshaller();

        Float64Marshaller() {
        }

        @Override
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putDouble(RubyNumeric.num2dbl(parameter));
        }
    }

    static final class Float32Marshaller
    extends NonSessionMarshaller {
        public static final ParameterMarshaller INSTANCE = new Float32Marshaller();

        Float32Marshaller() {
        }

        @Override
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putFloat((float)RubyNumeric.num2dbl(parameter));
        }
    }

    static final class Unsigned64Marshaller
    extends NonSessionMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned64Marshaller();

        Unsigned64Marshaller() {
        }

        @Override
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putLong(JITRuntime.u64Value64(parameter));
        }
    }

    static final class Signed64Marshaller
    extends NonSessionMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed64Marshaller();

        Signed64Marshaller() {
        }

        @Override
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putLong(JITRuntime.s64Value64(parameter));
        }
    }

    static final class Unsigned32Marshaller
    extends NonSessionMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned32Marshaller();

        Unsigned32Marshaller() {
        }

        @Override
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putInt(JITRuntime.u32Value32(parameter));
        }
    }

    static final class Signed32Marshaller
    extends NonSessionMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed32Marshaller();

        Signed32Marshaller() {
        }

        @Override
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putInt(JITRuntime.s32Value32(parameter));
        }
    }

    static final class Unsigned16Marshaller
    extends NonSessionMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned16Marshaller();

        Unsigned16Marshaller() {
        }

        @Override
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putShort(JITRuntime.u16Value32(parameter));
        }
    }

    static final class Signed16Marshaller
    extends NonSessionMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed16Marshaller();

        Signed16Marshaller() {
        }

        @Override
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putShort(JITRuntime.s16Value32(parameter));
        }
    }

    static final class Unsigned8Marshaller
    extends NonSessionMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned8Marshaller();

        Unsigned8Marshaller() {
        }

        @Override
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putByte(JITRuntime.u8Value32(parameter));
        }
    }

    static final class Signed8Marshaller
    extends NonSessionMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed8Marshaller();

        Signed8Marshaller() {
        }

        @Override
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putByte(JITRuntime.s8Value32(parameter));
        }
    }

    static final class BooleanMarshaller
    extends NonSessionMarshaller {
        public static final ParameterMarshaller INSTANCE = new BooleanMarshaller();

        BooleanMarshaller() {
        }

        @Override
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putByte(JITRuntime.boolValue32(parameter));
        }
    }

    static abstract class NonSessionMarshaller
    implements ParameterMarshaller {
        NonSessionMarshaller() {
        }

        @Override
        public final boolean requiresPostInvoke() {
            return false;
        }

        @Override
        public final boolean requiresReference() {
            return false;
        }

        @Override
        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            this.marshal(invocation.getThreadContext(), buffer, parameter);
        }
    }

    private static final class ConvertingInvoker
    extends BaseInvoker {
        private final FunctionInvoker nativeInvoker;
        private final NativeDataConverter converter;

        public ConvertingInvoker(FunctionInvoker nativeInvoker, NativeDataConverter converter) {
            this.nativeInvoker = nativeInvoker;
            this.converter = converter;
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return this.converter.fromNative(context, this.nativeInvoker.invoke(context, function, args2));
        }
    }

    private static final class StructByValueInvoker
    extends BaseInvoker {
        private final StructByValue info;

        public StructByValueInvoker(StructByValue info) {
            this.info = info;
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            int arrayOffset;
            byte[] array2;
            int size2 = this.info.getStructLayout().getSize();
            Buffer buf = new Buffer(context.runtime, size2);
            MemoryIO mem = buf.getMemoryIO();
            if (mem instanceof ArrayMemoryIO) {
                ArrayMemoryIO arrayMemoryIO = (ArrayMemoryIO)mem;
                array2 = arrayMemoryIO.array();
                arrayOffset = arrayMemoryIO.arrayOffset();
            } else {
                array2 = new byte[size2];
                arrayOffset = 0;
            }
            invoker.invokeStruct(function, args2, array2, arrayOffset);
            if (!(mem instanceof ArrayMemoryIO)) {
                mem.put(0L, array2, 0, array2.length);
            }
            return this.info.getStructClass().newInstance(context, buf, Block.NULL_BLOCK);
        }
    }

    private static final class StringInvoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new StringInvoker();

        private StringInvoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return JITRuntime.newString(context, invoker.invokeAddress(function, args2));
        }
    }

    private static final class Pointer64Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Pointer64Invoker();

        private Pointer64Invoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return JITRuntime.newPointer64(context, invoker.invokeAddress(function, args2));
        }
    }

    private static final class Pointer32Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Pointer32Invoker();

        private Pointer32Invoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return JITRuntime.newPointer32(context, invoker.invokeAddress(function, args2));
        }
    }

    private static final class Float64Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Float64Invoker();

        private Float64Invoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return context.runtime.newFloat(invoker.invokeDouble(function, args2));
        }
    }

    private static final class Float32Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Float32Invoker();

        private Float32Invoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return context.runtime.newFloat(invoker.invokeFloat(function, args2));
        }
    }

    private static final class Unsigned64Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned64Invoker();

        private Unsigned64Invoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return JITRuntime.newUnsigned64(context, invoker.invokeLong(function, args2));
        }
    }

    private static final class Signed64Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Signed64Invoker();

        private Signed64Invoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return JITRuntime.newSigned64(context, invoker.invokeLong(function, args2));
        }
    }

    private static final class Unsigned32Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned32Invoker();

        private Unsigned32Invoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return JITRuntime.newUnsigned32(context, invoker.invokeInt(function, args2));
        }
    }

    private static final class Signed32Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Signed32Invoker();

        private Signed32Invoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return JITRuntime.newSigned32(context, invoker.invokeInt(function, args2));
        }
    }

    private static final class Unsigned16Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned16Invoker();

        private Unsigned16Invoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return JITRuntime.newUnsigned16(context, invoker.invokeInt(function, args2));
        }
    }

    private static final class Signed16Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Signed16Invoker();

        private Signed16Invoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return JITRuntime.newSigned16(context, invoker.invokeInt(function, args2));
        }
    }

    private static final class Unsigned8Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned8Invoker();

        private Unsigned8Invoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return JITRuntime.newUnsigned8(context, invoker.invokeInt(function, args2));
        }
    }

    private static final class Signed8Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Signed8Invoker();

        private Signed8Invoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return JITRuntime.newSigned8(context, invoker.invokeInt(function, args2));
        }
    }

    private static final class BooleanInvoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new BooleanInvoker();

        private BooleanInvoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            return JITRuntime.newBoolean(context, invoker.invokeInt(function, args2));
        }
    }

    private static final class VoidInvoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new VoidInvoker();

        private VoidInvoker() {
        }

        @Override
        public final IRubyObject invoke(ThreadContext context, Function function, HeapInvocationBuffer args2) {
            invoker.invokeInt(function, args2);
            return context.nil;
        }
    }

    private static abstract class BaseInvoker
    implements FunctionInvoker {
        static final Invoker invoker = Invoker.getInstance();

        private BaseInvoker() {
        }
    }

    private static final class SingletonHolder {
        private static final DefaultMethodFactory INSTANCE = new DefaultMethodFactory();

        private SingletonHolder() {
        }
    }
}

