/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import javax.swing.SwingUtilities;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.JaveleonModule;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ModuleHistory;
import org.netbeans.core.startup.NbInstaller;
import org.openide.modules.Dependency;
import org.openide.util.Exceptions;

class JaveleonModuleReloader {
    private static JaveleonModuleReloader reloader = new JaveleonModuleReloader();
    private HashMap<String, Module> registeredModules = new HashMap();

    static JaveleonModuleReloader getDefault() {
        return reloader;
    }

    private JaveleonModuleReloader() {
    }

    boolean reloadJaveleonModule(File file, ModuleManager moduleManager, NbInstaller nbInstaller, Events events) throws IOException {
        if (!JaveleonModule.incrementGlobalId()) {
            return false;
        }
        System.err.println("Start Javeleon module update...");
        Module module = null;
        JaveleonModule javeleonModule = null;
        for (Module module2 : moduleManager.getModules()) {
            if (module2.getJarFile() == null || !file.equals(module2.getJarFile())) continue;
            module = module2;
            javeleonModule = this.createJaveleonModule(moduleManager, file, new ModuleHistory(file.getAbsolutePath()));
            break;
        }
        if (module == null) {
            return false;
        }
        List list = moduleManager.simulateJaveleonReload(module);
        this.setupClassLoaderForJaveleonModule(moduleManager, javeleonModule);
        this.refreshLayer(module, (Module)javeleonModule, nbInstaller, moduleManager);
        for (Module module2 : list) {
            File file2 = module2.getJarFile();
            JaveleonModule javeleonModule2 = this.createJaveleonModule(moduleManager, file2, new ModuleHistory(file2.getAbsolutePath()));
            this.setupClassLoaderForJaveleonModule(moduleManager, javeleonModule2);
            this.refreshLayer(module2, (Module)javeleonModule2, nbInstaller, moduleManager);
        }
        System.err.println("Javeleon finished module update...");
        MainLookup.systemClassLoaderChanged(moduleManager.getClassLoader());
        events.log("finishDeployTestModule", new Object[]{file});
        return true;
    }

    private JaveleonModule createJaveleonModule(ModuleManager moduleManager, File file, Object object) throws IOException {
        try {
            return new JaveleonModule(moduleManager, file.getAbsoluteFile(), object, moduleManager.getEvents());
        }
        catch (IOException iOException) {
            System.err.println("EXCEPTION IN MGR.createJav...");
            throw iOException;
        }
    }

    private void setupClassLoaderForJaveleonModule(ModuleManager moduleManager, JaveleonModule javeleonModule) throws InvalidException {
        try {
            Dependency[] dependencyArray = javeleonModule.getDependenciesArray();
            HashSet<Module> hashSet = new HashSet<Module>(dependencyArray.length * 4 / 3 + 1);
            for (Dependency dependency : dependencyArray) {
                if (dependency.getType() != 1) continue;
                String string = (String)Util.parseCodeName((String)dependency.getName())[0];
                Module module = moduleManager.get(string);
                if (module == null) {
                    throw new IOException("Parent " + string + " not found!");
                }
                hashSet.add(module);
            }
            javeleonModule.classLoaderUp(hashSet);
        }
        catch (IOException iOException) {
            InvalidException invalidException = new InvalidException((Module)javeleonModule, iOException.toString());
            invalidException.initCause((Throwable)iOException);
            throw invalidException;
        }
    }

    private Set<?> getOpenTopComponents(ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass("org.openide.windows.WindowManager");
            Object object = clazz.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
            Object object2 = clazz.getMethod("getRegistry", new Class[0]).invoke(object, new Object[0]);
            Class<?> clazz2 = classLoader.loadClass("org.openide.windows.TopComponent$Registry");
            return (Set)clazz2.getMethod("getOpened", new Class[0]).invoke(object2, new Object[0]);
        }
        catch (Exception exception) {
            return Collections.emptySet();
        }
    }

    private void restoreOpenTopComponents(final ClassLoader classLoader, final Set<?> set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Class<?> clazz = classLoader.loadClass("org.openide.windows.TopComponent");
                    for (Object e : set) {
                        clazz.getMethod("open", new Class[0]).invoke(e, new Object[0]);
                    }
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        });
    }

    private void refreshLayer(Module module, Module module2, NbInstaller nbInstaller, ModuleManager moduleManager) {
        try {
            boolean bl = this.layersChanged(module, module2);
            Set<?> set = null;
            if (bl) {
                set = this.getOpenTopComponents(moduleManager.getClassLoader());
                Module module3 = this.getAndClearRegisteredModule(module);
                nbInstaller.loadLayers(Collections.singletonList(module3), false);
                nbInstaller.dispose(module3);
            }
            moduleManager.replaceJaveleonModule(module, module2);
            if (bl) {
                nbInstaller.prepare(module2);
                nbInstaller.loadLayers(Collections.singletonList(module2), true);
                this.registerModule(module2);
                this.restoreOpenTopComponents(moduleManager.getClassLoader(), set);
            }
            if (!bl && !(module instanceof JaveleonModule)) {
                this.registerModule(module);
            }
        }
        catch (InvalidException invalidException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    private boolean layersChanged(Module module, Module module2) {
        return this.CRC32Layer(module) != this.CRC32Layer(module2) || this.CRC32GeneratedLayer(module) != this.CRC32GeneratedLayer(module2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calculateChecksum(URL uRL) {
        long l;
        if (uRL == null) {
            return -1L;
        }
        InputStream inputStream = uRL.openStream();
        try {
            CheckedInputStream checkedInputStream = new CheckedInputStream(inputStream, new CRC32());
            byte[] byArray = new byte[1024];
            while (checkedInputStream.read(byArray) >= 0) {
            }
            checkedInputStream.close();
            l = checkedInputStream.getChecksum().getValue();
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return -1L;
            }
        }
        inputStream.close();
        return l;
    }

    private long CRC32Layer(Module module) {
        String string = module.getManifest().getMainAttributes().getValue("OpenIDE-Module-Layer");
        String string2 = module.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
        if (string != null && string2 == null) {
            URL uRL = module.getClassLoader().getResource(string);
            return this.calculateChecksum(uRL);
        }
        return -1L;
    }

    private long CRC32GeneratedLayer(Module module) {
        String string = "META-INF/generated-layer.xml";
        URL uRL = module.getClassLoader().getResource(string);
        return this.calculateChecksum(uRL);
    }

    private Module getAndClearRegisteredModule(Module module) {
        return this.registeredModules.containsKey(module.getCodeNameBase()) ? this.registeredModules.remove(module.getCodeNameBase()) : module;
    }

    private void registerModule(Module module) {
        this.registeredModules.put(module.getCodeNameBase(), module);
    }
}

