/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.plugins;

import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.artifact.MavenArtifactNotationParserFactory;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publication.WritableMavenProjectIdentity;
import org.gradle.api.publish.maven.internal.publisher.MutableMavenProjectIdentity;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.publish.maven.tasks.PublishToMavenLocal;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class MavenPublishPlugin
implements Plugin<Project> {
    public static final String PUBLISH_LOCAL_LIFECYCLE_TASK_NAME = "publishToMavenLocal";
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final FileResolver fileResolver;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final FileCollectionFactory fileCollectionFactory;
    private final FeaturePreviews featurePreviews;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final ProviderFactory providerFactory;

    @Inject
    public MavenPublishPlugin(Instantiator instantiator, ObjectFactory objectFactory, DependencyMetaDataProvider dependencyMetaDataProvider, FileResolver fileResolver, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory, FeaturePreviews featurePreviews, ImmutableAttributesFactory immutableAttributesFactory, ProviderFactory providerFactory) {
        this.instantiator = instantiator;
        this.objectFactory = objectFactory;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.fileResolver = fileResolver;
        this.projectDependencyResolver = projectDependencyResolver;
        this.fileCollectionFactory = fileCollectionFactory;
        this.featurePreviews = featurePreviews;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.providerFactory = providerFactory;
    }

    public void apply(final Project project) {
        project.getPluginManager().apply(PublishingPlugin.class);
        TaskContainer tasks = project.getTasks();
        tasks.register(PUBLISH_LOCAL_LIFECYCLE_TASK_NAME, (Action)new Action<Task>(){

            public void execute(Task publish) {
                publish.setDescription("Publishes all Maven publications produced by this project to the local Maven cache.");
                publish.setGroup("publishing");
            }
        });
        project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

            public void execute(PublishingExtension extension) {
                extension.getPublications().registerFactory(MavenPublication.class, (NamedDomainObjectFactory)new MavenPublicationFactory(MavenPublishPlugin.this.dependencyMetaDataProvider, MavenPublishPlugin.this.instantiator, MavenPublishPlugin.this.fileResolver));
                MavenPublishPlugin.this.realizePublishingTasksLater(project, extension);
            }
        });
    }

    private void realizePublishingTasksLater(Project project, final PublishingExtension extension) {
        final NamedDomainObjectSet mavenPublications = extension.getPublications().withType(MavenPublicationInternal.class);
        final TaskContainer tasks = project.getTasks();
        final DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        final TaskProvider publishLifecycleTask = tasks.named("publish");
        final TaskProvider publishLocalLifecycleTask = tasks.named(PUBLISH_LOCAL_LIFECYCLE_TASK_NAME);
        mavenPublications.all((Action)new Action<MavenPublicationInternal>(){

            public void execute(MavenPublicationInternal publication) {
                MavenPublishPlugin.this.createGenerateMetadataTask(tasks, publication, (Set)mavenPublications, buildDirectory);
                MavenPublishPlugin.this.createGeneratePomTask(tasks, publication, buildDirectory);
                MavenPublishPlugin.this.createLocalInstallTask(tasks, (TaskProvider<Task>)publishLocalLifecycleTask, publication);
                MavenPublishPlugin.this.createPublishTasksForEachMavenRepo(tasks, extension, (TaskProvider<Task>)publishLifecycleTask, publication);
            }
        });
    }

    private void createPublishTasksForEachMavenRepo(final TaskContainer tasks, PublishingExtension extension, final TaskProvider<Task> publishLifecycleTask, final MavenPublicationInternal publication) {
        final String publicationName = publication.getName();
        NamedDomainObjectList repositories = extension.getRepositories().withType(MavenArtifactRepository.class);
        repositories.all((Action)new Action<MavenArtifactRepository>(){

            public void execute(final MavenArtifactRepository repository) {
                final String repositoryName = repository.getName();
                final String publishTaskName = "publish" + StringUtils.capitalize((String)publicationName) + "PublicationTo" + StringUtils.capitalize((String)repositoryName) + "Repository";
                tasks.register(publishTaskName, PublishToMavenRepository.class, (Action)new Action<PublishToMavenRepository>(){

                    public void execute(PublishToMavenRepository publishTask) {
                        publishTask.setPublication(publication);
                        publishTask.setRepository(repository);
                        publishTask.setGroup("publishing");
                        publishTask.setDescription("Publishes Maven publication '" + publicationName + "' to Maven repository '" + repositoryName + "'.");
                    }
                });
                publishLifecycleTask.configure((Action)new Action<Task>(){

                    public void execute(Task task) {
                        task.dependsOn(new Object[]{publishTaskName});
                    }
                });
            }
        });
    }

    private void createLocalInstallTask(TaskContainer tasks, TaskProvider<Task> publishLocalLifecycleTask, final MavenPublicationInternal publication) {
        final String publicationName = publication.getName();
        final String installTaskName = "publish" + StringUtils.capitalize((String)publicationName) + "PublicationToMavenLocal";
        tasks.register(installTaskName, PublishToMavenLocal.class, (Action)new Action<PublishToMavenLocal>(){

            public void execute(PublishToMavenLocal publishLocalTask) {
                publishLocalTask.setPublication(publication);
                publishLocalTask.setGroup("publishing");
                publishLocalTask.setDescription("Publishes Maven publication '" + publicationName + "' to the local Maven repository.");
            }
        });
        publishLocalLifecycleTask.configure((Action)new Action<Task>(){

            public void execute(Task task) {
                task.dependsOn(new Object[]{installTaskName});
            }
        });
    }

    private void createGeneratePomTask(TaskContainer tasks, final MavenPublicationInternal publication, final DirectoryProperty buildDir) {
        final String publicationName = publication.getName();
        String descriptorTaskName = "generatePomFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
        TaskProvider generatorTask = tasks.register(descriptorTaskName, GenerateMavenPom.class, (Action)new Action<GenerateMavenPom>(){

            public void execute(GenerateMavenPom generatePomTask) {
                generatePomTask.setDescription("Generates the Maven POM file for publication '" + publicationName + "'.");
                generatePomTask.setGroup("publishing");
                generatePomTask.setPom(publication.getPom());
                if (generatePomTask.getDestination() == null) {
                    generatePomTask.setDestination(buildDir.file("publications/" + publication.getName() + "/pom-default.xml"));
                }
            }
        });
        publication.setPomGenerator((Task)generatorTask.get());
    }

    private void createGenerateMetadataTask(TaskContainer tasks, final MavenPublicationInternal publication, final Set<? extends MavenPublicationInternal> publications, final DirectoryProperty buildDir) {
        final String publicationName = publication.getName();
        String descriptorTaskName = "generateMetadataFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
        TaskProvider generatorTask = tasks.register(descriptorTaskName, GenerateModuleMetadata.class, (Action)new Action<GenerateModuleMetadata>(){

            public void execute(GenerateModuleMetadata generateTask) {
                generateTask.setDescription("Generates the Gradle metadata file for publication '" + publicationName + "'.");
                generateTask.setGroup("publishing");
                generateTask.getPublication().set((Object)publication);
                generateTask.getPublications().set((Iterable)publications);
                RegularFileProperty outputFile = generateTask.getOutputFile();
                if (!outputFile.isPresent()) {
                    outputFile.set(buildDir.file("publications/" + publication.getName() + "/module.json"));
                }
            }
        });
        publication.setModuleDescriptorGenerator((Task)generatorTask.get());
    }

    private class MavenPublicationFactory
    implements NamedDomainObjectFactory<MavenPublication> {
        private final Instantiator instantiator;
        private final DependencyMetaDataProvider dependencyMetaDataProvider;
        private final FileResolver fileResolver;

        private MavenPublicationFactory(DependencyMetaDataProvider dependencyMetaDataProvider, Instantiator instantiator, FileResolver fileResolver) {
            this.dependencyMetaDataProvider = dependencyMetaDataProvider;
            this.instantiator = instantiator;
            this.fileResolver = fileResolver;
        }

        public MavenPublication create(String name) {
            MutableMavenProjectIdentity projectIdentity = this.createProjectIdentity();
            NotationParser<Object, MavenArtifact> artifactNotationParser = new MavenArtifactNotationParserFactory(this.instantiator, this.fileResolver).create();
            return (MavenPublication)this.instantiator.newInstance(DefaultMavenPublication.class, new Object[]{name, projectIdentity, artifactNotationParser, this.instantiator, MavenPublishPlugin.this.objectFactory, MavenPublishPlugin.this.projectDependencyResolver, MavenPublishPlugin.this.fileCollectionFactory, MavenPublishPlugin.this.featurePreviews, MavenPublishPlugin.this.immutableAttributesFactory});
        }

        private MutableMavenProjectIdentity createProjectIdentity() {
            final Module module = this.dependencyMetaDataProvider.getModule();
            WritableMavenProjectIdentity projectIdentity = new WritableMavenProjectIdentity(MavenPublishPlugin.this.objectFactory);
            projectIdentity.getGroupId().set(MavenPublishPlugin.this.providerFactory.provider((Callable)new Callable<String>(){

                @Override
                public String call() {
                    return module.getGroup();
                }
            }));
            projectIdentity.getArtifactId().set(MavenPublishPlugin.this.providerFactory.provider((Callable)new Callable<String>(){

                @Override
                public String call() {
                    return module.getName();
                }
            }));
            projectIdentity.getVersion().set(MavenPublishPlugin.this.providerFactory.provider((Callable)new Callable<String>(){

                @Override
                public String call() {
                    return module.getVersion();
                }
            }));
            return projectIdentity;
        }
    }
}

