/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.toolchain;

import java.io.File;
import java.util.Set;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.fingerprint.classpath.ClasspathFingerprinter;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.play.internal.javascript.GoogleClosureCompiler;
import org.gradle.play.internal.javascript.JavaScriptCompileSpec;
import org.gradle.play.internal.platform.PlayMajorVersion;
import org.gradle.play.internal.routes.RoutesCompileSpec;
import org.gradle.play.internal.routes.RoutesCompiler;
import org.gradle.play.internal.routes.RoutesCompilerFactory;
import org.gradle.play.internal.run.PlayApplicationRunner;
import org.gradle.play.internal.run.PlayApplicationRunnerFactory;
import org.gradle.play.internal.spec.PlayCompileSpec;
import org.gradle.play.internal.toolchain.DaemonPlayCompiler;
import org.gradle.play.internal.toolchain.PlayToolProvider;
import org.gradle.play.internal.twirl.TwirlCompileSpec;
import org.gradle.play.internal.twirl.TwirlCompiler;
import org.gradle.play.internal.twirl.TwirlCompilerFactory;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.util.TreeVisitor;
import org.gradle.workers.internal.WorkerDaemonFactory;

class DefaultPlayToolProvider
implements PlayToolProvider {
    private final PathToFileResolver fileResolver;
    private final WorkerDaemonFactory workerDaemonFactory;
    private final File daemonWorkingDir;
    private final PlayPlatform targetPlatform;
    private WorkerProcessFactory workerProcessBuilderFactory;
    private final Set<File> twirlClasspath;
    private final Set<File> routesClasspath;
    private final Set<File> javaScriptClasspath;
    private final ClasspathFingerprinter fingerprinter;

    public DefaultPlayToolProvider(PathToFileResolver fileResolver, File daemonWorkingDir, WorkerDaemonFactory workerDaemonFactory, WorkerProcessFactory workerProcessBuilderFactory, PlayPlatform targetPlatform, Set<File> twirlClasspath, Set<File> routesClasspath, Set<File> javaScriptClasspath, ClasspathFingerprinter fingerprinter) {
        this.fileResolver = fileResolver;
        this.daemonWorkingDir = daemonWorkingDir;
        this.workerDaemonFactory = workerDaemonFactory;
        this.workerProcessBuilderFactory = workerProcessBuilderFactory;
        this.targetPlatform = targetPlatform;
        this.twirlClasspath = twirlClasspath;
        this.routesClasspath = routesClasspath;
        this.javaScriptClasspath = javaScriptClasspath;
        this.fingerprinter = fingerprinter;
        PlayMajorVersion.forPlatform(targetPlatform);
    }

    public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
        if (TwirlCompileSpec.class.isAssignableFrom(spec)) {
            TwirlCompiler twirlCompiler = TwirlCompilerFactory.create(this.targetPlatform);
            return this.cast((Compiler<? extends PlayCompileSpec>)new DaemonPlayCompiler<TwirlCompileSpec>(this.daemonWorkingDir, twirlCompiler, this.workerDaemonFactory, this.twirlClasspath, twirlCompiler.getClassLoaderPackages(), this.fileResolver));
        }
        if (RoutesCompileSpec.class.isAssignableFrom(spec)) {
            RoutesCompiler routesCompiler = RoutesCompilerFactory.create(this.targetPlatform);
            return this.cast((Compiler<? extends PlayCompileSpec>)new DaemonPlayCompiler<RoutesCompileSpec>(this.daemonWorkingDir, routesCompiler, this.workerDaemonFactory, this.routesClasspath, routesCompiler.getClassLoaderPackages(), this.fileResolver));
        }
        if (JavaScriptCompileSpec.class.isAssignableFrom(spec)) {
            GoogleClosureCompiler javaScriptCompiler = new GoogleClosureCompiler();
            return this.cast((Compiler<? extends PlayCompileSpec>)new DaemonPlayCompiler<JavaScriptCompileSpec>(this.daemonWorkingDir, javaScriptCompiler, this.workerDaemonFactory, this.javaScriptClasspath, javaScriptCompiler.getClassLoaderPackages(), this.fileResolver));
        }
        throw new IllegalArgumentException(String.format("Cannot create Compiler for unsupported CompileSpec type '%s'", spec.getSimpleName()));
    }

    public <T> T get(Class<T> toolType) {
        if (PlayApplicationRunner.class.isAssignableFrom(toolType)) {
            return toolType.cast(PlayApplicationRunnerFactory.create(this.targetPlatform, this.workerProcessBuilderFactory, this.fingerprinter));
        }
        throw new IllegalArgumentException(String.format("Don't know how to provide tool of type %s.", toolType.getSimpleName()));
    }

    private <T extends CompileSpec> Compiler<T> cast(Compiler<? extends PlayCompileSpec> raw) {
        Compiler<? extends PlayCompileSpec> converted = raw;
        return converted;
    }

    public boolean isAvailable() {
        return true;
    }

    public void explain(TreeVisitor<? super String> visitor) {
    }
}

