/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jvxl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class MonitorInputStream
extends FilterInputStream {
    int length;
    int position;
    int markPosition;
    int readEventCount;
    long timeBegin;

    MonitorInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.length = n;
        this.position = 0;
        this.timeBegin = System.currentTimeMillis();
    }

    @Override
    public int read() throws IOException {
        ++this.readEventCount;
        int n = super.read();
        if (n >= 0) {
            ++this.position;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        ++this.readEventCount;
        int n = super.read(byArray);
        if (n > 0) {
            this.position += n;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        ++this.readEventCount;
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.position += n3;
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this.position = (int)((long)this.position + l2);
        return l2;
    }

    @Override
    public synchronized void mark(int n) {
        super.mark(n);
        this.markPosition = this.position;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.position = this.markPosition;
        super.reset();
    }

    int getPosition() {
        return this.position;
    }

    int getLength() {
        return this.length;
    }

    int getPercentageRead() {
        return this.position * 100 / this.length;
    }

    int getReadingTimeMillis() {
        return (int)(System.currentTimeMillis() - this.timeBegin);
    }
}

