/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsPeer;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.DefaultTlsECConfigVerifier;
import org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.OCSPStatusRequest;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.ServerNameList;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContext;
import org.bouncycastle.tls.TlsCompression;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsECConfigVerifier;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsNullCompression;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;

public abstract class AbstractTlsClient
extends AbstractTlsPeer
implements TlsClient {
    protected TlsKeyExchangeFactory keyExchangeFactory;
    protected TlsClientContext context;
    protected Vector supportedGroups;
    protected Vector supportedSignatureAlgorithms;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;

    public AbstractTlsClient(TlsCrypto tlsCrypto) {
        this(tlsCrypto, new DefaultTlsKeyExchangeFactory());
    }

    public AbstractTlsClient(TlsCrypto tlsCrypto, TlsKeyExchangeFactory tlsKeyExchangeFactory) {
        super(tlsCrypto);
        this.keyExchangeFactory = tlsKeyExchangeFactory;
    }

    protected boolean allowUnexpectedServerExtension(Integer n, byte[] byArray) throws IOException {
        switch (n) {
            case 10: {
                TlsExtensionsUtils.readSupportedGroupsExtension(byArray);
                return true;
            }
            case 11: {
                TlsECCUtils.readSupportedPointFormatsExtension(byArray);
                return true;
            }
        }
        return false;
    }

    protected void checkForUnexpectedServerExtension(Hashtable hashtable, Integer n) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, n);
        if (byArray != null && !this.allowUnexpectedServerExtension(n, byArray)) {
            throw new TlsFatalAlert(47);
        }
    }

    protected TlsECConfigVerifier createECConfigVerifier() {
        int n = TlsECCUtils.getMinimumCurveBits(this.selectedCipherSuite);
        return new DefaultTlsECConfigVerifier(n, this.supportedGroups);
    }

    protected CertificateStatusRequest getCertificateStatusRequest() {
        return new CertificateStatusRequest(1, new OCSPStatusRequest(null, null));
    }

    protected Vector getSNIServerNames() {
        return null;
    }

    protected short[] getSupportedPointFormats() {
        return new short[]{0, 1, 2};
    }

    protected Vector getSupportedGroups(boolean bl, boolean bl2) {
        Vector<Integer> vector = new Vector<Integer>();
        if (bl2) {
            vector.addElement(23);
            vector.addElement(24);
        }
        if (bl) {
            vector.addElement(256);
            vector.addElement(257);
            vector.addElement(258);
        }
        return vector;
    }

    protected Vector getSupportedSignatureAlgorithms() {
        return TlsUtils.getDefaultSupportedSignatureAlgorithms(this.context);
    }

    public void init(TlsClientContext tlsClientContext) {
        this.context = tlsClientContext;
    }

    public TlsSession getSessionToResume() {
        return null;
    }

    public ProtocolVersion getClientHelloRecordLayerVersion() {
        return this.getClientVersion();
    }

    public ProtocolVersion getClientVersion() {
        return ProtocolVersion.TLSv12;
    }

    public boolean isFallback() {
        return false;
    }

    public Hashtable getClientExtensions() throws IOException {
        Vector vector;
        ProtocolVersion protocolVersion;
        CertificateStatusRequest certificateStatusRequest;
        Hashtable hashtable = new Hashtable();
        TlsExtensionsUtils.addEncryptThenMACExtension(hashtable);
        TlsExtensionsUtils.addExtendedMasterSecretExtension(hashtable);
        Vector vector2 = this.getSNIServerNames();
        if (vector2 != null) {
            TlsExtensionsUtils.addServerNameExtension(hashtable, new ServerNameList(vector2));
        }
        if ((certificateStatusRequest = this.getCertificateStatusRequest()) != null) {
            TlsExtensionsUtils.addStatusRequestExtension(hashtable, certificateStatusRequest);
        }
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion = this.context.getClientVersion())) {
            this.supportedSignatureAlgorithms = this.getSupportedSignatureAlgorithms();
            TlsUtils.addSignatureAlgorithmsExtension(hashtable, this.supportedSignatureAlgorithms);
        }
        int[] nArray = this.getCipherSuites();
        boolean bl = TlsDHUtils.containsDHECipherSuites(nArray);
        boolean bl2 = TlsECCUtils.containsECCipherSuites(nArray);
        if (bl2) {
            this.clientECPointFormats = this.getSupportedPointFormats();
            TlsECCUtils.addSupportedPointFormatsExtension(hashtable, this.clientECPointFormats);
        }
        if ((vector = this.getSupportedGroups(bl, bl2)) != null && !vector.isEmpty()) {
            this.supportedGroups = vector;
            TlsExtensionsUtils.addSupportedGroupsExtension(hashtable, vector);
        }
        return hashtable;
    }

    public ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv10;
    }

    public void notifyServerVersion(ProtocolVersion protocolVersion) throws IOException {
        if (!this.getMinimumVersion().isEqualOrEarlierVersionOf(protocolVersion)) {
            throw new TlsFatalAlert(70);
        }
    }

    public short[] getCompressionMethods() {
        return new short[]{0};
    }

    public void notifySessionID(byte[] byArray) {
    }

    public void notifySelectedCipherSuite(int n) {
        this.selectedCipherSuite = n;
    }

    public void notifySelectedCompressionMethod(short s) {
        this.selectedCompressionMethod = s;
    }

    public void processServerExtensions(Hashtable hashtable) throws IOException {
        if (hashtable != null) {
            this.checkForUnexpectedServerExtension(hashtable, TlsUtils.EXT_signature_algorithms);
            this.checkForUnexpectedServerExtension(hashtable, TlsExtensionsUtils.EXT_supported_groups);
            if (TlsECCUtils.isECCipherSuite(this.selectedCipherSuite)) {
                this.serverECPointFormats = TlsECCUtils.getSupportedPointFormatsExtension(hashtable);
            } else {
                this.checkForUnexpectedServerExtension(hashtable, TlsECCUtils.EXT_ec_point_formats);
            }
            this.checkForUnexpectedServerExtension(hashtable, TlsExtensionsUtils.EXT_padding);
        }
    }

    public void processServerSupplementalData(Vector vector) throws IOException {
        if (vector != null) {
            throw new TlsFatalAlert(10);
        }
    }

    public Vector getClientSupplementalData() throws IOException {
        return null;
    }

    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsCipher getCipher() throws IOException {
        int n = TlsUtils.getEncryptionAlgorithm(this.selectedCipherSuite);
        int n2 = TlsUtils.getMACAlgorithm(this.selectedCipherSuite);
        if (n < 0 || n2 < 0) {
            throw new TlsFatalAlert(80);
        }
        return this.context.getSecurityParameters().getMasterSecret().createCipher(new TlsCryptoParameters(this.context), n, n2);
    }

    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
    }
}

