/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

public class Regexp {
    public boolean ignoreCase;
    public String exp;
    public String prefix;
    public String suffix;
    public boolean exact;
    public int prefixLen;
    public int suffixLen;
    public int totalLen;
    public String[] mids;

    public Regexp(String s) {
        this.exp = s;
        int firstst = s.indexOf(42);
        int lastst = s.lastIndexOf(42);
        if (firstst < 0) {
            this.totalLen = s.length();
            this.exact = true;
        } else {
            this.prefixLen = firstst;
            this.prefix = firstst == 0 ? null : s.substring(0, firstst);
            this.suffixLen = s.length() - lastst - 1;
            this.suffix = this.suffixLen == 0 ? null : s.substring(lastst + 1);
            int nmids = 0;
            int pos = firstst;
            while (pos < lastst && pos >= 0) {
                ++nmids;
                pos = s.indexOf(42, pos + 1);
            }
            this.totalLen = this.prefixLen + this.suffixLen;
            if (nmids > 0) {
                this.mids = new String[nmids];
                pos = firstst;
                for (int i = 0; i < nmids; ++i) {
                    int npos;
                    if (++pos < (npos = s.indexOf(42, pos))) {
                        this.mids[i] = s.substring(pos, npos);
                        this.totalLen += this.mids[i].length();
                    }
                    pos = npos;
                }
            }
        }
    }

    final boolean matches(String s) {
        return this.matches(s, 0, s.length());
    }

    boolean matches(String s, int offset, int len) {
        if (this.exact) {
            return len == this.totalLen && this.exp.regionMatches(this.ignoreCase, 0, s, offset, len);
        }
        if (len < this.totalLen) {
            return false;
        }
        if (this.prefixLen > 0 && !this.prefix.regionMatches(this.ignoreCase, 0, s, offset, this.prefixLen) || this.suffixLen > 0 && !this.suffix.regionMatches(this.ignoreCase, 0, s, offset + len - this.suffixLen, this.suffixLen)) {
            return false;
        }
        if (this.mids == null) {
            return true;
        }
        int nmids = this.mids.length;
        int spos = offset + this.prefixLen;
        int limit = offset + len - this.suffixLen;
        for (int i = 0; i < nmids; ++i) {
            String ms = this.mids[i];
            int ml = ms.length();
            while (spos + ml <= limit && !ms.regionMatches(this.ignoreCase, 0, s, spos, ml)) {
                ++spos;
            }
            if (spos + ml > limit) {
                return false;
            }
            spos += ml;
        }
        return true;
    }
}

