// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `RemoteLogger.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Ice;

/**
 * The interface of the admin object that allows an Ice application the attach its
 * {@link RemoteLogger} to the {@link Logger} of this admin object's Ice communicator.
 *
 **/
public interface LoggerAdminPrx extends ObjectPrx
{
    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     *
     * @throws RemoteLoggerAlreadyAttachedException Raised if this remote logger is already
     * attached to this admin object.
     *
     **/
    public void attachRemoteLogger(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax)
        throws RemoteLoggerAlreadyAttachedException;

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     *
     * @throws RemoteLoggerAlreadyAttachedException Raised if this remote logger is already
     * attached to this admin object.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void attachRemoteLogger(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax, java.util.Map<String, String> context)
        throws RemoteLoggerAlreadyAttachedException;

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     *
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_attachRemoteLogger(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax);

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_attachRemoteLogger(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax, java.util.Map<String, String> context);

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_attachRemoteLogger(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax, Callback cb);

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_attachRemoteLogger(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax, java.util.Map<String, String> context, Callback cb);

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_attachRemoteLogger(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax, Callback_LoggerAdmin_attachRemoteLogger cb);

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_attachRemoteLogger(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax, java.util.Map<String, String> context, Callback_LoggerAdmin_attachRemoteLogger cb);

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_attachRemoteLogger(RemoteLoggerPrx prx,
                                                    LogMessageType[] messageTypes,
                                                    String[] traceCategories,
                                                    int messageMax,
                                                    IceInternal.Functional_VoidCallback responseCb,
                                                    IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_attachRemoteLogger(RemoteLoggerPrx prx,
                                                    LogMessageType[] messageTypes,
                                                    String[] traceCategories,
                                                    int messageMax,
                                                    IceInternal.Functional_VoidCallback responseCb,
                                                    IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_attachRemoteLogger(RemoteLoggerPrx prx,
                                                    LogMessageType[] messageTypes,
                                                    String[] traceCategories,
                                                    int messageMax,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_VoidCallback responseCb,
                                                    IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_attachRemoteLogger(RemoteLoggerPrx prx,
                                                    LogMessageType[] messageTypes,
                                                    String[] traceCategories,
                                                    int messageMax,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_VoidCallback responseCb,
                                                    IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     *
     * @param result The asynchronous result object.
     * @throws RemoteLoggerAlreadyAttachedException Raised if this remote logger is already
     * attached to this admin object.
     *
     **/
    public void end_attachRemoteLogger(Ice.AsyncResult result)
        throws RemoteLoggerAlreadyAttachedException;

    /**
     * Detaches a RemoteLogger object from the local logger.
     *
     * @param prx A proxy to the remote logger.
     *
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     *
     **/
    public boolean detachRemoteLogger(RemoteLoggerPrx prx);

    /**
     * Detaches a RemoteLogger object from the local logger.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param context The Context map to send with the invocation.
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     *
     **/
    public boolean detachRemoteLogger(RemoteLoggerPrx prx, java.util.Map<String, String> context);

    /**
     * Detaches a RemoteLogger object from the local logger.
     *
     * @param prx A proxy to the remote logger.
     *
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_detachRemoteLogger(RemoteLoggerPrx prx);

    /**
     * Detaches a RemoteLogger object from the local logger.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_detachRemoteLogger(RemoteLoggerPrx prx, java.util.Map<String, String> context);

    /**
     * Detaches a RemoteLogger object from the local logger.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_detachRemoteLogger(RemoteLoggerPrx prx, Callback cb);

    /**
     * Detaches a RemoteLogger object from the local logger.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_detachRemoteLogger(RemoteLoggerPrx prx, java.util.Map<String, String> context, Callback cb);

    /**
     * Detaches a RemoteLogger object from the local logger.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_detachRemoteLogger(RemoteLoggerPrx prx, Callback_LoggerAdmin_detachRemoteLogger cb);

    /**
     * Detaches a RemoteLogger object from the local logger.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_detachRemoteLogger(RemoteLoggerPrx prx, java.util.Map<String, String> context, Callback_LoggerAdmin_detachRemoteLogger cb);

    /**
     * Detaches a RemoteLogger object from the local logger.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_detachRemoteLogger(RemoteLoggerPrx prx,
                                                    IceInternal.Functional_BoolCallback responseCb,
                                                    IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Detaches a RemoteLogger object from the local logger.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_detachRemoteLogger(RemoteLoggerPrx prx,
                                                    IceInternal.Functional_BoolCallback responseCb,
                                                    IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Detaches a RemoteLogger object from the local logger.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_detachRemoteLogger(RemoteLoggerPrx prx,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_BoolCallback responseCb,
                                                    IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Detaches a RemoteLogger object from the local logger.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_detachRemoteLogger(RemoteLoggerPrx prx,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_BoolCallback responseCb,
                                                    IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Detaches a RemoteLogger object from the local logger.
     *
     * @param result The asynchronous result object.
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     *
     **/
    public boolean end_detachRemoteLogger(Ice.AsyncResult result);

    /**
     * Retrieves log messages recently logged.
     *
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     *
     * @param prefix The prefix of the associated local logger.
     *
     * @return The Log messages.
     *
     **/
    public LogMessage[] getLog(LogMessageType[] messageTypes, String[] traceCategories, int messageMax, Ice.StringHolder prefix);

    /**
     * Retrieves log messages recently logged.
     *
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     *
     * @param prefix The prefix of the associated local logger.
     *
     * @param context The Context map to send with the invocation.
     * @return The Log messages.
     *
     **/
    public LogMessage[] getLog(LogMessageType[] messageTypes, String[] traceCategories, int messageMax, Ice.StringHolder prefix, java.util.Map<String, String> context);

    /**
     * Retrieves log messages recently logged.
     *
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     *
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_getLog(LogMessageType[] messageTypes, String[] traceCategories, int messageMax);

    /**
     * Retrieves log messages recently logged.
     *
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_getLog(LogMessageType[] messageTypes, String[] traceCategories, int messageMax, java.util.Map<String, String> context);

    /**
     * Retrieves log messages recently logged.
     *
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLog(LogMessageType[] messageTypes, String[] traceCategories, int messageMax, Callback cb);

    /**
     * Retrieves log messages recently logged.
     *
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLog(LogMessageType[] messageTypes, String[] traceCategories, int messageMax, java.util.Map<String, String> context, Callback cb);

    /**
     * Retrieves log messages recently logged.
     *
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLog(LogMessageType[] messageTypes, String[] traceCategories, int messageMax, Callback_LoggerAdmin_getLog cb);

    /**
     * Retrieves log messages recently logged.
     *
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLog(LogMessageType[] messageTypes, String[] traceCategories, int messageMax, java.util.Map<String, String> context, Callback_LoggerAdmin_getLog cb);

    public interface FunctionalCallback_LoggerAdmin_getLog_Response
    {
        void apply(LogMessage[] ret, String prefix);
    }

    /**
     * Retrieves log messages recently logged.
     *
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLog(LogMessageType[] messageTypes,
                                        String[] traceCategories,
                                        int messageMax,
                                        FunctionalCallback_LoggerAdmin_getLog_Response responseCb,
                                        IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Retrieves log messages recently logged.
     *
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLog(LogMessageType[] messageTypes,
                                        String[] traceCategories,
                                        int messageMax,
                                        FunctionalCallback_LoggerAdmin_getLog_Response responseCb,
                                        IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Retrieves log messages recently logged.
     *
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLog(LogMessageType[] messageTypes,
                                        String[] traceCategories,
                                        int messageMax,
                                        java.util.Map<String, String> context,
                                        FunctionalCallback_LoggerAdmin_getLog_Response responseCb,
                                        IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Retrieves log messages recently logged.
     *
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLog(LogMessageType[] messageTypes,
                                        String[] traceCategories,
                                        int messageMax,
                                        java.util.Map<String, String> context,
                                        FunctionalCallback_LoggerAdmin_getLog_Response responseCb,
                                        IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Retrieves log messages recently logged.
     *
     * @param prefix The prefix of the associated local logger.
     *
     * @param result The asynchronous result object.
     * @return The Log messages.
     *
     **/
    public LogMessage[] end_getLog(Ice.StringHolder prefix, Ice.AsyncResult result);
}
