/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.main.Tools;
import freemind.modes.FreeMindFileDialog;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class ExportBranchAction
extends AbstractAction {
    private final MindMapController mMindMapController;

    public ExportBranchAction(MindMapController pMindMapController) {
        super(pMindMapController.getText("export_branch_new"));
        this.mMindMapController = pMindMapController;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MindMapNodeModel node = (MindMapNodeModel)this.mMindMapController.getSelected();
        if (this.mMindMapController.getMap() == null || node == null || node.isRoot()) {
            this.mMindMapController.getFrame().err("Could not export branch.");
            return;
        }
        if (this.mMindMapController.getMap().getFile() == null) {
            this.mMindMapController.getFrame().out("You must save the current map first!");
            this.mMindMapController.save();
        }
        FreeMindFileDialog chooser = this.mMindMapController.getFileChooser();
        chooser.setSelectedFile(new File(Tools.getFileNameProposal(node) + ".mm"));
        int returnVal = chooser.showSaveDialog(this.mMindMapController.getSelectedView());
        if (returnVal == 0) {
            int overwriteMap;
            File chosenFile = chooser.getSelectedFile();
            String ext = Tools.getExtension(chosenFile.getName());
            if (!ext.equals("mm")) {
                chosenFile = new File(chosenFile.getParent(), chosenFile.getName() + ".mm");
            }
            try {
                URL link = Tools.fileToUrl(chosenFile);
            }
            catch (MalformedURLException ex) {
                JOptionPane.showMessageDialog(this.mMindMapController.getView(), "couldn't create valid URL!");
                return;
            }
            if (chosenFile.exists() && (overwriteMap = JOptionPane.showConfirmDialog(this.mMindMapController.getView(), this.mMindMapController.getText("map_already_exists"), "FreeMind", 0)) != 0) {
                return;
            }
            MindMapNodeModel parent = (MindMapNodeModel)node.getParentNode();
            String linkToNewMapString = Tools.fileToRelativeUrlString(this.mMindMapController.getModel().getFile(), chosenFile);
            this.mMindMapController.setLink(node, linkToNewMapString);
            int nodePosition = parent.getChildPosition(node);
            this.mMindMapController.deleteNode(node);
            node.setParent(null);
            node.setFolded(false);
            ModeController newModeController = this.mMindMapController.getMode().createModeController();
            MindMapMapModel map = new MindMapMapModel(node, this.mMindMapController.getFrame(), newModeController);
            map.save(chosenFile);
            MindMapNode newNode = this.mMindMapController.addNewNode(parent, nodePosition, node.isLeft());
            this.mMindMapController.setNodeText(newNode, node.getText());
            String linkString = Tools.fileToRelativeUrlString(chosenFile, this.mMindMapController.getModel().getFile());
            this.mMindMapController.setLink(newNode, linkString);
            this.mMindMapController.newMap(map);
        }
    }
}

