/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalMarkerDeclarationAnnotationChecker$checkMarkerTargets$1;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u000f\u001a\u00020\u00072\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalMarkerDeclarationAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "WRONG_TARGETS_FOR_MARKER", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkMarkerTargets", "checkUseExperimentalUsage", "annotationClasses", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "entry", "frontend"})
public final class ExperimentalMarkerDeclarationAnnotationChecker
implements AdditionalAnnotationChecker {
    private static final Set<KotlinTarget> WRONG_TARGETS_FOR_MARKER;
    public static final ExperimentalMarkerDeclarationAnnotationChecker INSTANCE;

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries2, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(entries2, "entries");
        Intrinsics.checkParameterIsNotNull(actualTargets, "actualTargets");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        boolean isAnnotatedWithExperimental = false;
        for (KtAnnotationEntry ktAnnotationEntry : entries2) {
            FqName fqName2;
            AnnotationDescriptor annotation2;
            AnnotationDescriptor annotationDescriptor = annotation2 = (AnnotationDescriptor)trace.getBindingContext().get(BindingContext.ANNOTATION, ktAnnotationEntry);
            FqName fqName3 = fqName2 = annotationDescriptor != null ? annotationDescriptor.getFqName() : null;
            if (Intrinsics.areEqual(fqName2, ExperimentalUsageChecker.Companion.getUSE_EXPERIMENTAL_FQ_NAME())) {
                ConstantValue<?> constantValue = annotation2.getAllValueArguments().get(ExperimentalUsageChecker.Companion.getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend());
                if (!(constantValue instanceof ArrayValue)) {
                    constantValue = null;
                }
                ArrayValue arrayValue = (ArrayValue)constantValue;
                List<Object> list2 = arrayValue != null ? (List)arrayValue.getValue() : null;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                List annotationClasses = list3;
                this.checkUseExperimentalUsage(annotationClasses, trace, ktAnnotationEntry);
                continue;
            }
            if (!Intrinsics.areEqual(fqName2, ExperimentalUsageChecker.Companion.getEXPERIMENTAL_FQ_NAME())) continue;
            isAnnotatedWithExperimental = true;
        }
        if (isAnnotatedWithExperimental) {
            this.checkMarkerTargets(entries2, trace);
        }
    }

    private final void checkUseExperimentalUsage(List<? extends ConstantValue<?>> annotationClasses, BindingTrace trace, KtAnnotationEntry entry) {
        if (annotationClasses.isEmpty()) {
            trace.report(Errors.USE_EXPERIMENTAL_WITHOUT_ARGUMENTS.on((KtAnnotationEntry)((PsiElement)entry)));
            return;
        }
        for (ConstantValue<?> annotationClass : annotationClasses) {
            ClassDescriptor classDescriptor2;
            ClassifierDescriptor classifierDescriptor;
            Object object;
            ConstantValue<?> constantValue = annotationClass;
            if (!(constantValue instanceof KClassValue)) {
                constantValue = null;
            }
            if (!(((object = (KClassValue)constantValue) != null && (object = ((KClassValue)object).getValue()) != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            if ((ClassDescriptor)classifierDescriptor == null) {
                continue;
            }
            ExperimentalUsageChecker.Companion companion = ExperimentalUsageChecker.Companion;
            ExperimentalUsageChecker.Companion $receiver = companion;
            ExperimentalUsageChecker.Experimentality experimentality = $receiver.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor2);
            if (experimentality != null) continue;
            trace.report(Errors.USE_EXPERIMENTAL_ARGUMENT_IS_NOT_MARKER.on((KtAnnotationEntry)((PsiElement)entry), DescriptorUtilsKt.getFqNameSafe(classDescriptor2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMarkerTargets(List<? extends KtAnnotationEntry> entries2, BindingTrace trace) {
        AnnotationDescriptor descriptor2;
        Object v0;
        Map.Entry entry;
        Map.Entry $$_$_descriptor;
        Object element$iv;
        Object $receiver$iv;
        block6: {
            void $receiver$iv$iv;
            $receiver$iv = entries2;
            int capacity$iv22 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
            Iterable iterable = $receiver$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
            for (Object element$iv$iv : $receiver$iv$iv) {
                Map map2 = destination$iv$iv;
                KtAnnotationEntry entry2 = (KtAnnotationEntry)element$iv$iv;
                Pair pair = TuplesKt.to(entry2, trace.getBindingContext().get(BindingContext.ANNOTATION, entry2));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            $receiver$iv = destination$iv$iv.entrySet();
            Iterator capacity$iv22 = $receiver$iv.iterator();
            while (capacity$iv22.hasNext()) {
                element$iv = capacity$iv22.next();
                $$_$_descriptor = (Map.Entry)element$iv;
                entry = $$_$_descriptor;
                AnnotationDescriptor descriptor3 = (AnnotationDescriptor)entry.getValue();
                if (!(descriptor3 != null && Intrinsics.areEqual(descriptor3.getFqName(), KotlinBuiltIns.FQ_NAMES.target))) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        Map.Entry entry3 = v0;
        if (entry3 == null) {
            return;
        }
        Map.Entry targetEntry = entry3;
        element$iv = targetEntry;
        $$_$_descriptor = element$iv;
        $receiver$iv = (KtAnnotationEntry)$$_$_descriptor.getKey();
        $$_$_descriptor = element$iv;
        AnnotationDescriptor annotationDescriptor = descriptor2 = (AnnotationDescriptor)$$_$_descriptor.getValue();
        if (annotationDescriptor == null) {
            Intrinsics.throwNpe();
        }
        Set<KotlinTarget> set = AnnotationChecker.Companion.loadAnnotationTargets(annotationDescriptor);
        if (set == null) {
            return;
        }
        Set<KotlinTarget> allowedTargets = set;
        Set wrongTargets = CollectionsKt.intersect((Iterable)allowedTargets, (Iterable)WRONG_TARGETS_FOR_MARKER);
        entry = wrongTargets;
        if (!entry.isEmpty()) {
            void entry4;
            trace.report(Errors.EXPERIMENTAL_ANNOTATION_WITH_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)entry4), CollectionsKt.joinToString$default(wrongTargets, null, null, null, 0, null, ExperimentalMarkerDeclarationAnnotationChecker$checkMarkerTargets$1.INSTANCE, 31, null)));
        }
    }

    private ExperimentalMarkerDeclarationAnnotationChecker() {
    }

    static {
        ExperimentalMarkerDeclarationAnnotationChecker experimentalMarkerDeclarationAnnotationChecker;
        INSTANCE = experimentalMarkerDeclarationAnnotationChecker = new ExperimentalMarkerDeclarationAnnotationChecker();
        WRONG_TARGETS_FOR_MARKER = SetsKt.setOf(KotlinTarget.EXPRESSION, KotlinTarget.FILE);
    }
}

