/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.search.ModuleEntry;
import org.apache.ivy.core.search.OrganisationEntry;
import org.apache.ivy.core.search.RevisionEntry;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.resolver.FileSystemResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;

public class CacheResolver
extends FileSystemResolver {
    public CacheResolver() {
    }

    public CacheResolver(ResolverSettings resolverSettings) {
        this.setSettings(resolverSettings);
        this.setName("cache");
    }

    @Override
    public ResolvedModuleRevision getDependency(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) throws ParseException {
        this.clearIvyAttempts();
        ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
        ResolvedModuleRevision resolvedModuleRevision = this.getRepositoryCacheManager().findModuleInCache(dependencyDescriptor, moduleRevisionId, this.getCacheOptions(resolveData), null);
        if (resolvedModuleRevision != null) {
            Message.verbose("\t" + this.getName() + ": revision in cache: " + moduleRevisionId);
            return resolvedModuleRevision;
        }
        if (!this.getSettings().getVersionMatcher().isDynamic(moduleRevisionId)) {
            Message.verbose("\t" + this.getName() + ": no ivy file in cache found for " + moduleRevisionId);
            return null;
        }
        this.ensureConfigured();
        ResolvedResource resolvedResource = this.findIvyFileRef(dependencyDescriptor, resolveData);
        if (resolvedResource != null) {
            Message.verbose("\t" + this.getName() + ": found ivy file in cache for " + moduleRevisionId);
            Message.verbose("\t\t=> " + resolvedResource);
            ModuleRevisionId moduleRevisionId2 = ModuleRevisionId.newInstance(moduleRevisionId, resolvedResource.getRevision());
            IvyNode ivyNode = resolveData.getNode(moduleRevisionId2);
            if (ivyNode != null && ivyNode.getModuleRevision() != null) {
                Message.verbose("\t" + this.getName() + ": revision already resolved: " + moduleRevisionId2);
                return ivyNode.getModuleRevision();
            }
            resolvedModuleRevision = this.getRepositoryCacheManager().findModuleInCache(dependencyDescriptor.clone(ModuleRevisionId.newInstance(dependencyDescriptor.getDependencyRevisionId(), resolvedResource.getRevision())), dependencyDescriptor.getDependencyRevisionId(), this.getCacheOptions(resolveData), null);
            if (resolvedModuleRevision != null) {
                Message.verbose("\t" + this.getName() + ": revision in cache: " + moduleRevisionId2);
                return resolvedModuleRevision;
            }
            Message.error("\t" + this.getName() + ": inconsistent cache: clean it and resolve again");
            return null;
        }
        Message.verbose("\t" + this.getName() + ": no ivy file in cache found for " + moduleRevisionId);
        return null;
    }

    @Override
    public DownloadReport download(Artifact[] artifactArray, DownloadOptions downloadOptions) {
        this.ensureConfigured();
        this.clearArtifactAttempts();
        DownloadReport downloadReport = new DownloadReport();
        for (int i = 0; i < artifactArray.length; ++i) {
            ArtifactDownloadReport artifactDownloadReport = new ArtifactDownloadReport(artifactArray[i]);
            downloadReport.addArtifactReport(artifactDownloadReport);
            ResolvedResource resolvedResource = this.getArtifactRef(artifactArray[i], null);
            if (resolvedResource != null) {
                Message.verbose("\t[NOT REQUIRED] " + artifactArray[i]);
                ArtifactOrigin artifactOrigin = new ArtifactOrigin(artifactArray[i], true, resolvedResource.getResource().getName());
                File file = ((FileResource)resolvedResource.getResource()).getFile();
                artifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                artifactDownloadReport.setSize(file.length());
                artifactDownloadReport.setArtifactOrigin(artifactOrigin);
                artifactDownloadReport.setLocalFile(file);
                continue;
            }
            artifactDownloadReport.setDownloadStatus(DownloadStatus.FAILED);
        }
        return downloadReport;
    }

    @Override
    public boolean exists(Artifact artifact) {
        this.ensureConfigured();
        return super.exists(artifact);
    }

    @Override
    public ArtifactOrigin locate(Artifact artifact) {
        this.ensureConfigured();
        return super.locate(artifact);
    }

    @Override
    public void publish(Artifact artifact, File file, boolean bl) throws IOException {
        this.ensureConfigured();
        super.publish(artifact, file, bl);
    }

    @Override
    public OrganisationEntry[] listOrganisations() {
        this.ensureConfigured();
        return super.listOrganisations();
    }

    @Override
    public ModuleEntry[] listModules(OrganisationEntry organisationEntry) {
        this.ensureConfigured();
        return super.listModules(organisationEntry);
    }

    @Override
    public RevisionEntry[] listRevisions(ModuleEntry moduleEntry) {
        this.ensureConfigured();
        return super.listRevisions(moduleEntry);
    }

    @Override
    public void dumpSettings() {
        Message.verbose("\t" + this.getName() + " [cache]");
    }

    private void ensureConfigured() {
        if (this.getIvyPatterns().isEmpty()) {
            this.setIvyPatterns(new ArrayList());
            this.setArtifactPatterns(new ArrayList());
            RepositoryCacheManager[] repositoryCacheManagerArray = this.getSettings().getRepositoryCacheManagers();
            for (int i = 0; i < repositoryCacheManagerArray.length; ++i) {
                if (repositoryCacheManagerArray[i] instanceof DefaultRepositoryCacheManager) {
                    DefaultRepositoryCacheManager defaultRepositoryCacheManager = (DefaultRepositoryCacheManager)repositoryCacheManagerArray[i];
                    this.addIvyPattern(defaultRepositoryCacheManager.getBasedir().getAbsolutePath() + "/" + defaultRepositoryCacheManager.getIvyPattern());
                    this.addArtifactPattern(defaultRepositoryCacheManager.getBasedir().getAbsolutePath() + "/" + defaultRepositoryCacheManager.getArtifactPattern());
                    continue;
                }
                Message.verbose(repositoryCacheManagerArray[i] + ": cache implementation is not a DefaultRepositoryCacheManager:" + " unable to configure cache resolver with it");
            }
        }
    }

    @Override
    public String getTypeName() {
        return "cache";
    }
}

