/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.StyleConverter;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public final class ColorConverter
extends StyleConverter<String, Color> {
    public static ColorConverter getInstance() {
        return Holder.COLOR_INSTANCE;
    }

    private ColorConverter() {
    }

    @Override
    public Color convert(ParsedValue<String, Color> parsedValue, Font font) {
        String string = parsedValue.getValue();
        if (string == null || string.isEmpty() || "null".equals(string)) {
            return null;
        }
        try {
            return Color.web(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("not a color: " + parsedValue);
            return Color.BLACK;
        }
    }

    public String toString() {
        return "ColorConverter";
    }

    private static class Holder {
        static ColorConverter COLOR_INSTANCE = new ColorConverter();

        private Holder() {
        }
    }
}

