# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2018 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtSvg, except for defaults which are replaced by "...".
"""

# Module PySide2.QtSvg
import shiboken2 as Shiboken
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

Shiboken.Object = Object

import PySide2.QtSvg


class QGraphicsSvgItem(PySide2.QtWidgets.QGraphicsObject):

    @typing.overload
    def __init__(self, fileName: str, parentItem: PySide2.QtWidgets.QGraphicsItem = ...): ...
    @typing.overload
    def __init__(self, parentItem: PySide2.QtWidgets.QGraphicsItem = ...): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def elementId(self) -> str: ...
    def isCachingEnabled(self) -> bool: ...
    def maximumCacheSize(self) -> PySide2.QtCore.QSize: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget = ...): ...
    def renderer(self) -> PySide2.QtSvg.QSvgRenderer: ...
    def setCachingEnabled(self, arg__1: bool): ...
    def setElementId(self, id: str): ...
    def setMaximumCacheSize(self, size: PySide2.QtCore.QSize): ...
    def setSharedRenderer(self, renderer: PySide2.QtSvg.QSvgRenderer): ...
    def type(self) -> int: ...


class QSvgGenerator(PySide2.QtGui.QPaintDevice):

    def __init__(self): ...
    def description(self) -> str: ...
    def fileName(self) -> str: ...
    def metric(self, metric: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def outputDevice(self) -> PySide2.QtCore.QIODevice: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def resolution(self) -> int: ...
    def setDescription(self, description: str): ...
    def setFileName(self, fileName: str): ...
    def setOutputDevice(self, outputDevice: PySide2.QtCore.QIODevice): ...
    def setResolution(self, dpi: int): ...
    def setSize(self, size: PySide2.QtCore.QSize): ...
    def setTitle(self, title: str): ...
    @typing.overload
    def setViewBox(self, viewBox: PySide2.QtCore.QRect): ...
    @typing.overload
    def setViewBox(self, viewBox: PySide2.QtCore.QRectF): ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def title(self) -> str: ...
    def viewBox(self) -> PySide2.QtCore.QRect: ...
    def viewBoxF(self) -> PySide2.QtCore.QRectF: ...


class QSvgRenderer(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, contents: PySide2.QtCore.QByteArray, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, contents: PySide2.QtCore.QXmlStreamReader, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, filename: str, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def animated(self) -> bool: ...
    def animationDuration(self) -> int: ...
    def boundsOnElement(self, id: str) -> PySide2.QtCore.QRectF: ...
    def currentFrame(self) -> int: ...
    def defaultSize(self) -> PySide2.QtCore.QSize: ...
    def elementExists(self, id: str) -> bool: ...
    def framesPerSecond(self) -> int: ...
    def isValid(self) -> bool: ...
    @typing.overload
    def load(self, contents: PySide2.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def load(self, contents: PySide2.QtCore.QXmlStreamReader) -> bool: ...
    @typing.overload
    def load(self, filename: str) -> bool: ...
    def matrixForElement(self, id: str) -> PySide2.QtGui.QMatrix: ...
    @typing.overload
    def render(self, p: PySide2.QtGui.QPainter): ...
    @typing.overload
    def render(self, p: PySide2.QtGui.QPainter, bounds: PySide2.QtCore.QRectF): ...
    @typing.overload
    def render(self, p: PySide2.QtGui.QPainter, elementId: str, bounds: PySide2.QtCore.QRectF = ...): ...
    def setCurrentFrame(self, arg__1: int): ...
    def setFramesPerSecond(self, num: int): ...
    @typing.overload
    def setViewBox(self, viewbox: PySide2.QtCore.QRect): ...
    @typing.overload
    def setViewBox(self, viewbox: PySide2.QtCore.QRectF): ...
    def viewBox(self) -> PySide2.QtCore.QRect: ...
    def viewBoxF(self) -> PySide2.QtCore.QRectF: ...


class QSvgWidget(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, file: str, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def load(self, contents: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def load(self, file: str): ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent): ...
    def renderer(self) -> PySide2.QtSvg.QSvgRenderer: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...

# eof
