/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.filemonitor;

import javax.swing.JComboBox;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.sourceforge.glsof.common.main.AbstractFilterBar;
import net.sourceforge.glsof.common.main.Observer;
import net.sourceforge.glsof.filemonitor.MonitorTable;

public class FilterBar
extends AbstractFilterBar
implements Observer {
    private TableRowSorter<TableModel> _sorter;

    public FilterBar(MonitorTable table) {
        this._sorter = (TableRowSorter)table.getRowSorter();
    }

    @Override
    protected void createColumnsList() {
        String[] columnsNames = new String[MonitorTable.COLUMN_NAMES.length + 1];
        columnsNames[0] = "";
        System.arraycopy(MonitorTable.COLUMN_NAMES, 0, columnsNames, 1, MonitorTable.COLUMN_NAMES.length);
        this._comboColumnsList = new JComboBox<String>(columnsNames);
        this._comboColumnsList.setSelectedIndex(0);
    }

    @Override
    protected void filter() {
        this._sorter.setRowFilter(this.getRowFilter());
    }

    private RowFilter getRowFilter() {
        int selectedColumn;
        String text = this._comboFilter.getText();
        if (text.length() == 0) {
            return null;
        }
        if (!this._buttonCase.isSelected()) {
            text = "(?i)" + text;
        }
        return (selectedColumn = this._comboColumnsList.getSelectedIndex()) == 0 ? RowFilter.regexFilter(text, new int[0]) : RowFilter.regexFilter(text, selectedColumn - 1);
    }

    @Override
    public void update(Observer.NOTIFY notify, Object ... params) {
        if (notify == Observer.NOTIFY.CLEAR) {
            this._sorter.setRowFilter(null);
            this._comboColumnsList.setSelectedIndex(0);
            this._comboFilter.setText("");
        }
    }
}

