/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class DetailAnalyzeResponse
implements Streamable,
ToXContentFragment {
    private boolean customAnalyzer = false;
    private AnalyzeTokenList analyzer;
    private CharFilteredText[] charfilters;
    private AnalyzeTokenList tokenizer;
    private AnalyzeTokenList[] tokenfilters;
    static final ConstructingObjectParser<DetailAnalyzeResponse, Void> PARSER = new ConstructingObjectParser("detail", true, args -> new DetailAnalyzeResponse((Boolean)args[0], (AnalyzeTokenList)args[1], DetailAnalyzeResponse.fromList(CharFilteredText.class, (List)args[2]), (AnalyzeTokenList)args[3], DetailAnalyzeResponse.fromList(AnalyzeTokenList.class, (List)args[4])));

    DetailAnalyzeResponse() {
    }

    public DetailAnalyzeResponse(AnalyzeTokenList analyzer) {
        this(false, analyzer, null, null, null);
    }

    public DetailAnalyzeResponse(CharFilteredText[] charfilters, AnalyzeTokenList tokenizer, AnalyzeTokenList[] tokenfilters) {
        this(true, null, charfilters, tokenizer, tokenfilters);
    }

    public DetailAnalyzeResponse(boolean customAnalyzer, AnalyzeTokenList analyzer, CharFilteredText[] charfilters, AnalyzeTokenList tokenizer, AnalyzeTokenList[] tokenfilters) {
        this.customAnalyzer = customAnalyzer;
        this.analyzer = analyzer;
        this.charfilters = charfilters;
        this.tokenizer = tokenizer;
        this.tokenfilters = tokenfilters;
    }

    public AnalyzeTokenList analyzer() {
        return this.analyzer;
    }

    public DetailAnalyzeResponse analyzer(AnalyzeTokenList analyzer) {
        this.customAnalyzer = false;
        this.analyzer = analyzer;
        return this;
    }

    public CharFilteredText[] charfilters() {
        return this.charfilters;
    }

    public DetailAnalyzeResponse charfilters(CharFilteredText[] charfilters) {
        this.customAnalyzer = true;
        this.charfilters = charfilters;
        return this;
    }

    public AnalyzeTokenList tokenizer() {
        return this.tokenizer;
    }

    public DetailAnalyzeResponse tokenizer(AnalyzeTokenList tokenizer) {
        this.customAnalyzer = true;
        this.tokenizer = tokenizer;
        return this;
    }

    public AnalyzeTokenList[] tokenfilters() {
        return this.tokenfilters;
    }

    public DetailAnalyzeResponse tokenfilters(AnalyzeTokenList[] tokenfilters) {
        this.customAnalyzer = true;
        this.tokenfilters = tokenfilters;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetailAnalyzeResponse that = (DetailAnalyzeResponse)o;
        return this.customAnalyzer == that.customAnalyzer && Objects.equals(this.analyzer, that.analyzer) && Arrays.equals(this.charfilters, that.charfilters) && Objects.equals(this.tokenizer, that.tokenizer) && Arrays.equals(this.tokenfilters, that.tokenfilters);
    }

    public int hashCode() {
        int result = Objects.hash(this.customAnalyzer, this.analyzer, this.tokenizer);
        result = 31 * result + Arrays.hashCode(this.charfilters);
        result = 31 * result + Arrays.hashCode(this.tokenfilters);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("custom_analyzer", this.customAnalyzer);
        if (this.analyzer != null) {
            builder.startObject("analyzer");
            this.analyzer.toXContentWithoutObject(builder, params);
            builder.endObject();
        }
        if (this.charfilters != null) {
            builder.startArray("charfilters");
            for (Streamable streamable : this.charfilters) {
                ((CharFilteredText)streamable).toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.tokenizer != null) {
            builder.startObject("tokenizer");
            this.tokenizer.toXContentWithoutObject(builder, params);
            builder.endObject();
        }
        if (this.tokenfilters != null) {
            builder.startArray("tokenfilters");
            for (Streamable streamable : this.tokenfilters) {
                ((AnalyzeTokenList)streamable).toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder;
    }

    private static <T> T[] fromList(Class<T> clazz, List<T> list) {
        if (list == null) {
            return null;
        }
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static DetailAnalyzeResponse fromXContent(XContentParser parser) throws IOException {
        return (DetailAnalyzeResponse)PARSER.parse(parser, null);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.customAnalyzer = in.readBoolean();
        if (this.customAnalyzer) {
            int i;
            this.tokenizer = AnalyzeTokenList.readAnalyzeTokenList(in);
            int size = in.readVInt();
            if (size > 0) {
                this.charfilters = new CharFilteredText[size];
                for (i = 0; i < size; ++i) {
                    this.charfilters[i] = CharFilteredText.readCharFilteredText(in);
                }
            }
            if ((size = in.readVInt()) > 0) {
                this.tokenfilters = new AnalyzeTokenList[size];
                for (i = 0; i < size; ++i) {
                    this.tokenfilters[i] = AnalyzeTokenList.readAnalyzeTokenList(in);
                }
            }
        } else {
            this.analyzer = AnalyzeTokenList.readAnalyzeTokenList(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.customAnalyzer);
        if (this.customAnalyzer) {
            this.tokenizer.writeTo(out);
            if (this.charfilters != null) {
                out.writeVInt(this.charfilters.length);
                for (Streamable streamable : this.charfilters) {
                    ((CharFilteredText)streamable).writeTo(out);
                }
            } else {
                out.writeVInt(0);
            }
            if (this.tokenfilters != null) {
                out.writeVInt(this.tokenfilters.length);
                for (Streamable streamable : this.tokenfilters) {
                    ((AnalyzeTokenList)streamable).writeTo(out);
                }
            } else {
                out.writeVInt(0);
            }
        } else {
            this.analyzer.writeTo(out);
        }
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("custom_analyzer", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)AnalyzeTokenList.PARSER, new ParseField("analyzer", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)CharFilteredText.PARSER, new ParseField("charfilters", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)AnalyzeTokenList.PARSER, new ParseField("tokenizer", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)AnalyzeTokenList.PARSER, new ParseField("tokenfilters", new String[0]));
    }

    public static class CharFilteredText
    implements Streamable,
    ToXContentObject {
        private String name;
        private String[] texts;
        private static final ConstructingObjectParser<CharFilteredText, Void> PARSER = new ConstructingObjectParser("char_filtered_text", true, args -> new CharFilteredText((String)args[0], ((List)args[1]).toArray(new String[0])));

        CharFilteredText() {
        }

        public CharFilteredText(String name, String[] texts) {
            this.name = name;
            this.texts = texts != null ? texts : Strings.EMPTY_ARRAY;
        }

        public String getName() {
            return this.name;
        }

        public String[] getTexts() {
            return this.texts;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.name);
            builder.array("filtered_text", this.texts);
            builder.endObject();
            return builder;
        }

        public static CharFilteredText fromXContent(XContentParser parser) throws IOException {
            return (CharFilteredText)PARSER.parse(parser, null);
        }

        public static CharFilteredText readCharFilteredText(StreamInput in) throws IOException {
            CharFilteredText text = new CharFilteredText();
            text.readFrom(in);
            return text;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readString();
            this.texts = in.readStringArray();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeStringArray(this.texts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CharFilteredText that = (CharFilteredText)o;
            return Objects.equals(this.name, that.name) && Arrays.equals(this.texts, that.texts);
        }

        public int hashCode() {
            int result = Objects.hash(this.name);
            result = 31 * result + Arrays.hashCode(this.texts);
            return result;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
            PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("filtered_text", new String[0]));
        }
    }

    public static class AnalyzeTokenList
    implements Streamable,
    ToXContentObject {
        private String name;
        private AnalyzeResponse.AnalyzeToken[] tokens;
        private static final ConstructingObjectParser<AnalyzeTokenList, Void> PARSER = new ConstructingObjectParser("token_list", true, args -> new AnalyzeTokenList((String)args[0], (AnalyzeResponse.AnalyzeToken[])DetailAnalyzeResponse.fromList(AnalyzeResponse.AnalyzeToken.class, (List)args[1])));

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnalyzeTokenList that = (AnalyzeTokenList)o;
            return Objects.equals(this.name, that.name) && Arrays.equals(this.tokens, that.tokens);
        }

        public int hashCode() {
            int result = Objects.hash(this.name);
            result = 31 * result + Arrays.hashCode(this.tokens);
            return result;
        }

        AnalyzeTokenList() {
        }

        public AnalyzeTokenList(String name, AnalyzeResponse.AnalyzeToken[] tokens) {
            this.name = name;
            this.tokens = tokens;
        }

        public String getName() {
            return this.name;
        }

        public AnalyzeResponse.AnalyzeToken[] getTokens() {
            return this.tokens;
        }

        public static AnalyzeTokenList readAnalyzeTokenList(StreamInput in) throws IOException {
            AnalyzeTokenList list = new AnalyzeTokenList();
            list.readFrom(in);
            return list;
        }

        XContentBuilder toXContentWithoutObject(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("name", this.name);
            builder.startArray("tokens");
            for (AnalyzeResponse.AnalyzeToken token : this.tokens) {
                token.toXContent(builder, params);
            }
            builder.endArray();
            return builder;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.toXContentWithoutObject(builder, params);
            builder.endObject();
            return builder;
        }

        public static AnalyzeTokenList fromXContent(XContentParser parser) throws IOException {
            return (AnalyzeTokenList)PARSER.parse(parser, null);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readString();
            int size = in.readVInt();
            if (size > 0) {
                this.tokens = new AnalyzeResponse.AnalyzeToken[size];
                for (int i = 0; i < size; ++i) {
                    this.tokens[i] = AnalyzeResponse.AnalyzeToken.readAnalyzeToken(in);
                }
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            if (this.tokens != null) {
                out.writeVInt(this.tokens.length);
                for (AnalyzeResponse.AnalyzeToken token : this.tokens) {
                    token.writeTo(out);
                }
            } else {
                out.writeVInt(0);
            }
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> AnalyzeResponse.AnalyzeToken.fromXContent(p), new ParseField("tokens", new String[0]));
        }
    }

    static final class Fields {
        static final String NAME = "name";
        static final String FILTERED_TEXT = "filtered_text";
        static final String CUSTOM_ANALYZER = "custom_analyzer";
        static final String ANALYZER = "analyzer";
        static final String CHARFILTERS = "charfilters";
        static final String TOKENIZER = "tokenizer";
        static final String TOKENFILTERS = "tokenfilters";

        Fields() {
        }
    }
}

