/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.adapter.readers.molxyz.MolReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.Interface;
import org.jmol.api.JmolJDXMOLParser;
import org.jmol.api.JmolJDXMOLReader;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;

public class JcampdxReader
extends MolReader
implements JmolJDXMOLReader {
    private int selectedModel;
    private JmolJDXMOLParser mpr;
    private String acdMolFile;
    private int nPeaks;
    private Lst<String[]> acdAssignments;
    private String title;
    private String nucleus = "";
    private String type;
    private Lst<String> peakData = new Lst();
    private String allTypes;

    @Override
    public void initializeReader() throws Exception {
        this.vwr.setBooleanProperty("_JSpecView".toLowerCase(), true);
        if (this.isTrajectory) {
            Logger.warn("TRAJECTORY keyword ignored");
            this.isTrajectory = false;
        }
        if (this.reverseModels) {
            Logger.warn("REVERSE keyword ignored");
            this.reverseModels = false;
        }
        this.selectedModel = this.desiredModelNumber;
        this.desiredModelNumber = Integer.MIN_VALUE;
        if (!this.checkFilterKey("NOSYNC")) {
            this.addJmolScript("sync on");
        }
    }

    @Override
    public boolean checkLine() throws Exception {
        int n;
        int n2 = this.line.indexOf("=");
        if (n2 < 0 || !this.line.startsWith("##")) {
            return true;
        }
        String string = PT.replaceAllCharacters(this.line.substring(0, n2).trim(), " ", "").toUpperCase();
        if (string.length() > 12) {
            string = string.substring(0, 12);
        }
        if ((n = "##$MODELS   ##$PEAKS    ##$SIGNALS  ##$MOLFILE  ##NPOINTS   ##TITLE     ##PEAKASSIGN##$UVIR_ASSI##$MS_FRAGME##.OBSERVENU##DATATYPE  ".indexOf(string)) < 0) {
            return true;
        }
        if (this.mpr == null) {
            this.mpr = ((JmolJDXMOLParser)Interface.getOption("jsv.JDXMOLParser", this.vwr, "file")).set(this, this.filePath, this.htParams);
        }
        String string2 = this.line.substring(n2 + 1).trim();
        this.mpr.setLine(string2);
        switch (n) {
            case 0: {
                this.mpr.readModels();
                break;
            }
            case 12: 
            case 24: {
                this.mpr.readPeaks(n == 24, -1);
                break;
            }
            case 36: {
                this.acdMolFile = this.mpr.readACDMolFile();
                this.processModelData(this.acdMolFile, String.valueOf(this.title) + " (assigned)", "MOL", "mol", "", 0.01f, Float.NaN, true);
                if (this.asc.errorMessage == null) break;
                this.continuing = false;
                return false;
            }
            case 48: {
                this.nPeaks = PT.parseInt(string2);
                break;
            }
            case 60: {
                this.title = PT.split(string2, "$$")[0].trim();
                break;
            }
            case 72: 
            case 84: 
            case 96: {
                this.acdAssignments = this.mpr.readACDAssignments(this.nPeaks, n == 72);
                break;
            }
            case 108: {
                this.nucleus = string2.substring(1);
                break;
            }
            case 120: {
                this.type = string2;
                n = this.type.indexOf(" ");
                if (n < 0) break;
                this.type = this.type.substring(0, n);
            }
        }
        return true;
    }

    @Override
    public void finalizeSubclassReader() throws Exception {
        if (this.mpr != null) {
            this.processPeakData();
        }
        this.finalizeReaderMR();
    }

    @Override
    public void processModelData(String string, String string2, String string3, String string4, String string5, float f, float f2, boolean bl) throws Exception {
        int n = this.asc.iSet;
        AtomSetCollection atomSetCollection = null;
        Object object = SmarterJmolAdapter.staticGetAtomSetCollectionReader(this.filePath, string3, Rdr.getBR(string), this.htParams);
        if (object instanceof String) {
            Logger.warn("" + object);
            if (((String)object).startsWith(JC.READER_NOT_FOUND)) {
                this.asc.errorMessage = (String)object;
            }
        } else if ((object = SmarterJmolAdapter.staticGetAtomSetCollection((AtomSetCollectionReader)object)) instanceof String) {
            Logger.warn("" + object);
        } else {
            int n2;
            int n3;
            atomSetCollection = (AtomSetCollection)object;
            String string6 = string4;
            if (string6.length() == 0) {
                string6 = string5;
            }
            if (string6.length() != 0 && (n3 = this.findModelById(string6)) >= 0) {
                this.asc.setModelInfoForSet("jdxModelID", string6, n3);
                n2 = atomSetCollection.atomSetCount;
                while (--n2 >= 0) {
                    atomSetCollection.setModelInfoForSet("jdxBaseModel", string6, n2);
                }
                if (atomSetCollection.bondCount == 0) {
                    this.setBonding(atomSetCollection, n3);
                }
            }
            if (!Float.isNaN(f2)) {
                Logger.info("JcampdxReader applying vibration scaling of " + f2 + " to " + atomSetCollection.ac + " atoms");
                Atom[] atomArray = atomSetCollection.atoms;
                n2 = atomSetCollection.ac;
                while (--n2 >= 0) {
                    if (atomArray[n2].vib == null || Float.isNaN(atomArray[n2].vib.z)) continue;
                    atomArray[n2].vib.scale(f2);
                }
            }
            if (!Float.isNaN(f)) {
                Logger.info("JcampdxReader applying model scaling of " + f + " to " + atomSetCollection.ac + " atoms");
                Atom[] atomArray = atomSetCollection.atoms;
                n2 = atomSetCollection.ac;
                while (--n2 >= 0) {
                    atomArray[n2].scale(f);
                }
            }
            Logger.info("jdx model=" + string2 + " type=" + atomSetCollection.fileTypeName);
            this.asc.appendAtomSetCollection(-1, atomSetCollection);
        }
        this.updateModelIDs(string2, n, bl);
    }

    private void setBonding(AtomSetCollection atomSetCollection, int n) {
        int n2 = atomSetCollection.ac;
        int n3 = this.asc.getAtomSetAtomCount(n);
        if (n2 % n3 != 0) {
            Logger.warn("atom count in secondary model (" + n2 + ") is not a multiple of " + n3 + " -- bonding ignored");
            return;
        }
        Bond[] bondArray = this.asc.bonds;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            n4 += this.asc.getAtomSetBondCount(n5);
            ++n5;
        }
        n5 = n4 + this.asc.getAtomSetBondCount(n);
        int n6 = this.asc.getAtomSetAtomIndex(n);
        int n7 = atomSetCollection.atomSetCount;
        int n8 = 0;
        while (n8 < n7) {
            int n9 = atomSetCollection.getAtomSetAtomIndex(n8) - n6;
            if (atomSetCollection.getAtomSetAtomCount(n8) != n3) {
                Logger.warn("atom set atom count in secondary model (" + atomSetCollection.getAtomSetAtomCount(n8) + ") is not equal to " + n3 + " -- bonding ignored");
                return;
            }
            int n10 = n4;
            while (n10 < n5) {
                atomSetCollection.addNewBondWithOrder(bondArray[n10].atomIndex1 + n9, bondArray[n10].atomIndex2 + n9, bondArray[n10].order);
                ++n10;
            }
            ++n8;
        }
    }

    private void updateModelIDs(String string, int n, boolean bl) {
        int n2 = this.asc.atomSetCount;
        if (bl && n2 == n + 2) {
            this.asc.setCurrentModelInfo("modelID", string);
            return;
        }
        int n3 = 0;
        int n4 = n;
        while (++n4 < n2) {
            this.asc.setModelInfoForSet("modelID", String.valueOf(string) + "." + ++n3, n4);
        }
    }

    @Override
    public void addPeakData(String string) {
        this.peakData.addLast(string);
    }

    private void processPeakData() {
        String string;
        int n;
        if (this.acdAssignments != null) {
            try {
                this.mpr.setACDAssignments(this.title, String.valueOf(this.nucleus) + this.type, 0, this.acdAssignments, this.acdMolFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((n = this.peakData.size()) == 0) {
            return;
        }
        BS bS = new BS();
        boolean bl = n > 0;
        int n2 = 0;
        while (n2 < n) {
            this.line = (String)this.peakData.get(n2);
            string = this.mpr.getAttribute(this.line, "type");
            String string2 = this.mpr.getAttribute(this.line, "model");
            int n3 = this.findModelById(string2);
            if (n3 < 0) {
                Logger.warn("cannot find model " + string2 + " required for " + this.line);
            } else {
                String string3;
                this.addType(n3, string);
                String string4 = String.valueOf(string) + ": " + this.mpr.getAttribute(this.line, "title");
                String string5 = "jdxAtomSelect_" + this.mpr.getAttribute(this.line, "type");
                bS.set(n3);
                if (this.mpr.getAttribute(this.line, "atoms").length() != 0) {
                    this.processPeakSelectAtom(n3, string5, this.line);
                    string3 = String.valueOf(string) + ": ";
                } else {
                    string3 = this.processPeakSelectModel(n3, string4) ? "model: " : "ignored: ";
                }
                Logger.info(String.valueOf(string3) + this.line);
            }
            ++n2;
        }
        n2 = n = this.asc.atomSetCount;
        while (--n2 >= 0) {
            string = (String)this.asc.getAtomSetAuxiliaryInfoValue(n2, "modelID");
            if (!bl || bS.get(n2) || string.indexOf(".") < 0) continue;
            this.asc.removeAtomSet(n2);
            --n;
        }
        if (this.selectedModel == Integer.MIN_VALUE) {
            if (this.allTypes != null) {
                this.appendLoadNote(this.allTypes);
            }
        } else {
            if (this.selectedModel == 0) {
                this.selectedModel = n - 1;
            }
            n2 = this.asc.atomSetCount;
            while (--n2 >= 0) {
                if (n2 + 1 == this.selectedModel) continue;
                this.asc.removeAtomSet(n2);
            }
            if (n > 0) {
                this.appendLoadNote((String)this.asc.getAtomSetAuxiliaryInfoValue(0, "name"));
            }
        }
        n2 = this.asc.atomSetCount;
        while (--n2 >= 0) {
            this.asc.setAtomSetNumber(n2, n2 + 1);
        }
        this.asc.centralize();
    }

    private int findModelById(String string) {
        int n = this.asc.atomSetCount;
        while (--n >= 0) {
            String string2 = (String)this.asc.getAtomSetAuxiliaryInfoValue(n, "modelID");
            if (!string.equals(string2)) continue;
            return n;
        }
        return -1;
    }

    private void addType(int n, String string) {
        String string2 = this.addTypeStr((String)this.asc.getAtomSetAuxiliaryInfoValue(n, "spectrumTypes"), string);
        if (string2 == null) {
            return;
        }
        this.asc.setModelInfoForSet("spectrumTypes", string2, n);
        String string3 = this.addTypeStr(this.allTypes, string);
        if (string3 != null) {
            this.allTypes = string3;
        }
    }

    private String addTypeStr(String string, String string2) {
        if (string != null && string.contains(string2)) {
            return null;
        }
        string = string == null ? "" : String.valueOf(string) + ",";
        return String.valueOf(string) + string2;
    }

    private void processPeakSelectAtom(int n, String string, String string2) {
        Lst<String> lst = (Lst<String>)this.asc.getAtomSetAuxiliaryInfoValue(n, string);
        if (lst == null) {
            lst = new Lst<String>();
            this.asc.setModelInfoForSet(string, lst, n);
        }
        lst.addLast(string2);
    }

    private boolean processPeakSelectModel(int n, String string) {
        if (this.asc.getAtomSetAuxiliaryInfoValue(n, "jdxModelSelect") != null) {
            return false;
        }
        this.asc.setModelInfoForSet("name", string, n);
        this.asc.setModelInfoForSet("jdxModelSelect", this.line, n);
        return true;
    }

    @Override
    public void setSpectrumPeaks(int n, String string, String string2) {
    }
}

