/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.script.SV;
import org.jmol.util.C;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.MeshCapper;
import org.jmol.util.Node;
import org.jmol.util.Normix;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

public class Polyhedron {
    Map<String, Object> info;
    public String id;
    public P3 center;
    public Atom centralAtom;
    public P3[] vertices;
    public int[][] triangles;
    public int[][] faces;
    int nVertices;
    public boolean collapsed;
    private BS bsFlat;
    private float distanceRef;
    private V3[] normals;
    private short[] normixes;
    P4[] planes;
    public String smiles;
    public String smarts;
    public String polySmiles;
    private SymmetryInterface pointGroup;
    private SymmetryInterface pointGroupFamily;
    private Float volume;
    boolean visible = true;
    boolean isFullyLit;
    public boolean isValid = true;
    public short colixEdge = 0;
    public int visibilityFlags = 0;
    public short colix = (short)23;
    public int modelIndex = Integer.MIN_VALUE;
    private P3 offset;
    public float scale = 1.0f;
    public float pointScale;
    private int[][] faceTriangles;
    private int[] elemNos;

    Polyhedron() {
    }

    Polyhedron set(String string, int n, P3 p3, P3[] p3Array, int n2, int n3, int[][] nArray, int n4, int[][] nArray2, int[][] nArray3, V3[] v3Array, BS bS, boolean bl, float f, float f2) {
        this.pointScale = f2;
        this.distanceRef = f;
        if (string == null) {
            this.centralAtom = (Atom)p3;
            this.modelIndex = this.centralAtom.mi;
        } else {
            this.id = string;
            this.center = p3;
            this.modelIndex = n;
        }
        this.nVertices = n3;
        this.vertices = new P3[n2 + 1];
        this.normals = new V3[n4];
        this.faces = nArray2;
        this.faceTriangles = nArray3;
        this.bsFlat = bS;
        this.triangles = AU.newInt2(n4);
        int n5 = n2 + 1;
        while (--n5 >= 0) {
            this.vertices[n5] = p3Array[n5];
        }
        n5 = n4;
        while (--n5 >= 0) {
            this.normals[n5] = V3.newV(v3Array[n5]);
        }
        n5 = n4;
        while (--n5 >= 0) {
            this.triangles[n5] = nArray[n5];
        }
        this.collapsed = bl;
        return this;
    }

    Polyhedron setInfo(Viewer viewer, Map<String, Object> map, Atom[] atomArray) {
        try {
            Object object;
            int n;
            boolean bl;
            Object object2 = map.get("id");
            this.collapsed = map.containsKey("collapsed");
            boolean bl2 = bl = !(object2 instanceof String);
            if (object2 != null) {
                String string = this.id = bl ? ((SV)map.get("id")).asString() : object2.toString();
            }
            if (this.id == null) {
                this.centralAtom = atomArray[((SV)map.get((Object)"atomIndex")).intValue];
                this.modelIndex = this.centralAtom.mi;
            } else {
                object2 = map.get("center");
                this.center = P3.newP(bl ? SV.ptValue((SV)object2) : (P3)object2);
                object2 = map.get("modelIndex");
                this.modelIndex = object2 == null ? viewer.am.cmi : (bl ? ((SV)object2).intValue : (Integer)object2);
                object2 = map.get("color");
                this.colix = C.getColixS(object2 == null ? "gold" : (bl ? ((SV)object2).asString() : (String)object2));
                object2 = map.get("colorEdge");
                if (object2 != null) {
                    this.colixEdge = C.getColixS(bl ? ((SV)object2).asString() : object2.toString());
                }
                if ((object2 = map.get("offset")) != null) {
                    this.offset = P3.newP(bl ? SV.ptValue((SV)object2) : (P3)object2);
                }
                if ((object2 = map.get("scale")) != null) {
                    this.scale = bl ? SV.fValue((SV)object2) : ((Float)object2).floatValue();
                }
            }
            object2 = map.get("vertices");
            Lst<SV> lst = bl ? ((SV)object2).getList() : (Lst<SV>)object2;
            object2 = map.get("vertexCount");
            boolean bl3 = false;
            if (object2 != null) {
                this.nVertices = bl ? ((SV)object2).intValue : (Integer)object2;
                this.vertices = new P3[lst.size()];
                object2 = map.get("r");
                if (object2 != null) {
                    this.distanceRef = bl ? ((SV)object2).asFloat() : ((Float)object2).floatValue();
                }
            } else {
                this.nVertices = lst.size();
                this.vertices = new P3[this.nVertices + 1];
                if (this.center == null) {
                    this.vertices[this.nVertices] = SV.ptValue((SV)map.get("ptRef"));
                } else {
                    this.vertices[this.nVertices] = this.center;
                    bl3 = true;
                }
            }
            int n2 = lst.size();
            while (--n2 >= 0) {
                object2 = lst.get(n2);
                P3 p3 = this.vertices[n2] = bl ? SV.ptValue((SV)object2) : (P3)object2;
            }
            object2 = map.get("elemNos");
            if (object2 != null) {
                lst = bl ? ((SV)object2).getList() : (Lst<SV>)object2;
                n2 = this.nVertices;
                while (--n2 >= 0) {
                    object2 = lst.get(n2);
                    int n3 = n = bl ? ((SV)object2).intValue : (Integer)object2;
                    if (n <= 0) continue;
                    object = new Point3fi();
                    ((T3)object).setT(this.vertices[n2]);
                    ((Point3fi)object).sD = (short)n;
                    this.vertices[n2] = object;
                }
            }
            if ((object2 = map.get("pointScale")) != null) {
                this.pointScale = Math.max(0.0f, bl ? SV.fValue((SV)object2) : ((Float)object2).floatValue());
            }
            this.faces = this.toInt2(bl, map.get("faces"));
            object2 = map.get("triangles");
            if (object2 == null) {
                if (bl3) {
                    this.faceTriangles = AU.newInt2(this.faces.length);
                    this.triangles = ((MeshCapper)Interface.getInterface("org.jmol.util.MeshCapper", viewer, "script")).set(null).triangulateFaces(this.faces, this.vertices, this.faceTriangles);
                } else {
                    this.triangles = this.faces;
                    this.faces = null;
                }
            } else {
                this.triangles = this.toInt2(bl, object2);
            }
            this.normals = new V3[this.triangles.length];
            V3 v3 = new V3();
            n = this.triangles.length;
            while (--n >= 0) {
                this.normals[n] = new V3();
                object = this.triangles[n];
                Measure.getNormalThroughPoints(this.vertices[object[0]], this.vertices[object[1]], this.vertices[object[2]], this.normals[n], v3);
            }
            object2 = map.get("bsFlat");
            this.bsFlat = object2 == null ? new BS() : (bl ? SV.getBitSet((SV)object2, false) : (BS)object2);
        }
        catch (Exception exception) {
            return null;
        }
        return this;
    }

    private int[][] toInt2(boolean bl, Object object) {
        Lst<SV> lst = bl ? ((SV)object).getList() : (Lst<SV>)object;
        int[][] nArray = AU.newInt2(lst.size());
        int n = nArray.length;
        while (--n >= 0) {
            object = lst.get(n);
            if (bl) {
                Lst<SV> lst2 = ((SV)object).getList();
                nArray[n] = new int[lst2.size()];
                int[] nArray2 = nArray[n];
                int n2 = nArray2.length;
                while (--n2 >= 0) {
                    nArray2[n2] = ((SV)lst2.get((int)n2)).intValue;
                }
                continue;
            }
            nArray[n] = (int[])object;
        }
        return nArray;
    }

    Map<String, Object> getInfo(Viewer viewer, String string) {
        boolean bl = string == null;
        boolean bl2 = !bl;
        Map<String, Object> map = this.info;
        if (!(bl || map == null || bl2 && !map.containsKey("face_types") || Logger.debugging)) {
            return map;
        }
        map = new Hashtable<String, Object>();
        map.put("vertexCount", this.nVertices);
        int n = bl ? this.vertices.length : this.nVertices;
        P3[] p3Array = new P3[n];
        int n2 = 0;
        while (n2 < n) {
            p3Array[n2] = P3.newP(this.vertices[n2]);
            ++n2;
        }
        map.put("vertices", p3Array);
        map.put("elemNos", this.getElemNos());
        if (this.id == null) {
            map.put("atomIndex", this.centralAtom.i);
        } else {
            map.put("id", this.id);
            map.put("center", P3.newP(this.center));
            map.put("color", C.getHexCode(this.colix));
            map.put("colorEdge", C.getHexCode(this.colixEdge == 0 ? this.colix : this.colixEdge));
            if (this.offset != null) {
                map.put("offset", this.offset);
            }
            if (this.scale != 1.0f) {
                map.put("scale", Float.valueOf(this.scale));
            }
        }
        if (this.id != null || !bl) {
            map.put("modelIndex", this.modelIndex);
        }
        if (!bl) {
            Object object;
            this.info = map;
            if (this.id == null) {
                map.put("center", P3.newP(this.centralAtom));
                map.put("modelNumber", this.centralAtom.getModelNumber());
                map.put("atomNumber", this.centralAtom.getAtomNumber());
                map.put("atomName", this.centralAtom.getInfo());
                map.put("element", this.centralAtom.getElementSymbol());
                Object object2 = viewer.ms.getInfo(this.centralAtom.mi, "Energy");
                if (object2 != null) {
                    map.put("energy", object2);
                }
            }
            map.put("triangleCount", this.triangles.length);
            map.put("volume", this.getVolume());
            String[] stringArray = new String[this.nVertices];
            int[] nArray = new int[this.nVertices];
            int n3 = this.nVertices;
            while (--n3 >= 0) {
                object = this.vertices[n3];
                boolean bl3 = object instanceof Node;
                stringArray[n3] = bl3 ? ((Node)object).getAtomName() : (object instanceof Point3fi ? Elements.elementSymbolFromNumber(((Point3fi)object).sD) : "");
                int n4 = nArray[n3] = bl3 ? ((Node)object).getIndex() : -1;
            }
            map.put("atomNames", stringArray);
            map.put("vertexIndices", nArray);
            if (this.faces != null && !this.collapsed && this.faceTriangles != null) {
                map.put("faceCount", this.faces.length);
                map.put("faceTriangles", this.faceTriangles);
                if (bl2) {
                    int[] nArray2 = new int[this.faces.length];
                    object = new float[this.faces.length];
                    Lst<P3[]> lst = new Lst<P3[]>();
                    V3 v3 = new V3();
                    V3 v32 = new V3();
                    V3 v33 = new V3();
                    int n5 = this.faces.length;
                    while (--n5 >= 0) {
                        int[] nArray3 = this.faces[n5];
                        nArray2[n5] = nArray3.length;
                        float f = 0.0f;
                        int[] nArray4 = this.faceTriangles[n5];
                        int n6 = nArray4.length;
                        while (--n6 >= 0) {
                            int[] nArray5 = this.triangles[nArray4[n6]];
                            f += this.triangleArea(nArray5[0], nArray5[1], nArray5[2], v3, v32, v33);
                        }
                        object[n5] = f;
                        P3[] p3Array2 = new P3[nArray3.length];
                        int n7 = nArray3.length;
                        while (--n7 >= 0) {
                            p3Array2[n7] = this.vertices[nArray3[n7]];
                        }
                        lst.addLast(p3Array2);
                    }
                    map.put("face_types", nArray2);
                    map.put("face_areas", object);
                    map.put("face_points", lst);
                }
            }
            if (this.smarts != null) {
                map.put("smarts", this.smarts);
            }
            if (this.smiles != null) {
                map.put("smiles", this.smiles);
            }
            if (this.polySmiles != null) {
                map.put("polySmiles", this.polySmiles);
            }
            if (this.pointGroup != null) {
                map.put("pointGroup", this.pointGroup.getPointGroupName());
            }
            if (this.pointGroupFamily != null) {
                map.put("pointGroupFamily", this.pointGroupFamily.getPointGroupName());
            }
        }
        if (this.pointScale > 0.0f) {
            map.put("pointScale", Float.valueOf(this.pointScale));
        }
        if (this.faces != null) {
            map.put("faces", this.faces);
        }
        if (bl || Logger.debugging) {
            map.put("bsFlat", this.bsFlat);
            if (this.collapsed) {
                map.put("collapsed", this.collapsed);
            }
            if (this.distanceRef != 0.0f) {
                map.put("r", Float.valueOf(this.distanceRef));
            }
            P3[] p3Array3 = new P3[this.normals.length];
            int n8 = p3Array3.length;
            while (--n8 >= 0) {
                p3Array3[n8] = P3.newP(this.normals[n8]);
            }
            if (!bl) {
                map.put("normals", p3Array3);
            }
            map.put("triangles", AU.arrayCopyII(this.triangles, this.triangles.length));
        }
        return map;
    }

    public int[] getElemNos() {
        if (this.elemNos == null) {
            this.elemNos = new int[this.nVertices];
            int n = 0;
            while (n < this.nVertices) {
                P3 p3 = this.vertices[n];
                this.elemNos[n] = p3 instanceof Node ? ((Node)((Object)p3)).getElementNumber() : (p3 instanceof Point3fi ? (int)((Point3fi)p3).sD : -2);
                ++n;
            }
        }
        return this.elemNos;
    }

    String getSymmetry(Viewer viewer, boolean bl) {
        T3[] t3Array;
        if (this.id == null && this.smarts == null) {
            this.info = null;
            t3Array = viewer.getSmilesMatcher();
            try {
                String string = this.distanceRef <= 0.0f ? null : "r=" + this.distanceRef;
                this.smarts = t3Array.polyhedronToSmiles(this.centralAtom, this.faces, this.nVertices, null, 8192, null);
                this.smiles = t3Array.polyhedronToSmiles(this.centralAtom, this.faces, this.nVertices, this.vertices, 1, null);
                this.polySmiles = t3Array.polyhedronToSmiles(this.centralAtom, this.faces, this.nVertices, this.vertices, 196609, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            return null;
        }
        if (this.pointGroup == null) {
            t3Array = new T3[this.nVertices];
            int n = t3Array.length;
            while (--n >= 0) {
                t3Array[n] = this.vertices[n];
            }
            this.pointGroup = viewer.getSymTemp().setPointGroup(null, null, t3Array, null, false, viewer.getFloat(0x22000026), viewer.getFloat(0x22000028), true);
            n = t3Array.length;
            while (--n >= 0) {
                t3Array[n] = P3.newP(this.vertices[n]);
            }
            this.pointGroupFamily = viewer.getSymTemp().setPointGroup(null, null, t3Array, null, false, viewer.getFloat(0x22000026), viewer.getFloat(0x22000028), true);
        }
        return (this.center == null ? this.centralAtom : this.center) + "    \t" + this.pointGroup.getPointGroupName() + "\t" + this.pointGroupFamily.getPointGroupName();
    }

    private Float getVolume() {
        if (this.volume != null) {
            return this.volume;
        }
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        float f = 0.0f;
        if (this.bsFlat.cardinality() < this.triangles.length) {
            int n = this.triangles.length;
            while (--n >= 0) {
                int[] nArray = this.triangles[n];
                f += this.triangleVolume(nArray[0], nArray[1], nArray[2], v3, v32, v33);
            }
        }
        return Float.valueOf(f / 6.0f);
    }

    private float triangleArea(int n, int n2, int n3, V3 v3, V3 v32, V3 v33) {
        v3.sub2(this.vertices[n2], this.vertices[n]);
        v32.sub2(this.vertices[n3], this.vertices[n]);
        v33.cross(v3, v32);
        return v33.length();
    }

    private float triangleVolume(int n, int n2, int n3, V3 v3, V3 v32, V3 v33) {
        v3.setT(this.vertices[n]);
        v32.setT(this.vertices[n2]);
        v33.cross(v3, v32);
        v32.setT(this.vertices[n3]);
        return v32.dot(v33);
    }

    String getState(Viewer viewer) {
        String string = this.id == null ? "({" + this.centralAtom.i + "})" : "ID " + Escape.e(this.id);
        return "  polyhedron @{" + Escape.e(this.getInfo(viewer, null)) + "} " + (this.isFullyLit ? " fullyLit" : "") + ";" + (this.visible ? "" : "polyhedra " + string + " off;") + "\n";
    }

    void move(M4 m4, BS bS) {
        this.info = null;
        int n = 0;
        while (n < this.nVertices) {
            block5: {
                P3 p3;
                block4: {
                    p3 = this.vertices[n];
                    if (!(p3 instanceof Atom)) break block4;
                    if (bS.get(((Atom)p3).i)) break block5;
                    p3 = this.vertices[n] = P3.newP(p3);
                }
                m4.rotTrans(p3);
            }
            ++n;
        }
        n = this.normals.length;
        while (--n >= 0) {
            m4.rotate(this.normals[n]);
        }
        this.normixes = null;
    }

    public short[] getNormixes() {
        if (this.normixes == null) {
            this.normixes = new short[this.normals.length];
            BS bS = new BS();
            int n = this.normals.length;
            while (--n >= 0) {
                short s = this.normixes[n] = this.bsFlat.get(n) ? Normix.get2SidedNormix(this.normals[n], bS) : Normix.getNormixV(this.normals[n], bS);
            }
        }
        return this.normixes;
    }

    void setOffset(P3 p3) {
        this.planes = null;
        if (this.center == null) {
            return;
        }
        P3 p32 = P3.newP(p3);
        if (this.offset != null) {
            p3.sub(this.offset);
        }
        this.offset = p32;
        int n = this.vertices.length;
        while (--n >= 0) {
            this.vertices[n].add(p3);
        }
    }
}

