/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.encoding;

import java.io.Console;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.ISO8859_16Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.spi.ISO_8859_16;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.Hash;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.ext.nkf.RubyNKF;
import org.jruby.platform.Platform;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.EncodingUtils;

public final class EncodingService {
    private final CaseInsensitiveBytesHash<EncodingDB.Entry> encodings;
    private final CaseInsensitiveBytesHash<EncodingDB.Entry> aliases;
    private final IRubyObject[] encodingList;
    private RubyEncoding[] encodingIndex = new RubyEncoding[4];
    private final Ruby runtime;
    private final Encoding ascii8bit;
    private final Encoding javaDefault;
    private static final ByteList LOCALE_BL = ByteList.create("locale");
    private static final ByteList EXTERNAL_BL = ByteList.create("external");
    private static final ByteList INTERNAL_BL = ByteList.create("internal");
    private static final ByteList FILESYSTEM_BL = ByteList.create("filesystem");
    private static ByteList defaultCharsetName;

    public EncodingService(Ruby runtime2) {
        this.runtime = runtime2;
        this.encodings = EncodingDB.getEncodings();
        this.aliases = EncodingDB.getAliases();
        this.ascii8bit = this.encodings.get("ASCII-8BIT".getBytes()).getEncoding();
        String javaDefaultCharset = Charset.defaultCharset().name();
        EncodingDB.Entry javaDefaultEntry = this.findEncodingOrAliasEntry(javaDefaultCharset.getBytes());
        this.javaDefault = javaDefaultEntry == null ? this.ascii8bit : javaDefaultEntry.getEncoding();
        this.encodingList = new IRubyObject[this.encodings.size()];
    }

    public Encoding getConsoleEncoding() {
        if (!Platform.IS_WINDOWS) {
            return null;
        }
        Encoding consoleEncoding = null;
        try {
            Console console = System.console();
            if (console != null) {
                String CONSOLE_CHARSET = "cs";
                Field fcs = Console.class.getDeclaredField("cs");
                fcs.setAccessible(true);
                Charset cs = (Charset)fcs.get(console);
                consoleEncoding = this.loadEncoding(ByteList.create(cs.name()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return consoleEncoding;
    }

    public Encoding getUSAsciiEncoding() {
        return USASCIIEncoding.INSTANCE;
    }

    public Encoding getAscii8bitEncoding() {
        return this.ascii8bit;
    }

    public Encoding getFileSystemEncoding() {
        return SpecialEncoding.FILESYSTEM.toEncoding(this.runtime);
    }

    public CaseInsensitiveBytesHash<EncodingDB.Entry> getEncodings() {
        return this.encodings;
    }

    public CaseInsensitiveBytesHash<EncodingDB.Entry> getAliases() {
        return this.aliases;
    }

    public EncodingDB.Entry findEncodingEntry(ByteList bytes2) {
        return this.encodings.get(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public EncodingDB.Entry findEncodingEntry(byte[] bytes2) {
        return this.encodings.get(bytes2);
    }

    public EncodingDB.Entry findAliasEntry(ByteList bytes2) {
        return this.aliases.get(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public EncodingDB.Entry findAliasEntry(byte[] bytes2) {
        return this.aliases.get(bytes2);
    }

    public EncodingDB.Entry findEncodingOrAliasEntry(ByteList bytes2) {
        EncodingDB.Entry e = this.findEncodingEntry(bytes2);
        return e != null ? e : this.findAliasEntry(bytes2);
    }

    public EncodingDB.Entry findEncodingOrAliasEntry(byte[] bytes2) {
        EncodingDB.Entry e = this.findEncodingEntry(bytes2);
        return e != null ? e : this.findAliasEntry(bytes2);
    }

    public Encoding getLocaleEncoding() {
        EncodingDB.Entry entry;
        Encoding consoleEncoding = this.getConsoleEncoding();
        if (consoleEncoding != null) {
            return consoleEncoding;
        }
        ByteList encName = defaultCharsetName;
        if (encName == null) {
            defaultCharsetName = encName = new ByteList(Charset.defaultCharset().name().getBytes(), false);
        }
        return (entry = this.findEncodingOrAliasEntry(encName)) == null ? ASCIIEncoding.INSTANCE : entry.getEncoding();
    }

    public IRubyObject[] getEncodingList() {
        return this.encodingList;
    }

    public Encoding loadEncoding(ByteList name2) {
        EncodingDB.Entry entry = this.findEncodingOrAliasEntry(name2);
        if (entry == null) {
            return null;
        }
        this.loadEncodingEntry(entry);
        return entry.getEncoding();
    }

    private RubyEncoding loadEncodingEntry(EncodingDB.Entry entry) {
        RubyEncoding[] encodingIndex;
        Encoding enc = entry.getEncoding();
        int index2 = enc.getIndex();
        if (index2 >= (encodingIndex = this.encodingIndex).length) {
            encodingIndex = this.encodingIndex = Arrays.copyOf(encodingIndex, index2 + 4);
        }
        encodingIndex[index2] = (RubyEncoding)this.encodingList[entry.getIndex()];
        return encodingIndex[index2];
    }

    public RubyEncoding getEncoding(Encoding enc) {
        RubyEncoding rubyEncoding;
        RubyEncoding[] encodingIndex;
        int index2 = enc.getIndex();
        if (index2 < (encodingIndex = this.encodingIndex).length && (rubyEncoding = encodingIndex[index2]) != null) {
            return rubyEncoding;
        }
        EncodingDB.Entry entry = this.findEncodingOrAliasEntry(enc.getName());
        return this.loadEncodingEntry(entry);
    }

    public void defineEncodings() {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator hei = this.encodings.entryIterator();
        while (hei.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)hei).next();
            EncodingDB.Entry ee = (EncodingDB.Entry)e.value;
            RubyEncoding encoding2 = RubyEncoding.newEncoding(this.runtime, e.bytes, e.p, e.end, ee.isDummy());
            this.encodingList[ee.getIndex()] = encoding2;
            for (String constName : EncodingUtils.encodingNames(e.bytes, e.p, e.end)) {
                this.defineEncodingConstant(this.runtime, (RubyEncoding)this.encodingList[ee.getIndex()], constName);
            }
        }
    }

    public void defineAliases() {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator i2 = this.aliases.entryIterator();
        while (i2.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)i2).next();
            EncodingDB.Entry entry = (EncodingDB.Entry)e.value;
            for (String constName : EncodingUtils.encodingNames(e.bytes, e.p, e.end)) {
                this.defineEncodingConstant(this.runtime, (RubyEncoding)this.encodingList[entry.getIndex()], constName);
            }
        }
    }

    private void defineEncodingConstant(Ruby runtime2, RubyEncoding encoding2, String constName) {
        runtime2.getEncoding().defineConstant(constName, encoding2);
    }

    public IRubyObject getDefaultExternal() {
        Encoding defaultEncoding = this.runtime.getDefaultExternalEncoding();
        if (defaultEncoding == null) {
            ByteList encodingName = ByteList.create("US-ASCII");
            defaultEncoding = this.runtime.getEncodingService().loadEncoding(encodingName);
            this.runtime.setDefaultExternalEncoding(defaultEncoding);
        }
        return this.getEncoding(defaultEncoding);
    }

    public IRubyObject getDefaultInternal() {
        return this.convertEncodingToRubyEncoding(this.runtime.getDefaultInternalEncoding());
    }

    public IRubyObject convertEncodingToRubyEncoding(Encoding defaultEncoding) {
        return defaultEncoding != null ? this.getEncoding(defaultEncoding) : this.runtime.getNil();
    }

    public IRubyObject findEncodingObject(byte[] bytes2) {
        EncodingDB.Entry entry = this.findEncodingEntry(bytes2);
        Encoding enc = entry != null ? entry.getEncoding() : ASCIIEncoding.INSTANCE;
        return this.convertEncodingToRubyEncoding(enc);
    }

    public Encoding getJavaDefault() {
        return this.javaDefault;
    }

    public Encoding getEncodingFromObject(IRubyObject arg2) {
        return this.getEncodingFromObjectCommon(arg2, true);
    }

    public Encoding getEncodingFromObjectNoError(IRubyObject arg2) {
        return this.getEncodingFromObjectCommon(arg2, false);
    }

    private Encoding getEncodingFromObjectCommon(IRubyObject arg2, boolean error2) {
        int id2;
        String name2;
        if (arg2 == null) {
            return null;
        }
        if (arg2 instanceof RubyEncoding) {
            return ((RubyEncoding)arg2).getEncoding();
        }
        if (arg2 instanceof RubyFixnum && (name2 = RubyNKF.NKFCharsetMap.get(id2 = (int)arg2.convertToInteger().getLongValue())) != null) {
            return this.getEncodingFromNKFName(name2);
        }
        if ((arg2 = arg2.checkStringType()).isNil()) {
            return null;
        }
        if (!((RubyString)arg2).getEncoding().isAsciiCompatible()) {
            return null;
        }
        return this.findEncodingCommon(((RubyString)arg2).getByteList(), error2);
    }

    private Encoding getEncodingFromNKFName(String name2) {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator hei = this.encodings.entryIterator();
        while (hei.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)hei).next();
            EncodingDB.Entry entry = (EncodingDB.Entry)e.value;
            String className = entry.getEncodingClass();
            if (!className.equals(name2)) continue;
            return entry.getEncoding();
        }
        return null;
    }

    public Encoding getEncodingFromString(String string2) {
        if (string2 == null) {
            return null;
        }
        ByteList name2 = new ByteList(ByteList.plain(string2), false);
        this.checkAsciiEncodingName(name2);
        SpecialEncoding special = SpecialEncoding.valueOf(name2);
        if (special != null) {
            return special.toEncoding(this.runtime);
        }
        return this.findEncodingWithError(name2);
    }

    public Encoding findEncoding(IRubyObject str) {
        return this.findEncodingCommon(str, true);
    }

    public Encoding findEncodingNoError(IRubyObject str) {
        return this.findEncodingCommon(str, false);
    }

    public Encoding findEncodingNoError(ByteList str) {
        return this.findEncodingCommon(str, false);
    }

    private Encoding findEncodingCommon(IRubyObject str, boolean error2) {
        ByteList name2 = str.convertToString().getByteList();
        return this.findEncodingCommon(name2, error2);
    }

    private Encoding findEncodingCommon(ByteList name2, boolean error2) {
        this.checkAsciiEncodingName(name2);
        SpecialEncoding special = SpecialEncoding.valueOf(name2);
        if (special != null) {
            return special.toEncoding(this.runtime);
        }
        if (error2) {
            return this.findEncodingWithError(name2);
        }
        EncodingDB.Entry e = this.findEncodingOrAliasEntry(name2);
        if (e == null) {
            return null;
        }
        return e.getEncoding();
    }

    public EncodingDB.Entry findEntry(IRubyObject str) {
        ByteList name2 = str.convertToString().getByteList();
        this.checkAsciiEncodingName(name2);
        SpecialEncoding special = SpecialEncoding.valueOf(name2);
        if (special != null) {
            return this.findEntryFromEncoding(special.toEncoding(this.runtime));
        }
        return this.findEntryWithError(name2);
    }

    public IRubyObject rubyEncodingFromObject(IRubyObject str) {
        if (str instanceof RubyEncoding) {
            return str;
        }
        EncodingDB.Entry entry = this.findEntry(str);
        if (entry == null) {
            return this.runtime.getNil();
        }
        return this.getEncodingList()[entry.getIndex()];
    }

    public Charset charsetForEncoding(Encoding encoding2) {
        if (encoding2 == ASCIIEncoding.INSTANCE) {
            return RubyEncoding.ISO;
        }
        if (encoding2 == ISO8859_16Encoding.INSTANCE) {
            return ISO_8859_16.INSTANCE;
        }
        try {
            return EncodingUtils.charsetForEncoding(encoding2);
        }
        catch (UnsupportedCharsetException uce) {
            throw this.runtime.newEncodingCompatibilityError("no java.nio.charset.Charset found for encoding `" + encoding2.toString() + "'");
        }
    }

    private void checkAsciiEncodingName(ByteList name2) {
        if (!name2.getEncoding().isAsciiCompatible()) {
            throw this.runtime.newArgumentError("invalid name encoding (non ASCII)");
        }
    }

    public Encoding findEncodingWithError(ByteList name2) {
        return this.findEntryWithError(name2).getEncoding();
    }

    private EncodingDB.Entry findEntryWithError(ByteList name2) {
        EncodingDB.Entry e = this.findEncodingOrAliasEntry(name2);
        if (e == null) {
            throw this.runtime.newArgumentError("unknown encoding name - " + name2);
        }
        return e;
    }

    private EncodingDB.Entry findEntryFromEncoding(Encoding e) {
        if (e == null) {
            return null;
        }
        return this.findEncodingEntry(e.getName());
    }

    @Deprecated
    public Encoding getFileSystemEncoding(Ruby runtime2) {
        return this.getFileSystemEncoding();
    }

    private static enum SpecialEncoding {
        LOCALE,
        EXTERNAL,
        INTERNAL,
        FILESYSTEM;


        public static SpecialEncoding valueOf(ByteList name2) {
            if (name2.caseInsensitiveCmp(LOCALE_BL) == 0) {
                return LOCALE;
            }
            if (name2.caseInsensitiveCmp(EXTERNAL_BL) == 0) {
                return EXTERNAL;
            }
            if (name2.caseInsensitiveCmp(INTERNAL_BL) == 0) {
                return INTERNAL;
            }
            if (name2.caseInsensitiveCmp(FILESYSTEM_BL) == 0) {
                return FILESYSTEM;
            }
            return null;
        }

        public Encoding toEncoding(Ruby runtime2) {
            switch (this) {
                case LOCALE: {
                    return runtime2.getEncodingService().getLocaleEncoding();
                }
                case EXTERNAL: {
                    return runtime2.getDefaultExternalEncoding();
                }
                case INTERNAL: {
                    return runtime2.getDefaultInternalEncoding();
                }
                case FILESYSTEM: {
                    return runtime2.getDefaultFilesystemEncoding();
                }
            }
            throw new AssertionError((Object)("invalid SpecialEncoding: " + (Object)((Object)this)));
        }
    }
}

