/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.Date;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.deliver.DefaultPublishingDRResolver;
import org.apache.ivy.core.deliver.DeliverOptions;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Echo;
import org.apache.tools.ant.taskdefs.Input;
import org.apache.tools.ant.taskdefs.Property;

public class IvyDeliver
extends IvyTask {
    private String organisation;
    private String module;
    private String revision;
    private String pubRevision;
    private String deliverpattern;
    private String status;
    private String pubdate;
    private String deliverTarget;
    private File deliveryList;
    private boolean replacedynamicrev = true;
    private boolean replaceForcedRev = false;
    private String resolveId;
    private String conf;
    private String pubBranch;
    private boolean generateRevConstraint = true;
    private boolean merge = true;

    public void setCache(File file) {
        this.cacheAttributeNotSupported();
    }

    public String getDeliverpattern() {
        return this.deliverpattern;
    }

    public void setDeliverpattern(String string) {
        this.deliverpattern = string;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String string) {
        this.organisation = string;
    }

    public String getPubdate() {
        return this.pubdate;
    }

    public void setPubdate(String string) {
        this.pubdate = string;
    }

    public String getPubrevision() {
        return this.pubRevision;
    }

    public void setPubrevision(String string) {
        this.pubRevision = string;
    }

    public String getPubbranch() {
        return this.pubBranch;
    }

    public void setPubbranch(String string) {
        this.pubBranch = string;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public void setDelivertarget(String string) {
        this.deliverTarget = string;
    }

    public void setDeliveryList(File file) {
        this.deliveryList = file;
    }

    public boolean isReplacedynamicrev() {
        return this.replacedynamicrev;
    }

    public void setReplacedynamicrev(boolean bl) {
        this.replacedynamicrev = bl;
    }

    public boolean isReplaceForcedRev() {
        return this.replaceForcedRev;
    }

    public void setReplaceForcedRev(boolean bl) {
        this.replaceForcedRev = bl;
    }

    public String getResolveId() {
        return this.resolveId;
    }

    public void setResolveId(String string) {
        this.resolveId = string;
    }

    public String getConf() {
        return this.conf;
    }

    public void setConf(String string) {
        this.conf = string;
    }

    public boolean isGenerateRevConstraint() {
        return this.generateRevConstraint;
    }

    public void setGenerateRevConstraint(boolean bl) {
        this.generateRevConstraint = bl;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean bl) {
        this.merge = bl;
    }

    @Override
    public void doExecute() throws BuildException {
        Object object;
        Ivy ivy = this.getIvyInstance();
        IvySettings ivySettings = ivy.getSettings();
        this.organisation = this.getProperty(this.organisation, ivySettings, "ivy.organisation", this.resolveId);
        this.module = this.getProperty(this.module, ivySettings, "ivy.module", this.resolveId);
        this.revision = this.getProperty(this.revision, ivySettings, "ivy.revision", this.resolveId);
        this.pubBranch = this.getProperty(this.pubBranch, ivySettings, "ivy.deliver.branch");
        this.pubRevision = this.getProperty(this.pubRevision, ivySettings, "ivy.deliver.revision");
        this.deliverpattern = this.getProperty(this.deliverpattern, ivySettings, "ivy.deliver.ivy.pattern");
        this.status = this.getProperty(this.status, ivySettings, "ivy.status");
        if (this.deliveryList == null) {
            object = this.getProperty(ivySettings, "ivy.delivery.list.file");
            this.deliveryList = object == null ? new File(System.getProperty("java.io.tmpdir") + "/delivery.properties") : this.getProject().resolveFile(ivySettings.substitute((String)object));
        }
        if (this.resolveId == null) {
            if (this.organisation == null) {
                throw new BuildException("no organisation provided for ivy deliver task: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
            }
            if (this.module == null) {
                throw new BuildException("no module name provided for ivy deliver task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
            }
        }
        if (this.revision == null) {
            this.revision = Ivy.getWorkingRevision();
        }
        object = IvyDeliver.getPubDate(this.pubdate, new Date());
        if (this.pubRevision == null) {
            this.pubRevision = this.revision.startsWith("working@") ? DateUtil.format((Date)object) : this.revision;
        }
        if (this.deliverpattern == null) {
            throw new BuildException("deliver ivy pattern is missing: either provide it as parameters or through ivy.deliver.ivy.pattern properties");
        }
        if (this.status == null) {
            throw new BuildException("no status provided: either provide it as parameter or through the ivy.status.default property");
        }
        ModuleRevisionId moduleRevisionId = null;
        if (this.resolveId == null) {
            moduleRevisionId = ModuleRevisionId.newInstance(this.organisation, this.module, this.revision);
        }
        boolean bl = false;
        try {
            if (!this.deliveryList.exists()) {
                bl = true;
            }
            this.loadDeliveryList();
            DefaultPublishingDRResolver defaultPublishingDRResolver = this.deliverTarget != null && this.deliverTarget.trim().length() > 0 ? new DeliverDRResolver() : new DefaultPublishingDRResolver();
            DeliverOptions deliverOptions = new DeliverOptions(this.status, (Date)object, defaultPublishingDRResolver, this.doValidate(ivySettings), this.replacedynamicrev, this.splitConfs(this.conf)).setResolveId(this.resolveId).setReplaceForcedRevisions(this.isReplaceForcedRev()).setGenerateRevConstraint(this.generateRevConstraint).setMerge(this.merge).setPubBranch(this.pubBranch);
            if (moduleRevisionId == null) {
                ivy.deliver(this.pubRevision, this.deliverpattern, deliverOptions);
            } else {
                ivy.deliver(moduleRevisionId, this.pubRevision, this.deliverpattern, deliverOptions);
            }
        }
        catch (Exception exception) {
            throw new BuildException("impossible to deliver " + moduleRevisionId == null ? this.resolveId : moduleRevisionId + ": " + exception, (Throwable)exception);
        }
        finally {
            if (bl && this.deliveryList.exists()) {
                this.deliveryList.delete();
            }
        }
    }

    private void loadDeliveryList() {
        Property property = (Property)this.getProject().createTask("property");
        property.setOwningTarget(this.getOwningTarget());
        property.init();
        property.setFile(this.deliveryList);
        property.perform();
    }

    private void appendDeliveryList(String string) {
        Echo echo = (Echo)this.getProject().createTask("echo");
        echo.setOwningTarget(this.getOwningTarget());
        echo.init();
        echo.setFile(this.deliveryList);
        echo.setMessage(string + "\n");
        echo.setAppend(true);
        echo.perform();
    }

    private final class DeliverDRResolver
    extends DefaultPublishingDRResolver {
        private DeliverDRResolver() {
        }

        @Override
        public String resolve(ModuleDescriptor moduleDescriptor, String string, ModuleRevisionId moduleRevisionId, String string2) {
            if (StatusManager.getCurrent().isIntegration(string)) {
                return super.resolve(moduleDescriptor, string, moduleRevisionId, string2);
            }
            if (!StatusManager.getCurrent().isIntegration(string2)) {
                return super.resolve(moduleDescriptor, string, moduleRevisionId, string2);
            }
            String string3 = moduleRevisionId.getName() + "." + moduleRevisionId.getRevision() + ".status";
            String string4 = moduleRevisionId.getName() + "." + moduleRevisionId.getRevision() + ".version";
            String string5 = moduleRevisionId.getName() + "." + moduleRevisionId.getRevision() + ".delivered";
            String string6 = IvyDeliver.this.getProject().getProperty(string4);
            String string7 = IvyDeliver.this.getProject().getProperty(string3);
            String string8 = IvyDeliver.this.getProject().getProperty(string5);
            Message.debug("found version = " + string6 + " status=" + string7 + " delivered=" + string8);
            if (string6 != null && string7 != null) {
                if ("true".equals(string8)) {
                    return string6;
                }
                this.deliverDependency(moduleRevisionId, string6, string7, string2);
                IvyDeliver.this.loadDeliveryList();
                return string6;
            }
            String string9 = "recursive.delivery.status";
            String string10 = "recursive.delivery.version";
            string6 = IvyDeliver.this.getProject().getProperty(string10);
            string7 = IvyDeliver.this.getProject().getProperty(string9);
            if (string6 != null && string7 != null) {
                string8 = IvyDeliver.this.getProject().getProperty("recursive." + moduleRevisionId.getName() + ".delivered");
                Message.debug("found global version = " + string6 + " and global status=" + string7 + " - delivered = " + string8);
                if ("true".equals(string8)) {
                    return string6;
                }
                IvyDeliver.this.getProject().setProperty(string3, string7);
                this.deliverDependency(moduleRevisionId, string6, string7, string2);
                IvyDeliver.this.loadDeliveryList();
                return string6;
            }
            Input input = (Input)IvyDeliver.this.getProject().createTask("input");
            input.setOwningTarget(IvyDeliver.this.getOwningTarget());
            input.init();
            input.setMessage(moduleRevisionId.getName() + " " + moduleRevisionId.getRevision() + ": please enter a status: ");
            input.setValidargs(StatusManager.getCurrent().getDeliveryStatusListString());
            input.setAddproperty(string3);
            input.perform();
            string7 = IvyDeliver.this.getProject().getProperty(string3);
            IvyDeliver.this.appendDeliveryList(string3 + " = " + string7);
            input.setMessage(moduleRevisionId.getName() + " " + moduleRevisionId.getRevision() + ": please enter a version: ");
            input.setValidargs(null);
            input.setAddproperty(string4);
            input.perform();
            string6 = IvyDeliver.this.getProject().getProperty(string4);
            IvyDeliver.this.appendDeliveryList(string4 + " = " + string6);
            this.deliverDependency(moduleRevisionId, string6, string7, string2);
            IvyDeliver.this.loadDeliveryList();
            return string6;
        }

        public void deliverDependency(ModuleRevisionId moduleRevisionId, String string, String string2, String string3) {
            if (IvyDeliver.this.deliverTarget != null && IvyDeliver.this.deliverTarget.trim().length() > 0) {
                CallTarget callTarget = (CallTarget)IvyDeliver.this.getProject().createTask("antcall");
                callTarget.setOwningTarget(IvyDeliver.this.getOwningTarget());
                callTarget.init();
                callTarget.setTarget(IvyDeliver.this.deliverTarget);
                callTarget.setInheritAll(true);
                callTarget.setInheritRefs(true);
                Property property = callTarget.createParam();
                property.setName("dependency.name");
                property.setValue(moduleRevisionId.getName());
                property = callTarget.createParam();
                property.setName("dependency.published.status");
                property.setValue(string2);
                property = callTarget.createParam();
                property.setName("dependency.published.version");
                property.setValue(string);
                property = callTarget.createParam();
                property.setName("dependency.version");
                property.setValue(moduleRevisionId.getRevision());
                property = callTarget.createParam();
                property.setName("dependency.status");
                property.setValue(string3 == null ? "null" : string3);
                callTarget.perform();
                String string4 = moduleRevisionId.getName() + "." + moduleRevisionId.getRevision() + ".delivered";
                IvyDeliver.this.getProject().setProperty(string4, "true");
                IvyDeliver.this.appendDeliveryList(string4 + " = true");
                IvyDeliver.this.getProject().setProperty("recursive." + moduleRevisionId.getName() + ".delivered", "true");
                IvyDeliver.this.appendDeliveryList("recursive." + moduleRevisionId.getName() + ".delivered" + " = true");
            }
        }
    }
}

