/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputListener;
import net.sf.sdedit.Constants;
import net.sf.sdedit.diagram.AbstractGraphicDevice;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.Fragment;
import net.sf.sdedit.drawable.Strokes;
import net.sf.sdedit.ui.PanelGraphicDevicePartner;
import net.sf.sdedit.ui.components.ZoomPane;
import net.sf.sdedit.ui.components.Zoomable;

public class PanelGraphicDevice
extends AbstractGraphicDevice
implements MouseInputListener,
Constants {
    private Drawable lastDrawableMovedOver;
    private Dimension size;
    private PanelGraphicDevicePartner partner;
    private final Panel panel;
    private final boolean interactive;
    protected boolean antialias;
    protected Drawable highlighted;
    private static MouseEvent lastMove;
    private boolean empty;

    public PanelGraphicDevice(boolean interactive) {
        this.interactive = interactive;
        this.panel = new Panel();
        ToolTipManager.sharedInstance().registerComponent(this.panel);
        this.antialias = true;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.interactive && this.partner != null) {
            lastMove = e;
            JPanel zp = this.panel.getZoomPane().getPanel();
            Point point = e.getPoint();
            if (this.lastDrawableMovedOver != null) {
                if (this.lastDrawableMovedOver.contains(point)) {
                    return;
                }
                this.partner.mouseExitedDrawable(this.lastDrawableMovedOver);
                zp.setCursor(Cursor.getDefaultCursor());
            }
            this.lastDrawableMovedOver = null;
            for (Drawable drawable : this.drawables()) {
                if (drawable instanceof Fragment || !drawable.contains(point)) continue;
                this.lastDrawableMovedOver = drawable;
                if (this.partner.mouseEnteredDrawable(drawable)) {
                    zp.setCursor(HAND_CURSOR);
                }
                return;
            }
        }
    }

    public void highlight(Drawable drawable) {
        this.highlighted = drawable;
    }

    public void setPartner(PanelGraphicDevicePartner partner) {
        this.partner = partner;
    }

    public Zoomable<JPanel> getPanel() {
        return this.panel;
    }

    public void setAntialiasing(boolean on) {
        this.setFontRenderContext(on);
        this.antialias = on;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.partner != null && this.lastDrawableMovedOver != null) {
            this.partner.mouseClickedDrawable(e, this.lastDrawableMovedOver);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void close(int width, int height, boolean empty) {
        this.empty = empty;
        this.size = new Dimension(width, height);
    }

    @Override
    public void initialize(Diagram diagram) {
        super.initialize(diagram);
    }

    private final class Panel
    extends JPanel
    implements Zoomable<JPanel> {
        private ZoomPane zoomPane;

        Panel() {
            this.addMouseMotionListener(PanelGraphicDevice.this);
            this.addMouseListener(PanelGraphicDevice.this);
        }

        @Override
        public ZoomPane getZoomPane() {
            return this.zoomPane;
        }

        @Override
        public void setZoomPane(ZoomPane zoomPane) {
            this.zoomPane = zoomPane;
        }

        @Override
        public JPanel asJComponent() {
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getSize();
        }

        @Override
        public Dimension getSize() {
            if (PanelGraphicDevice.this.size == null) {
                return super.getSize();
            }
            return PanelGraphicDevice.this.size;
        }

        @Override
        public int getWidth() {
            return this.getAbsoluteWidth();
        }

        @Override
        public int getHeight() {
            return this.getAbsoluteHeight();
        }

        @Override
        public int getAbsoluteWidth() {
            if (PanelGraphicDevice.this.size == null) {
                return super.getWidth();
            }
            return ((PanelGraphicDevice)PanelGraphicDevice.this).size.width;
        }

        @Override
        public int getAbsoluteHeight() {
            if (PanelGraphicDevice.this.size == null) {
                return super.getHeight();
            }
            return ((PanelGraphicDevice)PanelGraphicDevice.this).size.height;
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            String text = null;
            if (PanelGraphicDevice.this.partner != null) {
                Point mousePoint = e.getPoint();
                for (Drawable drawable : PanelGraphicDevice.this.drawables()) {
                    if (!drawable.contains(mousePoint)) continue;
                    text = PanelGraphicDevice.this.partner.getTooltip(drawable);
                    break;
                }
            }
            if (text == null) {
                return super.getToolTipText();
            }
            return text;
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            Rectangle clipBounds = g2.getClipBounds();
            g2.setColor(Color.WHITE);
            g2.fill(clipBounds);
            if (!PanelGraphicDevice.this.empty) {
                g2.setFont(PanelGraphicDevice.this.getFont(false));
                if (PanelGraphicDevice.this.antialias) {
                    g2.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
                }
                g2.setColor(Color.BLACK);
                g2.setStroke(Strokes.defaultStroke());
                for (Drawable drawable : PanelGraphicDevice.this.drawables()) {
                    if (!drawable.intersects(clipBounds)) continue;
                    if (drawable == PanelGraphicDevice.this.highlighted) {
                        Graphics gg = g2.create();
                        gg.setColor(Color.YELLOW);
                        gg.fillRect(drawable.getLeft() - 5, drawable.getTop() - 5, drawable.getWidth() + 10, drawable.getHeight() + 10);
                        gg.dispose();
                    }
                    drawable.draw(g2);
                }
            }
            g2.dispose();
            if (lastMove != null) {
                PanelGraphicDevice.this.mouseMoved(lastMove);
            }
        }
    }
}

