/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.j3d.Ground3D;
import com.eteks.sweethome3d.j3d.HomePieceOfFurniture3D;
import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.j3d.Object3DBranchFactory;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.j3d.Wall3D;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.HomeController3D;
import com.eteks.sweethome3d.viewcontroller.Object3DFactory;
import com.sun.j3d.exp.swing.JCanvas3D;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Group;
import javax.media.j3d.IllegalRenderingStateException;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.Light;
import javax.media.j3d.Link;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeComponent3D
extends JComponent
implements com.eteks.sweethome3d.viewcontroller.View,
Printable {
    private static final boolean JAVA3D_1_5 = VirtualUniverse.getProperties().get("j3d.version") != null && ((String)VirtualUniverse.getProperties().get("j3d.version")).startsWith("1.5");
    private final Home home;
    private final boolean displayShadowOnFloor;
    private final Object3DFactory object3dFactory;
    private final Map<Selectable, Object3DBranch> homeObjects = new HashMap<Selectable, Object3DBranch>();
    private Light[] sceneLights;
    private Collection<Selectable> homeObjectsToUpdate;
    private Collection<Selectable> lightScopeObjectsToUpdate;
    private Component component3D;
    private SimpleUniverse onscreenUniverse;
    private Camera camera;
    private PropertyChangeListener cameraChangeListener;
    private PropertyChangeListener homeCameraListener;
    private PropertyChangeListener backgroundChangeListener;
    private PropertyChangeListener groundChangeListener;
    private PropertyChangeListener backgroundLightColorListener;
    private PropertyChangeListener lightColorListener;
    private PropertyChangeListener subpartSizeListener;
    private PropertyChangeListener elevationChangeListener;
    private PropertyChangeListener wallsAlphaListener;
    private PropertyChangeListener drawingModeListener;
    private CollectionListener<Level> levelListener;
    private PropertyChangeListener levelChangeListener;
    private CollectionListener<Wall> wallListener;
    private PropertyChangeListener wallChangeListener;
    private CollectionListener<HomePieceOfFurniture> furnitureListener;
    private PropertyChangeListener furnitureChangeListener;
    private CollectionListener<Room> roomListener;
    private PropertyChangeListener roomChangeListener;
    private CollectionListener<Label> labelListener;
    private PropertyChangeListener labelChangeListener;
    private BufferedImage printedImageCache;
    private BoundingBox approximateHomeBoundsCache;
    private SimpleUniverse offscreenUniverse;
    private JComponent navigationPanel;
    private ComponentListener navigationPanelListener;
    private BufferedImage navigationPanelImage;
    private Area lightScopeOutsideWallsAreaCache;

    public HomeComponent3D(Home home) {
        this(home, null);
    }

    public HomeComponent3D(Home home, HomeController3D homeController3D) {
        this(home, null, homeController3D);
    }

    public HomeComponent3D(Home home, UserPreferences userPreferences, boolean bl) {
        this(home, userPreferences, new Object3DBranchFactory(), bl, null);
    }

    public HomeComponent3D(Home home, UserPreferences userPreferences, HomeController3D homeController3D) {
        this(home, userPreferences, new Object3DBranchFactory(), false, homeController3D);
    }

    public HomeComponent3D(Home home, UserPreferences userPreferences, Object3DFactory object3DFactory, HomeController3D homeController3D) {
        this(home, userPreferences, object3DFactory, false, homeController3D);
    }

    public HomeComponent3D(Home home, UserPreferences userPreferences, Object3DFactory object3DFactory, boolean bl, HomeController3D homeController3D) {
        GraphicsEnvironment graphicsEnvironment;
        this.home = home;
        this.displayShadowOnFloor = bl;
        Object3DFactory object3DFactory2 = this.object3dFactory = object3DFactory != null ? object3DFactory : new Object3DBranchFactory();
        if (homeController3D != null) {
            this.createActions(homeController3D);
            this.installKeyboardActions();
            this.setFocusable(true);
            SwingTools.installFocusBorder(this);
        }
        if ((graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment()).getScreenDevices().length == 1) {
            this.createComponent3D(graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration(), userPreferences, homeController3D);
        }
        this.addAncestorListener(userPreferences, homeController3D, bl);
    }

    private void addAncestorListener(final UserPreferences userPreferences, final HomeController3D homeController3D, final boolean bl) {
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                Component component;
                if (HomeComponent3D.this.offscreenUniverse != null) {
                    throw new IllegalStateException("Can't listen to home changes offscreen and onscreen at the same time");
                }
                Insets insets = HomeComponent3D.this.getInsets();
                if (HomeComponent3D.this.getHeight() <= insets.top + insets.bottom || HomeComponent3D.this.getWidth() <= insets.left + insets.right) {
                    HomeComponent3D.this.addComponentListener(new ComponentAdapter(){

                        public void componentResized(ComponentEvent componentEvent) {
                            HomeComponent3D.this.removeComponentListener(this);
                            if (SwingUtilities.getRoot(HomeComponent3D.this) != null) {
                                this.ancestorAdded(null);
                            }
                        }
                    });
                    return;
                }
                if (ancestorEvent == null) {
                    component = SwingUtilities.getRoot(HomeComponent3D.this);
                    component.dispatchEvent(new ComponentEvent(component, 101));
                }
                if (HomeComponent3D.this.component3D == null) {
                    HomeComponent3D.this.createComponent3D(HomeComponent3D.this.getGraphicsConfiguration(), userPreferences, homeController3D);
                }
                if (HomeComponent3D.this.onscreenUniverse == null) {
                    HomeComponent3D.this.onscreenUniverse = HomeComponent3D.this.createUniverse(bl, true, false);
                    if (HomeComponent3D.this.component3D instanceof Canvas3D) {
                        component = (Canvas3D)HomeComponent3D.this.component3D;
                    } else {
                        try {
                            component = (Canvas3D)Class.forName("com.sun.j3d.exp.swing.JCanvas3D").getMethod("getOffscreenCanvas3D", new Class[0]).invoke((Object)HomeComponent3D.this.component3D, new Object[0]);
                        }
                        catch (Exception exception) {
                            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                            unsupportedOperationException.initCause(exception);
                            throw unsupportedOperationException;
                        }
                    }
                    HomeComponent3D.this.onscreenUniverse.getViewer().getView().addCanvas3D((Canvas3D)component);
                    HomeComponent3D.this.component3D.setFocusable(false);
                    HomeComponent3D.this.updateNavigationPanelImage();
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                if (HomeComponent3D.this.onscreenUniverse != null) {
                    HomeComponent3D.this.onscreenUniverse.cleanup();
                    HomeComponent3D.this.removeHomeListeners();
                    HomeComponent3D.this.onscreenUniverse = null;
                }
                if (HomeComponent3D.this.component3D != null) {
                    HomeComponent3D.this.removeAll();
                    HomeComponent3D.this.component3D = null;
                    HomeComponent3D.this.navigationPanel = null;
                }
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    private void createComponent3D(GraphicsConfiguration graphicsConfiguration, UserPreferences userPreferences, HomeController3D homeController3D) {
        Object object;
        if (Boolean.valueOf(System.getProperty("com.eteks.sweethome3d.j3d.useOffScreen3DView", "false")).booleanValue()) {
            object = new GraphicsConfigTemplate3D();
            object.setSceneAntialiasing(2);
            try {
                this.component3D = (Component)Class.forName(this.getClass().getName() + "$JCanvas3DWithNavigationPanel").getConstructor(this.getClass(), GraphicsConfigTemplate3D.class).newInstance(this, object);
                this.component3D.setSize(1, 1);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnsupportedOperationException("Java 3D 1.5 required to display an offscreen 3D view");
            }
            catch (Exception exception) {
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                unsupportedOperationException.initCause(exception);
                throw unsupportedOperationException;
            }
        } else {
            this.component3D = Component3DManager.getInstance().getOnscreenCanvas3D(graphicsConfiguration, new Component3DManager.RenderingObserver(){
                private Shape3D dummyShape;

                public void canvas3DSwapped(Canvas3D canvas3D) {
                }

                public void canvas3DPreRendered(Canvas3D canvas3D) {
                }

                public void canvas3DPostRendered(Canvas3D canvas3D) {
                    BufferedImage bufferedImage = HomeComponent3D.this.navigationPanelImage;
                    if (bufferedImage != null) {
                        J3DGraphics2D j3DGraphics2D;
                        if (JAVA3D_1_5) {
                            if (this.dummyShape == null) {
                                j3DGraphics2D = new PointArray(1, 1);
                                j3DGraphics2D.setCoordinates(0, new float[]{0.0f, 0.0f, 0.0f});
                                Appearance appearance = new Appearance();
                                appearance.setTransparencyAttributes(new TransparencyAttributes(0, 1.0f));
                                this.dummyShape = new Shape3D((Geometry)j3DGraphics2D, appearance);
                            }
                            canvas3D.getGraphicsContext3D().draw(this.dummyShape);
                        }
                        j3DGraphics2D = canvas3D.getGraphics2D();
                        j3DGraphics2D.drawImage(bufferedImage, null, 0, 0);
                        j3DGraphics2D.flush(true);
                    }
                }
            });
        }
        this.component3D.setBackground(new Color(230, 230, 230));
        object = new JPanel(new LayoutManager(){

            public void addLayoutComponent(String string, Component component) {
            }

            public void removeLayoutComponent(Component component) {
            }

            public Dimension preferredLayoutSize(Container container) {
                return HomeComponent3D.this.component3D.getPreferredSize();
            }

            public Dimension minimumLayoutSize(Container container) {
                return HomeComponent3D.this.component3D.getMinimumSize();
            }

            public void layoutContainer(Container container) {
                HomeComponent3D.this.component3D.setBounds(0, 0, Math.max(1, container.getWidth()), Math.max(1, container.getHeight()));
                if (HomeComponent3D.this.navigationPanel != null && HomeComponent3D.this.navigationPanel.isVisible()) {
                    Dimension dimension = HomeComponent3D.this.navigationPanel.getPreferredSize();
                    HomeComponent3D.this.navigationPanel.setBounds(0, 0, dimension.width, dimension.height);
                }
            }
        });
        ((Container)object).add(this.component3D);
        this.setLayout(new GridLayout());
        this.add((Component)object);
        if (homeController3D != null) {
            this.addMouseListeners(homeController3D, this.component3D);
            if (userPreferences != null && (!OperatingSystem.isMacOSX() || OperatingSystem.isMacOSXLeopardOrSuperior())) {
                this.navigationPanel = this.createNavigationPanel(this.home, userPreferences, homeController3D);
                this.setNavigationPanelVisible(userPreferences.isNavigationPanelVisible() && this.isVisible());
                userPreferences.addPropertyChangeListener(UserPreferences.Property.NAVIGATION_PANEL_VISIBLE, new NavigationPanelChangeListener(this));
            }
            this.createActions(homeController3D);
            this.installKeyboardActions();
            this.setFocusable(true);
            SwingTools.installFocusBorder(this);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.component3D != null) {
            this.component3D.setVisible(bl);
        }
    }

    private JComponent createNavigationPanel(Home home, UserPreferences userPreferences, HomeController3D homeController3D) {
        JPanel jPanel = new JPanel(new GridBagLayout()){

            public void applyComponentOrientation(ComponentOrientation componentOrientation) {
            }
        };
        String string = userPreferences.getLocalizedString(HomeComponent3D.class, "navigationPanel.icon", new Object[0]);
        final ImageIcon imageIcon = string.length() > 0 ? new ImageIcon(HomeComponent3D.class.getResource(string)) : null;
        jPanel.setBorder(new Border(){

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                if (imageIcon != null) {
                    imageIcon.paintIcon(component, graphics, n, n2);
                } else {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.drawOval(n + 3, n2 + 3, n3 - 6, n4 - 6);
                }
            }

            public Insets getBorderInsets(Component component) {
                return new Insets(2, 2, 2, 2);
            }

            public boolean isBorderOpaque() {
                return false;
            }
        });
        jPanel.setOpaque(false);
        jPanel.add((Component)new NavigationButton(0.0f, -0.08726647f, 0.0f, "TURN_LEFT", userPreferences, homeController3D), new GridBagConstraints(0, 1, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 0), 0, 0));
        jPanel.add((Component)new NavigationButton(12.5f, 0.0f, 0.0f, "GO_FORWARD", userPreferences, homeController3D), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 0, 0, 0), 0, 0));
        jPanel.add((Component)new NavigationButton(0.0f, 0.08726647f, 0.0f, "TURN_RIGHT", userPreferences, homeController3D), new GridBagConstraints(2, 1, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0));
        jPanel.add((Component)new NavigationButton(-12.5f, 0.0f, 0.0f, "GO_BACKWARD", userPreferences, homeController3D), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 0), 0, 0));
        jPanel.add((Component)new NavigationButton(0.0f, 0.0f, -0.03141593f, "TURN_UP", userPreferences, homeController3D), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        jPanel.add((Component)new NavigationButton(0.0f, 0.0f, 0.03141593f, "TURN_DOWN", userPreferences, homeController3D), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 1, 0), 0, 0));
        return jPanel;
    }

    private void setNavigationPanelVisible(boolean bl) {
        if (this.navigationPanel != null) {
            this.navigationPanel.setVisible(bl);
            if (bl) {
                this.navigationPanelListener = new ComponentAdapter(){

                    public void componentResized(ComponentEvent componentEvent) {
                        HomeComponent3D.this.updateNavigationPanelImage();
                    }

                    public void componentMoved(ComponentEvent componentEvent) {
                        HomeComponent3D.this.updateNavigationPanelImage();
                    }
                };
                this.navigationPanel.addComponentListener(this.navigationPanelListener);
                this.component3D.getParent().add(this.navigationPanel);
            } else {
                this.navigationPanel.removeComponentListener(this.navigationPanelListener);
                if (this.navigationPanel.getParent() != null) {
                    this.navigationPanel.getParent().remove(this.navigationPanel);
                }
            }
            this.revalidate();
            this.updateNavigationPanelImage();
            this.component3D.repaint();
        }
    }

    private void updateNavigationPanelImage() {
        if (this.navigationPanel != null && this.navigationPanel.isVisible()) {
            Rectangle rectangle = this.navigationPanel.getBounds();
            Rectangle rectangle2 = new Rectangle(this.component3D.getX(), this.component3D.getY());
            rectangle2.add(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            if (!rectangle2.isEmpty()) {
                Graphics2D graphics2D;
                BufferedImage bufferedImage = this.navigationPanelImage;
                this.navigationPanelImage = null;
                if (bufferedImage == null || bufferedImage.getWidth() != rectangle2.width || bufferedImage.getHeight() != rectangle2.height) {
                    bufferedImage = new BufferedImage(rectangle2.width, rectangle2.height, 2);
                    graphics2D = (Graphics2D)bufferedImage.getGraphics();
                } else {
                    graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
                    graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, rectangle2.width, rectangle2.height));
                    graphics2D.setComposite(composite);
                }
                this.navigationPanel.paintAll(graphics2D);
                graphics2D.dispose();
                this.navigationPanelImage = bufferedImage;
                return;
            }
        }
        this.navigationPanelImage = null;
    }

    private SimpleUniverse createUniverse(boolean bl, boolean bl2, boolean bl3) {
        ViewingPlatform viewingPlatform = new ViewingPlatform();
        TransformGroup transformGroup = viewingPlatform.getViewPlatformTransform();
        CameraInterpolator cameraInterpolator = new CameraInterpolator(transformGroup);
        cameraInterpolator.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 1.0E7));
        transformGroup.addChild((Node)cameraInterpolator);
        transformGroup.setCapability(12);
        Viewer viewer = new Viewer(new Canvas3D[0]);
        SimpleUniverse simpleUniverse = new SimpleUniverse(viewingPlatform, viewer);
        View view = viewer.getView();
        view.setTransparencySortingPolicy(1);
        this.updateView(view, this.home.getCamera());
        this.updateViewPlatformTransform(transformGroup, this.home.getCamera(), false);
        if (bl2) {
            this.addCameraListeners(view, transformGroup);
        }
        simpleUniverse.addBranchGraph(this.createSceneTree(bl, bl2, bl3));
        return simpleUniverse;
    }

    private void removeHomeListeners() {
        this.home.removePropertyChangeListener(Home.Property.CAMERA, this.homeCameraListener);
        HomeEnvironment homeEnvironment = this.home.getEnvironment();
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.SKY_COLOR, this.backgroundChangeListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.SKY_TEXTURE, this.backgroundChangeListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.GROUND_COLOR, this.backgroundChangeListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.GROUND_TEXTURE, this.backgroundChangeListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.GROUND_COLOR, this.groundChangeListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.GROUND_TEXTURE, this.groundChangeListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.LIGHT_COLOR, this.backgroundLightColorListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.LIGHT_COLOR, this.lightColorListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.WALLS_ALPHA, this.wallsAlphaListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.DRAWING_MODE, this.drawingModeListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.SUBPART_SIZE_UNDER_LIGHT, this.subpartSizeListener);
        this.home.getCamera().removePropertyChangeListener(this.cameraChangeListener);
        this.home.removePropertyChangeListener(Home.Property.CAMERA, this.elevationChangeListener);
        this.home.getCamera().removePropertyChangeListener(this.elevationChangeListener);
        this.home.removeLevelsListener(this.levelListener);
        for (Level homeObject : this.home.getLevels()) {
            homeObject.removePropertyChangeListener(this.levelChangeListener);
        }
        this.home.removeWallsListener(this.wallListener);
        for (Wall wall : this.home.getWalls()) {
            wall.removePropertyChangeListener(this.wallChangeListener);
        }
        this.home.removeFurnitureListener(this.furnitureListener);
        for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
            homePieceOfFurniture.removePropertyChangeListener(this.furnitureChangeListener);
            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                homePieceOfFurniture2.removePropertyChangeListener(this.furnitureChangeListener);
            }
        }
        this.home.removeRoomsListener(this.roomListener);
        for (Room room : this.home.getRooms()) {
            room.removePropertyChangeListener(this.roomChangeListener);
        }
        this.home.removeLabelsListener(this.labelListener);
        for (Label label : this.home.getLabels()) {
            label.removePropertyChangeListener(this.labelChangeListener);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n == 0) {
            double d = Math.min(pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
            int n2 = (int)(d / 72.0 * 150.0);
            if (this.printedImageCache == null || this.printedImageCache.getWidth() != n2) {
                try {
                    this.printedImageCache = this.getOffScreenImage(n2, n2);
                }
                catch (IllegalRenderingStateException illegalRenderingStateException) {
                    return 1;
                }
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.translate(pageFormat.getImageableX() + (pageFormat.getImageableWidth() - d) / 2.0, pageFormat.getImageableY() + (pageFormat.getImageableHeight() - d) / 2.0);
            double d2 = d / (double)n2;
            graphics2D.scale(d2, d2);
            graphics2D.drawImage((Image)this.printedImageCache, 0, 0, this);
            graphics2D.dispose();
            return 0;
        }
        return 1;
    }

    public void startOffscreenImagesCreation() {
        if (this.offscreenUniverse == null) {
            if (this.onscreenUniverse != null) {
                throw new IllegalStateException("Can't listen to home changes offscreen and onscreen at the same time");
            }
            this.offscreenUniverse = this.createUniverse(this.displayShadowOnFloor, true, true);
            HashMap<Texture, Texture> hashMap = new HashMap<Texture, Texture>();
            Enumeration enumeration = this.offscreenUniverse.getLocale().getAllBranchGraphs();
            while (enumeration.hasMoreElements()) {
                this.cloneTexture((Node)enumeration.nextElement(), hashMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getOffScreenImage(int n, int n2) {
        List<Selectable> list = this.home.getSelectedItems();
        SimpleUniverse simpleUniverse = null;
        try {
            Object object;
            Object object2;
            View view;
            if (this.offscreenUniverse == null) {
                simpleUniverse = this.createUniverse(this.displayShadowOnFloor, false, true);
                view = simpleUniverse.getViewer().getView();
                object2 = new HashMap();
                object = simpleUniverse.getLocale().getAllBranchGraphs();
                while (object.hasMoreElements()) {
                    this.cloneTexture((Node)object.nextElement(), (Map<Texture, Texture>)object2);
                }
            } else {
                view = this.offscreenUniverse.getViewer().getView();
            }
            this.updateView(view, this.home.getCamera(), n, n2);
            object2 = Collections.emptyList();
            this.home.setSelectedItems((List<? extends Selectable>)object2);
            object = Component3DManager.getInstance().getOffScreenImage(view, n, n2);
            return object;
        }
        finally {
            this.home.setSelectedItems(list);
            if (simpleUniverse != null) {
                simpleUniverse.cleanup();
            }
        }
    }

    private void cloneTexture(Node node, Map<Texture, Texture> map) {
        Texture texture;
        Appearance appearance;
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.cloneTexture((Node)enumeration.nextElement(), map);
            }
        } else if (node instanceof Link) {
            this.cloneTexture((Node)((Link)node).getSharedGroup(), map);
        } else if (node instanceof Shape3D && (appearance = ((Shape3D)node).getAppearance()) != null && (texture = appearance.getTexture()) != null) {
            Texture texture2 = map.get(texture);
            if (texture2 == null) {
                texture2 = (Texture)texture.cloneNodeComponent(false);
                map.put(texture, texture2);
            }
            appearance.setTexture(texture2);
        }
    }

    public void endOffscreenImagesCreation() {
        if (this.offscreenUniverse != null) {
            this.offscreenUniverse.cleanup();
            this.removeHomeListeners();
            this.offscreenUniverse = null;
        }
    }

    private void addCameraListeners(final View view, final TransformGroup transformGroup) {
        this.cameraChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        HomeComponent3D.this.updateView(view, HomeComponent3D.this.home.getCamera());
                        HomeComponent3D.this.updateViewPlatformTransform(transformGroup, HomeComponent3D.this.home.getCamera(), true);
                    }
                });
            }
        };
        this.home.getCamera().addPropertyChangeListener(this.cameraChangeListener);
        this.homeCameraListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeComponent3D.this.updateView(view, HomeComponent3D.this.home.getCamera());
                HomeComponent3D.this.updateViewPlatformTransform(transformGroup, HomeComponent3D.this.home.getCamera(), false);
                ((Camera)propertyChangeEvent.getOldValue()).removePropertyChangeListener(HomeComponent3D.this.cameraChangeListener);
                HomeComponent3D.this.home.getCamera().addPropertyChangeListener(HomeComponent3D.this.cameraChangeListener);
            }
        };
        this.home.addPropertyChangeListener(Home.Property.CAMERA, this.homeCameraListener);
    }

    private void updateView(View view, Camera camera) {
        if (this.component3D != null) {
            this.updateView(view, camera, this.component3D.getWidth(), this.component3D.getHeight());
        } else {
            this.updateView(view, camera, 0, 0);
        }
    }

    private void updateView(View view, Camera camera, int n, int n2) {
        float f;
        float f2 = camera.getFieldOfView();
        if (f2 == 0.0f) {
            f2 = 1.0995574f;
        }
        view.setFieldOfView((double)f2);
        double d = 2.5;
        BoundingBox boundingBox = this.getApproximateHomeBounds();
        if (boundingBox != null && !boundingBox.intersect(new Point3d((double)camera.getX(), (double)camera.getY(), (double)camera.getZ())) && !Float.isNaN(f = this.getDistanceToBox(camera.getX(), camera.getY(), camera.getZ(), boundingBox))) {
            d = Math.max(d, (double)(0.1f * f));
        }
        if (camera.getZ() > 0.0f && n != 0 && n2 != 0) {
            float f3;
            f = (float)Math.atan(Math.tan(f2 / 2.0f) * (double)n2 / (double)n);
            float f4 = camera.getPitch() + f;
            if (f4 > 0.0f && (d = Math.min(d, (double)(0.35f * (f3 = (float)((double)camera.getZ() / Math.sin(f4)))))) * 3000.0 < (double)f3) {
                d = f3 / 3000.0f;
            }
        }
        view.setFrontClipDistance(d);
        view.setBackClipDistance(d * 3000.0);
        this.clearPrintedImageCache();
    }

    private BoundingBox getApproximateHomeBounds() {
        if (this.approximateHomeBoundsCache == null) {
            BoundingBox boundingBox = null;
            for (HomePieceOfFurniture homeObject : this.home.getFurniture()) {
                if (!homeObject.isVisible() || homeObject.getLevel() != null && !homeObject.getLevel().isViewable()) continue;
                float f = Math.max(homeObject.getWidthInPlan(), homeObject.getDepthInPlan()) / 2.0f;
                float f2 = homeObject.getGroundElevation();
                Point3d point3d = new Point3d((double)(homeObject.getX() - f), (double)(homeObject.getY() - f), (double)f2);
                if (boundingBox == null) {
                    boundingBox = new BoundingBox(point3d, point3d);
                } else {
                    boundingBox.combine(point3d);
                }
                boundingBox.combine(new Point3d((double)(homeObject.getX() + f), (double)(homeObject.getY() + f), (double)(f2 + homeObject.getHeightInPlan())));
            }
            for (Wall wall : this.home.getWalls()) {
                if (wall.getLevel() != null && !wall.getLevel().isViewable()) continue;
                Point3d point3d = new Point3d((double)wall.getXStart(), (double)wall.getYStart(), wall.getLevel() != null ? (double)wall.getLevel().getElevation() : 0.0);
                if (boundingBox == null) {
                    boundingBox = new BoundingBox(point3d, point3d);
                } else {
                    boundingBox.combine(point3d);
                }
                boundingBox.combine(new Point3d((double)wall.getXEnd(), (double)wall.getYEnd(), point3d.z + (double)(wall.getHeight() != null ? wall.getHeight().floatValue() : this.home.getWallHeight())));
            }
            for (Room room : this.home.getRooms()) {
                if (room.getLevel() != null && !room.getLevel().isViewable()) continue;
                Point3d point3d = new Point3d((double)room.getXCenter(), (double)room.getYCenter(), room.getLevel() != null ? (double)room.getLevel().getElevation() : 0.0);
                if (boundingBox == null) {
                    boundingBox = new BoundingBox(point3d, point3d);
                    continue;
                }
                boundingBox.combine(point3d);
            }
            for (Label label : this.home.getLabels()) {
                if (label.getLevel() != null && !label.getLevel().isViewable() || label.getPitch() == null) continue;
                Point3d point3d = new Point3d((double)label.getX(), (double)label.getY(), (double)label.getGroundElevation());
                if (boundingBox == null) {
                    boundingBox = new BoundingBox(point3d, point3d);
                    continue;
                }
                boundingBox.combine(point3d);
            }
            this.approximateHomeBoundsCache = boundingBox;
        }
        return this.approximateHomeBoundsCache;
    }

    private float getDistanceToBox(float f, float f2, float f3, BoundingBox boundingBox) {
        Point3f point3f = new Point3f(f, f2, f3);
        Point3d point3d = new Point3d();
        boundingBox.getLower(point3d);
        Point3d point3d2 = new Point3d();
        boundingBox.getUpper(point3d2);
        Point3f[] point3fArray = new Point3f[]{new Point3f((float)point3d.x, (float)point3d.y, (float)point3d.z), new Point3f((float)point3d2.x, (float)point3d.y, (float)point3d.z), new Point3f((float)point3d.x, (float)point3d2.y, (float)point3d.z), new Point3f((float)point3d2.x, (float)point3d2.y, (float)point3d.z), new Point3f((float)point3d.x, (float)point3d.y, (float)point3d2.z), new Point3f((float)point3d2.x, (float)point3d.y, (float)point3d2.z), new Point3f((float)point3d.x, (float)point3d2.y, (float)point3d2.z), new Point3f((float)point3d2.x, (float)point3d2.y, (float)point3d2.z)};
        float[] fArray = new float[point3fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = point3f.distanceSquared(point3fArray[i]);
        }
        float[] fArray2 = new float[]{this.getDistanceToSide(point3f, point3fArray, fArray, 0, 1, 3, 2, 2), this.getDistanceToSide(point3f, point3fArray, fArray, 0, 1, 5, 4, 1), this.getDistanceToSide(point3f, point3fArray, fArray, 0, 2, 6, 4, 0), this.getDistanceToSide(point3f, point3fArray, fArray, 4, 5, 7, 6, 2), this.getDistanceToSide(point3f, point3fArray, fArray, 2, 3, 7, 6, 1), this.getDistanceToSide(point3f, point3fArray, fArray, 1, 3, 7, 5, 0)};
        float f4 = fArray2[0];
        for (int i = 1; i < fArray2.length; ++i) {
            f4 = Math.min(f4, fArray2[i]);
        }
        return f4;
    }

    private float getDistanceToSide(Point3f point3f, Point3f[] point3fArray, float[] fArray, int n, int n2, int n3, int n4, int n5) {
        switch (n5) {
            case 0: {
                if (point3f.y <= point3fArray[n].y) {
                    if (point3f.z <= point3fArray[n].z) {
                        return (float)Math.sqrt(fArray[n]);
                    }
                    if (point3f.z >= point3fArray[n4].z) {
                        return (float)Math.sqrt(fArray[n4]);
                    }
                    return this.getDistanceToLine(point3f, point3fArray[n], point3fArray[n4]);
                }
                if (point3f.y >= point3fArray[n2].y) {
                    if (point3f.z <= point3fArray[n2].z) {
                        return (float)Math.sqrt(fArray[n2]);
                    }
                    if (point3f.z >= point3fArray[n3].z) {
                        return (float)Math.sqrt(fArray[n3]);
                    }
                    return this.getDistanceToLine(point3f, point3fArray[n2], point3fArray[n3]);
                }
                if (point3f.z <= point3fArray[n].z) {
                    return this.getDistanceToLine(point3f, point3fArray[n], point3fArray[n2]);
                }
                if (!(point3f.z >= point3fArray[n4].z)) break;
                return this.getDistanceToLine(point3f, point3fArray[n3], point3fArray[n4]);
            }
            case 1: {
                if (point3f.x <= point3fArray[n].x) {
                    if (point3f.z <= point3fArray[n].z) {
                        return (float)Math.sqrt(fArray[n]);
                    }
                    if (point3f.z >= point3fArray[n4].z) {
                        return (float)Math.sqrt(fArray[n4]);
                    }
                    return this.getDistanceToLine(point3f, point3fArray[n], point3fArray[n4]);
                }
                if (point3f.x >= point3fArray[n2].x) {
                    if (point3f.z <= point3fArray[n2].z) {
                        return (float)Math.sqrt(fArray[n2]);
                    }
                    if (point3f.z >= point3fArray[n3].z) {
                        return (float)Math.sqrt(fArray[n3]);
                    }
                    return this.getDistanceToLine(point3f, point3fArray[n2], point3fArray[n3]);
                }
                if (point3f.z <= point3fArray[n].z) {
                    return this.getDistanceToLine(point3f, point3fArray[n], point3fArray[n2]);
                }
                if (!(point3f.z >= point3fArray[n4].z)) break;
                return this.getDistanceToLine(point3f, point3fArray[n3], point3fArray[n4]);
            }
            case 2: {
                if (point3f.x <= point3fArray[n].x) {
                    if (point3f.y <= point3fArray[n].y) {
                        return (float)Math.sqrt(fArray[n]);
                    }
                    if (point3f.y >= point3fArray[n4].y) {
                        return (float)Math.sqrt(fArray[n4]);
                    }
                    return this.getDistanceToLine(point3f, point3fArray[n], point3fArray[n4]);
                }
                if (point3f.x >= point3fArray[n2].x) {
                    if (point3f.y <= point3fArray[n2].y) {
                        return (float)Math.sqrt(fArray[n2]);
                    }
                    if (point3f.y >= point3fArray[n3].y) {
                        return (float)Math.sqrt(fArray[n3]);
                    }
                    return this.getDistanceToLine(point3f, point3fArray[n2], point3fArray[n3]);
                }
                if (point3f.y <= point3fArray[n].y) {
                    return this.getDistanceToLine(point3f, point3fArray[n], point3fArray[n2]);
                }
                if (!(point3f.y >= point3fArray[n4].y)) break;
                return this.getDistanceToLine(point3f, point3fArray[n3], point3fArray[n4]);
            }
        }
        Vector3f vector3f = new Vector3f(point3fArray[n2].x - point3fArray[n].x, point3fArray[n2].y - point3fArray[n].y, point3fArray[n2].z - point3fArray[n].z);
        Vector3f vector3f2 = new Vector3f(point3fArray[n3].x - point3fArray[n].x, point3fArray[n3].y - point3fArray[n].y, point3fArray[n3].z - point3fArray[n].z);
        Vector3f vector3f3 = new Vector3f();
        vector3f3.cross(vector3f, vector3f2);
        return Math.abs(vector3f3.dot(new Vector3f(point3fArray[n].x - point3f.x, point3fArray[n].y - point3f.y, point3fArray[n].z - point3f.z))) / vector3f3.length();
    }

    private float getDistanceToLine(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        Vector3f vector3f = new Vector3f(point3f3.x - point3f2.x, point3f3.y - point3f2.y, point3f3.z - point3f2.z);
        Vector3f vector3f2 = new Vector3f(point3f.x - point3f2.x, point3f.y - point3f2.y, point3f.z - point3f2.z);
        Vector3f vector3f3 = new Vector3f();
        vector3f3.cross(vector3f, vector3f2);
        return vector3f3.length() / vector3f.length();
    }

    private void clearPrintedImageCache() {
        this.printedImageCache = null;
    }

    private void updateViewPlatformTransform(TransformGroup transformGroup, Camera camera, boolean bl) {
        if (bl) {
            CameraInterpolator cameraInterpolator = (CameraInterpolator)transformGroup.getChild(transformGroup.numChildren() - 1);
            cameraInterpolator.moveCamera(camera);
        } else {
            Transform3D transform3D = new Transform3D();
            this.updateViewPlatformTransform(transform3D, camera.getX(), camera.getY(), camera.getZ(), camera.getYaw(), camera.getPitch());
            transformGroup.setTransform(transform3D);
        }
        this.clearPrintedImageCache();
    }

    private void updateViewPlatformTransform(Transform3D transform3D, float f, float f2, float f3, float f4, float f5) {
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotY((double)(-f4) + Math.PI);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.rotX((double)(-f5));
        transform3D2.mul(transform3D3);
        transform3D.setIdentity();
        transform3D.setTranslation(new Vector3f(f, f3, f2));
        transform3D.mul(transform3D2);
        this.camera = new Camera(f, f2, f3, f4, f5, 0.0f);
    }

    private void addMouseListeners(final HomeController3D homeController3D, final Component component) {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            private int xLastMouseMove;
            private int yLastMouseMove;
            private Component grabComponent;
            private Component previousMouseEventTarget;

            public void mousePressed(MouseEvent mouseEvent) {
                if (!this.retargetMouseEventToNavigationPanelChildren(mouseEvent)) {
                    if (mouseEvent.isPopupTrigger()) {
                        this.mouseReleased(mouseEvent);
                    } else if (HomeComponent3D.this.isEnabled()) {
                        HomeComponent3D.this.requestFocusInWindow();
                        this.xLastMouseMove = mouseEvent.getX();
                        this.yLastMouseMove = mouseEvent.getY();
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu;
                if (!this.retargetMouseEventToNavigationPanelChildren(mouseEvent) && mouseEvent.isPopupTrigger() && (jPopupMenu = HomeComponent3D.this.getComponentPopupMenu()) != null) {
                    jPopupMenu.show(HomeComponent3D.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.retargetMouseEventToNavigationPanelChildren(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                this.retargetMouseEventToNavigationPanelChildren(mouseEvent);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (!this.retargetMouseEventToNavigationPanelChildren(mouseEvent) && HomeComponent3D.this.isEnabled()) {
                    if (mouseEvent.isAltDown()) {
                        float f = 1.25f * (float)(this.yLastMouseMove - mouseEvent.getY());
                        if (mouseEvent.isShiftDown()) {
                            f *= 5.0f;
                        }
                        homeController3D.moveCamera(f);
                    } else {
                        float f = 0.005f * (float)(mouseEvent.getX() - this.xLastMouseMove);
                        if (mouseEvent.isShiftDown()) {
                            f *= 5.0f;
                        }
                        homeController3D.rotateCameraYaw(f);
                        float f2 = 0.005f * (float)(mouseEvent.getY() - this.yLastMouseMove);
                        homeController3D.rotateCameraPitch(f2);
                    }
                    this.xLastMouseMove = mouseEvent.getX();
                    this.yLastMouseMove = mouseEvent.getY();
                }
            }

            private boolean retargetMouseEventToNavigationPanelChildren(MouseEvent mouseEvent) {
                if (HomeComponent3D.this.navigationPanel != null && HomeComponent3D.this.navigationPanel.isVisible()) {
                    if (this.grabComponent != null && (mouseEvent.getID() == 502 || mouseEvent.getID() == 506)) {
                        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.grabComponent);
                        this.dispatchRetargetedEvent(this.deriveEvent(mouseEvent, this.grabComponent, mouseEvent.getID(), point.x, point.y));
                        if (mouseEvent.getID() == 502) {
                            this.grabComponent = null;
                        } else if (this.previousMouseEventTarget == null && this.grabComponent.contains(point)) {
                            this.dispatchRetargetedEvent(this.deriveEvent(mouseEvent, this.grabComponent, 504, point.x, point.y));
                            this.previousMouseEventTarget = this.grabComponent;
                        } else if (this.previousMouseEventTarget != null && !this.grabComponent.contains(point)) {
                            this.dispatchRetargetedEvent(this.deriveEvent(mouseEvent, this.grabComponent, 505, point.x, point.y));
                            this.previousMouseEventTarget = null;
                        }
                        return true;
                    }
                    Component component2 = this.retargetMouseEvent(HomeComponent3D.this.navigationPanel, mouseEvent);
                    if (component2 != null) {
                        this.previousMouseEventTarget = component2;
                        return true;
                    }
                }
                return false;
            }

            private Component retargetMouseEvent(Component component4, MouseEvent mouseEvent) {
                if (component4.getBounds().contains(mouseEvent.getPoint())) {
                    int n;
                    if (component4 instanceof Container) {
                        Container container = (Container)component4;
                        for (n = container.getComponentCount() - 1; n >= 0; --n) {
                            MouseEvent mouseEvent2;
                            Component component2 = container.getComponent(n);
                            Component component3 = this.retargetMouseEvent(component2, mouseEvent2 = this.deriveEvent(mouseEvent, component4, mouseEvent.getID(), mouseEvent.getX() - component4.getX(), mouseEvent.getY() - component4.getY()));
                            if (component3 == null) continue;
                            return component3;
                        }
                    }
                    int n2 = mouseEvent.getX() - component4.getX();
                    n = mouseEvent.getY() - component4.getY();
                    if (this.dispatchRetargetedEvent(this.deriveEvent(mouseEvent, component4, mouseEvent.getID(), n2, n))) {
                        if (mouseEvent.getID() == 501) {
                            this.grabComponent = component4;
                        }
                        return component4;
                    }
                }
                return null;
            }

            private boolean dispatchRetargetedEvent(MouseEvent mouseEvent) {
                mouseEvent.getComponent().dispatchEvent(mouseEvent);
                if (!RepaintManager.currentManager(mouseEvent.getComponent()).getDirtyRegion((JComponent)mouseEvent.getComponent()).isEmpty()) {
                    HomeComponent3D.this.updateNavigationPanelImage();
                    component.repaint();
                    return true;
                }
                return false;
            }

            private MouseEvent deriveEvent(MouseEvent mouseEvent, Component component2, int n, int n2, int n3) {
                return new MouseEvent(component2, n, mouseEvent.getWhen(), mouseEvent.getModifiersEx() | mouseEvent.getModifiers(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
        };
        MouseWheelListener mouseWheelListener = new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (HomeComponent3D.this.isEnabled()) {
                    float f = -2.5f * (float)mouseWheelEvent.getWheelRotation();
                    if (mouseWheelEvent.isShiftDown()) {
                        f *= 5.0f;
                    }
                    homeController3D.moveCamera(f);
                }
            }
        };
        component.addMouseListener(mouseInputAdapter);
        component.addMouseMotionListener(mouseInputAdapter);
        component.addMouseWheelListener(mouseWheelListener);
        this.addMouseListener(new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                HomeComponent3D.this.requestFocusInWindow();
            }
        });
    }

    private void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke("shift UP"), (Object)ActionType.MOVE_CAMERA_FAST_FORWARD);
        inputMap.put(KeyStroke.getKeyStroke("shift alt UP"), (Object)ActionType.MOVE_CAMERA_FAST_FORWARD);
        inputMap.put(KeyStroke.getKeyStroke("shift W"), (Object)ActionType.MOVE_CAMERA_FAST_FORWARD);
        inputMap.put(KeyStroke.getKeyStroke("UP"), (Object)ActionType.MOVE_CAMERA_FORWARD);
        inputMap.put(KeyStroke.getKeyStroke("alt UP"), (Object)ActionType.MOVE_CAMERA_FORWARD);
        inputMap.put(KeyStroke.getKeyStroke("W"), (Object)ActionType.MOVE_CAMERA_FORWARD);
        inputMap.put(KeyStroke.getKeyStroke("shift DOWN"), (Object)ActionType.MOVE_CAMERA_FAST_BACKWARD);
        inputMap.put(KeyStroke.getKeyStroke("shift alt DOWN"), (Object)ActionType.MOVE_CAMERA_FAST_BACKWARD);
        inputMap.put(KeyStroke.getKeyStroke("shift S"), (Object)ActionType.MOVE_CAMERA_FAST_BACKWARD);
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), (Object)ActionType.MOVE_CAMERA_BACKWARD);
        inputMap.put(KeyStroke.getKeyStroke("alt DOWN"), (Object)ActionType.MOVE_CAMERA_BACKWARD);
        inputMap.put(KeyStroke.getKeyStroke("S"), (Object)ActionType.MOVE_CAMERA_BACKWARD);
        inputMap.put(KeyStroke.getKeyStroke("shift alt LEFT"), (Object)ActionType.MOVE_CAMERA_FAST_LEFT);
        inputMap.put(KeyStroke.getKeyStroke("alt LEFT"), (Object)ActionType.MOVE_CAMERA_LEFT);
        inputMap.put(KeyStroke.getKeyStroke("shift alt RIGHT"), (Object)ActionType.MOVE_CAMERA_FAST_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke("alt RIGHT"), (Object)ActionType.MOVE_CAMERA_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke("shift LEFT"), (Object)ActionType.ROTATE_CAMERA_YAW_FAST_LEFT);
        inputMap.put(KeyStroke.getKeyStroke("shift A"), (Object)ActionType.ROTATE_CAMERA_YAW_FAST_LEFT);
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), (Object)ActionType.ROTATE_CAMERA_YAW_LEFT);
        inputMap.put(KeyStroke.getKeyStroke("A"), (Object)ActionType.ROTATE_CAMERA_YAW_LEFT);
        inputMap.put(KeyStroke.getKeyStroke("shift RIGHT"), (Object)ActionType.ROTATE_CAMERA_YAW_FAST_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke("shift D"), (Object)ActionType.ROTATE_CAMERA_YAW_FAST_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), (Object)ActionType.ROTATE_CAMERA_YAW_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke("D"), (Object)ActionType.ROTATE_CAMERA_YAW_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke("shift PAGE_UP"), (Object)ActionType.ROTATE_CAMERA_PITCH_FAST_UP);
        inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), (Object)ActionType.ROTATE_CAMERA_PITCH_UP);
        inputMap.put(KeyStroke.getKeyStroke("shift PAGE_DOWN"), (Object)ActionType.ROTATE_CAMERA_PITCH_FAST_DOWN);
        inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), (Object)ActionType.ROTATE_CAMERA_PITCH_DOWN);
        inputMap.put(KeyStroke.getKeyStroke("shift HOME"), (Object)ActionType.ELEVATE_CAMERA_FAST_UP);
        inputMap.put(KeyStroke.getKeyStroke("HOME"), (Object)ActionType.ELEVATE_CAMERA_UP);
        inputMap.put(KeyStroke.getKeyStroke("shift END"), (Object)ActionType.ELEVATE_CAMERA_FAST_DOWN);
        inputMap.put(KeyStroke.getKeyStroke("END"), (Object)ActionType.ELEVATE_CAMERA_DOWN);
    }

    private void createActions(final HomeController3D homeController3D) {
        ActionMap actionMap = this.getActionMap();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MoveCameraAction
        extends AbstractAction {
            private final float delta;

            public MoveCameraAction(float f) {
                this.delta = f;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                homeController3D.moveCamera(this.delta);
            }
        }
        actionMap.put((Object)ActionType.MOVE_CAMERA_FORWARD, new MoveCameraAction(6.5f));
        actionMap.put((Object)ActionType.MOVE_CAMERA_FAST_FORWARD, new MoveCameraAction(32.5f));
        actionMap.put((Object)ActionType.MOVE_CAMERA_BACKWARD, new MoveCameraAction(-6.5f));
        actionMap.put((Object)ActionType.MOVE_CAMERA_FAST_BACKWARD, new MoveCameraAction(-32.5f));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MoveCameraSidewaysAction
        extends AbstractAction {
            private final float delta;

            public MoveCameraSidewaysAction(float f) {
                this.delta = f;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                homeController3D.moveCameraSideways(this.delta);
            }
        }
        actionMap.put((Object)ActionType.MOVE_CAMERA_LEFT, new MoveCameraSidewaysAction(-2.5f));
        actionMap.put((Object)ActionType.MOVE_CAMERA_FAST_LEFT, new MoveCameraSidewaysAction(-10.0f));
        actionMap.put((Object)ActionType.MOVE_CAMERA_RIGHT, new MoveCameraSidewaysAction(2.5f));
        actionMap.put((Object)ActionType.MOVE_CAMERA_FAST_RIGHT, new MoveCameraSidewaysAction(10.0f));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ElevateCameraAction
        extends AbstractAction {
            private final float delta;

            public ElevateCameraAction(float f) {
                this.delta = f;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                homeController3D.elevateCamera(this.delta);
            }
        }
        actionMap.put((Object)ActionType.ELEVATE_CAMERA_DOWN, new ElevateCameraAction(-2.5f));
        actionMap.put((Object)ActionType.ELEVATE_CAMERA_FAST_DOWN, new ElevateCameraAction(-10.0f));
        actionMap.put((Object)ActionType.ELEVATE_CAMERA_UP, new ElevateCameraAction(2.5f));
        actionMap.put((Object)ActionType.ELEVATE_CAMERA_FAST_UP, new ElevateCameraAction(10.0f));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RotateCameraYawAction
        extends AbstractAction {
            private final float delta;

            public RotateCameraYawAction(float f) {
                this.delta = f;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                homeController3D.rotateCameraYaw(this.delta);
            }
        }
        actionMap.put((Object)ActionType.ROTATE_CAMERA_YAW_LEFT, new RotateCameraYawAction(-0.05235988f));
        actionMap.put((Object)ActionType.ROTATE_CAMERA_YAW_FAST_LEFT, new RotateCameraYawAction(-0.2617994f));
        actionMap.put((Object)ActionType.ROTATE_CAMERA_YAW_RIGHT, new RotateCameraYawAction(0.05235988f));
        actionMap.put((Object)ActionType.ROTATE_CAMERA_YAW_FAST_RIGHT, new RotateCameraYawAction(0.2617994f));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RotateCameraPitchAction
        extends AbstractAction {
            private final float delta;

            public RotateCameraPitchAction(float f) {
                this.delta = f;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                homeController3D.rotateCameraPitch(this.delta);
            }
        }
        actionMap.put((Object)ActionType.ROTATE_CAMERA_PITCH_UP, new RotateCameraPitchAction(-0.02617994f));
        actionMap.put((Object)ActionType.ROTATE_CAMERA_PITCH_FAST_UP, new RotateCameraPitchAction(-0.1308997f));
        actionMap.put((Object)ActionType.ROTATE_CAMERA_PITCH_DOWN, new RotateCameraPitchAction(0.02617994f));
        actionMap.put((Object)ActionType.ROTATE_CAMERA_PITCH_FAST_DOWN, new RotateCameraPitchAction(0.1308997f));
    }

    private BranchGroup createSceneTree(boolean bl, boolean bl2, boolean bl3) {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.addChild(this.createHomeTree(bl, bl2, bl3));
        Node node = this.createBackgroundNode(bl2, bl3);
        branchGroup.addChild(node);
        Node node2 = this.createGroundNode(-5000000.0f, -5000000.0f, 1.0E7f, 1.0E7f, bl2, bl3);
        branchGroup.addChild(node2);
        for (Light light : this.sceneLights = this.createLights(node2, bl2)) {
            branchGroup.addChild((Node)light);
        }
        return branchGroup;
    }

    private Node createBackgroundNode(boolean bl, final boolean bl2) {
        final Appearance appearance = new Appearance();
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        appearance.setColoringAttributes(coloringAttributes);
        appearance.setCapability(3);
        appearance.setCapability(8);
        coloringAttributes.setCapability(1);
        Geometry geometry = this.createHalfSphereGeometry(true);
        Shape3D shape3D = new Shape3D(geometry, appearance);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.addChild((Node)shape3D);
        Appearance appearance2 = new Appearance();
        final RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setVisible(false);
        appearance2.setRenderingAttributes(renderingAttributes);
        renderingAttributes.setCapability(6);
        Shape3D shape3D2 = new Shape3D(this.createHalfSphereGeometry(false), appearance2);
        branchGroup.addChild((Node)shape3D2);
        final Appearance appearance3 = new Appearance();
        TextureAttributes textureAttributes = new TextureAttributes();
        textureAttributes.setTextureMode(2);
        appearance3.setTextureAttributes(textureAttributes);
        appearance3.setTexCoordGeneration(new TexCoordGeneration(0, 0, new Vector4f(100000.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 100000.0f, 0.0f)));
        final RenderingAttributes renderingAttributes2 = new RenderingAttributes();
        appearance3.setRenderingAttributes(renderingAttributes2);
        appearance3.setCapability(3);
        appearance3.setCapability(1);
        renderingAttributes2.setCapability(6);
        GeometryInfo geometryInfo = new GeometryInfo(2);
        geometryInfo.setCoordinates(new Point3f[]{new Point3f(-1.0f, -0.01f, -1.0f), new Point3f(-1.0f, -0.01f, 1.0f), new Point3f(1.0f, -0.01f, 1.0f), new Point3f(1.0f, -0.01f, -1.0f), new Point3f(-1.0f, -0.1f, -1.0f), new Point3f(-1.0f, -0.1f, 1.0f), new Point3f(1.0f, -0.1f, 1.0f), new Point3f(1.0f, -0.1f, -1.0f)});
        geometryInfo.setCoordinateIndices(new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        geometryInfo.setNormals(new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f)});
        geometryInfo.setNormalIndices(new int[]{0, 0, 0, 0, 0, 0, 0, 0});
        Shape3D shape3D3 = new Shape3D((Geometry)geometryInfo.getIndexedGeometryArray(), appearance3);
        branchGroup.addChild((Node)shape3D3);
        for (Light light : this.createBackgroundLights(bl)) {
            branchGroup.addChild((Node)light);
        }
        Background background = new Background(branchGroup);
        this.updateBackgroundColorAndTexture(appearance, appearance3, this.home, bl2);
        background.setApplicationBounds((Bounds)new BoundingBox(new Point3d(-1.0E7, -1.0E7, -1.0E7), new Point3d(1.0E7, 1.0E7, 1.0E7)));
        if (bl) {
            this.backgroundChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeComponent3D.this.updateBackgroundColorAndTexture(appearance, appearance3, HomeComponent3D.this.home, bl2);
                }
            };
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.SKY_COLOR, this.backgroundChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.SKY_TEXTURE, this.backgroundChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.GROUND_COLOR, this.backgroundChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.GROUND_TEXTURE, this.backgroundChangeListener);
            this.elevationChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getSource() == HomeComponent3D.this.home) {
                        ((Camera)propertyChangeEvent.getOldValue()).removePropertyChangeListener(this);
                        HomeComponent3D.this.home.getCamera().addPropertyChangeListener(this);
                    }
                    if (propertyChangeEvent.getSource() == HomeComponent3D.this.home || Camera.Property.Z.name().equals(propertyChangeEvent.getPropertyName())) {
                        renderingAttributes2.setVisible(HomeComponent3D.this.home.getCamera().getZ() >= 0.0f);
                        renderingAttributes.setVisible(HomeComponent3D.this.home.getCamera().getZ() < 0.0f);
                    }
                }
            };
            this.home.getCamera().addPropertyChangeListener(this.elevationChangeListener);
            this.home.addPropertyChangeListener(Home.Property.CAMERA, this.elevationChangeListener);
        }
        return background;
    }

    private Geometry createHalfSphereGeometry(boolean bl) {
        Point3f[] point3fArray = new Point3f[2304];
        TexCoord2f[] texCoord2fArray = bl ? new TexCoord2f[2304] : null;
        Color3f[] color3fArray = bl ? null : new Color3f[2304];
        int n = 0;
        for (int i = 0; i < 48; ++i) {
            double d = (double)(i * 2) * Math.PI / 48.0;
            float f = (float)Math.cos(d);
            float f2 = (float)Math.sin(d);
            double d2 = (double)((i + 1) * 2) * Math.PI / 48.0;
            float f3 = (float)Math.cos(d2);
            float f4 = (float)Math.sin(d2);
            for (int j = 0; j < 12; ++j) {
                double d3 = (double)(2 * j) * Math.PI / 48.0;
                float f5 = (float)Math.cos(d3);
                float f6 = (float)Math.sin(d3);
                float f7 = j != 0 ? (bl ? f6 : -f6) : -0.01f;
                double d4 = (double)(2 * (j + 1)) * Math.PI / 48.0;
                if (!bl) {
                    d4 = -d4;
                }
                float f8 = (float)Math.cos(d4);
                float f9 = (float)Math.sin(d4);
                if (bl) {
                    point3fArray[n] = new Point3f(f * f5, f7, f2 * f5);
                    texCoord2fArray[n++] = new TexCoord2f((float)i / 48.0f, f6);
                    point3fArray[n] = new Point3f(f3 * f5, f7, f4 * f5);
                    texCoord2fArray[n++] = new TexCoord2f((float)(i + 1) / 48.0f, f6);
                    point3fArray[n] = new Point3f(f3 * f8, f9, f4 * f8);
                    texCoord2fArray[n++] = new TexCoord2f((float)(i + 1) / 48.0f, f9);
                    point3fArray[n] = new Point3f(f * f8, f9, f2 * f8);
                    texCoord2fArray[n++] = new TexCoord2f((float)i / 48.0f, f9);
                    continue;
                }
                point3fArray[n] = new Point3f(f * f5, f7, f2 * f5);
                float f10 = 0.9f + f7 * 0.5f;
                color3fArray[n++] = new Color3f(f10, f10, f10);
                point3fArray[n] = new Point3f(f * f8, f9, f2 * f8);
                float f11 = 0.9f + f9 * 0.5f;
                color3fArray[n++] = new Color3f(f11, f11, f11);
                point3fArray[n] = new Point3f(f3 * f8, f9, f4 * f8);
                color3fArray[n++] = new Color3f(f11, f11, f11);
                point3fArray[n] = new Point3f(f3 * f5, f7, f4 * f5);
                color3fArray[n++] = new Color3f(f10, f10, f10);
            }
        }
        GeometryInfo geometryInfo = new GeometryInfo(2);
        geometryInfo.setCoordinates(point3fArray);
        if (texCoord2fArray != null) {
            geometryInfo.setTextureCoordinateParams(1, 2);
            geometryInfo.setTextureCoordinates(0, texCoord2fArray);
        }
        if (color3fArray != null) {
            geometryInfo.setColors(color3fArray);
        }
        geometryInfo.indexify();
        geometryInfo.compact();
        IndexedGeometryArray indexedGeometryArray = geometryInfo.getIndexedGeometryArray();
        return indexedGeometryArray;
    }

    private void updateBackgroundColorAndTexture(final Appearance appearance, final Appearance appearance2, Home home, boolean bl) {
        Object object;
        Color3f color3f = new Color3f(new Color(home.getEnvironment().getSkyColor()));
        appearance.getColoringAttributes().setColor(color3f);
        HomeTexture homeTexture = home.getEnvironment().getSkyTexture();
        if (homeTexture != null) {
            object = TextureManager.getInstance();
            if (bl) {
                appearance.setTexture(((TextureManager)object).loadTexture(homeTexture.getImage()));
            } else {
                ((TextureManager)object).loadTexture(homeTexture.getImage(), bl, new TextureManager.TextureObserver(){

                    public void textureUpdated(Texture texture) {
                        appearance.setTexture((Texture)texture.cloneNodeComponent(false));
                    }
                });
            }
        } else {
            appearance.setTexture(null);
        }
        object = home.getEnvironment().getGroundTexture();
        if (object != null) {
            appearance2.setMaterial(new Material(new Color3f(1.0f, 1.0f, 1.0f), new Color3f(), new Color3f(1.0f, 1.0f, 1.0f), new Color3f(0.0f, 0.0f, 0.0f), 1.0f));
            TextureManager textureManager = TextureManager.getInstance();
            if (bl) {
                appearance2.setTexture(textureManager.loadTexture(((HomeTexture)object).getImage()));
            } else {
                textureManager.loadTexture(((HomeTexture)object).getImage(), bl, new TextureManager.TextureObserver(){

                    public void textureUpdated(Texture texture) {
                        appearance2.setTexture((Texture)texture.cloneNodeComponent(false));
                    }
                });
            }
        } else {
            int n = home.getEnvironment().getGroundColor();
            Color3f color3f2 = new Color3f((float)(n >>> 16 & 0xFF) / 255.0f, (float)(n >>> 8 & 0xFF) / 255.0f, (float)(n & 0xFF) / 255.0f);
            appearance2.setMaterial(new Material(color3f2, new Color3f(), color3f2, new Color3f(0.0f, 0.0f, 0.0f), 1.0f));
            appearance2.setTexture(null);
        }
        this.clearPrintedImageCache();
    }

    private Node createGroundNode(float f, float f2, float f3, float f4, boolean bl, boolean bl2) {
        final Ground3D ground3D = new Ground3D(this.home, f, f2, f3, f4, bl2);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(0.0f, -0.2f, 0.0f));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)ground3D);
        if (bl) {
            this.groundChangeListener = new PropertyChangeListener(){
                private Runnable updater;

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (this.updater == null) {
                        this.updater = new Runnable(){

                            public void run() {
                                ground3D.update();
                                updater = null;
                            }
                        };
                        EventQueue.invokeLater(this.updater);
                    }
                    HomeComponent3D.this.clearPrintedImageCache();
                }
            };
            HomeEnvironment homeEnvironment = this.home.getEnvironment();
            homeEnvironment.addPropertyChangeListener(HomeEnvironment.Property.GROUND_COLOR, this.groundChangeListener);
            homeEnvironment.addPropertyChangeListener(HomeEnvironment.Property.GROUND_TEXTURE, this.groundChangeListener);
        }
        return transformGroup;
    }

    private Light[] createBackgroundLights(boolean bl) {
        final Light[] lightArray = new Light[]{new DirectionalLight(new Color3f(1.435f, 1.435f, 1.435f), new Vector3f(0.0f, -1.0f, 0.0f)), new AmbientLight(new Color3f(0.2f, 0.2f, 0.2f))};
        for (int i = 0; i < lightArray.length - 1; ++i) {
            lightArray[i].setCapability(15);
            Light[] lightArray2 = new Color3f();
            lightArray[i].getColor((Color3f)lightArray2);
            lightArray[i].setUserData((Object)lightArray2);
            this.updateLightColor(lightArray[i]);
        }
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(), 2.0);
        for (Light light : lightArray) {
            light.setInfluencingBounds((Bounds)boundingSphere);
        }
        if (bl) {
            this.backgroundLightColorListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeComponent3D.this.updateLightColor(lightArray[0]);
                }
            };
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.LIGHT_COLOR, this.backgroundLightColorListener);
        }
        return lightArray;
    }

    private Light[] createLights(Node node, boolean bl) {
        Color3f color3f = new Color3f[]{new DirectionalLight(new Color3f(1.0f, 1.0f, 1.0f), new Vector3f(1.5f, -0.8f, -1.0f)), new DirectionalLight(new Color3f(1.0f, 1.0f, 1.0f), new Vector3f(-1.5f, -0.8f, -1.0f)), new DirectionalLight(new Color3f(1.0f, 1.0f, 1.0f), new Vector3f(0.0f, -0.8f, 1.0f)), new DirectionalLight(new Color3f(0.7f, 0.7f, 0.7f), new Vector3f(0.0f, 1.0f, 0.0f)), new AmbientLight(new Color3f(0.2f, 0.2f, 0.2f))};
        for (int i = 0; i < ((Light[])color3f).length - 1; ++i) {
            color3f[i].setCapability(15);
            color3f[i].setCapability(29);
            Color3f color3f2 = new Color3f();
            color3f[i].getColor(color3f2);
            color3f[i].setUserData((Object)color3f2);
            this.updateLightColor((Light)color3f[i]);
        }
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(), 1.0E7);
        for (Color3f color3f3 : color3f) {
            color3f3.setInfluencingBounds((Bounds)boundingSphere);
        }
        if (bl) {
            this.lightColorListener = new PropertyChangeListener((Light[])color3f){
                final /* synthetic */ Light[] val$lights;
                {
                    this.val$lights = lightArray;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    for (int i = 0; i < this.val$lights.length - 1; ++i) {
                        HomeComponent3D.this.updateLightColor(this.val$lights[i]);
                    }
                    HomeComponent3D.this.updateObjects(HomeComponent3D.this.getHomeObjects(HomeLight.class));
                }
            };
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.LIGHT_COLOR, this.lightColorListener);
            this.subpartSizeListener = new PropertyChangeListener((Light[])color3f, node){
                final /* synthetic */ Light[] val$lights;
                final /* synthetic */ Node val$groundNode;
                {
                    this.val$lights = lightArray;
                    this.val$groundNode = node;
                }

                /*
                 * WARNING - void declaration
                 */
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    void var5_9;
                    Object object;
                    Light[] lightArray;
                    ArrayList<Wall> arrayList;
                    if (propertyChangeEvent != null) {
                        arrayList = new ArrayList<Wall>(HomeComponent3D.this.home.getWalls());
                        arrayList.addAll(HomeComponent3D.this.home.getRooms());
                        arrayList.addAll(HomeComponent3D.this.getHomeObjects(HomeLight.class));
                        HomeComponent3D.this.updateObjects(arrayList);
                        HomeComponent3D.this.clearPrintedImageCache();
                    }
                    arrayList = null;
                    if (HomeComponent3D.this.home.getEnvironment().getSubpartSizeUnderLight() > 0.0f) {
                        lightArray = HomeComponent3D.this.getLightScopeOutsideWallsArea();
                        arrayList = new ArrayList();
                        for (Wall object32 : HomeComponent3D.this.home.getWalls()) {
                            object = (Object3DBranch)((Object)HomeComponent3D.this.homeObjects.get(object32));
                            if (object instanceof Wall3D) {
                                float[][] fArray = object32.getPoints();
                                if (!lightArray.contains(fArray[0][0], fArray[0][1])) {
                                    arrayList.add((Wall)((Group)object.getChild(1)));
                                }
                                if (!lightArray.contains(fArray[fArray.length - 1][0], fArray[fArray.length - 1][1])) {
                                    arrayList.add((Wall)((Group)object.getChild(4)));
                                }
                            }
                            arrayList.add((Wall)((Group)object.getChild(0)));
                            arrayList.add((Wall)((Group)object.getChild(2)));
                            arrayList.add((Wall)((Group)object.getChild(3)));
                            arrayList.add((Wall)((Group)object.getChild(5)));
                        }
                        ArrayList<Room> arrayList2 = new ArrayList<Room>(HomeComponent3D.this.home.getRooms());
                        arrayList2.addAll(HomeComponent3D.this.getHomeObjects(HomePieceOfFurniture.class));
                        Iterator iterator = arrayList2.iterator();
                        block1: while (iterator.hasNext()) {
                            object = (Selectable)iterator.next();
                            for (float[] fArray : object.getPoints()) {
                                if (lightArray.contains(fArray[0], fArray[1])) continue;
                                Group group = (Group)HomeComponent3D.this.homeObjects.get(object);
                                if (group instanceof HomePieceOfFurniture3D) {
                                    group = (Group)group.getChild(0);
                                }
                                arrayList.add((Wall)group);
                                continue block1;
                            }
                        }
                    } else {
                        HomeComponent3D.this.lightScopeOutsideWallsAreaCache = null;
                    }
                    lightArray = this.val$lights;
                    int n = lightArray.length;
                    boolean bl = false;
                    while (var5_9 < n) {
                        object = lightArray[var5_9];
                        if (object instanceof DirectionalLight) {
                            object.removeAllScopes();
                            if (arrayList != null) {
                                object.addScope((Group)this.val$groundNode);
                                for (Group group : arrayList) {
                                    object.addScope(group);
                                }
                            }
                        }
                        ++var5_9;
                    }
                }
            };
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.SUBPART_SIZE_UNDER_LIGHT, this.subpartSizeListener);
            this.subpartSizeListener.propertyChange(null);
        }
        return color3f;
    }

    private <T> List<T> getHomeObjects(Class<T> clazz) {
        return Home.getSubList(new ArrayList<Selectable>(this.homeObjects.keySet()), clazz);
    }

    private void updateLightColor(Light light) {
        Color3f color3f = (Color3f)light.getUserData();
        int n = this.home.getEnvironment().getLightColor();
        light.setColor(new Color3f((float)(n >>> 16 & 0xFF) / 255.0f * color3f.x, (float)(n >>> 8 & 0xFF) / 255.0f * color3f.y, (float)(n & 0xFF) / 255.0f * color3f.z));
        this.clearPrintedImageCache();
    }

    private Area getLightScopeOutsideWallsArea() {
        if (this.lightScopeOutsideWallsAreaCache == null) {
            Object object;
            Area area = new Area();
            for (Wall cloneable2 : this.home.getWalls()) {
                object = cloneable2.clone();
                ((Wall)object).setThickness(Math.max(((Wall)object).getThickness() - 0.1f, 0.08f));
                area.add(new Area(this.getShape(((Wall)object).getPoints())));
            }
            Area area2 = new Area();
            ArrayList<float[]> arrayList = new ArrayList<float[]>();
            object = area.getPathIterator(null, 1.0);
            while (!object.isDone()) {
                float[] fArray = new float[2];
                switch (object.currentSegment(fArray)) {
                    case 0: 
                    case 1: {
                        arrayList.add(fArray);
                        break;
                    }
                    case 4: {
                        float[][] fArray2;
                        if (arrayList.size() > 2 && new Room(fArray2 = (float[][])arrayList.toArray((T[])new float[arrayList.size()][])).isClockwise()) {
                            area2.add(new Area(this.getShape(fArray2)));
                        }
                        arrayList.clear();
                    }
                }
                object.next();
            }
            this.lightScopeOutsideWallsAreaCache = area2;
        }
        return this.lightScopeOutsideWallsAreaCache;
    }

    private Node createHomeTree(boolean bl, boolean bl2, boolean bl3) {
        Group group = this.createHomeRoot();
        for (Label object : this.home.getLabels()) {
            this.addObject(group, object, bl2, bl3);
        }
        for (Room room : this.home.getRooms()) {
            this.addObject(group, room, bl2, bl3);
        }
        for (Wall wall : this.home.getWalls()) {
            this.addObject(group, wall, bl2, bl3);
        }
        HashMap hashMap = new HashMap();
        for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                    if (homePieceOfFurniture2 instanceof HomeFurnitureGroup) continue;
                    hashMap.put(homePieceOfFurniture2, this.addObject(group, homePieceOfFurniture2, bl2, bl3));
                }
                continue;
            }
            hashMap.put(homePieceOfFurniture, this.addObject(group, homePieceOfFurniture, bl2, bl3));
        }
        if (bl) {
            this.addShadowOnFloor(group, hashMap);
        }
        if (bl2) {
            this.addLevelListener(group);
            this.addWallListener(group);
            this.addFurnitureListener(group);
            this.addRoomListener(group);
            this.addLabelListener(group);
            this.addEnvironmentListeners();
        }
        return group;
    }

    private Group createHomeRoot() {
        Group group = new Group();
        group.setCapability(13);
        group.setCapability(14);
        return group;
    }

    private void addLevelListener(Group group) {
        this.levelChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Level.Property.ELEVATION.name().equals(propertyChangeEvent.getPropertyName()) || Level.Property.VISIBLE.name().equals(propertyChangeEvent.getPropertyName()) || Level.Property.VIEWABLE.name().equals(propertyChangeEvent.getPropertyName())) {
                    HomeComponent3D.this.updateObjects(HomeComponent3D.this.homeObjects.keySet());
                    HomeComponent3D.this.groundChangeListener.propertyChange(null);
                } else if (Level.Property.FLOOR_THICKNESS.name().equals(propertyChangeEvent.getPropertyName())) {
                    HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getWalls());
                    HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
                } else if (Level.Property.HEIGHT.name().equals(propertyChangeEvent.getPropertyName())) {
                    HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
                }
            }
        };
        for (Level level : this.home.getLevels()) {
            level.addPropertyChangeListener(this.levelChangeListener);
        }
        this.levelListener = new CollectionListener<Level>(){

            @Override
            public void collectionChanged(CollectionEvent<Level> collectionEvent) {
                Level level = collectionEvent.getItem();
                switch (collectionEvent.getType()) {
                    case ADD: {
                        level.addPropertyChangeListener(HomeComponent3D.this.levelChangeListener);
                        break;
                    }
                    case DELETE: {
                        level.removePropertyChangeListener(HomeComponent3D.this.levelChangeListener);
                    }
                }
                HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
            }
        };
        this.home.addLevelsListener(this.levelListener);
    }

    private void addWallListener(final Group group) {
        this.wallChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (!Wall.Property.PATTERN.name().equals(string)) {
                    Wall wall = (Wall)propertyChangeEvent.getSource();
                    HomeComponent3D.this.updateWall(wall);
                    HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
                    if (wall.getLevel() != null && wall.getLevel().getElevation() < 0.0f) {
                        HomeComponent3D.this.groundChangeListener.propertyChange(null);
                    }
                    if (HomeComponent3D.this.home.getEnvironment().getSubpartSizeUnderLight() > 0.0f && (Wall.Property.X_START.name().equals(string) || Wall.Property.Y_START.name().equals(string) || Wall.Property.X_END.name().equals(string) || Wall.Property.Y_END.name().equals(string) || Wall.Property.ARC_EXTENT.name().equals(string) || Wall.Property.THICKNESS.name().equals(string))) {
                        HomeComponent3D.this.lightScopeOutsideWallsAreaCache = null;
                        HomeComponent3D.this.updateObjectsLightScope(null);
                    }
                }
            }
        };
        for (Wall wall : this.home.getWalls()) {
            wall.addPropertyChangeListener(this.wallChangeListener);
        }
        this.wallListener = new CollectionListener<Wall>(){

            @Override
            public void collectionChanged(CollectionEvent<Wall> collectionEvent) {
                Wall wall = collectionEvent.getItem();
                switch (collectionEvent.getType()) {
                    case ADD: {
                        HomeComponent3D.this.addObject(group, wall, true, false);
                        wall.addPropertyChangeListener(HomeComponent3D.this.wallChangeListener);
                        break;
                    }
                    case DELETE: {
                        HomeComponent3D.this.deleteObject(wall);
                        wall.removePropertyChangeListener(HomeComponent3D.this.wallChangeListener);
                    }
                }
                HomeComponent3D.this.lightScopeOutsideWallsAreaCache = null;
                HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
                HomeComponent3D.this.groundChangeListener.propertyChange(null);
                HomeComponent3D.this.updateObjectsLightScope(null);
            }
        };
        this.home.addWallsListener(this.wallListener);
    }

    private void addFurnitureListener(final Group group) {
        this.furnitureChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)propertyChangeEvent.getSource();
                String string = propertyChangeEvent.getPropertyName();
                if (HomePieceOfFurniture.Property.X.name().equals(string) || HomePieceOfFurniture.Property.Y.name().equals(string) || HomePieceOfFurniture.Property.ANGLE.name().equals(string) || HomePieceOfFurniture.Property.ROLL.name().equals(string) || HomePieceOfFurniture.Property.PITCH.name().equals(string) || HomePieceOfFurniture.Property.WIDTH.name().equals(string) || HomePieceOfFurniture.Property.DEPTH.name().equals(string)) {
                    this.updatePieceOfFurnitureGeometry(homePieceOfFurniture);
                    HomeComponent3D.this.updateObjectsLightScope(Arrays.asList(homePieceOfFurniture));
                } else if (HomePieceOfFurniture.Property.HEIGHT.name().equals(string) || HomePieceOfFurniture.Property.ELEVATION.name().equals(string) || HomePieceOfFurniture.Property.MODEL_MIRRORED.name().equals(string) || HomePieceOfFurniture.Property.VISIBLE.name().equals(string) || HomePieceOfFurniture.Property.LEVEL.name().equals(string)) {
                    this.updatePieceOfFurnitureGeometry(homePieceOfFurniture);
                } else if (HomePieceOfFurniture.Property.COLOR.name().equals(string) || HomePieceOfFurniture.Property.TEXTURE.name().equals(string) || HomePieceOfFurniture.Property.MODEL_MATERIALS.name().equals(string) || HomePieceOfFurniture.Property.SHININESS.name().equals(string) || HomeLight.Property.POWER.name().equals(string) && HomeComponent3D.this.home.getEnvironment().getSubpartSizeUnderLight() > 0.0f) {
                    HomeComponent3D.this.updateObjects(Arrays.asList(homePieceOfFurniture));
                }
            }

            private void updatePieceOfFurnitureGeometry(HomePieceOfFurniture homePieceOfFurniture) {
                HomeComponent3D.this.updateObjects(Arrays.asList(homePieceOfFurniture));
                if (HomeComponent3D.this.containsDoorsAndWindows(homePieceOfFurniture)) {
                    HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getWalls());
                } else if (HomeComponent3D.this.containsStaircases(homePieceOfFurniture)) {
                    HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
                }
                if (homePieceOfFurniture.getLevel() != null && homePieceOfFurniture.getLevel().getElevation() < 0.0f) {
                    HomeComponent3D.this.groundChangeListener.propertyChange(null);
                }
            }
        };
        for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                    homePieceOfFurniture2.addPropertyChangeListener(this.furnitureChangeListener);
                }
                continue;
            }
            homePieceOfFurniture.addPropertyChangeListener(this.furnitureChangeListener);
        }
        this.furnitureListener = new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                HomePieceOfFurniture homePieceOfFurniture = collectionEvent.getItem();
                switch (collectionEvent.getType()) {
                    case ADD: {
                        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                                if (homePieceOfFurniture2 instanceof HomeFurnitureGroup) continue;
                                HomeComponent3D.this.addObject(group, homePieceOfFurniture2, true, false);
                                homePieceOfFurniture2.addPropertyChangeListener(HomeComponent3D.this.furnitureChangeListener);
                            }
                            break;
                        }
                        HomeComponent3D.this.addObject(group, homePieceOfFurniture, true, false);
                        homePieceOfFurniture.addPropertyChangeListener(HomeComponent3D.this.furnitureChangeListener);
                        break;
                    }
                    case DELETE: {
                        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                            for (HomePieceOfFurniture homePieceOfFurniture3 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                                if (homePieceOfFurniture3 instanceof HomeFurnitureGroup) continue;
                                HomeComponent3D.this.deleteObject(homePieceOfFurniture3);
                                homePieceOfFurniture3.removePropertyChangeListener(HomeComponent3D.this.furnitureChangeListener);
                            }
                            break;
                        }
                        HomeComponent3D.this.deleteObject(homePieceOfFurniture);
                        homePieceOfFurniture.removePropertyChangeListener(HomeComponent3D.this.furnitureChangeListener);
                    }
                }
                if (HomeComponent3D.this.containsDoorsAndWindows(homePieceOfFurniture)) {
                    HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getWalls());
                } else if (HomeComponent3D.this.containsStaircases(homePieceOfFurniture)) {
                    HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
                } else {
                    HomeComponent3D.this.approximateHomeBoundsCache = null;
                }
                HomeComponent3D.this.groundChangeListener.propertyChange(null);
                HomeComponent3D.this.updateObjectsLightScope(Arrays.asList(homePieceOfFurniture));
            }
        };
        this.home.addFurnitureListener(this.furnitureListener);
    }

    private boolean containsDoorsAndWindows(HomePieceOfFurniture homePieceOfFurniture) {
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                if (!this.containsDoorsAndWindows(homePieceOfFurniture2)) continue;
                return true;
            }
            return false;
        }
        return homePieceOfFurniture.isDoorOrWindow();
    }

    private boolean containsStaircases(HomePieceOfFurniture homePieceOfFurniture) {
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                if (!this.containsStaircases(homePieceOfFurniture2)) continue;
                return true;
            }
            return false;
        }
        return homePieceOfFurniture.getStaircaseCutOutShape() != null;
    }

    private void addRoomListener(final Group group) {
        this.roomChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Room room = (Room)propertyChangeEvent.getSource();
                String string = propertyChangeEvent.getPropertyName();
                if (Room.Property.FLOOR_COLOR.name().equals(string) || Room.Property.FLOOR_TEXTURE.name().equals(string) || Room.Property.FLOOR_SHININESS.name().equals(string) || Room.Property.CEILING_COLOR.name().equals(string) || Room.Property.CEILING_TEXTURE.name().equals(string) || Room.Property.CEILING_SHININESS.name().equals(string)) {
                    HomeComponent3D.this.updateObjects(Arrays.asList(room));
                } else if (Room.Property.FLOOR_VISIBLE.name().equals(string) || Room.Property.CEILING_VISIBLE.name().equals(string) || Room.Property.LEVEL.name().equals(string)) {
                    HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
                    HomeComponent3D.this.groundChangeListener.propertyChange(null);
                } else if (Room.Property.POINTS.name().equals(string)) {
                    if (HomeComponent3D.this.homeObjectsToUpdate != null) {
                        HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
                    } else {
                        HomeComponent3D.this.updateObjects(Arrays.asList(room));
                        HomeComponent3D.this.updateObjects(HomeComponent3D.this.getHomeObjects(HomeLight.class));
                        Area area = new Area(HomeComponent3D.this.getShape((float[][])propertyChangeEvent.getOldValue()));
                        Area area2 = new Area(HomeComponent3D.this.getShape((float[][])propertyChangeEvent.getNewValue()));
                        Level level = room.getLevel();
                        for (Room room2 : HomeComponent3D.this.home.getRooms()) {
                            Level level2 = room2.getLevel();
                            if (room2 == room || level2 != null && !((double)Math.abs(level.getElevation() + level.getHeight() - (level2.getElevation() + level2.getHeight())) < 1.0E-5) && !((double)Math.abs(level.getElevation() + level.getHeight() - (level2.getElevation() - level2.getFloorThickness())) < 1.0E-5)) continue;
                            Area area3 = new Area(HomeComponent3D.this.getShape(room2.getPoints()));
                            Area area4 = new Area(area3);
                            area4.intersect(area2);
                            if (!area4.isEmpty()) {
                                HomeComponent3D.this.updateObjects(Arrays.asList(room2));
                                continue;
                            }
                            area3.intersect(area);
                            if (area3.isEmpty()) continue;
                            HomeComponent3D.this.updateObjects(Arrays.asList(room2));
                        }
                    }
                    HomeComponent3D.this.groundChangeListener.propertyChange(null);
                    HomeComponent3D.this.updateObjectsLightScope(Arrays.asList(room));
                    HomeComponent3D.this.updateObjectsLightScope(HomeComponent3D.this.getHomeObjects(HomeLight.class));
                }
            }
        };
        for (Room room : this.home.getRooms()) {
            room.addPropertyChangeListener(this.roomChangeListener);
        }
        this.roomListener = new CollectionListener<Room>(){

            @Override
            public void collectionChanged(CollectionEvent<Room> collectionEvent) {
                Room room = collectionEvent.getItem();
                switch (collectionEvent.getType()) {
                    case ADD: {
                        HomeComponent3D.this.addObject(group, room, collectionEvent.getIndex(), true, false);
                        room.addPropertyChangeListener(HomeComponent3D.this.roomChangeListener);
                        break;
                    }
                    case DELETE: {
                        HomeComponent3D.this.deleteObject(room);
                        room.removePropertyChangeListener(HomeComponent3D.this.roomChangeListener);
                    }
                }
                HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
                HomeComponent3D.this.groundChangeListener.propertyChange(null);
                HomeComponent3D.this.updateObjectsLightScope(Arrays.asList(room));
                HomeComponent3D.this.updateObjectsLightScope(HomeComponent3D.this.getHomeObjects(HomeLight.class));
            }
        };
        this.home.addRoomsListener(this.roomListener);
    }

    private GeneralPath getShape(float[][] fArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0][0], fArray[0][1]);
        for (int i = 1; i < fArray.length; ++i) {
            generalPath.lineTo(fArray[i][0], fArray[i][1]);
        }
        generalPath.closePath();
        return generalPath;
    }

    private void addLabelListener(final Group group) {
        this.labelChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Label label = (Label)propertyChangeEvent.getSource();
                HomeComponent3D.this.updateObjects(Arrays.asList(label));
            }
        };
        for (Label label : this.home.getLabels()) {
            label.addPropertyChangeListener(this.labelChangeListener);
        }
        this.labelListener = new CollectionListener<Label>(){

            @Override
            public void collectionChanged(CollectionEvent<Label> collectionEvent) {
                Label label = collectionEvent.getItem();
                switch (collectionEvent.getType()) {
                    case ADD: {
                        HomeComponent3D.this.addObject(group, label, true, false);
                        label.addPropertyChangeListener(HomeComponent3D.this.labelChangeListener);
                        break;
                    }
                    case DELETE: {
                        HomeComponent3D.this.deleteObject(label);
                        label.removePropertyChangeListener(HomeComponent3D.this.labelChangeListener);
                    }
                }
            }
        };
        this.home.addLabelsListener(this.labelListener);
    }

    private void addEnvironmentListeners() {
        this.wallsAlphaListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getWalls());
                HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
            }
        };
        this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.WALLS_ALPHA, this.wallsAlphaListener);
        this.drawingModeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getWalls());
                HomeComponent3D.this.updateObjects(HomeComponent3D.this.getHomeObjects(HomePieceOfFurniture.class));
            }
        };
        this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.DRAWING_MODE, this.drawingModeListener);
    }

    private Node addObject(Group group, Selectable selectable, boolean bl, boolean bl2) {
        return this.addObject(group, selectable, -1, bl, bl2);
    }

    private Node addObject(Group group, Selectable selectable, int n, boolean bl, boolean bl2) {
        Object3DBranch object3DBranch = this.createObject3D(selectable, bl2);
        if (bl) {
            this.homeObjects.put(selectable, object3DBranch);
        }
        if (n == -1) {
            group.addChild((Node)object3DBranch);
        } else {
            group.insertChild((Node)object3DBranch, n);
        }
        this.clearPrintedImageCache();
        return object3DBranch;
    }

    private Object3DBranch createObject3D(Selectable selectable, boolean bl) {
        return (Object3DBranch)((Object)this.object3dFactory.createObject3D(this.home, selectable, bl));
    }

    private void deleteObject(Selectable selectable) {
        this.homeObjects.get(selectable).detach();
        this.homeObjects.remove(selectable);
        this.clearPrintedImageCache();
    }

    private void updateObjects(Collection<? extends Selectable> collection) {
        if (this.homeObjectsToUpdate != null) {
            this.homeObjectsToUpdate.addAll(collection);
        } else {
            this.homeObjectsToUpdate = new HashSet<Selectable>(collection);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    for (Selectable selectable : HomeComponent3D.this.homeObjectsToUpdate) {
                        Object3DBranch object3DBranch = (Object3DBranch)((Object)HomeComponent3D.this.homeObjects.get(selectable));
                        if (object3DBranch == null) continue;
                        object3DBranch.update();
                    }
                    HomeComponent3D.this.homeObjectsToUpdate = null;
                }
            });
        }
        this.clearPrintedImageCache();
        this.approximateHomeBoundsCache = null;
    }

    private void updateWall(Wall wall) {
        ArrayList<Wall> arrayList = new ArrayList<Wall>(3);
        arrayList.add(wall);
        if (wall.getWallAtStart() != null) {
            arrayList.add(wall.getWallAtStart());
        }
        if (wall.getWallAtEnd() != null) {
            arrayList.add(wall.getWallAtEnd());
        }
        this.updateObjects(arrayList);
    }

    private void updateObjectsLightScope(Collection<? extends Selectable> collection) {
        if (this.home.getEnvironment().getSubpartSizeUnderLight() > 0.0f) {
            if (this.lightScopeObjectsToUpdate != null) {
                if (collection == null) {
                    this.lightScopeObjectsToUpdate.clear();
                    this.lightScopeObjectsToUpdate.add(null);
                } else if (!this.lightScopeObjectsToUpdate.contains(null)) {
                    this.lightScopeObjectsToUpdate.addAll(collection);
                }
            } else {
                this.lightScopeObjectsToUpdate = new HashSet<Selectable>();
                if (collection == null) {
                    this.lightScopeObjectsToUpdate.add(null);
                } else {
                    this.lightScopeObjectsToUpdate.addAll(collection);
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        if (HomeComponent3D.this.lightScopeObjectsToUpdate.contains(null)) {
                            HomeComponent3D.this.subpartSizeListener.propertyChange(null);
                        } else if (HomeComponent3D.this.home.getEnvironment().getSubpartSizeUnderLight() > 0.0f) {
                            Area area = HomeComponent3D.this.getLightScopeOutsideWallsArea();
                            for (Selectable selectable : HomeComponent3D.this.lightScopeObjectsToUpdate) {
                                Group group = (Group)HomeComponent3D.this.homeObjects.get(selectable);
                                if (group instanceof HomePieceOfFurniture3D) {
                                    group = (Group)group.getChild(0);
                                }
                                if (group == null) continue;
                                boolean bl = false;
                                for (Object object : selectable.getPoints()) {
                                    if (area.contains(object[0], object[1])) continue;
                                    bl = true;
                                    break;
                                }
                                Light[] lightArray = HomeComponent3D.this.sceneLights;
                                int n = lightArray.length;
                                for (int i = 0; i < n; ++i) {
                                    Object object;
                                    object = lightArray[i];
                                    if (!(object instanceof DirectionalLight)) continue;
                                    if (bl && object.indexOfScope(group) == -1) {
                                        object.addScope(group);
                                        continue;
                                    }
                                    if (bl || object.indexOfScope(group) == -1) continue;
                                    object.removeScope(group);
                                }
                            }
                        }
                        HomeComponent3D.this.lightScopeObjectsToUpdate = null;
                    }
                });
            }
        }
    }

    private void addShadowOnFloor(Group group, Map<HomePieceOfFurniture, Node> map) {
        Cloneable cloneable;
        Cloneable cloneable2;
        Map.Entry<HomePieceOfFurniture, Node> entry22;
        Comparator<Level> comparator = new Comparator<Level>(){

            @Override
            public int compare(Level level, Level level2) {
                return Float.compare(level.getElevation(), level2.getElevation());
            }
        };
        TreeMap<Level, Area> treeMap = new TreeMap<Level, Area>(comparator);
        for (Map.Entry<HomePieceOfFurniture, Node> entry22 : map.entrySet()) {
            if (!(entry22.getKey() instanceof HomePieceOfFurniture)) continue;
            HomePieceOfFurniture object = (HomePieceOfFurniture)entry22.getKey();
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (object.getElevation() != 0.0f || object.isDoorOrWindow() || object instanceof com.eteks.sweethome3d.model.Light) continue;
            cloneable2 = ModelManager.getInstance().getAreaOnFloor((Node)entry22.getValue());
            cloneable = object.getLevel();
            if (object.getLevel() == null) {
                cloneable = new Level("Dummy", 0.0f, 0.0f, 0.0f);
            }
            if (!((Level)cloneable).isViewableAndVisible()) continue;
            Area n = (Area)treeMap.get(cloneable);
            if (n == null) {
                n = new Area();
                treeMap.put((Level)cloneable, n);
            }
            n.add((Area)cloneable2);
        }
        Shape3D shape3D = new Shape3D();
        for (Map.Entry entry : treeMap.entrySet()) {
            cloneable2 = new ArrayList();
            cloneable = new ArrayList();
            int n = 0;
            float[] fArray = new float[2];
            PathIterator pathIterator = ((Area)entry.getValue()).getPathIterator(null);
            while (!pathIterator.isDone()) {
                if (pathIterator.currentSegment(fArray) == 4) {
                    cloneable.add(n);
                    n = 0;
                } else {
                    cloneable2.add(new Point3f(fArray[0], ((Level)entry.getKey()).getElevation() + 0.49f, fArray[1]));
                    ++n;
                }
                pathIterator.next();
            }
            if (cloneable2.size() <= 0) continue;
            pathIterator = new GeometryInfo(5);
            pathIterator.setCoordinates(cloneable2.toArray(new Point3f[cloneable2.size()]));
            int[] nArray = new int[cloneable.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)cloneable.get(i);
            }
            pathIterator.setStripCounts(nArray);
            shape3D.addGeometry((Geometry)pathIterator.getIndexedGeometryArray());
        }
        entry22 = new Appearance();
        entry22.setColoringAttributes(new ColoringAttributes(new Color3f(), 2));
        entry22.setTransparencyAttributes(new TransparencyAttributes(1, 0.7f));
        shape3D.setAppearance((Appearance)entry22);
        group.addChild((Node)shape3D);
    }

    private class CameraInterpolator
    extends TransformInterpolator {
        private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        private Camera initialCamera;
        private Camera finalCamera;

        public CameraInterpolator(TransformGroup transformGroup) {
            this.setTarget(transformGroup);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void moveCamera(Camera camera) {
            if (this.finalCamera == null || this.finalCamera.getX() != camera.getX() || this.finalCamera.getY() != camera.getY() || this.finalCamera.getZ() != camera.getZ() || this.finalCamera.getYaw() != camera.getYaw() || this.finalCamera.getPitch() != camera.getPitch()) {
                CameraInterpolator cameraInterpolator = this;
                synchronized (cameraInterpolator) {
                    Alpha alpha = this.getAlpha();
                    if (alpha == null || alpha.finished()) {
                        this.initialCamera = new Camera(HomeComponent3D.this.camera.getX(), HomeComponent3D.this.camera.getY(), HomeComponent3D.this.camera.getZ(), HomeComponent3D.this.camera.getYaw(), HomeComponent3D.this.camera.getPitch(), HomeComponent3D.this.camera.getFieldOfView());
                    } else if ((double)alpha.value() < 0.3) {
                        Transform3D transform3D = new Transform3D();
                        HomeComponent3D.this.updateViewPlatformTransform(transform3D, this.finalCamera.getX(), this.finalCamera.getY(), this.finalCamera.getZ(), this.finalCamera.getYaw(), this.finalCamera.getPitch());
                        this.getTarget().setTransform(transform3D);
                        this.initialCamera = this.finalCamera;
                    } else {
                        this.initialCamera = new Camera(this.initialCamera.getX() + (this.finalCamera.getX() - this.initialCamera.getX()) * alpha.value(), this.initialCamera.getY() + (this.finalCamera.getY() - this.initialCamera.getY()) * alpha.value(), this.initialCamera.getZ() + (this.finalCamera.getZ() - this.initialCamera.getZ()) * alpha.value(), this.initialCamera.getYaw() + (this.finalCamera.getYaw() - this.initialCamera.getYaw()) * alpha.value(), this.initialCamera.getPitch() + (this.finalCamera.getPitch() - this.initialCamera.getPitch()) * alpha.value(), camera.getFieldOfView());
                    }
                    this.finalCamera = new Camera(camera.getX(), camera.getY(), camera.getZ(), camera.getYaw(), camera.getPitch(), camera.getFieldOfView());
                    if (alpha == null) {
                        alpha = new Alpha(1, 150L);
                        this.setAlpha(alpha);
                    }
                    alpha.setStartTime(System.currentTimeMillis());
                    this.scheduledExecutor.schedule(new Runnable(){

                        public void run() {
                            if (CameraInterpolator.this.getAlpha().value() == 1.0f) {
                                Transform3D transform3D = new Transform3D();
                                CameraInterpolator.this.computeTransform(1.0f, transform3D);
                                CameraInterpolator.this.getTarget().setTransform(transform3D);
                            }
                        }
                    }, 150L, TimeUnit.MILLISECONDS);
                }
            }
        }

        public synchronized void computeTransform(float f, Transform3D transform3D) {
            HomeComponent3D.this.updateViewPlatformTransform(transform3D, this.initialCamera.getX() + (this.finalCamera.getX() - this.initialCamera.getX()) * f, this.initialCamera.getY() + (this.finalCamera.getY() - this.initialCamera.getY()) * f, this.initialCamera.getZ() + (this.finalCamera.getZ() - this.initialCamera.getZ()) * f, this.initialCamera.getYaw() + (this.finalCamera.getYaw() - this.initialCamera.getYaw()) * f, this.initialCamera.getPitch() + (this.finalCamera.getPitch() - this.initialCamera.getPitch()) * f);
        }
    }

    private static class NavigationButton
    extends JButton {
        private boolean shiftDown;

        public NavigationButton(final float f, final float f2, final float f3, String string, UserPreferences userPreferences, final HomeController3D homeController3D) {
            super(new ResourceAction(userPreferences, (Class)HomeComponent3D.class, string, true){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            this.setPressedIcon(new ImageIcon(this.createImage(new FilteredImageSource(((ImageIcon)this.getIcon()).getImage().getSource(), new RGBImageFilter(){
                {
                    this.canFilterIndexColorModel = true;
                }

                public int filterRGB(int n, int n2, int n3) {
                    int n4 = n3 & 0xFF000000;
                    int n5 = (n3 & 0xFF0000) >> 1 & 0xFF0000;
                    int n6 = (n3 & 0xFF00) >> 1 & 0xFF00;
                    int n7 = (n3 & 0xFF) >> 1;
                    return n4 | n5 | n6 | n7;
                }
            }))));
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    NavigationButton.this.shiftDown = mouseEvent.isShiftDown();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    NavigationButton.this.shiftDown = mouseEvent.isShiftDown();
                    SwingUtilities.getAncestorOfClass(HomeComponent3D.class, NavigationButton.this).requestFocusInWindow();
                }
            });
            final Timer timer = new Timer(50, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    homeController3D.moveCamera(NavigationButton.this.shiftDown ? f : f / 5.0f);
                    homeController3D.rotateCameraYaw(NavigationButton.this.shiftDown ? f2 : f2 / 5.0f);
                    homeController3D.rotateCameraPitch(f3);
                }
            });
            timer.setInitialDelay(0);
            this.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (NavigationButton.this.getModel().isArmed() && !timer.isRunning()) {
                        timer.restart();
                    } else if (!NavigationButton.this.getModel().isArmed() && timer.isRunning()) {
                        timer.stop();
                    }
                }
            });
            this.setFocusable(false);
            this.setBorder(null);
            this.setContentAreaFilled(false);
            this.setPreferredSize(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
            this.addPropertyChangeListener("icon", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    NavigationButton.this.setBorder(null);
                }
            });
        }
    }

    private static class NavigationPanelChangeListener
    implements PropertyChangeListener {
        private final WeakReference<HomeComponent3D> homeComponent3D;

        public NavigationPanelChangeListener(HomeComponent3D homeComponent3D) {
            this.homeComponent3D = new WeakReference<HomeComponent3D>(homeComponent3D);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomeComponent3D homeComponent3D = (HomeComponent3D)this.homeComponent3D.get();
            if (homeComponent3D == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.NAVIGATION_PANEL_VISIBLE, this);
            } else {
                homeComponent3D.setNavigationPanelVisible((Boolean)propertyChangeEvent.getNewValue() != false && homeComponent3D.isVisible());
            }
        }
    }

    private static class JCanvas3DWithNavigationPanel
    extends JCanvas3D {
        private final HomeComponent3D homeComponent3D;

        public JCanvas3DWithNavigationPanel(HomeComponent3D homeComponent3D, GraphicsConfigTemplate3D graphicsConfigTemplate3D) {
            super(graphicsConfigTemplate3D);
            this.homeComponent3D = homeComponent3D;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.drawImage(this.homeComponent3D.navigationPanelImage, 0, 0, (ImageObserver)((Object)this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ActionType {
        MOVE_CAMERA_FORWARD,
        MOVE_CAMERA_FAST_FORWARD,
        MOVE_CAMERA_BACKWARD,
        MOVE_CAMERA_FAST_BACKWARD,
        MOVE_CAMERA_LEFT,
        MOVE_CAMERA_FAST_LEFT,
        MOVE_CAMERA_RIGHT,
        MOVE_CAMERA_FAST_RIGHT,
        ROTATE_CAMERA_YAW_LEFT,
        ROTATE_CAMERA_YAW_FAST_LEFT,
        ROTATE_CAMERA_YAW_RIGHT,
        ROTATE_CAMERA_YAW_FAST_RIGHT,
        ROTATE_CAMERA_PITCH_UP,
        ROTATE_CAMERA_PITCH_FAST_UP,
        ROTATE_CAMERA_PITCH_DOWN,
        ROTATE_CAMERA_PITCH_FAST_DOWN,
        ELEVATE_CAMERA_UP,
        ELEVATE_CAMERA_FAST_UP,
        ELEVATE_CAMERA_DOWN,
        ELEVATE_CAMERA_FAST_DOWN;

    }
}

