/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image;

import org.sunflow.image.BlackbodySpectrum;
import org.sunflow.image.Color;
import org.sunflow.image.RGBSpace;
import org.sunflow.image.RegularSpectralCurve;
import org.sunflow.image.XYZColor;

public final class ColorFactory {
    public static String getInternalColorspace() {
        return "sRGB linear";
    }

    public static int getRequiredDataValues(String string) {
        if (string == null) {
            return 3;
        }
        if (string.equals("sRGB nonlinear")) {
            return 3;
        }
        if (string.equals("sRGB linear")) {
            return 3;
        }
        if (string.equals("XYZ")) {
            return 3;
        }
        if (string.equals("blackbody")) {
            return 1;
        }
        if (string.startsWith("spectrum")) {
            return -1;
        }
        return -2;
    }

    public static Color createColor(String string, float ... fArray) throws ColorSpecificationException {
        int n = ColorFactory.getRequiredDataValues(string);
        if (n == -2) {
            throw new ColorSpecificationException("unknown colorspace %s");
        }
        if (n != -1 && n != fArray.length) {
            throw new ColorSpecificationException(n, fArray.length);
        }
        if (string == null) {
            return new Color(fArray[0], fArray[1], fArray[2]);
        }
        if (string.equals("sRGB nonlinear")) {
            return new Color(fArray[0], fArray[1], fArray[2]).toLinear();
        }
        if (string.equals("sRGB linear")) {
            return new Color(fArray[0], fArray[1], fArray[2]);
        }
        if (string.equals("XYZ")) {
            return RGBSpace.SRGB.convertXYZtoRGB(new XYZColor(fArray[0], fArray[1], fArray[2]));
        }
        if (string.equals("blackbody")) {
            return RGBSpace.SRGB.convertXYZtoRGB(new BlackbodySpectrum(fArray[0]).toXYZ());
        }
        if (string.startsWith("spectrum")) {
            String[] stringArray = string.split("\\s+");
            if (stringArray.length != 3) {
                throw new ColorSpecificationException("invalid spectrum specification");
            }
            if (fArray.length == 0) {
                throw new ColorSpecificationException("missing spectrum data");
            }
            try {
                float f = Float.parseFloat(stringArray[1]);
                float f2 = Float.parseFloat(stringArray[2]);
                return RGBSpace.SRGB.convertXYZtoRGB(new RegularSpectralCurve(fArray, f, f2).toXYZ());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ColorSpecificationException("unable to parse spectrum wavelength range");
            }
        }
        throw new ColorSpecificationException(String.format("Inconsistent code! Please report this error. (Input %s - %d)", string, fArray.length));
    }

    public static final class ColorSpecificationException
    extends Exception {
        private ColorSpecificationException() {
            super("Invalid color specification");
        }

        private ColorSpecificationException(String string) {
            super(String.format("Invalid color specification: %s", string));
        }

        private ColorSpecificationException(int n, int n2) {
            this(String.format("invalid data length, expecting %d values, found %d", n, n2));
        }
    }
}

