/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.Bounds;
import javax.media.j3d.CachedFrustum;
import javax.media.j3d.J3dHash;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class BoundingSphere
extends Bounds {
    final Point3d center;
    double radius;

    public BoundingSphere(Point3d point3d, double d) {
        this.boundId = 2;
        this.center = new Point3d(point3d);
        this.radius = d;
        this.updateBoundsStates();
    }

    public BoundingSphere() {
        this.boundId = 2;
        this.center = new Point3d();
        this.radius = 1.0;
    }

    public BoundingSphere(Bounds bounds) {
        this.boundId = 2;
        this.center = new Point3d();
        if (bounds == null || bounds.boundsIsEmpty) {
            this.setEmptyBounds();
            return;
        }
        if (bounds.boundsIsInfinite) {
            this.setInfiniteBounds();
            return;
        }
        if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            this.center.x = (boundingBox.upper.x + boundingBox.lower.x) / 2.0;
            this.center.y = (boundingBox.upper.y + boundingBox.lower.y) / 2.0;
            this.center.z = (boundingBox.upper.z + boundingBox.lower.z) / 2.0;
            this.radius = 0.5 * Math.sqrt((boundingBox.upper.x - boundingBox.lower.x) * (boundingBox.upper.x - boundingBox.lower.x) + (boundingBox.upper.y - boundingBox.lower.y) * (boundingBox.upper.y - boundingBox.lower.y) + (boundingBox.upper.z - boundingBox.lower.z) * (boundingBox.upper.z - boundingBox.lower.z));
        } else if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            this.center.set((Tuple3d)boundingSphere.center);
            this.radius = boundingSphere.radius;
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.center.x = boundingPolytope.centroid.x;
            this.center.y = boundingPolytope.centroid.y;
            this.center.z = boundingPolytope.centroid.z;
            this.radius = Math.sqrt((boundingPolytope.verts[0].x - this.center.x) * (boundingPolytope.verts[0].x - this.center.x) + (boundingPolytope.verts[0].y - this.center.y) * (boundingPolytope.verts[0].y - this.center.y) + (boundingPolytope.verts[0].z - this.center.z) * (boundingPolytope.verts[0].z - this.center.z));
            for (int i = 1; i < boundingPolytope.nVerts; ++i) {
                double d = (boundingPolytope.verts[i].x - this.center.x) * (boundingPolytope.verts[i].x - this.center.x) + (boundingPolytope.verts[i].y - this.center.y) * (boundingPolytope.verts[i].y - this.center.y) + (boundingPolytope.verts[i].z - this.center.z) * (boundingPolytope.verts[i].z - this.center.z);
                double d2 = this.radius * this.radius;
                if (!(d > d2)) continue;
                double d3 = Math.sqrt(d);
                this.radius = (this.radius + d3) * 0.5;
                double d4 = d3 - this.radius;
                double d5 = d4 / d3;
                this.center.x += (boundingPolytope.verts[i].x - this.center.x) * d5;
                this.center.y += (boundingPolytope.verts[i].y - this.center.y) * d5;
                this.center.z += (boundingPolytope.verts[i].z - this.center.z) * d5;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere0"));
        }
        this.updateBoundsStates();
    }

    public BoundingSphere(Bounds[] boundsArray) {
        int n;
        this.boundId = 2;
        this.center = new Point3d();
        if (boundsArray == null || boundsArray.length <= 0) {
            this.setEmptyBounds();
            return;
        }
        for (n = 0; boundsArray[n] == null && n < boundsArray.length; ++n) {
        }
        if (n >= boundsArray.length) {
            this.setEmptyBounds();
            return;
        }
        this.set(boundsArray[n++]);
        if (this.boundsIsInfinite) {
            return;
        }
        Point3d[] point3dArray = null;
        while (n < boundsArray.length) {
            if (boundsArray[n] != null && !boundsArray[n].boundsIsEmpty) {
                Bounds bounds;
                if (boundsArray[n].boundsIsInfinite) {
                    this.setInfiniteBounds();
                    return;
                }
                if (boundsArray[n].boundId == 1) {
                    bounds = (BoundingBox)boundsArray[n];
                    if (point3dArray == null) {
                        point3dArray = new Point3d[8];
                        for (int i = 0; i < 8; ++i) {
                            point3dArray[i] = new Point3d();
                        }
                    }
                    point3dArray[0].set(bounds.lower.x, bounds.lower.y, bounds.lower.z);
                    point3dArray[1].set(bounds.lower.x, bounds.upper.y, bounds.lower.z);
                    point3dArray[2].set(bounds.upper.x, bounds.lower.y, bounds.lower.z);
                    point3dArray[3].set(bounds.upper.x, bounds.upper.y, bounds.lower.z);
                    point3dArray[4].set(bounds.lower.x, bounds.lower.y, bounds.upper.z);
                    point3dArray[5].set(bounds.lower.x, bounds.upper.y, bounds.upper.z);
                    point3dArray[6].set(bounds.upper.x, bounds.lower.y, bounds.upper.z);
                    point3dArray[7].set(bounds.upper.x, bounds.upper.y, bounds.upper.z);
                    this.combine(point3dArray);
                } else if (boundsArray[n].boundId == 2) {
                    double d;
                    double d2;
                    BoundingSphere boundingSphere = (BoundingSphere)boundsArray[n];
                    double d3 = Math.sqrt((this.center.x - boundingSphere.center.x) * (this.center.x - boundingSphere.center.x) + (this.center.y - boundingSphere.center.y) * (this.center.y - boundingSphere.center.y) + (this.center.z - boundingSphere.center.z) * (this.center.z - boundingSphere.center.z));
                    if (this.radius > boundingSphere.radius) {
                        if (d3 + boundingSphere.radius > this.radius) {
                            d2 = 0.5 * (this.radius - boundingSphere.radius + d3);
                            d = d2 / d3;
                            this.radius = d2 + boundingSphere.radius;
                            this.center.x = boundingSphere.center.x + (this.center.x - boundingSphere.center.x) * d;
                            this.center.y = boundingSphere.center.y + (this.center.y - boundingSphere.center.y) * d;
                            this.center.z = boundingSphere.center.z + (this.center.z - boundingSphere.center.z) * d;
                        }
                    } else if (d3 + this.radius <= boundingSphere.radius) {
                        this.center.x = boundingSphere.center.x;
                        this.center.y = boundingSphere.center.y;
                        this.center.z = boundingSphere.center.z;
                        this.radius = boundingSphere.radius;
                    } else {
                        d2 = 0.5 * (boundingSphere.radius - this.radius + d3);
                        d = d2 / d3;
                        this.radius = d2 + this.radius;
                        this.center.x += (boundingSphere.center.x - this.center.x) * d;
                        this.center.y += (boundingSphere.center.y - this.center.y) * d;
                        this.center.z += (boundingSphere.center.z - this.center.z) * d;
                    }
                } else if (boundsArray[n].boundId == 4) {
                    bounds = (BoundingPolytope)boundsArray[n];
                    this.combine(((BoundingPolytope)bounds).verts);
                } else if (boundsArray[n] != null) {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere0"));
                }
            }
            ++n;
        }
        this.updateBoundsStates();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
        this.updateBoundsStates();
    }

    public void getCenter(Point3d point3d) {
        point3d.set((Tuple3d)this.center);
    }

    public void setCenter(Point3d point3d) {
        this.center.set((Tuple3d)point3d);
        this.updateBoundsStates();
    }

    public void set(Bounds bounds) {
        if (bounds == null || bounds.boundsIsEmpty) {
            this.setEmptyBounds();
            return;
        }
        if (bounds.boundsIsInfinite) {
            this.setInfiniteBounds();
            return;
        }
        if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            this.center.x = (boundingBox.upper.x + boundingBox.lower.x) / 2.0;
            this.center.y = (boundingBox.upper.y + boundingBox.lower.y) / 2.0;
            this.center.z = (boundingBox.upper.z + boundingBox.lower.z) / 2.0;
            this.radius = 0.5 * Math.sqrt((boundingBox.upper.x - boundingBox.lower.x) * (boundingBox.upper.x - boundingBox.lower.x) + (boundingBox.upper.y - boundingBox.lower.y) * (boundingBox.upper.y - boundingBox.lower.y) + (boundingBox.upper.z - boundingBox.lower.z) * (boundingBox.upper.z - boundingBox.lower.z));
        } else if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            this.radius = boundingSphere.radius;
            this.center.x = boundingSphere.center.x;
            this.center.y = boundingSphere.center.y;
            this.center.z = boundingSphere.center.z;
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.center.x = boundingPolytope.centroid.x;
            this.center.y = boundingPolytope.centroid.y;
            this.center.z = boundingPolytope.centroid.z;
            this.radius = Math.sqrt((boundingPolytope.verts[0].x - this.center.x) * (boundingPolytope.verts[0].x - this.center.x) + (boundingPolytope.verts[0].y - this.center.y) * (boundingPolytope.verts[0].y - this.center.y) + (boundingPolytope.verts[0].z - this.center.z) * (boundingPolytope.verts[0].z - this.center.z));
            for (int i = 1; i < boundingPolytope.nVerts; ++i) {
                double d = (boundingPolytope.verts[i].x - this.center.x) * (boundingPolytope.verts[i].x - this.center.x) + (boundingPolytope.verts[i].y - this.center.y) * (boundingPolytope.verts[i].y - this.center.y) + (boundingPolytope.verts[i].z - this.center.z) * (boundingPolytope.verts[i].z - this.center.z);
                double d2 = this.radius * this.radius;
                if (!(d > d2)) continue;
                double d3 = Math.sqrt(d);
                this.radius = (this.radius + d3) * 0.5;
                double d4 = d3 - this.radius;
                double d5 = d4 / d3;
                this.center.x += (boundingPolytope.verts[i].x - this.center.x) * d5;
                this.center.y += (boundingPolytope.verts[i].y - this.center.y) * d5;
                this.center.z += (boundingPolytope.verts[i].z - this.center.z) * d5;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere2"));
        }
        this.updateBoundsStates();
    }

    public Object clone() {
        return new BoundingSphere(this.center, this.radius);
    }

    public boolean equals(Object object) {
        try {
            BoundingSphere boundingSphere = (BoundingSphere)object;
            return this.center.equals((Tuple3d)boundingSphere.center) && this.radius == boundingSphere.radius;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l = 1L;
        l = J3dHash.mixDoubleBits(l, this.radius);
        l = J3dHash.mixDoubleBits(l, this.center.x);
        l = J3dHash.mixDoubleBits(l, this.center.y);
        l = J3dHash.mixDoubleBits(l, this.center.z);
        return J3dHash.finish(l);
    }

    public void combine(Bounds bounds) {
        if (bounds == null || bounds.boundsIsEmpty || this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty || bounds.boundsIsInfinite) {
            this.set(bounds);
            return;
        }
        if (bounds.boundId == 1) {
            double d;
            BoundingBox boundingBox = (BoundingBox)bounds;
            double d2 = boundingBox.upper.x - this.center.x;
            double d3 = boundingBox.lower.x - this.center.x;
            double d4 = d2 * d2 > d3 * d3 ? boundingBox.upper.x : boundingBox.lower.x;
            d2 = boundingBox.upper.y - this.center.y;
            d3 = boundingBox.lower.y - this.center.y;
            double d5 = d2 * d2 > d3 * d3 ? boundingBox.upper.y : boundingBox.lower.y;
            double d6 = Math.sqrt((d4 - this.center.x) * (d4 - this.center.x) + (d5 - this.center.y) * (d5 - this.center.y) + ((d = (d2 = boundingBox.upper.z - this.center.z) * d2 > (d3 = boundingBox.lower.z - this.center.z) * d3 ? boundingBox.upper.z : boundingBox.lower.z) - this.center.z) * (d - this.center.z));
            if (d6 > this.radius) {
                this.radius = (d6 + this.radius) * 0.5;
                double d7 = d6 - this.radius;
                this.center.x = (this.radius * this.center.x + d7 * d4) / d6;
                this.center.y = (this.radius * this.center.y + d7 * d5) / d6;
                this.center.z = (this.radius * this.center.z + d7 * d) / d6;
                this.combinePoint(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
                this.combinePoint(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
                this.combinePoint(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
                this.combinePoint(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
                this.combinePoint(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
                this.combinePoint(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
                this.combinePoint(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
                this.combinePoint(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
            }
        } else if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            double d = Math.sqrt((this.center.x - boundingSphere.center.x) * (this.center.x - boundingSphere.center.x) + (this.center.y - boundingSphere.center.y) * (this.center.y - boundingSphere.center.y) + (this.center.z - boundingSphere.center.z) * (this.center.z - boundingSphere.center.z));
            if (this.radius > boundingSphere.radius) {
                if (d + boundingSphere.radius > this.radius) {
                    double d8 = 0.5 * (this.radius - boundingSphere.radius + d);
                    double d9 = d8 / d;
                    this.radius = d8 + boundingSphere.radius;
                    this.center.x = boundingSphere.center.x + (this.center.x - boundingSphere.center.x) * d9;
                    this.center.y = boundingSphere.center.y + (this.center.y - boundingSphere.center.y) * d9;
                    this.center.z = boundingSphere.center.z + (this.center.z - boundingSphere.center.z) * d9;
                }
            } else if (d + this.radius <= boundingSphere.radius) {
                this.center.x = boundingSphere.center.x;
                this.center.y = boundingSphere.center.y;
                this.center.z = boundingSphere.center.z;
                this.radius = boundingSphere.radius;
            } else {
                double d10 = 0.5 * (boundingSphere.radius - this.radius + d);
                double d11 = d10 / d;
                this.radius = d10 + this.radius;
                this.center.x += (boundingSphere.center.x - this.center.x) * d11;
                this.center.y += (boundingSphere.center.y - this.center.y) * d11;
                this.center.z += (boundingSphere.center.z - this.center.z) * d11;
            }
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.combine(boundingPolytope.verts);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere3"));
        }
        this.updateBoundsStates();
    }

    private void combinePoint(double d, double d2, double d3) {
        double d4 = Math.sqrt((d - this.center.x) * (d - this.center.x) + (d2 - this.center.y) * (d2 - this.center.y) + (d3 - this.center.z) * (d3 - this.center.z));
        if (d4 > this.radius) {
            this.radius = (d4 + this.radius) * 0.5;
            double d5 = d4 - this.radius;
            this.center.x = (this.radius * this.center.x + d5 * d) / d4;
            this.center.y = (this.radius * this.center.y + d5 * d2) / d4;
            this.center.z = (this.radius * this.center.z + d5 * d3) / d4;
        }
    }

    public void combine(Bounds[] boundsArray) {
        int n;
        if (boundsArray == null || boundsArray.length <= 0 || this.boundsIsInfinite) {
            return;
        }
        for (n = 0; n < boundsArray.length && (boundsArray[n] == null || boundsArray[n].boundsIsEmpty); ++n) {
        }
        if (n >= boundsArray.length) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.set(boundsArray[n++]);
        }
        if (this.boundsIsInfinite) {
            return;
        }
        while (n < boundsArray.length) {
            if (boundsArray[n] != null && !boundsArray[n].boundsIsEmpty) {
                double d;
                if (boundsArray[n].boundsIsInfinite) {
                    this.setInfiniteBounds();
                    return;
                }
                if (boundsArray[n].boundId == 1) {
                    double d2;
                    BoundingBox boundingBox = (BoundingBox)boundsArray[n];
                    double d3 = boundingBox.upper.x - this.center.x;
                    double d4 = boundingBox.lower.x - this.center.x;
                    double d5 = d3 * d3 > d4 * d4 ? boundingBox.upper.x : boundingBox.lower.x;
                    d3 = boundingBox.upper.y - this.center.y;
                    d4 = boundingBox.lower.y - this.center.y;
                    double d6 = d3 * d3 > d4 * d4 ? boundingBox.upper.y : boundingBox.lower.y;
                    d = Math.sqrt((d5 - this.center.x) * (d5 - this.center.x) + (d6 - this.center.y) * (d6 - this.center.y) + ((d2 = (d3 = boundingBox.upper.z - this.center.z) * d3 > (d4 = boundingBox.lower.z - this.center.z) * d4 ? boundingBox.upper.z : boundingBox.lower.z) - this.center.z) * (d2 - this.center.z));
                    if (d > this.radius) {
                        this.radius = (d + this.radius) * 0.5;
                        double d7 = d - this.radius;
                        this.center.x = (this.radius * this.center.x + d7 * d5) / d;
                        this.center.y = (this.radius * this.center.y + d7 * d6) / d;
                        this.center.z = (this.radius * this.center.z + d7 * d2) / d;
                        this.combinePoint(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
                        this.combinePoint(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
                        this.combinePoint(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
                        this.combinePoint(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
                        this.combinePoint(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
                        this.combinePoint(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
                        this.combinePoint(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
                        this.combinePoint(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
                    }
                } else if (boundsArray[n].boundId == 2) {
                    double d8;
                    double d9;
                    BoundingSphere boundingSphere = (BoundingSphere)boundsArray[n];
                    d = Math.sqrt((this.center.x - boundingSphere.center.x) * (this.center.x - boundingSphere.center.x) + (this.center.y - boundingSphere.center.y) * (this.center.y - boundingSphere.center.y) + (this.center.z - boundingSphere.center.z) * (this.center.z - boundingSphere.center.z));
                    if (this.radius > boundingSphere.radius) {
                        if (d + boundingSphere.radius > this.radius) {
                            d9 = 0.5 * (this.radius - boundingSphere.radius + d);
                            d8 = d9 / d;
                            this.radius = d9 + boundingSphere.radius;
                            this.center.x = boundingSphere.center.x + (this.center.x - boundingSphere.center.x) * d8;
                            this.center.y = boundingSphere.center.y + (this.center.y - boundingSphere.center.y) * d8;
                            this.center.z = boundingSphere.center.z + (this.center.z - boundingSphere.center.z) * d8;
                        }
                    } else if (d + this.radius <= boundingSphere.radius) {
                        this.center.x = boundingSphere.center.x;
                        this.center.y = boundingSphere.center.y;
                        this.center.z = boundingSphere.center.z;
                        this.radius = boundingSphere.radius;
                    } else {
                        d9 = 0.5 * (boundingSphere.radius - this.radius + d);
                        d8 = d9 / d;
                        this.radius = d9 + this.radius;
                        this.center.x += (boundingSphere.center.x - this.center.x) * d8;
                        this.center.y += (boundingSphere.center.y - this.center.y) * d8;
                        this.center.z += (boundingSphere.center.z - this.center.z) * d8;
                    }
                } else if (boundsArray[n].boundId == 4) {
                    BoundingPolytope boundingPolytope = (BoundingPolytope)boundsArray[n];
                    this.combine(boundingPolytope.verts);
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere4"));
                }
            }
            ++n;
        }
        this.updateBoundsStates();
    }

    public void combine(Point3d point3d) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.radius = 0.0;
            this.center.x = point3d.x;
            this.center.y = point3d.y;
            this.center.z = point3d.z;
        } else {
            double d = Math.sqrt((point3d.x - this.center.x) * (point3d.x - this.center.x) + (point3d.y - this.center.y) * (point3d.y - this.center.y) + (point3d.z - this.center.z) * (point3d.z - this.center.z));
            if (d > this.radius) {
                this.radius = (d + this.radius) * 0.5;
                double d2 = d - this.radius;
                this.center.x = (this.radius * this.center.x + d2 * point3d.x) / d;
                this.center.y = (this.radius * this.center.y + d2 * point3d.y) / d;
                this.center.z = (this.radius * this.center.z + d2 * point3d.z) / d;
            }
        }
        this.updateBoundsStates();
    }

    public void combine(Point3d[] point3dArray) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.center.x = point3dArray[0].x;
            this.center.y = point3dArray[0].y;
            this.center.z = point3dArray[0].z;
            this.radius = 0.0;
        }
        for (int i = 0; i < point3dArray.length; ++i) {
            double d = (point3dArray[i].x - this.center.x) * (point3dArray[i].x - this.center.x) + (point3dArray[i].y - this.center.y) * (point3dArray[i].y - this.center.y) + (point3dArray[i].z - this.center.z) * (point3dArray[i].z - this.center.z);
            double d2 = this.radius * this.radius;
            if (!(d > d2)) continue;
            double d3 = Math.sqrt(d);
            this.radius = (this.radius + d3) * 0.5;
            double d4 = d3 - this.radius;
            this.center.x = (this.radius * this.center.x + d4 * point3dArray[i].x) / d3;
            this.center.y = (this.radius * this.center.y + d4 * point3dArray[i].y) / d3;
            this.center.z = (this.radius * this.center.z + d4 * point3dArray[i].z) / d3;
        }
        this.updateBoundsStates();
    }

    public void transform(Bounds bounds, Transform3D transform3D) {
        if (bounds == null || bounds.boundsIsEmpty) {
            this.setEmptyBounds();
            return;
        }
        if (bounds.boundsIsInfinite) {
            this.setInfiniteBounds();
            return;
        }
        if (bounds.boundId == 1) {
            BoundingBox boundingBox = new BoundingBox(bounds);
            boundingBox.transform(transform3D);
            this.set(boundingBox);
        } else if (bounds.boundId == 2) {
            this.set(bounds);
            this.transform(transform3D);
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = new BoundingPolytope(bounds);
            boundingPolytope.transform(transform3D);
            this.set(boundingPolytope);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere5"));
        }
    }

    public void transform(Transform3D transform3D) {
        if (this.boundsIsInfinite) {
            return;
        }
        transform3D.transform(this.center);
        double d = transform3D.getDistanceScale();
        this.radius *= d;
        if (Double.isNaN(this.radius)) {
            this.setEmptyBounds();
            return;
        }
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        Vector3d vector3d2 = new Vector3d();
        Point3d point3d2 = new Point3d();
        point3d2.x = this.center.x - point3d.x;
        point3d2.y = this.center.y - point3d.y;
        point3d2.z = this.center.z - point3d.z;
        double d = point3d2.x * point3d2.x + point3d2.y * point3d2.y + point3d2.z * point3d2.z;
        double d2 = this.radius * this.radius;
        if (d < d2) {
            return true;
        }
        double d3 = 1.0 / Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        vector3d2.x = vector3d.x * d3;
        vector3d2.y = vector3d.y * d3;
        vector3d2.z = vector3d.z * d3;
        double d4 = point3d2.x * vector3d2.x + point3d2.y * vector3d2.y + point3d2.z * vector3d2.z;
        if (d4 <= 0.0) {
            return false;
        }
        double d5 = d2 - d + d4 * d4;
        if (d5 > 0.0) {
            double d6 = d4 - Math.sqrt(d5);
            point4d.x = point3d.x + vector3d2.x * d6;
            point4d.y = point3d.y + vector3d2.y * d6;
            point4d.z = point3d.z + vector3d2.z * d6;
            point4d.w = d6;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d point3d, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        double d = point3d.x - this.center.x;
        double d2 = point3d.y - this.center.y;
        double d3 = point3d.z - this.center.z;
        double d4 = d * d + d2 * d2 + d3 * d3;
        if (d4 > this.radius * this.radius) {
            return false;
        }
        point4d.x = point3d.x;
        point4d.y = point3d.y;
        point4d.z = point3d.z;
        point4d.w = Math.sqrt(d4);
        return true;
    }

    boolean intersect(Point3d point3d, Point3d point3d2, Point4d point4d) {
        double d;
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        Vector3d vector3d = new Vector3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        point3d3.x = this.center.x - point3d.x;
        point3d3.y = this.center.y - point3d.y;
        point3d3.z = this.center.z - point3d.z;
        vector3d2.x = point3d2.x - point3d.x;
        vector3d2.y = point3d2.y - point3d.y;
        vector3d2.z = point3d2.z - point3d.z;
        double d2 = 1.0 / Math.sqrt(vector3d2.x * vector3d2.x + vector3d2.y * vector3d2.y + vector3d2.z * vector3d2.z);
        vector3d.x = vector3d2.x * d2;
        vector3d.y = vector3d2.y * d2;
        vector3d.z = vector3d2.z * d2;
        double d3 = point3d3.x * point3d3.x + point3d3.y * point3d3.y + point3d3.z * point3d3.z;
        double d4 = this.radius * this.radius;
        if (d3 < d4) {
            return true;
        }
        double d5 = point3d3.x * vector3d.x + point3d3.y * vector3d.y + point3d3.z * vector3d.z;
        if (d5 <= 0.0) {
            return false;
        }
        double d6 = d4 - d3 + d5 * d5;
        if (d6 > 0.0 && (d = d5 - Math.sqrt(d6)) * d <= (point3d2.x - point3d.x) * (point3d2.x - point3d.x) + (point3d2.y - point3d.y) * (point3d2.y - point3d.y) + (point3d2.z - point3d.z) * (point3d2.z - point3d.z)) {
            point4d.x = point3d.x + vector3d.x * d;
            point4d.y = point3d.y + vector3d.x * d;
            point4d.z = point3d.z + vector3d.x * d;
            point4d.w = d;
            return true;
        }
        return false;
    }

    public boolean intersect(Point3d point3d, Vector3d vector3d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        Vector3d vector3d2 = new Vector3d();
        Point3d point3d2 = new Point3d();
        point3d2.x = this.center.x - point3d.x;
        point3d2.y = this.center.y - point3d.y;
        point3d2.z = this.center.z - point3d.z;
        double d = point3d2.x * point3d2.x + point3d2.y * point3d2.y + point3d2.z * point3d2.z;
        double d2 = this.radius * this.radius;
        if (d < d2) {
            return true;
        }
        double d3 = Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        vector3d2.x = vector3d.x / d3;
        vector3d2.y = vector3d.y / d3;
        vector3d2.z = vector3d.z / d3;
        double d4 = point3d2.x * vector3d2.x + point3d2.y * vector3d2.y + point3d2.z * vector3d2.z;
        if (d4 <= 0.0) {
            return false;
        }
        double d5 = d2 - d + d4 * d4;
        return d5 > 0.0;
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point3d2.x = point3d.x;
            point3d2.y = point3d.y;
            point3d2.z = point3d.z;
            return true;
        }
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        point3d4.x = this.center.x - point3d.x;
        point3d4.y = this.center.y - point3d.y;
        point3d4.z = this.center.z - point3d.z;
        double d = point3d4.x * point3d4.x + point3d4.y * point3d4.y + point3d4.z * point3d4.z;
        double d2 = this.radius * this.radius;
        if (d < d2) {
            return true;
        }
        double d3 = Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        point3d3.x = vector3d.x / d3;
        point3d3.y = vector3d.y / d3;
        point3d3.z = vector3d.z / d3;
        double d4 = point3d4.x * point3d3.x + point3d4.y * point3d3.y + point3d4.z * point3d3.z;
        if (d4 <= 0.0) {
            return false;
        }
        double d5 = d2 - d + d4 * d4;
        if (d5 > 0.0) {
            double d6 = d4 - Math.sqrt(d5);
            point3d2.x = point3d.x + vector3d.x * d6;
            point3d2.y = point3d.y + vector3d.y * d6;
            point3d2.z = point3d.z + vector3d.z * d6;
            return true;
        }
        return false;
    }

    public boolean intersect(Point3d point3d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        double d = point3d.x - this.center.x;
        double d2 = point3d.y - this.center.y;
        double d3 = point3d.z - this.center.z;
        double d4 = d * d + d2 * d2 + d3 * d3;
        return !(d4 > this.radius * this.radius);
    }

    public boolean isEmpty() {
        return this.boundsIsEmpty;
    }

    boolean intersect(Bounds bounds, Point4d point4d) {
        return this.intersect(bounds);
    }

    public boolean intersect(Bounds bounds) {
        if (bounds == null) {
            return false;
        }
        if (this.boundsIsEmpty || bounds.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite || bounds.boundsIsInfinite) {
            return true;
        }
        if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            double d = 0.0;
            double d2 = this.radius * this.radius;
            if (this.center.x < boundingBox.lower.x) {
                d = (this.center.x - boundingBox.lower.x) * (this.center.x - boundingBox.lower.x);
            } else if (this.center.x > boundingBox.upper.x) {
                d = (this.center.x - boundingBox.upper.x) * (this.center.x - boundingBox.upper.x);
            }
            if (this.center.y < boundingBox.lower.y) {
                d += (this.center.y - boundingBox.lower.y) * (this.center.y - boundingBox.lower.y);
            } else if (this.center.y > boundingBox.upper.y) {
                d += (this.center.y - boundingBox.upper.y) * (this.center.y - boundingBox.upper.y);
            }
            if (this.center.z < boundingBox.lower.z) {
                d += (this.center.z - boundingBox.lower.z) * (this.center.z - boundingBox.lower.z);
            } else if (this.center.z > boundingBox.upper.z) {
                d += (this.center.z - boundingBox.upper.z) * (this.center.z - boundingBox.upper.z);
            }
            return d <= d2;
        }
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            double d = this.radius + boundingSphere.radius;
            d *= d;
            double d3 = this.center.distanceSquared(boundingSphere.center);
            return d3 <= d;
        }
        if (bounds.boundId == 4) {
            return this.intersect_ptope_sphere((BoundingPolytope)bounds, this);
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere6"));
    }

    public boolean intersect(Bounds[] boundsArray) {
        if (boundsArray == null || boundsArray.length <= 0) {
            return false;
        }
        if (this.boundsIsEmpty) {
            return false;
        }
        for (int i = 0; i < boundsArray.length; ++i) {
            if (boundsArray[i] == null || boundsArray[i].boundsIsEmpty) continue;
            if (this.boundsIsInfinite || boundsArray[i].boundsIsInfinite) {
                return true;
            }
            if (boundsArray[i].boundId == 1) {
                if (!this.intersect(boundsArray[i])) continue;
                return true;
            }
            if (boundsArray[i].boundId == 2) {
                BoundingSphere boundingSphere = (BoundingSphere)boundsArray[i];
                double d = this.radius + boundingSphere.radius;
                d *= d;
                double d2 = this.center.distanceSquared(boundingSphere.center);
                if (!(d2 <= d)) continue;
                return true;
            }
            if (boundsArray[i].boundId == 4) {
                if (!this.intersect(boundsArray[i])) continue;
                return true;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere7"));
        }
        return false;
    }

    public boolean intersect(Bounds bounds, BoundingSphere boundingSphere) {
        if (bounds == null || this.boundsIsEmpty || bounds.boundsIsEmpty) {
            boundingSphere.set(null);
            return false;
        }
        if (this.boundsIsInfinite && !bounds.boundsIsInfinite) {
            boundingSphere.set(bounds);
            return true;
        }
        if (bounds.boundsIsInfinite) {
            boundingSphere.set(this);
            return true;
        }
        if (bounds.boundId == 1) {
            BoundingBox boundingBox = new BoundingBox();
            BoundingBox boundingBox2 = (BoundingBox)bounds;
            if (this.intersect(boundingBox2)) {
                BoundingBox boundingBox3 = new BoundingBox(this);
                boundingBox3.intersect((Bounds)boundingBox2, boundingBox);
                boundingSphere.set(boundingBox);
                return true;
            }
            boundingSphere.set(null);
            return false;
        }
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere2 = (BoundingSphere)bounds;
            double d = Math.sqrt((this.center.x - boundingSphere2.center.x) * (this.center.x - boundingSphere2.center.x) + (this.center.y - boundingSphere2.center.y) * (this.center.y - boundingSphere2.center.y) + (this.center.z - boundingSphere2.center.z) * (this.center.z - boundingSphere2.center.z));
            if (d > this.radius + boundingSphere2.radius) {
                boundingSphere.set(null);
                return false;
            }
            if (d + this.radius <= boundingSphere2.radius) {
                boundingSphere.center.x = this.center.x;
                boundingSphere.center.y = this.center.y;
                boundingSphere.center.z = this.center.z;
                boundingSphere.radius = this.radius;
            } else if (d + boundingSphere2.radius <= this.radius) {
                boundingSphere.center.x = boundingSphere2.center.x;
                boundingSphere.center.y = boundingSphere2.center.y;
                boundingSphere.center.z = boundingSphere2.center.z;
                boundingSphere.radius = boundingSphere2.radius;
            } else {
                double d2 = (d * d + this.radius * this.radius - boundingSphere2.radius * boundingSphere2.radius) / (2.0 * d);
                boundingSphere.radius = Math.sqrt(this.radius * this.radius - d2 * d2);
                double d3 = d2 / d;
                boundingSphere.center.x = this.center.x + (boundingSphere2.center.x - this.center.x) * d3;
                boundingSphere.center.y = this.center.y + (boundingSphere2.center.y - this.center.y) * d3;
                boundingSphere.center.z = this.center.z + (boundingSphere2.center.z - this.center.z) * d3;
            }
            boundingSphere.updateBoundsStates();
            return true;
        }
        if (bounds.boundId == 4) {
            BoundingBox boundingBox = new BoundingBox();
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            if (this.intersect(boundingPolytope)) {
                BoundingBox boundingBox4 = new BoundingBox(this);
                BoundingBox boundingBox5 = new BoundingBox(boundingPolytope);
                boundingBox4.intersect((Bounds)boundingBox5, boundingBox);
                boundingSphere.set(boundingBox);
                return true;
            }
            boundingSphere.set(null);
            return false;
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere8"));
    }

    public boolean intersect(Bounds[] boundsArray, BoundingSphere boundingSphere) {
        int n;
        if (boundsArray == null || boundsArray.length <= 0 || this.boundsIsEmpty) {
            boundingSphere.set(null);
            return false;
        }
        for (n = 0; boundsArray[n] == null && n < boundsArray.length; ++n) {
        }
        if (n >= boundsArray.length) {
            boundingSphere.set(null);
            return false;
        }
        boolean bl = false;
        Point3d point3d = new Point3d();
        BoundingBox boundingBox = new BoundingBox();
        for (n = 0; n < boundsArray.length; ++n) {
            BoundingBox boundingBox2;
            Bounds bounds;
            if (boundsArray[n] == null || boundsArray[n].boundsIsEmpty) continue;
            if (boundsArray[n].boundId == 1) {
                bounds = (BoundingBox)boundsArray[n];
                if (!this.intersect(bounds)) continue;
                boundingBox2 = new BoundingBox(this);
                boundingBox2.intersect(bounds, boundingBox);
                if (bl) {
                    boundingSphere.combine(boundingBox);
                    continue;
                }
                boundingSphere.set(boundingBox);
                bl = true;
                continue;
            }
            if (boundsArray[n].boundId == 2) {
                bounds = (BoundingSphere)boundsArray[n];
                double d = Math.sqrt((this.center.x - ((BoundingSphere)bounds).center.x) * (this.center.x - ((BoundingSphere)bounds).center.x) + (this.center.y - ((BoundingSphere)bounds).center.y) * (this.center.y - ((BoundingSphere)bounds).center.y) + (this.center.z - ((BoundingSphere)bounds).center.z) * (this.center.z - ((BoundingSphere)bounds).center.z));
                if (d > this.radius + ((BoundingSphere)bounds).radius) continue;
                if (d + this.radius <= ((BoundingSphere)bounds).radius) {
                    if (bl) {
                        boundingSphere.combine(this);
                        continue;
                    }
                    boundingSphere.center.x = this.center.x;
                    boundingSphere.center.y = this.center.y;
                    boundingSphere.center.z = this.center.z;
                    boundingSphere.radius = this.radius;
                    bl = true;
                    boundingSphere.updateBoundsStates();
                    continue;
                }
                if (d + ((BoundingSphere)bounds).radius <= this.radius) {
                    if (bl) {
                        boundingSphere.combine(bounds);
                        continue;
                    }
                    boundingSphere.center.x = this.center.x;
                    boundingSphere.center.y = this.center.y;
                    boundingSphere.center.z = this.center.z;
                    boundingSphere.radius = ((BoundingSphere)bounds).radius;
                    bl = true;
                    boundingSphere.updateBoundsStates();
                    continue;
                }
                double d2 = (d * d + this.radius * this.radius - ((BoundingSphere)bounds).radius * ((BoundingSphere)bounds).radius) / (2.0 * d);
                double d3 = Math.sqrt(this.radius * this.radius - d2 * d2);
                double d4 = d2 / d;
                point3d.x = this.center.x + (((BoundingSphere)bounds).center.x - this.center.x) * d4;
                point3d.y = this.center.y + (((BoundingSphere)bounds).center.y - this.center.y) * d4;
                point3d.z = this.center.z + (((BoundingSphere)bounds).center.z - this.center.z) * d4;
                if (bl) {
                    BoundingSphere boundingSphere2 = new BoundingSphere(point3d, d3);
                    boundingSphere.combine(boundingSphere2);
                    continue;
                }
                boundingSphere.setRadius(d3);
                boundingSphere.setCenter(point3d);
                bl = true;
                continue;
            }
            if (boundsArray[n].boundId == 4) {
                bounds = (BoundingPolytope)boundsArray[n];
                if (!this.intersect(bounds)) continue;
                boundingBox2 = new BoundingBox(this);
                BoundingBox boundingBox3 = new BoundingBox(bounds);
                boundingBox2.intersect((Bounds)boundingBox3, boundingBox);
                if (bl) {
                    boundingSphere.combine(boundingBox);
                    continue;
                }
                boundingSphere.set(boundingBox);
                bl = true;
                continue;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere9"));
        }
        if (!bl) {
            boundingSphere.set(null);
        }
        return bl;
    }

    public Bounds closestIntersection(Bounds[] boundsArray) {
        if (boundsArray == null || boundsArray.length <= 0) {
            return null;
        }
        if (this.boundsIsEmpty) {
            return null;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        double d4 = Double.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < boundsArray.length; ++i) {
            double d5;
            Bounds bounds;
            if (boundsArray[i] == null || !this.intersect(boundsArray[i])) continue;
            bl2 = true;
            if (boundsArray[i].boundId == 1) {
                bounds = (BoundingBox)boundsArray[i];
                d = (bounds.upper.x + bounds.lower.x) / 2.0;
                d2 = (bounds.upper.y + bounds.lower.y) / 2.0;
                d3 = (bounds.upper.z + bounds.lower.z) / 2.0;
                d5 = Math.sqrt((this.center.x - d) * (this.center.x - d) + (this.center.y - d2) * (this.center.y - d2) + (this.center.z - d3) * (this.center.z - d3));
                double d6 = (this.center.x - bounds.lower.x) * (this.center.x - bounds.lower.x) > (this.center.x - bounds.upper.x) * (this.center.x - bounds.upper.x) ? (this.center.x - bounds.lower.x) * (this.center.x - bounds.lower.x) : (this.center.x - bounds.upper.x) * (this.center.x - bounds.upper.x);
                d6 = (this.center.y - bounds.lower.y) * (this.center.y - bounds.lower.y) > (this.center.y - bounds.upper.y) * (this.center.y - bounds.upper.y) ? (d6 += (this.center.y - bounds.lower.y) * (this.center.y - bounds.lower.y)) : (d6 += (this.center.y - bounds.upper.y) * (this.center.y - bounds.upper.y));
                d6 = (this.center.z - bounds.lower.z) * (this.center.z - bounds.lower.z) > (this.center.z - bounds.upper.z) * (this.center.z - bounds.upper.z) ? (d6 += (this.center.z - bounds.lower.z) * (this.center.z - bounds.lower.z)) : (d6 += (this.center.z - bounds.upper.z) * (this.center.z - bounds.upper.z));
                double d7 = this.radius * this.radius;
                if (d6 <= d7) {
                    if (!bl) {
                        n = i;
                        d4 = d5;
                        bl = true;
                        continue;
                    }
                    if (!(d5 < d4)) continue;
                    n = i;
                    d4 = d5;
                    continue;
                }
                if (bl || !(d5 < d4)) continue;
                n = i;
                d4 = d5;
                continue;
            }
            if (boundsArray[i].boundId == 2) {
                bounds = (BoundingSphere)boundsArray[i];
                d5 = Math.sqrt((this.center.x - ((BoundingSphere)bounds).center.x) * (this.center.x - ((BoundingSphere)bounds).center.x) + (this.center.y - ((BoundingSphere)bounds).center.y) * (this.center.y - ((BoundingSphere)bounds).center.y) + (this.center.z - ((BoundingSphere)bounds).center.z) * (this.center.z - ((BoundingSphere)bounds).center.z));
                if (d5 + ((BoundingSphere)bounds).radius <= this.radius) {
                    if (!bl) {
                        n = i;
                        d4 = d5;
                        bl = true;
                        continue;
                    }
                    if (!(d5 < d4)) continue;
                    n = i;
                    d4 = d5;
                    continue;
                }
                if (bl || !(d5 < d4)) continue;
                n = i;
                d4 = d5;
                continue;
            }
            if (boundsArray[i].boundId == 4) {
                bounds = (BoundingPolytope)boundsArray[i];
                d5 = Math.sqrt((this.center.x - ((BoundingPolytope)bounds).centroid.x) * (this.center.x - ((BoundingPolytope)bounds).centroid.x) + (this.center.y - ((BoundingPolytope)bounds).centroid.y) * (this.center.y - ((BoundingPolytope)bounds).centroid.y) + (this.center.z - ((BoundingPolytope)bounds).centroid.z) * (this.center.z - ((BoundingPolytope)bounds).centroid.z));
                boolean bl3 = true;
                for (int j = 0; j < ((BoundingPolytope)bounds).nVerts; ++j) {
                    double d8 = ((BoundingPolytope)bounds).verts[j].x - this.center.x;
                    double d9 = ((BoundingPolytope)bounds).verts[j].y - this.center.y;
                    double d10 = ((BoundingPolytope)bounds).verts[j].z - this.center.z;
                    double d11 = d8 * d8 + d9 * d9 + d10 * d10;
                    if (!(d11 > this.radius * this.radius)) continue;
                    bl3 = false;
                }
                if (bl3) {
                    if (!bl) {
                        n = i;
                        d4 = d5;
                        bl = true;
                        continue;
                    }
                    if (!(d5 < d4)) continue;
                    n = i;
                    d4 = d5;
                    continue;
                }
                if (bl || !(d5 < d4)) continue;
                n = i;
                d4 = d5;
                continue;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere10"));
        }
        if (bl2) {
            return boundsArray[n];
        }
        return null;
    }

    boolean intersect(CachedFrustum cachedFrustum) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        for (int i = 0; i < 6; ++i) {
            double d = cachedFrustum.clipPlanes[i].x * this.center.x + cachedFrustum.clipPlanes[i].y * this.center.y + cachedFrustum.clipPlanes[i].z * this.center.z + cachedFrustum.clipPlanes[i].w;
            if (!(d < 0.0) || !(d + this.radius < 0.0)) continue;
            return false;
        }
        return true;
    }

    boolean intersect(Vector4d[] vector4dArray) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        for (int i = 0; i < 6; ++i) {
            double d = vector4dArray[i].x * this.center.x + vector4dArray[i].y * this.center.y + vector4dArray[i].z * this.center.z + vector4dArray[i].w;
            if (!(d < 0.0) || !(d + this.radius < 0.0)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new String("Center=" + this.center + "  Radius=" + this.radius);
    }

    private void setEmptyBounds() {
        this.center.set(0.0, 0.0, 0.0);
        this.radius = -1.0;
        this.boundsIsInfinite = false;
        this.boundsIsEmpty = true;
    }

    private void setInfiniteBounds() {
        this.center.set(0.0, 0.0, 0.0);
        this.radius = Double.POSITIVE_INFINITY;
        this.boundsIsEmpty = false;
        this.boundsIsInfinite = true;
    }

    private void updateBoundsStates() {
        if (Double.isNaN(this.radius + this.center.x + this.center.y + this.center.z)) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            return;
        }
        if (this.radius == Double.POSITIVE_INFINITY) {
            this.boundsIsEmpty = false;
            this.boundsIsInfinite = true;
        } else {
            this.boundsIsInfinite = false;
            this.boundsIsEmpty = this.radius < 0.0;
        }
    }

    Point3d getCenter() {
        return this.center;
    }

    Bounds copy(Bounds bounds) {
        if (bounds != null && this.boundId == bounds.boundId) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            boundingSphere.radius = this.radius;
            boundingSphere.center.x = this.center.x;
            boundingSphere.center.y = this.center.y;
            boundingSphere.center.z = this.center.z;
            boundingSphere.boundsIsEmpty = this.boundsIsEmpty;
            boundingSphere.boundsIsInfinite = this.boundsIsInfinite;
            return boundingSphere;
        }
        return (Bounds)this.clone();
    }

    int getPickType() {
        return 7;
    }
}

