// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * This interface provides access to IceGrid log file contents.
 **/
public interface FileIteratorPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @return An instance of FileIterator.ReadResult.
     * @throws FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     **/
    default FileIterator.ReadResult read(int size)
        throws FileNotAvailableException
    {
        return read(size, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @param context The Context map to send with the invocation.
     * @return An instance of FileIterator.ReadResult.
     * @throws FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     **/
    default FileIterator.ReadResult read(int size, java.util.Map<String, String> context)
        throws FileNotAvailableException
    {
        try
        {
            return _iceI_readAsync(size, context, true).waitForResponseOrUserEx();
        }
        catch(FileNotAvailableException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @return A future that will be completed with an instance of FileIterator.ReadResult.
     **/
    default java.util.concurrent.CompletableFuture<FileIterator.ReadResult> readAsync(int size)
    {
        return _iceI_readAsync(size, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed with an instance of FileIterator.ReadResult.
     **/
    default java.util.concurrent.CompletableFuture<FileIterator.ReadResult> readAsync(int size, java.util.Map<String, String> context)
    {
        return _iceI_readAsync(size, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<FileIterator.ReadResult> _iceI_readAsync(int iceP_size, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<FileIterator.ReadResult> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "read", null, sync, _iceE_read);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeInt(iceP_size);
                 }, istr -> {
                     FileIterator.ReadResult ret = new FileIterator.ReadResult();
                     ret.read(istr);
                     return ret;
                 });
        return f;
    }

    static final Class<?>[] _iceE_read =
    {
        FileNotAvailableException.class
    };

    /**
     * Destroy the iterator.
     **/
    default void destroy()
    {
        destroy(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Destroy the iterator.
     * @param context The Context map to send with the invocation.
     **/
    default void destroy(java.util.Map<String, String> context)
    {
        _iceI_destroyAsync(context, true).waitForResponse();
    }

    /**
     * Destroy the iterator.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> destroyAsync()
    {
        return _iceI_destroyAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Destroy the iterator.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> destroyAsync(java.util.Map<String, String> context)
    {
        return _iceI_destroyAsync(context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_destroyAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "destroy", null, sync, null);
        f.invoke(false, context, null, null, null);
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static FileIteratorPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), FileIteratorPrx.class, _FileIteratorPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static FileIteratorPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), FileIteratorPrx.class, _FileIteratorPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static FileIteratorPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), FileIteratorPrx.class, _FileIteratorPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static FileIteratorPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), FileIteratorPrx.class, _FileIteratorPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static FileIteratorPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, FileIteratorPrx.class, _FileIteratorPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static FileIteratorPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, FileIteratorPrx.class, _FileIteratorPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default FileIteratorPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (FileIteratorPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default FileIteratorPrx ice_adapterId(String newAdapterId)
    {
        return (FileIteratorPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default FileIteratorPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (FileIteratorPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default FileIteratorPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (FileIteratorPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default FileIteratorPrx ice_invocationTimeout(int newTimeout)
    {
        return (FileIteratorPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default FileIteratorPrx ice_connectionCached(boolean newCache)
    {
        return (FileIteratorPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default FileIteratorPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (FileIteratorPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default FileIteratorPrx ice_secure(boolean b)
    {
        return (FileIteratorPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default FileIteratorPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (FileIteratorPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default FileIteratorPrx ice_preferSecure(boolean b)
    {
        return (FileIteratorPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default FileIteratorPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (FileIteratorPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default FileIteratorPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (FileIteratorPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default FileIteratorPrx ice_collocationOptimized(boolean b)
    {
        return (FileIteratorPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default FileIteratorPrx ice_twoway()
    {
        return (FileIteratorPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default FileIteratorPrx ice_oneway()
    {
        return (FileIteratorPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default FileIteratorPrx ice_batchOneway()
    {
        return (FileIteratorPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default FileIteratorPrx ice_datagram()
    {
        return (FileIteratorPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default FileIteratorPrx ice_batchDatagram()
    {
        return (FileIteratorPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default FileIteratorPrx ice_compress(boolean co)
    {
        return (FileIteratorPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default FileIteratorPrx ice_timeout(int t)
    {
        return (FileIteratorPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default FileIteratorPrx ice_connectionId(String connectionId)
    {
        return (FileIteratorPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default FileIteratorPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (FileIteratorPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::IceGrid::FileIterator";
    }
}
