/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.HeapWalker;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.v2.SnapshotsWindow;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class HeapWalkerManager {
    private Set dumpsBeingDeleted = new HashSet();
    private List<File> heapDumps = new ArrayList<File>();
    private List<HeapWalker> heapWalkers = new ArrayList<HeapWalker>();
    private final RequestProcessor heapwalkerRp = new RequestProcessor(HeapWalkerManager.class);

    private HeapWalkerManager() {
    }

    public static HeapWalkerManager getDefault() {
        return Singleton.INSTANCE;
    }

    public boolean isHeapWalkerOpened(File file) {
        return this.getHeapWalker(file) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllHeapWalkers() {
        HeapWalker[] heapWalkerArray = this;
        synchronized (this) {
            HeapWalker[] heapWalkerArray2 = this.heapWalkers.toArray(new HeapWalker[0]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (HeapWalker heapWalker : heapWalkerArray2) {
                this.closeHeapWalker(heapWalker);
            }
            return;
        }
    }

    public void closeHeapWalker(final HeapWalker heapWalker) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopComponent topComponent = HeapWalkerManager.this.getTopComponent(heapWalker);
                if (topComponent == null) {
                    ErrorManager.getDefault().log("Cannot resolve TopComponent for HeapWalker [" + heapWalker.getHeapDumpFile() + "]");
                    return;
                }
                topComponent.close();
                FileObject fileObject = FileUtil.toFileObject((File)heapWalker.getHeapDumpFile().getParentFile());
                SnapshotsWindow.instance().refreshFolder(fileObject, false);
            }
        });
    }

    public void deleteHeapDump(File file) {
        HeapWalker heapWalker = this.getHeapWalker(file);
        if (heapWalker != null) {
            this.dumpsBeingDeleted.add(file);
            this.closeHeapWalker(heapWalker);
        } else {
            this.deleteHeapDumpImpl(file, 15);
        }
    }

    public synchronized void heapWalkerClosed(HeapWalker heapWalker) {
        TopComponent topComponent = this.getTopComponent(heapWalker);
        if (topComponent == null) {
            return;
        }
        final File file = heapWalker.getHeapDumpFile();
        this.heapDumps.remove(file);
        this.heapWalkers.remove(heapWalker);
        if (this.dumpsBeingDeleted.remove(file)) {
            BrowserUtils.performTask(new Runnable(){

                @Override
                public void run() {
                    HeapWalkerManager.this.deleteHeapDumpImpl(file, 15);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openHeapWalker(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            ProfilerDialogs.displayError((String)Bundle.HeapWalkerManager_CannotOpenHeapWalkerMsg(), null, (String)iOException.getLocalizedMessage());
            return;
        }
        String string2 = string.intern();
        synchronized (string2) {
            HeapWalker heapWalker = this.getHeapWalker(file);
            if (heapWalker == null) {
                try {
                    heapWalker = new HeapWalker(file);
                }
                catch (IOException iOException) {
                    ProfilerDialogs.displayError((String)Bundle.HeapWalkerManager_CannotOpenHeapWalkerMsg(), null, (String)iOException.getLocalizedMessage());
                }
                catch (Exception exception) {
                    Logger.getLogger(HeapWalkerManager.class.getName()).log(Level.SEVERE, null, exception);
                }
            }
            if (heapWalker != null) {
                this.openHeapWalker(heapWalker);
            } else {
                ProfilerLogger.severe((String)("Cannot create HeapWalker [" + file + "]"));
            }
        }
    }

    public synchronized void openHeapWalker(final HeapWalker heapWalker) {
        if (!this.heapWalkers.contains(heapWalker)) {
            this.heapDumps.add(heapWalker.getHeapDumpFile());
            this.heapWalkers.add(heapWalker);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopComponent topComponent = HeapWalkerManager.this.getTopComponent(heapWalker);
                if (topComponent == null) {
                    ProfilerLogger.severe((String)("Cannot resolve TopComponent for HeapWalker [" + heapWalker.getHeapDumpFile() + "]"));
                    return;
                }
                topComponent.open();
                topComponent.requestVisible();
                FileObject fileObject = FileUtil.toFileObject((File)heapWalker.getHeapDumpFile().getParentFile());
                SnapshotsWindow.instance().refreshFolder(fileObject, false);
            }
        });
    }

    public void openHeapWalkers(File[] fileArray) {
        for (File file : fileArray) {
            this.openHeapWalker(file);
        }
    }

    private synchronized HeapWalker getHeapWalker(File file) {
        int n = this.heapDumps.indexOf(file);
        return n == -1 ? null : this.heapWalkers.get(n);
    }

    private TopComponent getTopComponent(HeapWalker heapWalker) {
        assert (SwingUtilities.isEventDispatchThread());
        return heapWalker.getTopComponent();
    }

    private void deleteHeapDumpImpl(final File file, final int n) {
        this.heapwalkerRp.post(new Runnable(){

            @Override
            public void run() {
                if (!file.delete()) {
                    if (n > 0 && Platform.isWindows()) {
                        System.gc();
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        HeapWalkerManager.this.deleteHeapDumpImpl(file, n - 1);
                    } else {
                        ProfilerDialogs.displayError((String)Bundle.HeapWalkerManager_CannotDeleteHeapDumpMsg());
                    }
                } else {
                    FileObject fileObject = FileUtil.toFileObject((File)file.getParentFile());
                    SnapshotsWindow.instance().refreshFolder(fileObject, true);
                }
            }
        });
    }

    private static class Singleton {
        private static final HeapWalkerManager INSTANCE = new HeapWalkerManager();

        private Singleton() {
        }
    }
}

