/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.OQLSupport;
import org.netbeans.modules.profiler.heapwalk.ui.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

public class OQLQueryCustomizer {
    private static HelpCtx HELP_CTX_SAVE_QUERY = new HelpCtx("OQLQueryCustomizer.SaveQuery.HelpCtx");
    private static HelpCtx HELP_CTX_QUERY_PROPS = new HelpCtx("OQLQueryCustomizer.QueryProps.HelpCtx");
    private static Icon ICON_UP = Icons.getIcon((String)"GeneralIcons.Up");
    private static Icon ICON_DOWN = Icons.getIcon((String)"GeneralIcons.Down");

    public static boolean saveQuery(String string, OQLSupport.OQLTreeModel oQLTreeModel, JTree jTree) {
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)Bundle.OQLQueryCustomizer_OkButtonText());
        CustomizerPanel customizerPanel = new CustomizerPanel(jButton, oQLTreeModel);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)customizerPanel, Bundle.OQLQueryCustomizer_SaveQueryCaption(), true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, HELP_CTX_SAVE_QUERY, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton) {
            OQLSupport.OQLQueryNode oQLQueryNode;
            if (customizerPanel.isNewQuery()) {
                OQLSupport.Query query = new OQLSupport.Query(string, customizerPanel.getQueryName(), customizerPanel.getQueryDescription());
                oQLQueryNode = new OQLSupport.OQLQueryNode(query);
                oQLTreeModel.customCategory().add(oQLQueryNode);
                oQLTreeModel.nodeStructureChanged(oQLTreeModel.customCategory());
            } else {
                oQLQueryNode = (OQLSupport.OQLQueryNode)customizerPanel.getSelectedValue();
                ((OQLSupport.Query)oQLQueryNode.getUserObject()).setScript(string);
                oQLTreeModel.nodeChanged(oQLQueryNode);
            }
            jTree.setSelectionPath(new TreePath(oQLTreeModel.getPathToRoot(oQLQueryNode)));
            return true;
        }
        return false;
    }

    public static boolean editNode(final OQLSupport.OQLNode oQLNode, final OQLSupport.OQLTreeModel oQLTreeModel, final JTree jTree) {
        Object[] objectArray;
        JButton jButton;
        boolean bl = oQLNode.isReadOnly();
        final OQLSupport.OQLNode oQLNode2 = (OQLSupport.OQLNode)oQLNode.getParent();
        int n = oQLNode2.getIndex(oQLNode);
        JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)Bundle.OQLQueryCustomizer_OkButtonText());
        final JButton[] jButtonArray = new JButton[2];
        jButtonArray[0] = new JButton(ICON_UP){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                int n = oQLNode2.getIndex(oQLNode) - 1;
                oQLTreeModel.removeNodeFromParent(oQLNode);
                oQLTreeModel.insertNodeInto(oQLNode, oQLNode2, n);
                jTree.setSelectionPath(new TreePath(oQLTreeModel.getPathToRoot(oQLNode)));
                OQLQueryCustomizer.updateButtons(jButtonArray, oQLNode);
            }
        };
        jButtonArray[0].setToolTipText(Bundle.OQLQueryCustomizer_UpButtonToolTip());
        jButtonArray[0].getAccessibleContext().setAccessibleName(Bundle.OQLQueryCustomizer_UpButtonAccessName());
        jButtonArray[1] = new JButton(ICON_DOWN){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                int n = oQLNode2.getIndex(oQLNode) + 1;
                oQLTreeModel.removeNodeFromParent(oQLNode);
                oQLTreeModel.insertNodeInto(oQLNode, oQLNode2, n);
                jTree.setSelectionPath(new TreePath(oQLTreeModel.getPathToRoot(oQLNode)));
                OQLQueryCustomizer.updateButtons(jButtonArray, oQLNode);
            }
        };
        jButtonArray[1].setToolTipText(Bundle.OQLQueryCustomizer_DownButtonToolTip());
        jButtonArray[1].getAccessibleContext().setAccessibleName(Bundle.OQLQueryCustomizer_DownButtonAccessName());
        CustomizerPanel customizerPanel = new CustomizerPanel(jButton2, oQLNode.toString(), oQLNode.getDescription(), bl);
        customizerPanel.getInputMap(2).put(KeyStroke.getKeyStroke(38, 8), "MOVE_UP");
        customizerPanel.getActionMap().put("MOVE_UP", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jButtonArray[0].isEnabled()) {
                    jButtonArray[0].doClick();
                }
            }
        });
        customizerPanel.getInputMap(2).put(KeyStroke.getKeyStroke(40, 8), "MOVE_DOWN");
        customizerPanel.getActionMap().put("MOVE_DOWN", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jButtonArray[1].isEnabled()) {
                    jButtonArray[1].doClick();
                }
            }
        });
        JButton jButton3 = jButton = bl ? new JButton() : null;
        if (jButton != null) {
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)Bundle.OQLQueryCustomizer_CloseButtonText());
        }
        if (bl) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = jButton;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = jButton2;
            objectArray = objectArray3;
            objectArray3[1] = DialogDescriptor.CANCEL_OPTION;
        }
        Object[] objectArray4 = objectArray;
        JButton jButton4 = bl ? jButton : jButton2;
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)customizerPanel, Bundle.OQLQueryCustomizer_QueryPropertiesCaption(oQLNode.getCaption()), true, objectArray4, (Object)jButton4, 0, HELP_CTX_QUERY_PROPS, null);
        dialogDescriptor.setAdditionalOptions(new Object[]{jButtonArray[0], jButtonArray[1]});
        OQLQueryCustomizer.updateButtons(jButtonArray, oQLNode);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton2) {
            OQLSupport.Query query = (OQLSupport.Query)oQLNode.getUserObject();
            query.setName(customizerPanel.getQueryName());
            query.setDescription(customizerPanel.getQueryDescription());
            oQLTreeModel.nodeChanged(oQLNode);
            return true;
        }
        int n2 = oQLNode2.getIndex(oQLNode);
        if (n2 != n) {
            oQLTreeModel.removeNodeFromParent(oQLNode);
            oQLTreeModel.insertNodeInto(oQLNode, oQLNode2, n);
            jTree.setSelectionPath(new TreePath(oQLTreeModel.getPathToRoot(oQLNode)));
        }
        return false;
    }

    private static void updateButtons(JButton[] jButtonArray, OQLSupport.OQLNode oQLNode) {
        if (oQLNode.isReadOnly()) {
            jButtonArray[0].setEnabled(false);
            jButtonArray[1].setEnabled(false);
        } else {
            jButtonArray[0].setEnabled(oQLNode.getPreviousSibling() != null);
            jButtonArray[1].setEnabled(oQLNode.getNextSibling() != null);
        }
    }

    private static class CustomizerPanel
    extends JPanel {
        private JComponent submitComponent;
        private Object lastSelectedValue;
        private JRadioButton newRadio;
        private JSeparator newSeparator;
        private JLabel nameLabel;
        private JTextField nameField;
        private JLabel descriptionLabel;
        private JTextArea descriptionArea;
        private JRadioButton existingRadio;
        private JSeparator existingSeparator;
        private JLabel existingLabel;
        private JList existingList;

        public CustomizerPanel(JComponent jComponent, OQLSupport.OQLTreeModel oQLTreeModel) {
            this.submitComponent = jComponent;
            this.initComponents(oQLTreeModel, false);
            this.updateComponents();
        }

        public CustomizerPanel(JComponent jComponent, String string, String string2, boolean bl) {
            this.submitComponent = jComponent;
            this.initComponents(null, bl);
            this.nameField.setText(string);
            this.descriptionArea.setText(string2 == null ? "" : string2);
            try {
                this.descriptionArea.setCaretPosition(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updateComponents();
        }

        public boolean isNewQuery() {
            return this.newRadio == null || this.newRadio.isSelected();
        }

        public String getQueryName() {
            return this.nameField.getText().trim();
        }

        public String getQueryDescription() {
            String string = this.descriptionArea.getText().trim();
            return string.length() > 0 ? string : null;
        }

        public Object getSelectedValue() {
            return this.existingList.getSelectedValue();
        }

        private void updateComponents() {
            if (this.newRadio != null) {
                boolean bl = this.newRadio.isSelected();
                this.nameLabel.setEnabled(bl);
                this.nameField.setEnabled(bl);
                this.descriptionLabel.setEnabled(bl);
                this.descriptionArea.setEnabled(bl);
                this.existingLabel.setEnabled(!bl);
                if (bl && this.existingList.isEnabled()) {
                    this.lastSelectedValue = this.existingList.getSelectedValue();
                    this.existingList.setEnabled(false);
                    this.existingList.clearSelection();
                } else if (!bl && !this.existingList.isEnabled()) {
                    this.existingList.setEnabled(true);
                    if (this.lastSelectedValue == null) {
                        this.lastSelectedValue = this.existingList.getModel().getElementAt(0);
                    }
                    this.existingList.setSelectedValue(this.lastSelectedValue, false);
                }
            }
            if (this.existingRadio != null && this.existingRadio.isSelected()) {
                this.submitComponent.setEnabled(this.existingList.getSelectedValue() != null);
            } else {
                this.submitComponent.setEnabled(this.nameField.getText().trim().length() > 0);
            }
        }

        private void initComponents(OQLSupport.OQLTreeModel oQLTreeModel, boolean bl) {
            GridBagConstraints gridBagConstraints;
            JComponent jComponent;
            final boolean bl2 = oQLTreeModel != null && oQLTreeModel.hasCustomQueries();
            this.setLayout(new GridBagLayout());
            if (bl2) {
                jComponent = new JPanel(new GridBagLayout());
                this.newRadio = new JRadioButton(){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        this.updateComponents();
                    }
                };
                Mnemonics.setLocalizedText((AbstractButton)this.newRadio, (String)Bundle.OQLQueryCustomizer_NewQueryRadioText());
                this.newRadio.setSelected(true);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jComponent.add((Component)this.newRadio, gridBagConstraints);
                this.newSeparator = new JSeparator(0){

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }
                };
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jComponent.add((Component)this.newSeparator, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(8, 8, 0, 8);
                this.add((Component)jComponent, gridBagConstraints);
            }
            this.nameLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)Bundle.OQLQueryCustomizer_NameLabelText());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(bl2 ? 8 : 16, bl2 ? 40 : 16, 8, 8);
            this.add((Component)this.nameLabel, gridBagConstraints);
            this.nameField = new JTextField();
            this.nameLabel.setLabelFor(this.nameField);
            this.nameField.setText(Bundle.OQLQueryCustomizer_DefaultQueryName());
            this.nameField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.updateComponents();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.updateComponents();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.updateComponents();
                }
            });
            this.nameField.setEditable(!bl);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(bl2 ? 8 : 16, 0, 8, 16);
            this.add((Component)this.nameField, gridBagConstraints);
            this.descriptionLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)Bundle.OQLQueryCustomizer_DescriptionLabelText());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(8, bl2 ? 40 : 16, 8, 8);
            this.add((Component)this.descriptionLabel, gridBagConstraints);
            this.descriptionArea = new JTextArea();
            this.descriptionLabel.setLabelFor(this.descriptionArea);
            this.descriptionArea.setLineWrap(true);
            this.descriptionArea.setWrapStyleWord(true);
            this.descriptionArea.setFont(this.descriptionLabel.getFont());
            this.descriptionArea.setRows(3);
            jComponent = new JScrollPane(this.descriptionArea, 20, 30){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(250, super.getPreferredSize().height);
                }

                @Override
                public Dimension getMinimumSize() {
                    return bl2 ? this.getPreferredSize() : super.getMinimumSize();
                }
            };
            this.descriptionArea.setEditable(!bl);
            if (bl) {
                this.descriptionArea.setBackground(this.nameField.getBackground());
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            if (!bl2) {
                gridBagConstraints.weighty = 1.0;
            }
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, bl2 ? 8 : 16, 16);
            this.add((Component)jComponent, gridBagConstraints);
            if (bl2) {
                JPanel jPanel = new JPanel(new GridBagLayout());
                this.existingRadio = new JRadioButton(){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        this.updateComponents();
                    }
                };
                Mnemonics.setLocalizedText((AbstractButton)this.existingRadio, (String)Bundle.OQLQueryCustomizer_ExistingQueryRadioText());
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jPanel.add((Component)this.existingRadio, gridBagConstraints);
                this.existingSeparator = new JSeparator(0){

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }
                };
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jPanel.add((Component)this.existingSeparator, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(8, 8, 0, 8);
                this.add((Component)jPanel, gridBagConstraints);
                this.existingLabel = new JLabel();
                Mnemonics.setLocalizedText((JLabel)this.existingLabel, (String)Bundle.OQLQueryCustomizer_UpdateQueryLabelText());
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(8, 40, 8, 8);
                this.add((Component)this.existingLabel, gridBagConstraints);
                Vector<TreeNode> vector = new Vector<TreeNode>();
                Enumeration<TreeNode> enumeration = oQLTreeModel.customCategory().children();
                while (enumeration.hasMoreElements()) {
                    vector.add(enumeration.nextElement());
                }
                this.existingList = new JList(vector);
                this.existingLabel.setLabelFor(this.existingList);
                this.existingList.setVisibleRowCount(3);
                this.existingList.setSelectionMode(0);
                this.existingList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        this.updateComponents();
                    }
                });
                JScrollPane jScrollPane = new JScrollPane(this.existingList, 20, 30);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 6;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(0, 0, 16, 16);
                this.add((Component)jScrollPane, gridBagConstraints);
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(this.newRadio);
                buttonGroup.add(this.existingRadio);
            }
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                nameField.requestFocus();
                                nameField.selectAll();
                            }
                        });
                    }
                }
            });
        }
    }
}

