/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Util;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;

class DependencyChecker {
    private static final Logger err = Logger.getLogger(DependencyChecker.class.getName());

    DependencyChecker() {
    }

    public static Set<Dependency> findBrokenDependencies(Set<Dependency> set, Collection<ModuleInfo> collection) {
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        block7: for (Dependency dependency : set) {
            err.log(Level.FINE, "Dependency[" + dependency.getType() + "]: " + dependency);
            switch (dependency.getType()) {
                case 5: 
                case 6: {
                    if (!DependencyChecker.findModuleMatchesDependencyRequires(dependency, collection).isEmpty()) continue block7;
                    hashSet.add(dependency);
                    break;
                }
                case 7: {
                    break;
                }
                case 1: {
                    if (DependencyChecker.matchDependencyModule(dependency, collection) != null) break;
                    hashSet.add(dependency);
                    break;
                }
                case 3: {
                    if (DependencyChecker.matchDependencyJava(dependency)) continue block7;
                    err.log(Level.FINE, "The Java platform version " + dependency + " or higher was requested but only " + Dependency.JAVA_SPEC + " is running.");
                    hashSet.add(dependency);
                    break;
                }
                case 2: {
                    if (DependencyChecker.matchPackageDependency(dependency)) continue block7;
                    err.log(Level.FINE, "The package " + dependency + " was requested but it is not in current ClassPath.");
                    hashSet.add(dependency);
                    break;
                }
                default: {
                    err.log(Level.FINE, "Uncovered Dependency " + dependency);
                }
            }
        }
        return hashSet;
    }

    public static Set<Dependency> findBrokenDependenciesTransitive(ModuleInfo moduleInfo, Collection<ModuleInfo> collection, Set<ModuleInfo> set) {
        if (set.contains(moduleInfo)) {
            return Collections.emptySet();
        }
        set.add(moduleInfo);
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        block6: for (Dependency dependency : DependencyChecker.filterTypeRecommends(moduleInfo.getDependencies())) {
            err.log(Level.FINE, "Dependency[" + dependency.getType() + "]: " + dependency);
            Collection<ModuleInfo> collection2 = null;
            switch (dependency.getType()) {
                case 5: 
                case 6: 
                case 7: {
                    collection2 = DependencyChecker.findModuleMatchesDependencyRequires(dependency, collection);
                    if (collection2.size() > 0) {
                        for (ModuleInfo moduleInfo2 : collection2) {
                            hashSet.addAll(DependencyChecker.findBrokenDependenciesTransitive(moduleInfo2, collection, set));
                        }
                        continue block6;
                    }
                    hashSet.add(dependency);
                    break;
                }
                case 1: {
                    ModuleInfo moduleInfo3 = DependencyChecker.matchDependencyModule(dependency, collection);
                    if (moduleInfo3 != null) {
                        hashSet.addAll(DependencyChecker.findBrokenDependenciesTransitive(moduleInfo3, collection, set));
                        break;
                    }
                    hashSet.add(dependency);
                    break;
                }
                case 3: {
                    if (DependencyChecker.matchDependencyJava(dependency)) continue block6;
                    err.log(Level.FINE, "The Java platform version " + dependency + " or higher was requested but only " + Dependency.JAVA_SPEC + " is running.");
                    hashSet.add(dependency);
                    break;
                }
                case 2: {
                    if (DependencyChecker.matchPackageDependency(dependency)) continue block6;
                    err.log(Level.FINE, "The package " + dependency + " was requested but it is not in current ClassPath.");
                    hashSet.add(dependency);
                    break;
                }
                default: {
                    err.log(Level.FINE, "Uncovered Dependency " + dependency);
                }
            }
        }
        return hashSet;
    }

    private static Set<Dependency> filterTypeRecommends(Collection<Dependency> collection) {
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        for (Dependency dependency : collection) {
            if (7 == dependency.getType()) continue;
            hashSet.add(dependency);
        }
        return hashSet;
    }

    static Collection<ModuleInfo> findModuleMatchesDependencyRequires(Dependency dependency, Collection<ModuleInfo> collection) {
        UpdateManagerImpl updateManagerImpl = UpdateManagerImpl.getInstance();
        HashSet<ModuleInfo> hashSet = new HashSet<ModuleInfo>();
        hashSet.addAll(updateManagerImpl.getAvailableProviders(dependency.getName()));
        hashSet.addAll(updateManagerImpl.getInstalledProviders(dependency.getName()));
        HashSet<ModuleInfo> hashSet2 = new HashSet<ModuleInfo>(hashSet);
        for (ModuleInfo moduleInfo : hashSet) {
            for (ModuleInfo moduleInfo2 : collection) {
                if (!moduleInfo.getCodeName().equals(moduleInfo2.getCodeName())) continue;
                hashSet2.add(moduleInfo);
            }
        }
        return hashSet2;
    }

    private static ModuleInfo matchDependencyModule(Dependency dependency, Collection<ModuleInfo> collection) {
        for (ModuleInfo moduleInfo : collection) {
            if (!DependencyChecker.checkDependencyModule(dependency, moduleInfo)) continue;
            return moduleInfo;
        }
        return null;
    }

    public static boolean matchDependencyJava(Dependency dependency) {
        if (dependency.getName().equals("Java") && 1 == dependency.getComparison()) {
            return Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion(dependency.getVersion())) >= 0;
        }
        return true;
    }

    public static boolean matchPackageDependency(Dependency dependency) {
        if (dependency.getName().equals("javafx.application[Application]")) {
            File file = new File(System.getProperty("java.home"));
            return new File(new File(file, "lib"), "jfxrt.jar").exists() || new File(new File(new File(file, "lib"), "ext"), "jfxrt.jar").exists();
        }
        return Util.checkPackageDependency((Dependency)dependency, (ClassLoader)Util.class.getClassLoader());
    }

    static boolean checkDependencyModuleAllowEqual(Dependency dependency, ModuleInfo moduleInfo) {
        return DependencyChecker.checkDependencyModule(dependency, moduleInfo, true);
    }

    static boolean checkDependencyModule(Dependency dependency, ModuleInfo moduleInfo) {
        return DependencyChecker.checkDependencyModule(dependency, moduleInfo, false);
    }

    private static boolean checkDependencyModule(Dependency dependency, ModuleInfo moduleInfo, boolean bl) {
        boolean bl2 = false;
        if (dependency.getName().equals(moduleInfo.getCodeNameBase()) || dependency.getName().equals(moduleInfo.getCodeName())) {
            bl2 = dependency.getComparison() == 3 ? true : (dependency.getComparison() == 1 ? (moduleInfo.getSpecificationVersion() == null ? false : (new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) > 0 ? false : (bl && new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) == 0 ? true : true))) : (moduleInfo.getImplementationVersion() == null ? false : (!moduleInfo.getImplementationVersion().equals(dependency.getVersion()) ? false : (dependency.getName().indexOf(47) == -1 || moduleInfo.getCodeName().indexOf(47) != -1 ? dependency.getName().equals(moduleInfo.getCodeName()) : true))));
        } else {
            String string;
            int n = dependency.getName().indexOf(45);
            if (n != -1) {
                int n2 = dependency.getName().indexOf(47);
                String string2 = dependency.getName().substring(0, n2);
                int n3 = Integer.parseInt(dependency.getName().substring(n2 + 1, n));
                int n4 = Integer.parseInt(dependency.getName().substring(n + 1));
                if (string2.equals(moduleInfo.getCodeNameBase()) && n3 <= moduleInfo.getCodeNameRelease() && n4 >= moduleInfo.getCodeNameRelease()) {
                    bl2 = dependency.getComparison() == 3 ? true : (moduleInfo.getCodeNameRelease() > n3 ? true : (moduleInfo.getSpecificationVersion() == null ? false : (new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) > 0 ? false : (bl && new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) > 0 ? true : true))));
                }
            } else if (dependency.getName().indexOf(47) != -1 && (string = dependency.getName().substring(0, dependency.getName().indexOf(47))).equals(moduleInfo.getCodeNameBase())) {
                err.log(Level.FINE, "Unmatched major versions. Dependency " + dependency + " doesn't match with module " + moduleInfo);
                bl2 = false;
            }
        }
        return bl2;
    }
}

