/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import tim.prune.data.Timestamp;

public class TimestampLocal
extends Timestamp {
    private boolean _valid = false;
    private int _year = 0;
    private int _month = 0;
    private int _day = 0;
    private int _hour = 0;
    private int _minute = 0;
    private int _second = 0;

    public TimestampLocal(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = this._valid = n > 0 && n < 3000 && n2 > 0 && n2 < 13 && n3 > 0 && n3 < 32 && n4 >= 0 && n4 < 24 && n5 >= 0 && n5 < 60 && n6 >= 0 && n6 < 60;
        if (this._valid) {
            this._year = n;
            this._month = n2;
            this._day = n3;
            this._hour = n4;
            this._minute = n5;
            this._second = n6;
        }
    }

    public boolean isValid() {
        return this._valid;
    }

    public Calendar getCalendar(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        if (timeZone != null) {
            calendar.setTimeZone(timeZone);
        }
        calendar.set(1, this._year);
        calendar.set(2, this._month - 1);
        calendar.set(5, this._day);
        calendar.set(11, this._hour);
        calendar.set(12, this._minute);
        calendar.set(13, this._second);
        calendar.set(14, 0);
        return calendar;
    }

    public long getMilliseconds(TimeZone timeZone) {
        return this.getCalendar(timeZone).getTimeInMillis();
    }

    public void addOffsetSeconds(long l) {
        System.err.println("Local timestamps don't support offsets.");
    }

    protected boolean hasMilliseconds() {
        return false;
    }

    protected String format(DateFormat dateFormat, TimeZone timeZone) {
        Calendar calendar = this.getCalendar(timeZone);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(calendar.getTime());
    }
}

