/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.File;
import java.util.Collections;
import org.gradle.api.BuildCancelledException;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.ReportedException;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.DefaultBuildActionParameters;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.InternalBuildCancelledException;
import org.gradle.tooling.internal.protocol.InternalCancellationToken;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.protocol.test.InternalTestExecutionException;
import org.gradle.tooling.internal.provider.BuildModelAction;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;

public class DaemonBuildActionExecuter
implements BuildActionExecuter<ProviderOperationParameters> {
    private final BuildActionExecuter<BuildActionParameters> executer;
    private final DaemonParameters daemonParameters;

    public DaemonBuildActionExecuter(BuildActionExecuter<BuildActionParameters> executer, DaemonParameters daemonParameters) {
        this.executer = executer;
        this.daemonParameters = daemonParameters;
    }

    @Override
    public Object execute(BuildAction action, BuildRequestContext buildRequestContext, ProviderOperationParameters parameters, ServiceRegistry contextServices) {
        boolean continuous;
        boolean bl = continuous = action.getStartParameter() != null && action.getStartParameter().isContinuous() && this.isNotBuildingModel(action);
        if (continuous && !this.doesConsumerSupportCancellation(buildRequestContext)) {
            throw new UnsupportedVersionException("Continuous build requires Tooling API client version 2.1 or later.");
        }
        ClassPath classPath = DefaultClassPath.of(parameters.getInjectedPluginClasspath(Collections.<File>emptyList()));
        DefaultBuildActionParameters actionParameters = new DefaultBuildActionParameters(this.daemonParameters.getEffectiveSystemProperties(), this.daemonParameters.getEnvironmentVariables(), SystemProperties.getInstance().getCurrentDir(), parameters.getBuildLogLevel(), this.daemonParameters.isEnabled(), continuous, classPath);
        try {
            return this.executer.execute(action, buildRequestContext, actionParameters, contextServices);
        }
        catch (ReportedException e) {
            Throwable t;
            if (t instanceof InternalTestExecutionException) {
                throw (InternalTestExecutionException)t;
            }
            for (t = e.getCause(); t != null; t = t.getCause()) {
                if (!(t instanceof BuildCancelledException)) continue;
                throw new InternalBuildCancelledException(e.getCause());
            }
            throw new BuildExceptionVersion1(e.getCause());
        }
    }

    protected boolean doesConsumerSupportCancellation(BuildRequestContext buildRequestContext) {
        return buildRequestContext.getCancellationToken() instanceof InternalCancellationToken;
    }

    private boolean isNotBuildingModel(BuildAction action) {
        if (!(action instanceof BuildModelAction)) {
            return true;
        }
        String modelName = ((BuildModelAction)action).getModelName();
        return modelName.equals(ModelIdentifier.NULL_MODEL);
    }
}

