/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionLeafVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

@NonNullApi
public class CompilationSourceDirs {
    private static final Logger LOG = Logging.getLogger(CompilationSourceDirs.class);
    private final FileTreeInternal sources;
    private SourceRoots sourceRoots;

    public CompilationSourceDirs(FileTreeInternal sources) {
        this.sources = sources;
    }

    public List<File> getSourceRoots() {
        return this.resolveRoots().getSourceRoots();
    }

    public boolean canInferSourceRoots() {
        return this.resolveRoots().isCanInferSourceRoots();
    }

    private SourceRoots resolveRoots() {
        if (this.sourceRoots == null) {
            SourceRoots visitor = new SourceRoots();
            this.sources.visitLeafCollections((FileCollectionLeafVisitor)visitor);
            this.sourceRoots = visitor;
        }
        return this.sourceRoots;
    }

    private static class SourceRoots
    implements FileCollectionLeafVisitor {
        private boolean canInferSourceRoots = true;
        private List<File> sourceRoots = Lists.newArrayList();

        private SourceRoots() {
        }

        public void visitCollection(FileCollectionInternal fileCollection) {
            this.cannotInferSourceRoots(fileCollection);
        }

        public void visitGenericFileTree(FileTreeInternal fileTree) {
            this.cannotInferSourceRoots((FileCollectionInternal)fileTree);
        }

        public void visitDirectoryTree(DirectoryFileTree directoryTree) {
            this.sourceRoots.add(directoryTree.getDir());
        }

        private void cannotInferSourceRoots(FileCollectionInternal fileCollection) {
            this.canInferSourceRoots = false;
            LOG.info("Cannot infer source root(s) for source `{}`. Supported types are `File` (directories only), `DirectoryTree` and `SourceDirectorySet`.", (Object)fileCollection);
        }

        public boolean isCanInferSourceRoots() {
            return this.canInferSourceRoots;
        }

        public List<File> getSourceRoots() {
            return this.sourceRoots;
        }
    }
}

