/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.LazyContractProvider;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingServices;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.DslMarkerUtils;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.FunctionTypeResolveUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016JH\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'H\u0002J6\u0010(\u001a\b\u0012\u0004\u0012\u00020)0$2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u00100\u001a\u000201H\u0002J2\u00102\u001a\u0004\u0018\u0001032\u0006\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00104\u001a\u0002052\u0006\u0010*\u001a\u00020+H\u0002J>\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020'2\u0006\u00100\u001a\u0002012\u0006\u00104\u001a\u000205J0\u0010:\u001a\u0002072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020;2\u0006\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020'2\u0006\u00104\u001a\u000205H\u0002Jd\u0010<\u001a\u00020=2*\u0010>\u001a&\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020-0?2\u0006\u0010D\u001a\u0002092\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020;2\u0006\u0010&\u001a\u00020'2\u0006\u00104\u001a\u0002052\u0006\u00100\u001a\u000201H\u0002J.\u0010<\u001a\u00020=2\u0006\u0010D\u001a\u0002092\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020;2\u0006\u0010&\u001a\u00020'2\u0006\u00104\u001a\u000205J6\u0010E\u001a\u00020=2\u0006\u0010D\u001a\u0002092\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020;2\u0006\u0010&\u001a\u00020'2\u0006\u00104\u001a\u0002052\u0006\u00100\u001a\u000201J(\u0010F\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010G\u001a\u00020H2\u0006\u0010&\u001a\u00020'J&\u0010I\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010J\u001a\u00020K2\u0006\u0010&\u001a\u00020'JD\u0010L\u001a\b\u0012\u0004\u0012\u00020)0$2\u0006\u0010,\u001a\u00020M2\u0006\u0010N\u001a\u00020/2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'2\u000e\u0010O\u001a\n\u0012\u0004\u0012\u000201\u0018\u00010$H\u0002J\f\u0010P\u001a\u00020\u001e*\u000201H\u0002J\u000e\u0010Q\u001a\u0004\u0018\u000101*\u000201H\u0002J\u001c\u0010R\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010$*\u0002012\u0006\u0010S\u001a\u00020MH\u0002J\f\u0010T\u001a\u000201*\u000201H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lorg/jetbrains/kotlin/resolve/FunctionDescriptorResolver;", "", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "contractParsingServices", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/OverloadChecker;Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "createConstructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isPrimary", "", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "declarationToTrace", "Lorg/jetbrains/kotlin/psi/KtPureElement;", "valueParameters", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "createValueParameterDescriptors", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "innerScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "expectedFunctionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getContractProvider", "Lorg/jetbrains/kotlin/contracts/description/LazyContractProvider;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "initializeFunctionDescriptorAndExplicitReturnType", "", "container", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "initializeFunctionReturnTypeBasedOnFunctionBody", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "resolveFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "functionConstructor", "Lkotlin/Function5;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "containingDescriptor", "resolveFunctionExpressionDescriptor", "resolvePrimaryConstructorDescriptor", "classElement", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "resolveSecondaryConstructorDescriptor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "resolveValueParameters", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameterScope", "expectedParameterTypes", "functionTypeExpected", "getReceiverType", "getValueParameters", "owner", "removeParameterNameAnnotation", "frontend"})
public final class FunctionDescriptorResolver {
    private final TypeResolver typeResolver;
    private final DescriptorResolver descriptorResolver;
    private final AnnotationResolver annotationResolver;
    private final KotlinBuiltIns builtIns;
    private final ModifiersChecker modifiersChecker;
    private final OverloadChecker overloadChecker;
    private final ContractParsingServices contractParsingServices;
    private final ExpressionTypingServices expressionTypingServices;
    private final LanguageVersionSettings languageVersionSettings;
    private final StorageManager storageManager;

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope, @NotNull KtNamedFunction function2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        Intrinsics.checkParameterIsNotNull((Object)containingDescriptor, (String)"containingDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
        if (function2.getName() == null) {
            trace.report(Errors.FUNCTION_DECLARATION_WITH_NO_NAME.on((KtFunction)((PsiElement)function2)));
        }
        Function5 function5 = resolveFunctionDescriptor.1.INSTANCE;
        SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"TypeUtils.NO_EXPECTED_TYPE");
        return this.resolveFunctionDescriptor((Function5<? super DeclarationDescriptor, ? super Annotations, ? super Name, ? super CallableMemberDescriptor.Kind, ? super SourceElement, ? extends SimpleFunctionDescriptorImpl>)function5, containingDescriptor, scope, function2, trace, dataFlowInfo, simpleType2);
    }

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionExpressionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope, @NotNull KtNamedFunction function2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull KotlinType expectedFunctionType) {
        Intrinsics.checkParameterIsNotNull((Object)containingDescriptor, (String)"containingDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
        Intrinsics.checkParameterIsNotNull((Object)expectedFunctionType, (String)"expectedFunctionType");
        return this.resolveFunctionDescriptor((Function5<? super DeclarationDescriptor, ? super Annotations, ? super Name, ? super CallableMemberDescriptor.Kind, ? super SourceElement, ? extends SimpleFunctionDescriptorImpl>)((Function5)resolveFunctionExpressionDescriptor.1.INSTANCE), containingDescriptor, scope, function2, trace, dataFlowInfo, expectedFunctionType);
    }

    private final SimpleFunctionDescriptor resolveFunctionDescriptor(Function5<? super DeclarationDescriptor, ? super Annotations, ? super Name, ? super CallableMemberDescriptor.Kind, ? super SourceElement, ? extends SimpleFunctionDescriptorImpl> functionConstructor, DeclarationDescriptor containingDescriptor, LexicalScope scope, KtNamedFunction function2, BindingTrace trace, DataFlowInfo dataFlowInfo, KotlinType expectedFunctionType) {
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(scope, function2.getModifierList(), trace);
        Name name = function2.getNameAsSafeName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"function.nameAsSafeName");
        SimpleFunctionDescriptorImpl functionDescriptor = (SimpleFunctionDescriptorImpl)functionConstructor.invoke((Object)containingDescriptor, (Object)annotations2, (Object)name, (Object)CallableMemberDescriptor.Kind.DECLARATION, (Object)KotlinSourceElementKt.toSourceElement(function2));
        this.initializeFunctionDescriptorAndExplicitReturnType(containingDescriptor, scope, function2, functionDescriptor, trace, expectedFunctionType, dataFlowInfo);
        this.initializeFunctionReturnTypeBasedOnFunctionBody(scope, function2, functionDescriptor, trace, dataFlowInfo);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(trace, function2, functionDescriptor);
        return functionDescriptor;
    }

    private final void initializeFunctionReturnTypeBasedOnFunctionBody(LexicalScope scope, KtNamedFunction function2, SimpleFunctionDescriptorImpl functionDescriptor, BindingTrace trace, DataFlowInfo dataFlowInfo) {
        boolean bl;
        if (functionDescriptor.getReturnType() != null) {
            return;
        }
        boolean bl2 = bl = function2.getTypeReference() == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Return type must be initialized early for function: " + function2.getText() + ", at: " + PsiDiagnosticUtils.atLocation(function2);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinType kotlinType = function2.hasBlockBody() ? (KotlinType)this.builtIns.getUnitType() : (function2.hasBody() ? this.descriptorResolver.inferReturnTypeFromExpressionBody(trace, scope, dataFlowInfo, function2, functionDescriptor) : (KotlinType)ErrorUtils.createErrorType("No type, no body"));
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"when {\n            funct\u2026type, no body\")\n        }");
        KotlinType inferredReturnType = kotlinType;
        functionDescriptor.setReturnType(inferredReturnType);
    }

    public final void initializeFunctionDescriptorAndExplicitReturnType(@NotNull DeclarationDescriptor container2, @NotNull LexicalScope scope, @NotNull KtFunction function2, @NotNull SimpleFunctionDescriptorImpl functionDescriptor, @NotNull BindingTrace trace, @NotNull KotlinType expectedFunctionType, @NotNull DataFlowInfo dataFlowInfo) {
        ReceiverParameterDescriptor receiverParameterDescriptor;
        Object splitter;
        Object it;
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull((Object)container2, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)expectedFunctionType, (String)"expectedFunctionType");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
        LexicalWritableScope headerScope = new LexicalWritableScope(scope, functionDescriptor, true, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.FUNCTION_HEADER);
        List<TypeParameterDescriptorImpl> typeParameterDescriptors = this.descriptorResolver.resolveTypeParametersForDescriptor(functionDescriptor, headerScope, scope, function2.getTypeParameters(), trace);
        this.descriptorResolver.resolveGenericBounds(function2, functionDescriptor, headerScope, typeParameterDescriptors, trace);
        KtTypeReference receiverTypeRef = function2.getReceiverTypeReference();
        KotlinType receiverType = receiverTypeRef != null ? this.typeResolver.resolveType(headerScope, receiverTypeRef, trace, true) : (function2 instanceof KtFunctionLiteral ? this.getReceiverType(expectedFunctionType) : null);
        List<ValueParameterDescriptor> valueParameterDescriptors = this.createValueParameterDescriptors(function2, functionDescriptor, headerScope, trace, expectedFunctionType);
        headerScope.freeze();
        KtTypeReference ktTypeReference = function2.getTypeReference();
        if (ktTypeReference != null) {
            KtTypeReference ktTypeReference2;
            KtTypeReference it2 = ktTypeReference2 = ktTypeReference;
            LexicalScope lexicalScope = headerScope;
            KtTypeReference ktTypeReference3 = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference3, (String)"it");
            kotlinType = this.typeResolver.resolveType(lexicalScope, ktTypeReference3, trace, true);
        } else {
            kotlinType = null;
        }
        KotlinType returnType2 = kotlinType;
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(function2, DescriptorResolver.getDefaultVisibility(function2, container2));
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"resolveVisibilityFromMod\u2026ity(function, container))");
        Visibility visibility2 = visibility;
        Modality modality = ModifiersChecker.resolveMemberModalityFromModifiers(function2, DescriptorResolver.getDefaultModality(container2, visibility2, function2.hasBody()), trace.getBindingContext(), container2);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)modality), (String)"resolveMemberModalityFro\u2026text, container\n        )");
        Modality modality2 = modality;
        LazyContractProvider contractProvider = this.getContractProvider(functionDescriptor, trace, scope, dataFlowInfo, function2);
        Map map2 = new LinkedHashMap();
        Object $receiver = map2;
        if (contractProvider != null) {
            $receiver.put(ContractProviderKey.INSTANCE, contractProvider);
        }
        if (receiverType != null && this.functionTypeExpected(expectedFunctionType) && !expectedFunctionType.getAnnotations().isEmpty()) {
            $receiver.put(DslMarkerUtils.FunctionTypeAnnotationsKey.INSTANCE, expectedFunctionType.getAnnotations());
        }
        Map userData = map2;
        KotlinType kotlinType2 = receiverType;
        if (kotlinType2 != null) {
            it = $receiver = kotlinType2;
            Annotations annotations2 = receiverType.getAnnotations();
            EnumSet<Enum> enumSet = EnumSet.of((Enum)AnnotationUseSiteTarget.RECEIVER);
            Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"EnumSet.of(AnnotationUseSiteTarget.RECEIVER)");
            splitter = AnnotationSplitter.Companion.create(this.storageManager, annotations2, (Set<? extends AnnotationUseSiteTarget>)enumSet);
            receiverParameterDescriptor = DescriptorFactory.createExtensionReceiverParameterForCallable(functionDescriptor, (KotlinType)it, ((AnnotationSplitter)splitter).getAnnotationsForTarget(AnnotationUseSiteTarget.RECEIVER));
        } else {
            receiverParameterDescriptor = null;
        }
        ReceiverParameterDescriptor extensionReceiver2 = receiverParameterDescriptor;
        $receiver = userData;
        Visibility visibility3 = visibility2;
        Modality modality3 = modality2;
        KotlinType kotlinType3 = returnType2;
        List<ValueParameterDescriptor> list2 = valueParameterDescriptors;
        List<TypeParameterDescriptorImpl> list3 = typeParameterDescriptors;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = DescriptorUtils.getDispatchReceiverParameterIfNeeded(container2);
        ReceiverParameterDescriptor receiverParameterDescriptor3 = extensionReceiver2;
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        splitter = it = $receiver;
        Object object = !splitter.isEmpty() ? $receiver : null;
        simpleFunctionDescriptorImpl.initialize(receiverParameterDescriptor3, receiverParameterDescriptor2, (List<? extends TypeParameterDescriptor>)list3, list2, kotlinType3, modality3, visibility3, (Map<? extends CallableDescriptor.UserDataKey<?>, ?>)object);
        functionDescriptor.setOperator(function2.hasModifier(KtTokens.OPERATOR_KEYWORD));
        functionDescriptor.setInfix(function2.hasModifier(KtTokens.INFIX_KEYWORD));
        functionDescriptor.setExternal(function2.hasModifier(KtTokens.EXTERNAL_KEYWORD));
        functionDescriptor.setInline(function2.hasModifier(KtTokens.INLINE_KEYWORD));
        functionDescriptor.setTailrec(function2.hasModifier(KtTokens.TAILREC_KEYWORD));
        functionDescriptor.setSuspend(function2.hasModifier(KtTokens.SUSPEND_KEYWORD));
        functionDescriptor.setExpect(container2 instanceof PackageFragmentDescriptor && PsiUtilsKt.hasExpectModifier(function2) || container2 instanceof ClassDescriptor && ((ClassDescriptor)container2).isExpect());
        functionDescriptor.setActual(PsiUtilsKt.hasActualModifier(function2));
        KotlinType kotlinType4 = receiverType;
        if (kotlinType4 != null) {
            it = $receiver = kotlinType4;
            ForceResolveUtil.forceResolveAllContents(it.getAnnotations());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : valueParameterDescriptors) {
            ForceResolveUtil.forceResolveAllContents(valueParameterDescriptor.getType().getAnnotations());
        }
    }

    private final LazyContractProvider getContractProvider(SimpleFunctionDescriptorImpl functionDescriptor, BindingTrace trace, LexicalScope scope, DataFlowInfo dataFlowInfo, KtFunction function2) {
        boolean isContractsEnabled;
        LazyContractProvider provideByDeferredForceResolve2 = new LazyContractProvider((Function0<? extends Object>)((Function0)new Function0<Object>(this, trace, scope, dataFlowInfo, function2, functionDescriptor){
            final /* synthetic */ FunctionDescriptorResolver this$0;
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ LexicalScope $scope;
            final /* synthetic */ DataFlowInfo $dataFlowInfo;
            final /* synthetic */ KtFunction $function;
            final /* synthetic */ SimpleFunctionDescriptorImpl $functionDescriptor;

            @Nullable
            public final Object invoke() {
                return FunctionDescriptorResolver.access$getExpressionTypingServices$p(this.this$0).getBodyExpressionType(this.$trace, this.$scope, this.$dataFlowInfo, this.$function, this.$functionDescriptor);
            }
            {
                this.this$0 = functionDescriptorResolver;
                this.$trace = bindingTrace;
                this.$scope = lexicalScope;
                this.$dataFlowInfo = dataFlowInfo;
                this.$function = ktFunction;
                this.$functionDescriptor = simpleFunctionDescriptorImpl;
                super(0);
            }
        }));
        boolean bl = isContractsEnabled = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowContractsForCustomFunctions) || this.languageVersionSettings.getFlag(AnalysisFlag.Flags.getAllowKotlinPackage()) != false;
        if (!isContractsEnabled || !KtPsiUtilKt.isContractPresentPsiCheck(function2)) {
            return null;
        }
        return provideByDeferredForceResolve2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ValueParameterDescriptor> createValueParameterDescriptors(KtFunction function2, SimpleFunctionDescriptorImpl functionDescriptor, LexicalWritableScope innerScope, BindingTrace trace, KotlinType expectedFunctionType) {
        List expectedParameterTypes;
        List list2;
        List<ValueParameterDescriptor> expectedValueParameters;
        List<ValueParameterDescriptor> list3 = expectedValueParameters = this.getValueParameters(expectedFunctionType, functionDescriptor);
        if (list3 != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list3;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                KotlinType kotlinType = it.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"it.type");
                KotlinType kotlinType2 = this.removeParameterNameAnnotation(kotlinType);
                collection.add(kotlinType2);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = expectedParameterTypes = null;
        }
        if (expectedValueParameters != null) {
            if (expectedValueParameters.size() == 1 && function2 instanceof KtFunctionLiteral && function2.getValueParameterList() == null) {
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.single(expectedValueParameters);
                CallableDescriptor callableDescriptor = functionDescriptor;
                Annotations annotations2 = Annotations.Companion.getEMPTY();
                Name name = Name.identifier("it");
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(\"it\")");
                List list4 = expectedParameterTypes;
                if (list4 == null) {
                    Intrinsics.throwNpe();
                }
                KotlinType kotlinType = (KotlinType)CollectionsKt.single((List)list4);
                boolean bl = valueParameterDescriptor.declaresDefaultValue();
                boolean bl2 = valueParameterDescriptor.isCrossinline();
                boolean bl3 = valueParameterDescriptor.isNoinline();
                KotlinType kotlinType3 = valueParameterDescriptor.getVarargElementType();
                SourceElement sourceElement = SourceElement.NO_SOURCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"SourceElement.NO_SOURCE");
                ValueParameterDescriptorImpl it = new ValueParameterDescriptorImpl(callableDescriptor, null, 0, annotations2, name, kotlinType, bl, bl2, bl3, kotlinType3, sourceElement);
                trace.record(BindingContext.AUTO_CREATED_IT, it);
                return CollectionsKt.listOf((Object)it);
            }
            if (function2.getValueParameters().size() != expectedValueParameters.size()) {
                PsiElement psiElement = function2;
                List list5 = expectedParameterTypes;
                if (list5 == null) {
                    Intrinsics.throwNpe();
                }
                trace.report(Errors.EXPECTED_PARAMETERS_NUMBER_MISMATCH.on((KtFunction)psiElement, list5.size(), expectedParameterTypes));
            }
        }
        BindingContextUtilsKt.recordScope(trace, innerScope, function2.getValueParameterList());
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        List<KtParameter> list6 = function2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list6, (String)"function.valueParameters");
        return this.resolveValueParameters(functionDescriptor2, innerScope, list6, trace, expectedParameterTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType removeParameterNameAnnotation(@NotNull KotlinType $receiver) {
        void $receiver$iv$iv;
        void $receiver$iv;
        if ($receiver instanceof TypeUtils.SpecialType) {
            return $receiver;
        }
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.parameterName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.parameterName");
        AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
        if (annotationDescriptor == null) {
            return $receiver;
        }
        AnnotationDescriptor parameterNameAnnotation = annotationDescriptor;
        Iterable iterable = $receiver.getAnnotations();
        Annotations.Companion companion = Annotations.Companion;
        KotlinType kotlinType = $receiver;
        void var4_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            AnnotationDescriptor it = (AnnotationDescriptor)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it, (Object)parameterNameAnnotation) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return TypeUtilsKt.replaceAnnotations(kotlinType, companion.create(list2));
    }

    private final boolean functionTypeExpected(@NotNull KotlinType $receiver) {
        return !TypeUtils.noExpectedType($receiver) && FunctionTypesKt.isBuiltinFunctionalType($receiver);
    }

    private final KotlinType getReceiverType(@NotNull KotlinType $receiver) {
        return this.functionTypeExpected($receiver) ? FunctionTypesKt.getReceiverTypeFromFunctionType($receiver) : null;
    }

    private final List<ValueParameterDescriptor> getValueParameters(@NotNull KotlinType $receiver, FunctionDescriptor owner) {
        return this.functionTypeExpected($receiver) ? FunctionTypeResolveUtilsKt.createValueParametersForInvokeInFunctionType(owner, FunctionTypesKt.getValueParameterTypesFromFunctionType($receiver)) : null;
    }

    @Nullable
    public final ClassConstructorDescriptorImpl resolvePrimaryConstructorDescriptor(@NotNull LexicalScope scope, @NotNull ClassDescriptor classDescriptor2, @NotNull KtPureClassOrObject classElement, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)classElement, (String)"classElement");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        if (classDescriptor2.getKind() == ClassKind.ENUM_ENTRY || !classElement.hasPrimaryConstructor()) {
            return null;
        }
        KtModifierList ktModifierList = classElement.getPrimaryConstructorModifierList();
        KtPrimaryConstructor ktPrimaryConstructor = classElement.getPrimaryConstructor();
        KtPureElement ktPureElement = ktPrimaryConstructor != null ? (KtPureElement)ktPrimaryConstructor : (KtPureElement)classElement;
        List<KtParameter> list2 = classElement.getPrimaryConstructorParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classElement.primaryConstructorParameters");
        return this.createConstructorDescriptor(scope, classDescriptor2, true, ktModifierList, ktPureElement, list2, trace);
    }

    @NotNull
    public final ClassConstructorDescriptorImpl resolveSecondaryConstructorDescriptor(@NotNull LexicalScope scope, @NotNull ClassDescriptor classDescriptor2, @NotNull KtSecondaryConstructor constructor, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        return this.createConstructorDescriptor(scope, classDescriptor2, false, constructor.getModifierList(), constructor, constructor.getValueParameters(), trace);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ClassConstructorDescriptorImpl createConstructorDescriptor(LexicalScope scope, ClassDescriptor classDescriptor2, boolean isPrimary, KtModifierList modifierList, KtPureElement declarationToTrace, List<? extends KtParameter> valueParameters2, BindingTrace trace) {
        ClassConstructorDescriptorImpl constructor;
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = ClassConstructorDescriptorImpl.create(classDescriptor2, this.annotationResolver.resolveAnnotationsWithoutArguments(scope, modifierList, trace), isPrimary, KotlinSourceElementKt.toSourceElement(declarationToTrace));
        Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptorImpl, (String)"ClassConstructorDescript\u2026SourceElement()\n        )");
        ClassConstructorDescriptorImpl constructorDescriptor = classConstructorDescriptorImpl;
        constructorDescriptor.setExpect(classDescriptor2.isExpect());
        KtModifierList ktModifierList = modifierList;
        constructorDescriptor.setActual(ktModifierList != null && PsiUtilsKt.hasActualModifier(ktModifierList) || classDescriptor2.getKind() == ClassKind.ANNOTATION_CLASS && classDescriptor2.isActual());
        if (declarationToTrace instanceof PsiElement) {
            trace.record(BindingContext.CONSTRUCTOR, declarationToTrace, constructorDescriptor);
        }
        LexicalWritableScope parameterScope = new LexicalWritableScope(scope, constructorDescriptor, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.CONSTRUCTOR_HEADER);
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl2 = constructor = constructorDescriptor.initialize(this.resolveValueParameters(constructorDescriptor, parameterScope, valueParameters2, trace, null), ModifiersChecker.resolveVisibilityFromModifiers(modifierList, DescriptorUtils.getDefaultConstructorVisibility(classDescriptor2)));
        Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptorImpl2, (String)"constructor");
        classConstructorDescriptorImpl2.setReturnType(classDescriptor2.getDefaultType());
        if (DescriptorUtils.isAnnotationClass(classDescriptor2)) {
            CompileTimeConstantUtils.checkConstructorParametersType(valueParameters2, trace);
        }
        return constructor;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ValueParameterDescriptor> resolveValueParameters(FunctionDescriptor functionDescriptor, LexicalWritableScope parameterScope, List<? extends KtParameter> valueParameters2, BindingTrace trace, List<? extends KotlinType> expectedParameterTypes) {
        ArrayList<ValueParameterDescriptorImpl> result2 = new ArrayList<ValueParameterDescriptorImpl>();
        int n = 0;
        int n2 = ((Collection)valueParameters2).size();
        while (n < n2) {
            ValueParameterDescriptorImpl valueParameterDescriptor;
            Object object;
            Object type2;
            List<? extends KotlinType> expectedType;
            List<? extends KotlinType> list2;
            List<? extends KotlinType> it;
            void i;
            KtParameter valueParameter = valueParameters2.get((int)i);
            KtTypeReference typeReference = valueParameter.getTypeReference();
            List<? extends KotlinType> list3 = expectedParameterTypes;
            List<? extends KotlinType> list4 = list3 != null && (list3 = i < (it = (list2 = list3)).size() ? it.get((int)i) : null) != null ? (!TypeUtils.noExpectedType(it = (list2 = list3)) ? list2 : null) : (expectedType = null);
            if (typeReference != null) {
                type2 = this.typeResolver.resolveType(parameterScope, typeReference, trace, true);
                if (expectedType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf((KotlinType)((Object)expectedType), (KotlinType)type2)) {
                    trace.report(Errors.EXPECTED_PARAMETER_TYPE_MISMATCH.on((KtParameter)((PsiElement)valueParameter), (KotlinType)((Object)expectedType)));
                }
            } else if (ExpressionTypingUtils.isFunctionLiteral(functionDescriptor) || ExpressionTypingUtils.isFunctionExpression(functionDescriptor)) {
                boolean containsUninferredParameter2 = TypeUtils.contains(expectedType, (Function1<UnwrappedType, Boolean>)((Function1)resolveValueParameters.containsUninferredParameter.1.INSTANCE));
                if (expectedType == null || containsUninferredParameter2) {
                    trace.report(Errors.CANNOT_INFER_PARAMETER_TYPE.on((KtParameter)((PsiElement)valueParameter)));
                }
                if ((object = expectedType) == null) {
                    SimpleType simpleType2 = TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE");
                    object = simpleType2;
                }
            } else {
                trace.report(Errors.VALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION.on((KtParameter)((PsiElement)valueParameter)));
                SimpleType simpleType3 = ErrorUtils.createErrorType("Type annotation was missing for parameter " + valueParameter.getNameAsSafeName());
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"ErrorUtils.createErrorTy\u2026rameter.nameAsSafeName}\")");
                object = type2 = (KotlinType)simpleType3;
            }
            if (!(functionDescriptor instanceof ConstructorDescriptor) || !((ConstructorDescriptor)functionDescriptor).isPrimary()) {
                ModifiersChecker.ModifiersCheckingProcedure modifiersCheckingProcedure;
                boolean isConstructor = functionDescriptor instanceof ConstructorDescriptor;
                ModifiersChecker.ModifiersCheckingProcedure $receiver = modifiersCheckingProcedure = this.modifiersChecker.withTrace(trace);
                $receiver.checkParameterHasNoValOrVar(valueParameter, isConstructor ? Errors.VAL_OR_VAR_ON_SECONDARY_CONSTRUCTOR_PARAMETER : Errors.VAL_OR_VAR_ON_FUN_PARAMETER);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)this.descriptorResolver.resolveValueParameterDescriptor(parameterScope, functionDescriptor, valueParameter, (int)i, (KotlinType)type2, trace, Annotations.Companion.getEMPTY()), (String)"descriptorResolver.resol\u2026tions.EMPTY\n            )");
            ExpressionTypingUtils.checkVariableShadowing(parameterScope, trace, valueParameterDescriptor);
            parameterScope.addVariableDescriptor(valueParameterDescriptor);
            result2.add(valueParameterDescriptor);
            ++i;
        }
        return result2;
    }

    public FunctionDescriptorResolver(@NotNull TypeResolver typeResolver, @NotNull DescriptorResolver descriptorResolver, @NotNull AnnotationResolver annotationResolver, @NotNull KotlinBuiltIns builtIns, @NotNull ModifiersChecker modifiersChecker, @NotNull OverloadChecker overloadChecker, @NotNull ContractParsingServices contractParsingServices, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull StorageManager storageManager) {
        Intrinsics.checkParameterIsNotNull((Object)typeResolver, (String)"typeResolver");
        Intrinsics.checkParameterIsNotNull((Object)descriptorResolver, (String)"descriptorResolver");
        Intrinsics.checkParameterIsNotNull((Object)annotationResolver, (String)"annotationResolver");
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        Intrinsics.checkParameterIsNotNull((Object)modifiersChecker, (String)"modifiersChecker");
        Intrinsics.checkParameterIsNotNull((Object)overloadChecker, (String)"overloadChecker");
        Intrinsics.checkParameterIsNotNull((Object)contractParsingServices, (String)"contractParsingServices");
        Intrinsics.checkParameterIsNotNull((Object)expressionTypingServices, (String)"expressionTypingServices");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        this.typeResolver = typeResolver;
        this.descriptorResolver = descriptorResolver;
        this.annotationResolver = annotationResolver;
        this.builtIns = builtIns;
        this.modifiersChecker = modifiersChecker;
        this.overloadChecker = overloadChecker;
        this.contractParsingServices = contractParsingServices;
        this.expressionTypingServices = expressionTypingServices;
        this.languageVersionSettings = languageVersionSettings;
        this.storageManager = storageManager;
    }

    @NotNull
    public static final /* synthetic */ ExpressionTypingServices access$getExpressionTypingServices$p(FunctionDescriptorResolver $this) {
        return $this.expressionTypingServices;
    }
}

