/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.classpath.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.gradle.internal.changes.FileChange;
import org.gradle.internal.changes.TaskStateChange;
import org.gradle.internal.changes.TaskStateChangeVisitor;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintCompareStrategy;
import org.gradle.internal.hash.Hasher;

public class ClasspathCompareStrategy
extends AbstractFingerprintCompareStrategy {
    public static final FingerprintCompareStrategy INSTANCE = new ClasspathCompareStrategy();

    private ClasspathCompareStrategy() {
    }

    protected boolean doVisitChangesSince(TaskStateChangeVisitor visitor, Map<String, FileSystemLocationFingerprint> currentSnapshots, Map<String, FileSystemLocationFingerprint> previousSnapshots, String propertyTitle, boolean includeAdded) {
        block5: {
            Iterator<Map.Entry<String, FileSystemLocationFingerprint>> currentEntries = currentSnapshots.entrySet().iterator();
            Iterator<Map.Entry<String, FileSystemLocationFingerprint>> previousEntries = previousSnapshots.entrySet().iterator();
            while (true) {
                if (currentEntries.hasNext()) {
                    Map.Entry<String, FileSystemLocationFingerprint> current = currentEntries.next();
                    String currentAbsolutePath = current.getKey();
                    if (previousEntries.hasNext()) {
                        String previousNormalizedPath;
                        Map.Entry<String, FileSystemLocationFingerprint> previous = previousEntries.next();
                        FileSystemLocationFingerprint currentFingerprint = current.getValue();
                        FileSystemLocationFingerprint previousFingerprint = previous.getValue();
                        String currentNormalizedPath = currentFingerprint.getNormalizedPath();
                        if (currentNormalizedPath.equals(previousNormalizedPath = previousFingerprint.getNormalizedPath())) {
                            if (currentFingerprint.getNormalizedContentHash().equals((Object)previousFingerprint.getNormalizedContentHash()) || visitor.visitChange((TaskStateChange)FileChange.modified((String)currentAbsolutePath, (String)propertyTitle, (FileType)previousFingerprint.getType(), (FileType)currentFingerprint.getType()))) continue;
                            return false;
                        }
                        String previousAbsolutePath = previous.getKey();
                        if (!visitor.visitChange((TaskStateChange)FileChange.removed((String)previousAbsolutePath, (String)propertyTitle, (FileType)previousFingerprint.getType()))) {
                            return false;
                        }
                        if (!includeAdded || visitor.visitChange((TaskStateChange)FileChange.added((String)currentAbsolutePath, (String)propertyTitle, (FileType)currentFingerprint.getType()))) continue;
                        return false;
                    }
                    if (!includeAdded || visitor.visitChange((TaskStateChange)FileChange.added((String)currentAbsolutePath, (String)propertyTitle, (FileType)current.getValue().getType()))) continue;
                    return false;
                }
                if (!previousEntries.hasNext()) break block5;
                Map.Entry<String, FileSystemLocationFingerprint> previousEntry = previousEntries.next();
                if (!visitor.visitChange((TaskStateChange)FileChange.removed((String)previousEntry.getKey(), (String)propertyTitle, (FileType)previousEntry.getValue().getType()))) break;
            }
            return false;
        }
        return true;
    }

    public void appendToHasher(Hasher hasher, Collection<FileSystemLocationFingerprint> fingerprints) {
        for (FileSystemLocationFingerprint fingerprint : fingerprints) {
            fingerprint.appendToHasher(hasher);
        }
    }
}

