/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.util.Map;
import javajs.util.P3;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class MdCrdReader
extends AtomSetCollectionReader {
    private int ptFloat = 0;
    private int lenLine = 0;

    @Override
    protected void setup(String string, Map<String, Object> map, Object object) {
        this.requiresBSFilter = true;
        this.setupASCR(string, map, object);
    }

    @Override
    protected void initializeReader() {
        this.initializeTrajectoryFile();
    }

    @Override
    protected boolean checkLine() throws Exception {
        this.readCoordinates();
        Logger.info("Total number of trajectory steps=" + this.trajectorySteps.size());
        this.continuing = false;
        return false;
    }

    private void readCoordinates() throws Exception {
        this.line = null;
        int n = this.bsFilter == null ? this.templateAtomCount : (Integer)this.htParams.get("filteredAtomCount");
        boolean bl = this.htParams.containsKey("isPeriodic");
        int n2 = this.templateAtomCount * 3 + (bl ? 3 : 0);
        while (true) {
            if (this.doGetModel(++this.modelNumber, null)) {
                P3[] p3Array = new P3[n];
                if (!this.getTrajectoryStep(p3Array, bl)) {
                    return;
                }
                this.trajectorySteps.addLast(p3Array);
                if (!this.isLastModel(this.modelNumber)) continue;
                return;
            }
            if (!this.skipFloats(n2)) break;
        }
    }

    private float getFloat() throws Exception {
        while (this.line == null || this.ptFloat >= this.lenLine) {
            if (this.rd() == null) {
                return Float.NaN;
            }
            this.ptFloat = 0;
            this.lenLine = this.line.length();
        }
        this.ptFloat += 8;
        return this.parseFloatRange(this.line, this.ptFloat - 8, this.ptFloat);
    }

    private P3 getPoint() throws Exception {
        float f = this.getFloat();
        float f2 = this.getFloat();
        float f3 = this.getFloat();
        return Float.isNaN(f3) ? null : P3.new3(f, f2, f3);
    }

    private boolean getTrajectoryStep(P3[] p3Array, boolean bl) throws Exception {
        int n = p3Array.length;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.templateAtomCount) {
            P3 p3 = this.getPoint();
            if (p3 == null) {
                return false;
            }
            if (this.bsFilter == null || this.bsFilter.get(n3)) {
                if (++n2 == n) {
                    return false;
                }
                p3Array[n2] = p3;
            }
            ++n3;
        }
        if (bl) {
            this.getPoint();
        }
        return this.line != null;
    }

    private boolean skipFloats(int n) throws Exception {
        int n2 = 0;
        while (n2 < n && this.rd() != null) {
            n2 += this.getTokens().length;
        }
        return this.line != null;
    }
}

