/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jvxl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javajs.util.P4;
import javajs.util.PT;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.openscience.jvxl.FileReader;

public class Jvxl {
    private static final String VERSION = "JVXL.java Version 1.0";

    public static void main(String[] stringArray) {
        BufferedReader bufferedReader;
        Object object;
        Object object2;
        boolean bl = false;
        int n = Integer.MAX_VALUE;
        String string = null;
        String string2 = null;
        String string3 = null;
        float f = Float.NaN;
        boolean bl2 = false;
        P4 p4 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        float f2 = Float.NaN;
        float f3 = Float.NaN;
        Options options = new Options();
        options.addOption("h", "help", false, "give this help page");
        options.addOption("B", "blockdata", false, "multiple cube data are in blocks, not interspersed");
        options.addOption("P", "progressive", false, "create JVXL+ progressive X low-to-high format");
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.withDescription((String)"file containing surface data");
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withLongOpt((String)"index");
        OptionBuilder.withDescription((String)"index of surface in file (starting with 1)");
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)"plane");
        OptionBuilder.withDescription((String)"plane: x, y, z, xy, xz, yz, z2, x2-y2, or {a,b,c,d}");
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"map");
        OptionBuilder.withDescription((String)"file containing data to map onto the surface or \"sets\"");
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.withDescription((String)"JVXL output file");
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)"cutoff");
        OptionBuilder.withDescription((String)"isosurface cutoff value");
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"c"));
        options.addOption("b", "bicolor", false, "bicolor map (orbital)");
        options.addOption("r", "reversecolor", false, "reverse color");
        OptionBuilder.withLongOpt((String)"colorScheme");
        OptionBuilder.withDescription((String)"VRML color scheme: bw, wb, roygb, bgyor, rwb, bwr, low, high");
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"phase");
        OptionBuilder.withDescription((String)"color by phase: x, y, z, xy, xz, yz, z2, x2-y2");
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"F"));
        OptionBuilder.withLongOpt((String)"min");
        OptionBuilder.withDescription((String)"color absolute minimum value");
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)"max");
        OptionBuilder.withDescription((String)"color absolute maximum value");
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"x"));
        CommandLine commandLine = null;
        try {
            object2 = new PosixParser();
            commandLine = object2.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            Logger.error("Unexpected exception: " + parseException.toString());
        }
        if (commandLine.hasOption("h")) {
            object2 = new HelpFormatter();
            object2.printHelp("Jvxl", options);
            return;
        }
        stringArray = commandLine.getArgs();
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        bl = commandLine.hasOption("B");
        if (commandLine.hasOption("i")) {
            n = PT.parseInt(commandLine.getOptionValue("i"));
        }
        if (commandLine.hasOption("f")) {
            string = commandLine.getOptionValue("f");
        }
        if (commandLine.hasOption("m")) {
            string2 = commandLine.getOptionValue("m");
        }
        if (commandLine.hasOption("p")) {
            p4 = Jvxl.getPlane(commandLine.getOptionValue("p"));
            if (p4 == null) {
                Logger.error("invalid plane");
                return;
            }
            Logger.info("using plane " + p4);
            if (string2 == null) {
                string2 = string;
            }
            if (string == null) {
                string = string2;
            }
        }
        if (commandLine.hasOption("o")) {
            string3 = commandLine.getOptionValue("o");
        } else {
            string3 = string;
            if (string3.indexOf(".") < 0) {
                string3 = String.valueOf(string3) + ".";
            }
            String string4 = object2 = n == Integer.MAX_VALUE ? "" : "_" + n;
            if (((String)object2).length() == 0 && string3.indexOf(".jvxl") >= 0) {
                object2 = String.valueOf(object2) + "_new";
            }
            string3 = String.valueOf(string3.substring(0, string3.lastIndexOf("."))) + (String)object2 + ".jvxl";
        }
        bl3 = commandLine.hasOption("b");
        bl4 = commandLine.hasOption("r");
        if (bl3 && string2 != null) {
            Logger.warn("--map option ignored; incompatible with --bicolor");
            string2 = null;
        }
        if (commandLine.hasOption("c")) {
            object2 = commandLine.getOptionValue("c");
            if (((String)object2).indexOf("+") == 0) {
                bl2 = true;
                object2 = ((String)object2).substring(1);
            }
            f = PT.parseFloat((String)object2);
        }
        if (commandLine.hasOption("n")) {
            if (bl3) {
                Logger.warn("--min option ignored; incompatible with --bicolor");
            } else {
                f2 = PT.parseFloat(commandLine.getOptionValue("n"));
            }
        }
        if (commandLine.hasOption("x")) {
            if (bl3) {
                Logger.warn("--max option ignored; incompatible with --bicolor");
            } else {
                f3 = PT.parseFloat(commandLine.getOptionValue("x"));
            }
        }
        boolean bl5 = commandLine.hasOption("P");
        SurfaceGenerator surfaceGenerator = new SurfaceGenerator(null, null, null, null);
        surfaceGenerator.version = VERSION;
        if (bl) {
            surfaceGenerator.setProp("blockData", Boolean.TRUE, null);
        }
        if (!Float.isNaN(f)) {
            surfaceGenerator.setProp(bl2 ? "cutoffPositive" : "cutoff", Float.valueOf(f), null);
        }
        if (bl3) {
            surfaceGenerator.setProp("sign", null, null);
        }
        if (bl4) {
            surfaceGenerator.setProp("reverseColor", null, null);
        }
        if (bl5) {
            surfaceGenerator.setProp("progressive", null, null);
        }
        if (p4 != null) {
            surfaceGenerator.setProp("plane", p4, null);
        } else {
            if (n != Integer.MAX_VALUE) {
                surfaceGenerator.setProp("fileIndex", n, null);
            }
            if ((object = FileReader.getBufferedReaderOrErrorMessageFromName(string)) instanceof String) {
                Logger.error((String)object);
                return;
            }
            bufferedReader = (BufferedReader)object;
            surfaceGenerator.setProp("readFile", bufferedReader, null);
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        surfaceGenerator.setProp("title", commandLine.toString(), null);
        if (!Float.isNaN(f2)) {
            surfaceGenerator.setProp("red", Float.valueOf(f2), null);
        }
        if (!Float.isNaN(f3)) {
            surfaceGenerator.setProp("blue", Float.valueOf(f3), null);
        }
        if (string2 != null) {
            object = FileReader.getBufferedReaderOrErrorMessageFromName(string2);
            if (object instanceof String) {
                Logger.error((String)object);
                return;
            }
            bufferedReader = (BufferedReader)object;
            surfaceGenerator.setProp("mapColor", bufferedReader, null);
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Jvxl.writeFile(string3, (String)surfaceGenerator.getProperty("jvxlFileData", 0));
        Logger.info((String)surfaceGenerator.getProperty("jvxlFileInfo", 0));
        Logger.info("\ncreated " + string3);
    }

    static void writeFile(String string, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream), 8192);
            bufferedWriter.write(string2);
            bufferedWriter.close();
            fileOutputStream = null;
        }
        catch (IOException iOException) {
            Logger.error("IO Exception: " + iOException.toString());
        }
    }

    static P4 getPlane(String string) {
        if (string.equalsIgnoreCase("xy")) {
            return P4.new4(0.0f, 0.0f, 1.0f, 0.0f);
        }
        if (string.equalsIgnoreCase("xz")) {
            return P4.new4(0.0f, 1.0f, 0.0f, 0.0f);
        }
        if (string.equalsIgnoreCase("yz")) {
            return P4.new4(1.0f, 0.0f, 0.0f, 0.0f);
        }
        if (string.indexOf("x=") == 0) {
            return P4.new4(1.0f, 0.0f, 0.0f, -PT.parseFloat(string.substring(2)));
        }
        if (string.indexOf("y=") == 0) {
            return P4.new4(0.0f, 1.0f, 0.0f, -PT.parseFloat(string.substring(2)));
        }
        if (string.indexOf("z=") == 0) {
            return P4.new4(0.0f, 0.0f, 1.0f, -PT.parseFloat(string.substring(2)));
        }
        if (string.indexOf("{") == 0) {
            string = string.replace(',', ' ');
            int[] nArray = new int[1];
            return P4.new4(PT.parseFloatNext(string, nArray), PT.parseFloatNext(string, nArray), PT.parseFloatNext(string, nArray), PT.parseFloatNext(string, nArray));
        }
        return null;
    }
}

