/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.LocalFunctionCollector;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;

public final class FunctionBodyTranslator
extends AbstractTranslator {
    @NotNull
    private final FunctionDescriptor descriptor;
    @NotNull
    private final KtDeclarationWithBody declaration;

    @NotNull
    public static JsBlock translateFunctionBody(@NotNull FunctionDescriptor descriptor2, @NotNull KtDeclarationWithBody declarationWithBody, @NotNull TranslationContext functionBodyContext) {
        HashMap<DeclarationDescriptor, JsExpression> aliases = new HashMap<DeclarationDescriptor, JsExpression>();
        LocalFunctionCollector functionCollector = new LocalFunctionCollector(functionBodyContext.bindingContext());
        declarationWithBody.acceptChildren(functionCollector, null);
        for (FunctionDescriptor localFunction : functionCollector.getFunctions()) {
            String localIdent = localFunction.getName().isSpecial() ? "lambda" : localFunction.getName().asString();
            JsName localName = JsScope.declareTemporaryName(NameSuggestion.sanitizeName(localIdent));
            MetadataProperties.setDescriptor(localName, (DeclarationDescriptor)localFunction);
            JsNameRef alias = JsAstUtils.pureFqn(localName, null);
            aliases.put(localFunction, alias);
        }
        if (!aliases.isEmpty()) {
            functionBodyContext = functionBodyContext.innerContextWithDescriptorsAliased(aliases);
        }
        return new FunctionBodyTranslator(descriptor2, declarationWithBody, functionBodyContext).translate();
    }

    @NotNull
    public static List<JsStatement> setDefaultValueForArguments(@NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context) {
        List<ValueParameterDescriptor> valueParameters2 = descriptor2.getValueParameters();
        List<ValueParameterDescriptor> valueParametersForDefaultValue = CodegenUtil.getFunctionParametersForDefaultValueGeneration(descriptor2, context.bindingTrace());
        ArrayList<JsStatement> result2 = new ArrayList<JsStatement>(valueParameters2.size());
        for (int i = 0; i < valueParameters2.size(); ++i) {
            ValueParameterDescriptor valueParameter = valueParameters2.get(i);
            ValueParameterDescriptor valueParameterForDefaultValue = valueParametersForDefaultValue.get(i);
            if (!valueParameterForDefaultValue.declaresDefaultValue()) continue;
            JsExpression jsNameRef = ReferenceTranslator.translateAsValueReference(valueParameter, context);
            KtExpression defaultArgument = BindingUtils.getDefaultArgument(valueParameterForDefaultValue);
            JsBlock defaultArgBlock = new JsBlock();
            JsExpression defaultValue = Translation.translateAsExpression(defaultArgument, context, defaultArgBlock);
            PsiElement psi = KotlinSourceElementKt.getPsi(valueParameter.getSource());
            JsStatement assignStatement = JsAstUtils.assignment(jsNameRef, defaultValue).source(psi).makeStmt();
            JsStatement thenStatement = JsAstUtils.mergeStatementInBlockIfNeeded(assignStatement, defaultArgBlock);
            JsBinaryOperation checkArgIsUndefined = JsAstUtils.equality(jsNameRef, Namer.getUndefinedExpression());
            checkArgIsUndefined.source(psi);
            JsIf jsIf = JsAstUtils.newJsIf(checkArgIsUndefined, thenStatement);
            jsIf.setSource(checkArgIsUndefined.getSource());
            result2.add(jsIf);
        }
        return result2;
    }

    private FunctionBodyTranslator(@NotNull FunctionDescriptor descriptor2, @NotNull KtDeclarationWithBody declaration, @NotNull TranslationContext context) {
        super(context);
        this.descriptor = descriptor2;
        this.declaration = declaration;
    }

    @NotNull
    private JsBlock translate() {
        KtExpression jetBodyExpression = this.declaration.getBodyExpression();
        assert (jetBodyExpression != null) : "Cannot translate a body of an abstract function.";
        JsBlock jsBlock = new JsBlock();
        JsNode jsBody = Translation.translateExpression(jetBodyExpression, this.context(), jsBlock);
        jsBlock.getStatements().addAll(this.mayBeWrapWithReturn(jsBody).getStatements());
        if (jetBodyExpression instanceof KtBlockExpression && this.descriptor.getReturnType() != null && KotlinBuiltIns.isUnit(this.descriptor.getReturnType()) && !KotlinBuiltIns.isUnit(TranslationUtils.getReturnTypeForCoercion(this.descriptor))) {
            ClassDescriptor unit = this.context().getCurrentModule().getBuiltIns().getUnit();
            JsReturn jsReturn = new JsReturn(ReferenceTranslator.translateAsValueReference(unit, this.context()));
            jsReturn.setSource(UtilsKt.getFinalElement(this.declaration));
            jsBlock.getStatements().add(jsReturn);
        }
        return jsBlock;
    }

    @NotNull
    private JsBlock mayBeWrapWithReturn(@NotNull JsNode body) {
        if (!this.mustAddReturnToGeneratedFunctionBody()) {
            return JsAstUtils.convertToBlock(body);
        }
        return JsAstUtils.convertToBlock(this.lastExpressionReturned(body));
    }

    private boolean mustAddReturnToGeneratedFunctionBody() {
        KotlinType functionReturnType = this.descriptor.getReturnType();
        assert (functionReturnType != null) : "Function return typed type must be resolved.";
        return !this.declaration.hasBlockBody() && (!KotlinBuiltIns.isUnit(functionReturnType) || this.descriptor.isSuspend());
    }

    @NotNull
    private JsNode lastExpressionReturned(@NotNull JsNode body) {
        return LastExpressionMutator.mutateLastExpression(body, node -> {
            if (!(node instanceof JsExpression)) {
                return node;
            }
            assert (this.declaration.getBodyExpression() != null);
            KotlinType returnType2 = TranslationUtils.getReturnTypeForCoercion(this.descriptor);
            node = TranslationUtils.coerce(this.context(), (JsExpression)node, returnType2);
            JsReturn jsReturn = new JsReturn((JsExpression)node);
            jsReturn.setSource(this.declaration.getBodyExpression());
            MetadataProperties.setReturnTarget(jsReturn, this.descriptor);
            return jsReturn;
        });
    }
}

