/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.backend.common;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.SerializerCodegen;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.SerializerCodegen$getFuncDesc$;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializerDescriptorResolver;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperties;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperty;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H$J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H$J\b\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H$J\b\u0010)\u001a\u00020'H\u0002J\b\u0010*\u001a\u00020\u001fH$J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\bH$J\b\u0010-\u001a\u00020'H\u0002J@\u0010.\u001a\u0004\u0018\u00010\b2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00172\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020'022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020'02J,\u00105\u001a\u0004\u0018\u00010\b2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00172\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020'02J\b\u00106\u001a\u00020'H\u0002J\u001a\u00107\u001a\b\u0012\u0004\u0012\u00020%08*\u00020\u00032\u0006\u00109\u001a\u00020\u0017H\u0004R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001c\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/SerializerCodegen;", "", "serializerDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "anySerialDescProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getAnySerialDescProperty", "()Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generatedSerialDescPropertyDescriptor", "getGeneratedSerialDescPropertyDescriptor", "orderedProperties", "", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperty;", "getOrderedProperties", "()Ljava/util/List;", "properties", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperties;", "getProperties", "()Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperties;", "serialName", "", "getSerialName", "()Ljava/lang/String;", "serializableDescriptor", "getSerializableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getSerializerDescriptor", "generate", "", "generateGenericFieldsAndConstructor", "typedConstructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "generateLoad", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateLoadIfNeeded", "", "generateSave", "generateSaveIfNeeded", "generateSerialDesc", "generateSerializableClassProperty", "property", "generateSerializableClassPropertyIfNeeded", "getProperty", "classDescriptor", "name", "isReturnTypeOk", "Lkotlin/Function1;", "isKindOk", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "getPropertyToGenerate", "typedSerializerConstructorNotDeclared", "getFuncDesc", "Lkotlin/sequences/Sequence;", "funcName", "kotlinx-serialization-compiler-plugin"})
public abstract class SerializerCodegen {
    @NotNull
    private final ClassDescriptor serializableDescriptor;
    @NotNull
    private final String serialName;
    @NotNull
    private final SerializableProperties properties;
    @NotNull
    private final List<SerializableProperty> orderedProperties;
    @Nullable
    private final PropertyDescriptor generatedSerialDescPropertyDescriptor;
    @Nullable
    private final PropertyDescriptor anySerialDescProperty;
    @NotNull
    private final ClassDescriptor serializerDescriptor;

    @NotNull
    protected final ClassDescriptor getSerializableDescriptor() {
        return this.serializableDescriptor;
    }

    @NotNull
    protected final String getSerialName() {
        return this.serialName;
    }

    @NotNull
    protected final SerializableProperties getProperties() {
        return this.properties;
    }

    @NotNull
    protected final List<SerializableProperty> getOrderedProperties() {
        return this.orderedProperties;
    }

    public final void generate() {
        boolean bl = this.properties.isExternallySerializable();
        if (!bl) {
            String string = "Class " + this.serializableDescriptor.getName() + " is not externally serializable";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.generateSerialDesc();
        boolean prop = this.generateSerializableClassPropertyIfNeeded();
        boolean save = this.generateSaveIfNeeded();
        boolean load = this.generateLoadIfNeeded();
        List list = this.serializableDescriptor.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"serializableDescriptor.declaredTypeParameters");
        Collection collection = list;
        if (!collection.isEmpty() && this.typedSerializerConstructorNotDeclared()) {
            this.generateGenericFieldsAndConstructor((ConstructorDescriptor)KSerializerDescriptorResolver.INSTANCE.createTypedSerializerConstructorDescriptor(this.serializerDescriptor, this.serializableDescriptor));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean typedSerializerConstructorNotDeclared() {
        boolean bl;
        KotlinType kotlinType = KSerializationUtilKt.extractKSerializerArgumentFromImplementation(this.serializerDescriptor);
        Object object = kotlinType;
        if (kotlinType == null) throw (Throwable)((Object)new AssertionError((Object)"Serializer does not implement KSerializer??"));
        List list = object.getArguments();
        object = list;
        if (list == null) throw (Throwable)((Object)new AssertionError((Object)"Serializer does not implement KSerializer??"));
        Object serializableImplementationTypeArguments = object;
        int typeParamsCount = serializableImplementationTypeArguments.size();
        if (typeParamsCount == 0) {
            return false;
        }
        Collection collection = this.serializerDescriptor.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"serializerDescriptor.constructors");
        Collection ctors = collection;
        Iterable $receiver$iv = ctors;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $receiver$iv.iterator();
        do {
            ClassConstructorDescriptor it;
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            ClassConstructorDescriptor classConstructorDescriptor = it = (ClassConstructorDescriptor)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptor, (String)"it");
            if (classConstructorDescriptor.getValueParameters().size() == typeParamsCount) {
                void $receiver$iv2;
                List list2 = it.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"it.valueParameters");
                Iterable iterable = list2;
                boolean initial$iv = false;
                int index$iv = 0;
                boolean accumulator$iv = initial$iv;
                for (Object element$iv2 : $receiver$iv2) {
                    KotlinType type;
                    void flag;
                    void parameterDescriptor;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n2 = n;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv2;
                    boolean bl2 = accumulator$iv;
                    int index = n2;
                    void v6 = parameterDescriptor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"parameterDescriptor");
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6.getType(), (String)"parameterDescriptor.type");
                    accumulator$iv = flag != false || KSerializationUtilKt.isKSerializer(type) && Intrinsics.areEqual((Object)((TypeProjection)CollectionsKt.first((List)type.getArguments())), (Object)((TypeProjection)serializableImplementationTypeArguments.get(index)));
                }
                if (accumulator$iv) {
                    return false;
                }
            }
            bl = false;
        } while (!bl);
        return false;
    }

    @Nullable
    protected final PropertyDescriptor getGeneratedSerialDescPropertyDescriptor() {
        return this.generatedSerialDescPropertyDescriptor;
    }

    @Nullable
    protected final PropertyDescriptor getAnySerialDescProperty() {
        return this.anySerialDescProperty;
    }

    protected abstract void generateSerialDesc();

    protected abstract void generateGenericFieldsAndConstructor(@NotNull ConstructorDescriptor var1);

    protected abstract void generateSerializableClassProperty(@NotNull PropertyDescriptor var1);

    protected abstract void generateSave(@NotNull FunctionDescriptor var1);

    protected abstract void generateLoad(@NotNull FunctionDescriptor var1);

    private final boolean generateSerializableClassPropertyIfNeeded() {
        PropertyDescriptor propertyDescriptor = this.generatedSerialDescPropertyDescriptor;
        if (propertyDescriptor == null) {
            return false;
        }
        PropertyDescriptor property = propertyDescriptor;
        this.generateSerializableClassProperty(property);
        return true;
    }

    private final boolean generateSaveIfNeeded() {
        FunctionDescriptor functionDescriptor = CodegenUtil.INSTANCE.getMemberToGenerate(this.serializerDescriptor, "serialize", (Function1)new Function1<KotlinType, Boolean>(this.serializerDescriptor){

            public final boolean invoke(@NotNull KotlinType p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return KSerializationUtilKt.checkSaveMethodResult((ClassDescriptor)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinPackage(KSerializationUtilKt.class, (String)"kotlinx-serialization-compiler-plugin");
            }

            public final String getName() {
                return "checkSaveMethodResult";
            }

            public final String getSignature() {
                return "checkSaveMethodResult(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/types/KotlinType;)Z";
            }
        }, (Function1)new Function1<List<? extends ValueParameterDescriptor>, Boolean>(this.serializerDescriptor){

            public final boolean invoke(@NotNull List<? extends ValueParameterDescriptor> p1) {
                Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                return KSerializationUtilKt.checkSaveMethodParameters((ClassDescriptor)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinPackage(KSerializationUtilKt.class, (String)"kotlinx-serialization-compiler-plugin");
            }

            public final String getName() {
                return "checkSaveMethodParameters";
            }

            public final String getSignature() {
                return "checkSaveMethodParameters(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/List;)Z";
            }
        });
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor function2 = functionDescriptor;
        this.generateSave(function2);
        return true;
    }

    private final boolean generateLoadIfNeeded() {
        FunctionDescriptor functionDescriptor = CodegenUtil.INSTANCE.getMemberToGenerate(this.serializerDescriptor, "deserialize", (Function1)new Function1<KotlinType, Boolean>(this.serializerDescriptor){

            public final boolean invoke(@NotNull KotlinType p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return KSerializationUtilKt.checkLoadMethodResult((ClassDescriptor)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinPackage(KSerializationUtilKt.class, (String)"kotlinx-serialization-compiler-plugin");
            }

            public final String getName() {
                return "checkLoadMethodResult";
            }

            public final String getSignature() {
                return "checkLoadMethodResult(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/types/KotlinType;)Z";
            }
        }, (Function1)new Function1<List<? extends ValueParameterDescriptor>, Boolean>(this.serializerDescriptor){

            public final boolean invoke(@NotNull List<? extends ValueParameterDescriptor> p1) {
                Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                return KSerializationUtilKt.checkLoadMethodParameters((ClassDescriptor)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinPackage(KSerializationUtilKt.class, (String)"kotlinx-serialization-compiler-plugin");
            }

            public final String getName() {
                return "checkLoadMethodParameters";
            }

            public final String getSignature() {
                return "checkLoadMethodParameters(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/List;)Z";
            }
        });
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor function2 = functionDescriptor;
        this.generateLoad(function2);
        return true;
    }

    @Nullable
    public final PropertyDescriptor getPropertyToGenerate(@NotNull ClassDescriptor classDescriptor, @NotNull String name, @NotNull Function1<? super PropertyDescriptor, Boolean> isReturnTypeOk) {
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(isReturnTypeOk, (String)"isReturnTypeOk");
        return this.getProperty(classDescriptor, name, isReturnTypeOk, (Function1<? super CallableMemberDescriptor.Kind, Boolean>)((Function1)getPropertyToGenerate.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PropertyDescriptor getProperty(@NotNull ClassDescriptor classDescriptor, @NotNull String name, @NotNull Function1<? super PropertyDescriptor, Boolean> isReturnTypeOk, @NotNull Function1<? super CallableMemberDescriptor.Kind, Boolean> isKindOk) {
        Object v3;
        block2: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(isReturnTypeOk, (String)"isReturnTypeOk");
            Intrinsics.checkParameterIsNotNull(isKindOk, (String)"isKindOk");
            MemberScope memberScope = classDescriptor.getUnsubstitutedMemberScope();
            Name name2 = Name.identifier((String)name);
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(name)");
            Iterable iterable = memberScope.getContributedVariables(name2, (LookupLocation)NoLookupLocation.FROM_BACKEND);
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                PropertyDescriptor property = (PropertyDescriptor)element$iv;
                CallableMemberDescriptor.Kind kind = property.getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)kind, (String)"property.kind");
                if (!((Boolean)isKindOk.invoke((Object)kind) != false && property.getModality() != Modality.FINAL && property.getReturnType() != null && (Boolean)isReturnTypeOk.invoke((Object)property) != false)) continue;
                if (found$iv) {
                    v3 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v3 = !found$iv ? null : single$iv;
        }
        return v3;
    }

    @NotNull
    protected final Sequence<FunctionDescriptor> getFuncDesc(@NotNull ClassDescriptor $receiver, @NotNull String funcName) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        MemberScope memberScope = $receiver.getUnsubstitutedMemberScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)memberScope, (String)"unsubstitutedMemberScope");
        Sequence $receiver$iv = CollectionsKt.asSequence((Iterable)MemberScopeKt.getDescriptorsFiltered$default((MemberScope)memberScope, null, (Function1)((Function1)new Function1<Name, Boolean>(funcName){
            final /* synthetic */ String $funcName;

            public final boolean invoke(@NotNull Name it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)Name.identifier((String)this.$funcName));
            }
            {
                this.$funcName = string;
                super(1);
            }
        }), (int)1, null));
        Sequence sequence = SequencesKt.filter((Sequence)$receiver$iv, (Function1)getFuncDesc$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return sequence;
    }

    @NotNull
    protected final ClassDescriptor getSerializerDescriptor() {
        return this.serializerDescriptor;
    }

    public SerializerCodegen(@NotNull ClassDescriptor serializerDescriptor, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull((Object)serializerDescriptor, (String)"serializerDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        this.serializerDescriptor = serializerDescriptor;
        ClassDescriptor classDescriptor = KSerializationUtilKt.getSerializableClassDescriptorBySerializer(this.serializerDescriptor);
        if (classDescriptor == null) {
            Intrinsics.throwNpe();
        }
        this.serializableDescriptor = classDescriptor;
        String string = KSerializationUtilKt.getSerialNameValue(this.serializableDescriptor.getAnnotations());
        if (string == null) {
            String string2 = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)this.serializableDescriptor)).asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"serializableDescriptor.fqNameUnsafe.asString()");
        }
        this.serialName = string;
        this.properties = new SerializableProperties(this.serializableDescriptor, bindingContext);
        this.orderedProperties = this.properties.getSerializableProperties();
        this.generatedSerialDescPropertyDescriptor = this.getPropertyToGenerate(this.serializerDescriptor, "descriptor", (Function1<? super PropertyDescriptor, Boolean>)((Function1)new Function1<PropertyDescriptor, Boolean>(this.serializerDescriptor){

            public final boolean invoke(@NotNull PropertyDescriptor p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return KSerializationUtilKt.checkSerializableClassPropertyResult((ClassDescriptor)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinPackage(KSerializationUtilKt.class, (String)"kotlinx-serialization-compiler-plugin");
            }

            public final String getName() {
                return "checkSerializableClassPropertyResult";
            }

            public final String getSignature() {
                return "checkSerializableClassPropertyResult(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;)Z";
            }
        }));
        this.anySerialDescProperty = this.getProperty(this.serializerDescriptor, "descriptor", (Function1<? super PropertyDescriptor, Boolean>)((Function1)new Function1<PropertyDescriptor, Boolean>(this.serializerDescriptor){

            public final boolean invoke(@NotNull PropertyDescriptor p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return KSerializationUtilKt.checkSerializableClassPropertyResult((ClassDescriptor)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinPackage(KSerializationUtilKt.class, (String)"kotlinx-serialization-compiler-plugin");
            }

            public final String getName() {
                return "checkSerializableClassPropertyResult";
            }

            public final String getSignature() {
                return "checkSerializableClassPropertyResult(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;)Z";
            }
        }), (Function1<? super CallableMemberDescriptor.Kind, Boolean>)((Function1)anySerialDescProperty.2.INSTANCE));
    }
}

